/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.model.Path;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.rule.describe.MethodModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.DefaultModelRuleInvoker;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMethodRuleDefinition<T, R>
implements MethodRuleDefinition<R> {
    private final Method method;
    private final ModelType<T> instanceType;
    private final ModelType<R> returnType;

    private DefaultMethodRuleDefinition(Method method, ModelType<T> instanceType, ModelType<R> returnType) {
        this.method = method;
        this.instanceType = instanceType;
        this.returnType = returnType;
    }

    public static <T, R> MethodRuleDefinition<R> create(Class<T> source, Method method) {
        ModelType<?> returnType = ModelType.of(method.getGenericReturnType());
        return new DefaultMethodRuleDefinition(method, ModelType.of(source), returnType);
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public ModelType<R> getReturnType() {
        return this.returnType;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.method.getAnnotation(annotationType);
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return new MethodModelRuleDescriptor(this.method);
    }

    @Override
    public ModelRuleInvoker<R> getRuleInvoker() {
        return new DefaultModelRuleInvoker<T, R>(this.method, this.instanceType, this.returnType);
    }

    @Override
    public List<ModelReference<?>> getReferences() {
        Type[] types = this.method.getGenericParameterTypes();
        ImmutableList.Builder inputBindingBuilder = ImmutableList.builder();
        for (int i = 0; i < types.length; ++i) {
            Type paramType = types[i];
            Annotation[] paramAnnotations = this.method.getParameterAnnotations()[i];
            inputBindingBuilder.add(this.reference(paramType, paramAnnotations, i));
        }
        return inputBindingBuilder.build();
    }

    private ModelReference<?> reference(Type type, Annotation[] annotations, int i) {
        Path pathAnnotation = (Path)CollectionUtils.findFirst((Object[])annotations, (Spec)new Spec<Annotation>(){

            public boolean isSatisfiedBy(Annotation element) {
                return element.annotationType().equals(Path.class);
            }
        });
        String path = pathAnnotation == null ? null : pathAnnotation.value();
        ModelType<?> cast = ModelType.of(type);
        return ModelReference.of(path == null ? null : ModelPath.path(path), cast, String.format("parameter %s", i + 1));
    }
}

