/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiSuperMethodUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSuperElementsHelper {
    @Nullable
    public static PsiElement[] findSuperElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator2 = allSupers.iterator();
            while (iterator2.hasNext()) {
                PsiClass superClass = (PsiClass)iterator2.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator2.remove();
            }
            return allSupers.toArray(new PsiClass[allSupers.size()]);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper(method);
                if (constructorInSuper != null) {
                    return new PsiMethod[]{constructorInSuper};
                }
            } else {
                return method.findSuperMethods(false);
            }
        }
        return null;
    }
}

