/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, ValueReference<K, V>> myMap;
    protected final ReferenceQueue<V> myQueue = new ReferenceQueue();

    public ConcurrentRefValueHashMap() {
        this.myMap = ContainerUtil.newConcurrentMap();
    }

    boolean processQueue() {
        ValueReference ref;
        boolean processed = false;
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            this.myMap.remove(ref.getKey(), ref);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "get"));
        }
        ValueReference ref = (ValueReference)this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "put"));
        }
        this.processQueue();
        ValueReference<K, V> oldRef = this.myMap.put(key, this.createValueReference(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    protected abstract ValueReference<K, V> createValueReference(@NotNull K var1, @NotNull V var2);

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldVal;
        block4: {
            ValueReference<K, V> oldRef;
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putIfAbsent"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putIfAbsent"));
            }
            ValueReference<K, V> newRef = this.createValueReference(key, value);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block4;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(key, this.createValueReference(key, value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(key, this.createValueReference(key, oldValue), this.createValueReference(key, newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueHashMap", "replace"));
        }
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.replace(key, this.createValueReference(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference ref = (ValueReference)this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/containers/ConcurrentRefValueHashMap", "putAll"));
        }
        this.processQueue();
        for (K k : t.keySet()) {
            V v = t.get(k);
            if (v == null) continue;
            this.put(k, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "keySet"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result2 = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result2.add(value);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "values"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException("setValue is not implemented");
                }
            });
        }
        HashSet<Map.Entry<K, V>> hashSet = entries;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueHashMap", "entrySet"));
        }
        return hashSet;
    }

    public String toString() {
        String s = "map size:" + this.size() + " [";
        for (Object k : this.myMap.keySet()) {
            V v = this.get(k);
            s = s + "'" + k + "': '" + v + "', ";
        }
        s = s + "] ";
        return s;
    }

    protected static interface ValueReference<K, V> {
        @NotNull
        public K getKey();

        public V get();
    }
}

