/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesPackage$bridges$f36b2fcd;
import org.jetbrains.kotlin.backend.common.bridges.DescriptorBasedFunctionHandle;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class BridgesPackage$impl$b09b2bf7 {
    @NotNull
    public static final <Signature> Set<Bridge<Signature>> generateBridgesForFunctionDescriptor(@JetValueParameter(name="descriptor") @NotNull FunctionDescriptor descriptor, @JetValueParameter(name="signature") @NotNull Function1<? super FunctionDescriptor, ? extends Signature> signature) {
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        return BridgesPackage$bridges$f36b2fcd.generateBridges((FunctionHandle)new DescriptorBasedFunctionHandle(descriptor), new Function1<DescriptorBasedFunctionHandle, Signature>(signature){
            final /* synthetic */ Function1 $signature;

            public final Signature invoke(@JetValueParameter(name="it") @NotNull DescriptorBasedFunctionHandle it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return (Signature)this.$signature.invoke(it.getDescriptor());
            }
            {
                this.$signature = function1;
                super(1);
            }
        });
    }

    @Nullable
    public static final CallableMemberDescriptor findTraitImplementation(@JetValueParameter(name="descriptor") @NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        if (descriptor.getKind().isReal()) {
            return null;
        }
        if (CallResolverUtil.isOrOverridesSynthesized(descriptor)) {
            return null;
        }
        Set<CallableMemberDescriptor> overriddenDeclarations = OverrideResolver.getOverriddenDeclarations(descriptor);
        Set<CallableMemberDescriptor> filteredOverriddenDeclarations = OverrideResolver.filterOutOverridden(overriddenDeclarations);
        CallableMemberDescriptor implementation = null;
        for (CallableMemberDescriptor overriddenDeclaration : filteredOverriddenDeclarations) {
            if (!DescriptorUtils.isTrait(overriddenDeclaration.getContainingDeclaration()) || !(Intrinsics.areEqual((Object)overriddenDeclaration.getModality(), (Object)Modality.ABSTRACT) ^ true)) continue;
            implementation = overriddenDeclaration;
        }
        if (implementation == null) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
        CallableMemberDescriptor callableMemberDescriptor = implementation;
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = callableMemberDescriptor.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        JetType implClassType = receiverParameterDescriptor.getType();
        for (JetType supertype : containingClass.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor classifierDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (DescriptorUtils.isTrait(classifierDescriptor) || !TypeUtils.getAllSupertypes(supertype).contains(implClassType)) continue;
            return null;
        }
        return implementation;
    }
}

