/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.JetTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.JavaClassValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class AnnotationCodegen {
    public static final List<JvmFlagAnnotation> FIELD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.volatile", 64), new JvmFlagAnnotation("kotlin.jvm.transient", 128));
    public static final List<JvmFlagAnnotation> METHOD_FLAGS = Arrays.asList(new JvmFlagAnnotation("kotlin.jvm.strictfp", 2048), new JvmFlagAnnotation("kotlin.jvm.synchronized", 32), new JvmFlagAnnotation("kotlin.jvm.native", 256));
    private static final AnnotationVisitor NO_ANNOTATION_VISITOR = new AnnotationVisitor(327680){};
    private final JetTypeMapper typeMapper;

    private AnnotationCodegen(JetTypeMapper mapper) {
        this.typeMapper = mapper;
    }

    public void genAnnotations(@Nullable Annotated annotated, @Nullable Type returnType2) {
        if (annotated == null) {
            return;
        }
        if (!(annotated instanceof DeclarationDescriptor)) {
            return;
        }
        HashSet<String> annotationDescriptorsAlreadyPresent = new HashSet<String>();
        for (AnnotationDescriptor annotation2 : annotated.getAnnotations()) {
            String descriptor = this.genAnnotation(annotation2);
            if (descriptor == null) continue;
            annotationDescriptorsAlreadyPresent.add(descriptor);
        }
        this.generateAdditionalAnnotations(annotated, returnType2, annotationDescriptorsAlreadyPresent);
    }

    private void generateAdditionalAnnotations(@NotNull Annotated annotated, @Nullable Type returnType2, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        if (annotated == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAdditionalAnnotations"));
        }
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAdditionalAnnotations"));
        }
        if (annotated instanceof CallableDescriptor) {
            CallableDescriptor descriptor = (CallableDescriptor)annotated;
            if (AnnotationCodegen.isInvisibleFromTheOutside(descriptor)) {
                return;
            }
            if (descriptor instanceof ValueParameterDescriptor && AnnotationCodegen.isInvisibleFromTheOutside(descriptor.getContainingDeclaration())) {
                return;
            }
            if (returnType2 != null && !AsmUtil.isPrimitive(returnType2)) {
                this.generateNullabilityAnnotation(descriptor.getReturnType(), annotationDescriptorsAlreadyPresent);
            }
        }
    }

    private static boolean isInvisibleFromTheOutside(@Nullable DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableMemberDescriptor && JetTypeMapper.isAccessor((CallableMemberDescriptor)descriptor)) {
            return false;
        }
        if (descriptor instanceof MemberDescriptor) {
            return AsmUtil.getVisibilityAccessFlag((MemberDescriptor)descriptor) == 2;
        }
        return false;
    }

    private void generateNullabilityAnnotation(@Nullable JetType type2, @NotNull Set<String> annotationDescriptorsAlreadyPresent) {
        Flexibility flexibility;
        if (annotationDescriptorsAlreadyPresent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptorsAlreadyPresent", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateNullabilityAnnotation"));
        }
        if (type2 == null) {
            return;
        }
        if (AnnotationCodegen.isBareTypeParameterWithNullableUpperBound(type2)) {
            return;
        }
        if (TypesPackage.isFlexible(type2) && !TypeUtils.isNullableType((flexibility = TypesPackage.flexibility(type2)).getLowerBound()) && TypeUtils.isNullableType(flexibility.getUpperBound())) {
            AnnotationDescriptor notNull = type2.getAnnotations().findAnnotation(JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION);
            if (notNull != null) {
                this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, NotNull.class);
            }
            return;
        }
        boolean isNullableType = TypeUtils.isNullableType(type2);
        Class annotationClass = isNullableType ? Nullable.class : NotNull.class;
        this.generateAnnotationIfNotPresent(annotationDescriptorsAlreadyPresent, annotationClass);
    }

    private void generateAnnotationIfNotPresent(Set<String> annotationDescriptorsAlreadyPresent, Class<?> annotationClass) {
        String descriptor = Type.getType(annotationClass).getDescriptor();
        if (!annotationDescriptorsAlreadyPresent.contains(descriptor)) {
            this.visitAnnotation(descriptor, false).visitEnd();
        }
    }

    private static boolean isBareTypeParameterWithNullableUpperBound(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "isBareTypeParameterWithNullableUpperBound"));
        }
        ClassifierDescriptor classifier2 = type2.getConstructor().getDeclarationDescriptor();
        return !type2.isMarkedNullable() && classifier2 instanceof TypeParameterDescriptor && TypeUtils.hasNullableSuperType(type2);
    }

    public void generateAnnotationDefaultValue(@NotNull CompileTimeConstant value, @NotNull JetType expectedType) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAnnotationDefaultValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "generateAnnotationDefaultValue"));
        }
        AnnotationVisitor visitor2 = this.visitAnnotation(null, false);
        this.genCompileTimeValue(null, value, expectedType, visitor2);
        visitor2.visitEnd();
    }

    @Nullable
    private String genAnnotation(@NotNull AnnotationDescriptor annotationDescriptor) {
        if (annotationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDescriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genAnnotation"));
        }
        ClassifierDescriptor classifierDescriptor = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        assert (classifierDescriptor != null) : "Annotation descriptor has no class: " + annotationDescriptor;
        RetentionPolicy rp = this.getRetentionPolicy(classifierDescriptor);
        if (rp == RetentionPolicy.SOURCE) {
            return null;
        }
        String descriptor = this.typeMapper.mapType(annotationDescriptor.getType()).getDescriptor();
        AnnotationVisitor annotationVisitor = this.visitAnnotation(descriptor, rp == RetentionPolicy.RUNTIME);
        this.genAnnotationArguments(annotationDescriptor, annotationVisitor);
        annotationVisitor.visitEnd();
        return descriptor;
    }

    private void genAnnotationArguments(AnnotationDescriptor annotationDescriptor, AnnotationVisitor annotationVisitor) {
        for (Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>> entry : annotationDescriptor.getAllValueArguments().entrySet()) {
            ValueParameterDescriptor descriptor = entry.getKey();
            String name = descriptor.getName().asString();
            this.genCompileTimeValue(name, entry.getValue(), descriptor.getType(), annotationVisitor);
        }
    }

    private void genCompileTimeValue(final @Nullable String name, @NotNull CompileTimeConstant<?> value, final @NotNull JetType expectedType, final @NotNull AnnotationVisitor annotationVisitor) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        if (annotationVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationVisitor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "genCompileTimeValue"));
        }
        AnnotationArgumentVisitor<Void, Void> argumentVisitor = new AnnotationArgumentVisitor<Void, Void>(){

            @Override
            public Void visitLongValue(@NotNull LongValue value, Void data2) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/AnnotationCodegen$2", "visitLongValue"));
                }
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitIntValue(IntValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitShortValue(ShortValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitByteValue(ByteValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitDoubleValue(DoubleValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitFloatValue(FloatValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitBooleanValue(BooleanValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitCharValue(CharValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitStringValue(StringValue value, Void data2) {
                return this.visitSimpleValue(value);
            }

            @Override
            public Void visitEnumValue(EnumValue value, Void data2) {
                String propertyName = value.getValue().getName().asString();
                annotationVisitor.visitEnum(name, AnnotationCodegen.this.typeMapper.mapType(value.getType(KotlinBuiltIns.getInstance())).getDescriptor(), propertyName);
                return null;
            }

            @Override
            public Void visitArrayValue(ArrayValue value, Void data2) {
                AnnotationVisitor visitor2 = annotationVisitor.visitArray(name);
                Iterator i$ = value.getValue().iterator();
                while (i$.hasNext()) {
                    CompileTimeConstant argument = (CompileTimeConstant)i$.next();
                    AnnotationCodegen.this.genCompileTimeValue(null, argument, value.getType(KotlinBuiltIns.getInstance()), visitor2);
                }
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitAnnotationValue(AnnotationValue value, Void data2) {
                String internalAnnName = AnnotationCodegen.this.typeMapper.mapType(value.getValue().getType()).getDescriptor();
                AnnotationVisitor visitor2 = annotationVisitor.visitAnnotation(name, internalAnnName);
                AnnotationCodegen.this.genAnnotationArguments(value.getValue(), visitor2);
                visitor2.visitEnd();
                return null;
            }

            @Override
            public Void visitJavaClassValue(JavaClassValue value, Void data2) {
                return this.visitClassOfType(value.getValue());
            }

            @Override
            public Void visitKClassValue(KClassValue value, Void data2) {
                return this.visitClassOfType(value.getValue());
            }

            private Void visitClassOfType(@NotNull JetType type2) {
                if (type2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/AnnotationCodegen$2", "visitClassOfType"));
                }
                annotationVisitor.visit(name, AnnotationCodegen.this.typeMapper.mapType(type2));
                return null;
            }

            @Override
            public Void visitNumberTypeValue(IntegerValueTypeConstant value, Void data2) {
                Number numberType = value.getValue(expectedType);
                annotationVisitor.visit(name, numberType);
                return null;
            }

            private Void visitSimpleValue(CompileTimeConstant value) {
                annotationVisitor.visit(name, value.getValue());
                return null;
            }

            @Override
            public Void visitErrorValue(ErrorValue value, Void data2) {
                return this.visitUnsupportedValue(value);
            }

            @Override
            public Void visitNullValue(NullValue value, Void data2) {
                return this.visitUnsupportedValue(value);
            }

            private Void visitUnsupportedValue(CompileTimeConstant value) {
                throw new IllegalStateException("Don't know how to compile annotation value " + value);
            }
        };
        value.accept(argumentVisitor, null);
    }

    @NotNull
    private RetentionPolicy getRetentionPolicy(@NotNull Annotated descriptor) {
        ClassDescriptor enumEntry;
        JetType classObjectType;
        CompileTimeConstant<?> compileTimeConstant;
        Collection<CompileTimeConstant<?>> valueArguments2;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
        }
        AnnotationDescriptor retentionAnnotation = descriptor.getAnnotations().findAnnotation(new FqName(Retention.class.getName()));
        if (retentionAnnotation != null && !(valueArguments2 = retentionAnnotation.getAllValueArguments().values()).isEmpty() && (compileTimeConstant = valueArguments2.iterator().next()) instanceof EnumValue && (classObjectType = DescriptorUtilPackage.getClassObjectType(enumEntry = ((EnumValue)compileTimeConstant).getValue())) != null && "java/lang/annotation/RetentionPolicy".equals(this.typeMapper.mapType(classObjectType).getInternalName())) {
            RetentionPolicy retentionPolicy = RetentionPolicy.valueOf(enumEntry.getName().asString());
            if (retentionPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
            }
            return retentionPolicy;
        }
        RetentionPolicy retentionPolicy = RetentionPolicy.CLASS;
        if (retentionPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "getRetentionPolicy"));
        }
        return retentionPolicy;
    }

    @NotNull
    abstract AnnotationVisitor visitAnnotation(String var1, boolean var2);

    public static AnnotationCodegen forClass(final ClassVisitor cv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(cv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$3", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forMethod(final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$4", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forField(final FieldVisitor fv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(fv.visitAnnotation(descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$5", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forParameter(final int parameter, final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitParameterAnnotation(parameter, descr, visible));
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$6", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    public static AnnotationCodegen forAnnotationDefaultValue(final MethodVisitor mv, JetTypeMapper mapper) {
        return new AnnotationCodegen(mapper){

            @Override
            @NotNull
            AnnotationVisitor visitAnnotation(String descr, boolean visible) {
                AnnotationVisitor annotationVisitor = AnnotationCodegen.safe(mv.visitAnnotationDefault());
                if (annotationVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen$7", "visitAnnotation"));
                }
                return annotationVisitor;
            }
        };
    }

    @NotNull
    private static AnnotationVisitor safe(@Nullable AnnotationVisitor av) {
        AnnotationVisitor annotationVisitor = av == null ? NO_ANNOTATION_VISITOR : av;
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/AnnotationCodegen", "safe"));
        }
        return annotationVisitor;
    }

    public static final class JvmFlagAnnotation {
        private final FqName fqName;
        private final int jvmFlag;

        public JvmFlagAnnotation(@NotNull String fqName2, int jvmFlag) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/AnnotationCodegen$JvmFlagAnnotation", "<init>"));
            }
            this.fqName = new FqName(fqName2);
            this.jvmFlag = jvmFlag;
        }

        public boolean hasAnnotation(@NotNull Annotated annotated) {
            if (annotated == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotated", "org/jetbrains/kotlin/codegen/AnnotationCodegen$JvmFlagAnnotation", "hasAnnotation"));
            }
            return annotated.getAnnotations().findAnnotation(this.fqName) != null;
        }

        public int getJvmFlag() {
            return this.jvmFlag;
        }
    }
}

