/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.di;

import com.intellij.openapi.project.Project;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.context.LazyResolveToken;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetImportsFactory;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.ScriptBodyResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.ScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.types.expressions.LocalClassifierAnalyzer;
import org.jetbrains.kotlin.types.expressions.MultiDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;

public class InjectorForLazyResolve {
    private final ModuleContext moduleContext;
    private final KotlinBuiltIns kotlinBuiltIns;
    private final ModuleDescriptor moduleDescriptor;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;
    private final Project project;
    private final StorageManager storageManager;
    private final DeclarationProviderFactory declarationProviderFactory;
    private final BindingTrace bindingTrace;
    private final AdditionalCheckerProvider additionalCheckerProvider;
    private final SymbolUsageValidator symbolUsageValidator;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final ResolveSession resolveSession;
    private final ScopeProvider scopeProvider;
    private final LazyResolveToken lazyResolveToken;
    private final AnnotationResolver annotationResolver;
    private final CallResolver callResolver;
    private final ArgumentTypeResolver argumentTypeResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final ExpressionTypingComponents expressionTypingComponents;
    private final CallExpressionResolver callExpressionResolver;
    private final ControlStructureTypingUtils controlStructureTypingUtils;
    private final DescriptorResolver descriptorResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final TypeResolver typeResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final TypeResolver.FlexibleTypeCapabilitiesProvider flexibleTypeCapabilitiesProvider;
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    private final FakeCallResolver fakeCallResolver;
    private final FunctionDescriptorResolver functionDescriptorResolver;
    private final LocalClassifierAnalyzer localClassifierAnalyzer;
    private final MultiDeclarationResolver multiDeclarationResolver;
    private final ReflectionTypes reflectionTypes;
    private final ValueParameterResolver valueParameterResolver;
    private final StatementFilter statementFilter;
    private final CallCompleter callCompleter;
    private final CandidateResolver candidateResolver;
    private final TaskPrioritizer taskPrioritizer;
    private final JetImportsFactory jetImportsFactory;
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final DeclarationScopeProviderImpl declarationScopeProvider;
    private final ScriptBodyResolver scriptBodyResolver;
    private final ScopeProvider.AdditionalFileScopeProvider additionalFileScopeProvider;

    public InjectorForLazyResolve(@NotNull ModuleContext moduleContext, @NotNull DeclarationProviderFactory declarationProviderFactory2, @NotNull BindingTrace bindingTrace, @NotNull AdditionalCheckerProvider additionalCheckerProvider, @NotNull DynamicTypesSettings dynamicTypesSettings) {
        if (moduleContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleContext", "org/jetbrains/kotlin/di/InjectorForLazyResolve", "<init>"));
        }
        if (declarationProviderFactory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProviderFactory", "org/jetbrains/kotlin/di/InjectorForLazyResolve", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/di/InjectorForLazyResolve", "<init>"));
        }
        if (additionalCheckerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCheckerProvider", "org/jetbrains/kotlin/di/InjectorForLazyResolve", "<init>"));
        }
        if (dynamicTypesSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamicTypesSettings", "org/jetbrains/kotlin/di/InjectorForLazyResolve", "<init>"));
        }
        this.moduleContext = moduleContext;
        this.kotlinBuiltIns = moduleContext.getBuiltIns();
        this.moduleDescriptor = moduleContext.getModule();
        this.platformToKotlinClassMap = moduleContext.getPlatformToKotlinClassMap();
        this.project = moduleContext.getProject();
        this.storageManager = moduleContext.getStorageManager();
        this.declarationProviderFactory = declarationProviderFactory2;
        this.bindingTrace = bindingTrace;
        this.additionalCheckerProvider = additionalCheckerProvider;
        this.symbolUsageValidator = additionalCheckerProvider.getSymbolUsageValidator();
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.resolveSession = new ResolveSession(this.project, moduleContext, this.moduleDescriptor, declarationProviderFactory2, bindingTrace);
        this.scopeProvider = new ScopeProvider(this.getResolveSession());
        this.lazyResolveToken = new LazyResolveToken();
        this.annotationResolver = new AnnotationResolver();
        this.callResolver = new CallResolver();
        this.argumentTypeResolver = new ArgumentTypeResolver();
        this.expressionTypingComponents = new ExpressionTypingComponents();
        this.expressionTypingServices = new ExpressionTypingServices(this.expressionTypingComponents);
        this.callExpressionResolver = new CallExpressionResolver(this.callResolver, this.kotlinBuiltIns);
        this.controlStructureTypingUtils = new ControlStructureTypingUtils(this.callResolver);
        this.descriptorResolver = new DescriptorResolver();
        this.delegatedPropertyResolver = new DelegatedPropertyResolver();
        this.qualifiedExpressionResolver = new QualifiedExpressionResolver();
        this.flexibleTypeCapabilitiesProvider = new TypeResolver.FlexibleTypeCapabilitiesProvider();
        this.typeResolver = new TypeResolver(this.annotationResolver, this.qualifiedExpressionResolver, this.moduleDescriptor, this.flexibleTypeCapabilitiesProvider, this.storageManager, this.lazyResolveToken, dynamicTypesSettings);
        this.forLoopConventionsChecker = new ForLoopConventionsChecker();
        this.fakeCallResolver = new FakeCallResolver(this.project, this.callResolver);
        this.functionDescriptorResolver = new FunctionDescriptorResolver(this.typeResolver, this.descriptorResolver, this.annotationResolver, this.storageManager, this.expressionTypingServices, this.kotlinBuiltIns);
        this.localClassifierAnalyzer = new LocalClassifierAnalyzer(this.descriptorResolver, this.functionDescriptorResolver, this.typeResolver, this.annotationResolver);
        this.multiDeclarationResolver = new MultiDeclarationResolver(this.fakeCallResolver, this.descriptorResolver, this.typeResolver, this.symbolUsageValidator);
        this.reflectionTypes = new ReflectionTypes(this.moduleDescriptor);
        this.valueParameterResolver = new ValueParameterResolver(additionalCheckerProvider, this.expressionTypingServices);
        this.statementFilter = new StatementFilter();
        this.candidateResolver = new CandidateResolver();
        this.callCompleter = new CallCompleter(this.argumentTypeResolver, this.candidateResolver);
        this.taskPrioritizer = new TaskPrioritizer(this.storageManager);
        this.jetImportsFactory = new JetImportsFactory();
        this.lazyDeclarationResolver = new LazyDeclarationResolver(moduleContext, bindingTrace);
        this.declarationScopeProvider = new DeclarationScopeProviderImpl(this.lazyDeclarationResolver);
        this.scriptBodyResolver = new ScriptBodyResolver();
        this.additionalFileScopeProvider = new ScopeProvider.AdditionalFileScopeProvider();
        this.resolveSession.setAnnotationResolve(this.annotationResolver);
        this.resolveSession.setDescriptorResolver(this.descriptorResolver);
        this.resolveSession.setFunctionDescriptorResolver(this.functionDescriptorResolver);
        this.resolveSession.setJetImportFactory(this.jetImportsFactory);
        this.resolveSession.setLazyDeclarationResolver(this.lazyDeclarationResolver);
        this.resolveSession.setQualifiedExpressionResolver(this.qualifiedExpressionResolver);
        this.resolveSession.setScopeProvider(this.scopeProvider);
        this.resolveSession.setScriptBodyResolver(this.scriptBodyResolver);
        this.resolveSession.setTypeResolver(this.typeResolver);
        this.scopeProvider.setAdditionalFileScopesProvider(this.additionalFileScopeProvider);
        this.scopeProvider.setDeclarationScopeProvider(this.declarationScopeProvider);
        this.annotationResolver.setCallResolver(this.callResolver);
        this.annotationResolver.setStorageManager(this.storageManager);
        this.annotationResolver.setTypeResolver(this.typeResolver);
        this.callResolver.setAdditionalCheckerProvider(additionalCheckerProvider);
        this.callResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.callResolver.setCallCompleter(this.callCompleter);
        this.callResolver.setCandidateResolver(this.candidateResolver);
        this.callResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.callResolver.setTaskPrioritizer(this.taskPrioritizer);
        this.callResolver.setTypeResolver(this.typeResolver);
        this.argumentTypeResolver.setBuiltIns(this.kotlinBuiltIns);
        this.argumentTypeResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.argumentTypeResolver.setTypeResolver(this.typeResolver);
        this.expressionTypingServices.setStatementFilter(this.statementFilter);
        this.expressionTypingComponents.setAdditionalCheckerProvider(additionalCheckerProvider);
        this.expressionTypingComponents.setAnnotationResolver(this.annotationResolver);
        this.expressionTypingComponents.setBuiltIns(this.kotlinBuiltIns);
        this.expressionTypingComponents.setCallExpressionResolver(this.callExpressionResolver);
        this.expressionTypingComponents.setCallResolver(this.callResolver);
        this.expressionTypingComponents.setControlStructureTypingUtils(this.controlStructureTypingUtils);
        this.expressionTypingComponents.setDescriptorResolver(this.descriptorResolver);
        this.expressionTypingComponents.setDynamicTypesSettings(dynamicTypesSettings);
        this.expressionTypingComponents.setExpressionTypingServices(this.expressionTypingServices);
        this.expressionTypingComponents.setForLoopConventionsChecker(this.forLoopConventionsChecker);
        this.expressionTypingComponents.setFunctionDescriptorResolver(this.functionDescriptorResolver);
        this.expressionTypingComponents.setGlobalContext(moduleContext);
        this.expressionTypingComponents.setLocalClassifierAnalyzer(this.localClassifierAnalyzer);
        this.expressionTypingComponents.setMultiDeclarationResolver(this.multiDeclarationResolver);
        this.expressionTypingComponents.setPlatformToKotlinClassMap(this.platformToKotlinClassMap);
        this.expressionTypingComponents.setReflectionTypes(this.reflectionTypes);
        this.expressionTypingComponents.setSymbolUsageValidator(this.symbolUsageValidator);
        this.expressionTypingComponents.setTypeResolver(this.typeResolver);
        this.expressionTypingComponents.setValueParameterResolver(this.valueParameterResolver);
        this.callExpressionResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setAnnotationResolver(this.annotationResolver);
        this.descriptorResolver.setBuiltIns(this.kotlinBuiltIns);
        this.descriptorResolver.setDelegatedPropertyResolver(this.delegatedPropertyResolver);
        this.descriptorResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.descriptorResolver.setStorageManager(this.storageManager);
        this.descriptorResolver.setTypeResolver(this.typeResolver);
        this.delegatedPropertyResolver.setAdditionalCheckerProvider(additionalCheckerProvider);
        this.delegatedPropertyResolver.setBuiltIns(this.kotlinBuiltIns);
        this.delegatedPropertyResolver.setCallResolver(this.callResolver);
        this.delegatedPropertyResolver.setExpressionTypingServices(this.expressionTypingServices);
        this.qualifiedExpressionResolver.setSymbolUsageValidator(this.symbolUsageValidator);
        this.forLoopConventionsChecker.setBuiltIns(this.kotlinBuiltIns);
        this.forLoopConventionsChecker.setFakeCallResolver(this.fakeCallResolver);
        this.forLoopConventionsChecker.setSymbolUsageValidator(this.symbolUsageValidator);
        this.candidateResolver.setArgumentTypeResolver(this.argumentTypeResolver);
        this.jetImportsFactory.setProject(this.project);
        this.lazyDeclarationResolver.setDeclarationScopeProvider(this.declarationScopeProvider);
        this.lazyDeclarationResolver.setTopLevelDescriptorProvider(this.resolveSession);
        this.declarationScopeProvider.setFileScopeProvider(this.scopeProvider);
        this.scriptBodyResolver.setAdditionalCheckerProvider(additionalCheckerProvider);
        this.scriptBodyResolver.setExpressionTypingServices(this.expressionTypingServices);
    }

    @PreDestroy
    public void destroy() {
    }

    public ResolveSession getResolveSession() {
        return this.resolveSession;
    }
}

