/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingPackage$sam$Function$75ae0dca;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.InferencePackage$CapturedTypeConstructor$6c84c44e;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeConstructorMismatch;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u001d )I!+\u001a8eKJ,'o\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*YA-[1h]>\u001cH/[2t\u0015%\u0011XM\u001c3fe&twMC\u0002B]fTq\"Q'C\u0013\u001e+v*V*`\u0007\u0006cEj\u0015\u0006\t%\u0016tG-\u001a:fe*A!/\u001a8eKJ,'O\u0003\u0006D_2dWm\u0019;j_:TABU3t_24X\rZ\"bY2TqA]3t_24XMC\u0003dC2d7OC\u0003n_\u0012,GN\u0003\nhKR\fUJQ%H+>+6kX\"B\u00192\u001b&\u0002F\"M\u0003N\u001bViU0P%~\u001bV\tU!S\u0003R+EIC\bDY\u0006\u001c8\u000fR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b/\u001d,Go\u0011'B'N+5kX(S?N+\u0005+\u0011*B)\u0016#%\u0002\u0005#F\u00072\u000b%+\u0011+J\u001f:{f*Q'F\u0015MQU\r\u001e(b[\u0016$G)Z2mCJ\fG/[8o\u0015\r\u00018/\u001b\u0006\u0014O\u0016$H)R\"M\u0003J\u000bE+S(O?:\u000bU*\u0012\u0006\r\u000b2+U*\u0012(U?R+\u0005\f\u0016\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'NC\bhKR,E*R'F\u001dR{F+\u0012-U\u0015\rauj\u0012\u0006\u0007\u0019><w-\u001a:\u000b\u000f=\u0004XM\\1qS*QA-[1h]>\u001cH/[2\u000b\u000f9{GOT;mY*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XM\u0003\u0003O\u00036+%\"\u0002(b[\u0016$'bB4fi:\u000bU*\u0012\u0006\u0017%\u0016sE)\u0012*`\u00072\u000b5kU0P%~{%IS#D)*\u0001\"*\u001a;DY\u0006\u001c8o\u0014:PE*,7\r\u001e\u0006\u001aO\u0016$(+\u0012(E\u000bJ{6\tT!T'~{%kX(C\u0015\u0016\u001bEKC\u000eS\u000b:#UIU0D\u0019\u0006\u001b6kX(S?>\u0013%*R\"U?:\u000bU*\u0012\u0006\u001fO\u0016$(+\u0012(E\u000bJ{6\tT!T'~{%kX(C\u0015\u0016\u001bEk\u0018(B\u001b\u0016S!DU#O\t\u0016\u0013vlQ(M\u0019\u0016\u001bE+S(O?>3u\fV-Q\u000bNSqAS3u)f\u0004XMC\u0003usB,7OC\u000fhKR\u0014VI\u0014#F%~\u001bu\n\u0014'F\u0007RKuJT0P\r~#\u0016\fU#T\u0015a\u0011VI\u0014#F%~\u001buJT*U%\u0006Ke\nV0T3N#V)\u0014\u0006\u0011\u0007>t7\u000f\u001e:bS:$8+_:uK6T\u0011\"\u001b8gKJ,gnY3\u000b7\u001d,GOU#O\t\u0016\u0013vlQ(O'R\u0013\u0016)\u0013(U?NK6\u000bV#N\u0015a\u0011VI\u0014#F%~\u0003vjU%U\u0013>suLV!S\u0013\u0006s5)\u0012\u0006\t-\u0006\u0014\u0018.\u00198dK*Yr-\u001a;S\u000b:#UIU0Q\u001fNKE+S(O?Z\u000b%+S!O\u0007\u0016S1BU#O\t\u0016\u0013v\fV-Q\u000b*qq-\u001a;S\u000b:#UIU0U3B+%B\u0005*F\u001d\u0012+%k\u0018+Z!\u0016{&iT+O\tNS!\u0002V=qK\n{WO\u001c3t\u0015U9W\r\u001e*F\u001d\u0012+%k\u0018+Z!\u0016{&iT+O\tNSaa\u0015+S\u0013:;%BB*ue&twMC\u0005hKR\u001cFKU%O\u000f*IA\u000b\u0013*P/\u0006\u0013E*\u0012\u0006\n)\"\u0014xn^1cY\u0016TAbZ3u)\"\u0013vjV!C\u0019\u0016S\u0011\u0002V(`'R\u0013\u0016JT$\u000b\u0019\u001d,G\u000fV(`'R\u0013\u0016JT$\u000bYQK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~\u001b\u0015I\u0014(P)~\u001b\u0015\t\u0015+V%\u0016{F+\u0017)F'~\u0013VI\u0014#F%\u0016\u0013&BE%oM\u0016\u0014XM\\2f\u000bJ\u0014xN\u001d#bi\u0006TqfZ3u)f\u0003ViX%O\r\u0016\u0013VIT\"F?\u000e\u000beJT(U?\u000e\u000b\u0005\u000bV+S\u000b~#\u0016\fU#T?J+e\nR#S\u000bJS\u0011\u0007V-Q\u000b~KeJR#S\u000b:\u001bUiX\"P\u001d\u001ac\u0015j\u0011+J\u001d\u001e{6+\u0016\"T)&#V\u000bV%P\u001dN{&+\u0012(E\u000bJ+%K\u0003\u001bhKR$\u0016\fU#`\u0013:3UIU#O\u0007\u0016{6i\u0014(G\u0019&\u001bE+\u0013(H?N+&i\u0015+J)V#\u0016j\u0014(T?J+e\nR#S\u000bJSA\u0007V-Q\u000b~KeJR#S\u000b:\u001bUi\u0018(P?&sei\u0014*N\u0003RKuJT0G\u001fJ{\u0006+\u0011*B\u001b\u0016#VIU0S\u000b:#UIU#S\u0015]:W\r\u001e+Z!\u0016{\u0016J\u0014$F%\u0016s5)R0O\u001f~KeJR(S\u001b\u0006#\u0016j\u0014(`\r>\u0013v\fU!S\u00036+E+\u0012*`%\u0016sE)\u0012*F%*\tD+\u0017)F?&se)\u0012*F\u001d\u000e+u\fV-Q\u000b~\u001buJT*U%V\u001bEk\u0014*`\u001b&\u001bV*\u0011+D\u0011~\u0013VI\u0014#F%\u0016\u0013&\u0002N4fiRK\u0006+R0J\u001d\u001a+%+\u0012(D\u000b~#\u0016\fU#`\u0007>s5\u000b\u0016*V\u0007R{%kX'J'6\u000bEk\u0011%`%\u0016sE)\u0012*F%*aC+\u0017)F?&se)\u0012*F\u001d\u000e+u,\u0016)Q\u000bJ{&iT+O\t~3\u0016j\u0014'B)\u0016#uLU#O\t\u0016\u0013VI\u0015\u00060O\u0016$H+\u0017)F?&se)\u0012*F\u001d\u000e+u,\u0016)Q\u000bJ{&iT+O\t~3\u0016j\u0014'B)\u0016#uLU#O\t\u0016\u0013VI\u0015\u0006\u0002)*q1m\\7nCN+\u0007/\u0019:bi\u0016$'\u0002D5uK6\u0014VM\u001c3fe\u0016\u0014(\"\n:f]\u0012,'oQ1o]>$8)\u00199ukJ,G+\u001f9f!\u0006\u0014\u0018-\\3uKJ,%O]8s\u0015IIgNZ3sK:\u001cW-\u0012:s_J$\u0015\r^1\u000b\rI,7/\u001e7u\u0015a!\u0016M\u00197fI\u0012+7o\u0019:jaR|'OU3oI\u0016\u0014XM\u001d\u0006-e\u0016tG-\u001a:D_:4G.[2uS:<7+\u001e2ti&$X\u000f^5p]NLeNZ3sK:\u001cW-\u0012:s_JTaC]3oI\u0016\u00148i\u001c8tiJ\f\u0017N\u001c;TsN$X-\u001c\u0006\u0011G>t7\u000f\u001e:bS:$8+_:uK6TAA[1wC*!A.\u00198h\u0015I\u0011XM\u001c3fe\u0012+'-^4NKN\u001c\u0018mZ3\u000b\u000f5,7o]1hK*!#/\u001a8eKJtu.\u00138g_Jl\u0017\r^5p]\u001a{'\u000fU1sC6,G/\u001a:FeJ|'O\u0003\tsK:$WM\u001d+za\u0016\u0014u.\u001e8eg*QA/\u001f9f\u0005>,h\u000eZ:\u000bEI,g\u000eZ3s)f\u0004XmQ8ogR\u0014Xo\u0019;pe6K7/\\1uG\",%O]8s\u0015-\u0011XM\u001c3feRK\b/Z:\u000b\tU$\u0018\u000e\u001c\u0006'e\u0016tG-\u001a:VaB,'OQ8v]\u00124\u0016n\u001c7bi\u0016$\u0017J\u001c4fe\u0016t7-Z#se>\u0014([\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0003\t\u0005AI!B\u0002\u0005\t!!A\u0002A\u0003\u0004\t\rAQ\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001BB\u0003\u0003\t\u0017Ai!\u0002\u0002\u0005\r!9Qa\u0001C\u0007\u0011\u0017a\u0001!\u0002\u0002\u0005\t!!QA\u0001\u0003\u0002\u0011%)1\u0001\u0002\u0005\t\u00121\u0001QA\u0001\u0003\u0002\u0011-)1\u0001B\u0005\t\u00161\u0001Q!\u0001\u0005\u000e\u000b\t!!\u0002c\u0007\u0006\u0005\u0011U\u0001bC\u0003\u0004\t-AI\u0002\u0004\u0001\u0006\u0005\u0011U\u0001rD\u0003\u0003\t1A\u0001#B\u0002\u0005\u001a!yA\u0002A\u0003\u0003\t\u0003A\u0011#B\u0002\u0005\u001c!\u0005B\u0002A\u0003\u0003\t3Aq\"B\u0002\u0005\u0011!\u0015B\u0002A\u0003\u0004\t%AA\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001bF\u0003\u0004\tAAi\u0003\u0004\u0001\u0006\u0005\u00111\u0001\"G\u0003\u0004\tEA\t\u0004\u0004\u0001\u0006\u0007\u0011\u0001\u0002R\u0007\u0007\u0001\u000b\r!\u0011\u0003C\u000f\r\u0001\u0015\u0019Aa\u0001E\u001f\u0019\u0001)1\u0001B\u0002\tA1\u0001Qa\u0001\u0003\u0012\u0011\u000bb\u0001!B\u0002\u0005\u0005!UC\u0002A\u0003\u0003\t\tA)&\u0002\u0002\u0005#!\u0015S!\u0001E-\u000b\t!a\u0003C\u0017\u0006\u0005\u00115\u0002RH\u0003\u0003\tEA\t$\u0002\u0002\u0005#!iRA\u0001\u0003\u0017\u0011E*!\u0001\"\r\t\u000b\u0011\u0019\u0017\u0001$\u0002\u001a\u0005\u0015\t\u0001rA\u0017\u001a\t\r$\u0001tA\u0011\r\u000b\u0005AI!C\u0005\n\u0011\u0015\t\u0001\"B\u0005\u0006\u0013\u0011)\u0011\u0001C\u0004\n\u0003\u0011\rQk\u0001\u0005\u0006\u0007\u0011\u001d\u0011\"\u0001E\b\u001b\r!y!C\u0001\t\u00105:Ba\u0019\u0003\u0019\u0011\u0005RQ!\u0001E\u0005\u0013\u001dIa!B\u0001\t\u000b%\u0019\u0011BA\u0003\u0002\u0011#)6\u0001C\u0003\u0004\t!I\u0011\u0001c\u0004\u000e\u0007\u0011M\u0011\"\u0001E\b[M!1\r\u0002\r\u000bC\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001E\n+\u000eAQa\u0001\u0003\u000b\u0013\u0005Ay!D\u0002\u0005\u0018%\t\u0001rB\u0017\u0014\t\r$\u0001\u0004D\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001rC+\u0004\u0011\u0015\u0019A\u0001D\u0005\u0002\u0011\u001fi1\u0001\u0002\b\n\u0003!=Q&\u0006\u0003b\tau\u0011\u0005D\u0003\u0002\u00115\u0001\u001a#f\u0003\u0006\u0003!iA\u0012A)\u0004\u0003\u0011q\u0011kA\u0001\u0005\u001dU\u001bA!B\u0002\u0005\u001e%\t\u0001RD\u0017\u0014\t\r$\u0001DE\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001bD+\u0004\u0011\u0015\u0019AAE\u0005\u0002\u0011\u001fi1\u0001B\n\n\u0003!=Qf\u0005\u0003d\ta\u001d\u0012EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!}Qk\u0001\u0005\u0006\u0007\u0011\u001d\u0012\"\u0001E\b\u001b\r!I#C\u0001\t\u00105\u001aBa\u0019\u0003\u0019+\u00052Q!\u0001E\u0005\u0013\rI!!B\u0001\t\u0012U\u001b\u0001\"B\u0002\u0005+%\t\u0001rB\u0007\u0004\tWI\u0011\u0001c\u0004./\u0011\u0019G\u0001\u0007\f\"\u0015\u0015\t\u0001\u0012B\u0005\b\u0013\u0019)\u0011\u0001C\u0003\n\u0007%\u0011Q!\u0001E\u0011+\u000eAQa\u0001\u0003\u0017\u0013\u0005Ay!D\u0002\u00050%\t\u0001rB\u0017\u0014\t\r$\u0001\u0004G\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u00012E+\u0004\u0011\u0015\u0019A\u0001G\u0005\u0002\u0011\u001fi1\u0001b\r\n\u0003!=Qf\u0005\u0003d\taQ\u0012EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!\u0011Rk\u0001\u0005\u0006\u0007\u0011Q\u0012\"\u0001E\b\u001b\r!1$C\u0001\t\u00105\u001aBa\u0019\u0003\u00198\u00052Q!\u0001E\u0005\u0013\rI!!B\u0001\t\"U\u001b\u0001\"B\u0002\u00058%\t\u0001rB\u0007\u0004\tqI\u0011\u0001c\u0004.'\u0011\u0019G\u0001'\u000f\"\r\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001#\nV\u0007!)1\u0001\"\u000f\n\u0003!=Qb\u0001C\u001e\u0013\u0005Ay!L\n\u0005G\u0012Ab$\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005A1#V\u0002\t\u000b\r!a$C\u0001\t\u00105\u0019AaH\u0005\u0002\u0011\u001fi3\u0003B2\u00051\u007f\tc!B\u0001\t\n%\u0019\u0011BA\u0003\u0002\u0011O)6\u0001C\u0003\u0004\t\u007fI\u0011\u0001c\u0004\u000e\u0007\u0011\u0005\u0013\"\u0001E\b[M!1\r\u0002\r\"C\u0019)\u0011\u0001#\u0003\n\u0007%\u0011Q!\u0001E\u0004+\u000eAQa\u0001\u0003\"\u0013\u0005Ay!D\u0002\u0005D%\t\u0001rB\u0017\u0014\t\r$\u0001DI\u0011\u0007\u000b\u0005AI!C\u0002\n\u0005\u0015\t\u0001\u0002F+\u0004\u0011\u0015\u0019AAI\u0005\u0002\u0011\u001fi1\u0001B\u0012\n\u0003!=Qf\u0005\u0003d\ta\u001d\u0013EB\u0003\u0002\u0011\u0013I1!\u0003\u0002\u0006\u0003!!Rk\u0001\u0005\u0006\u0007\u0011\u001d\u0013\"\u0001E\b\u001b\r!A%C\u0001\t\u00105\u001aBa\u0019\u0003\u0019J\u00052Q!\u0001E\u0005\u0013\rI!!B\u0001\t)U\u001b\u0001\"B\u0002\u0005J%\t\u0001rB\u0007\u0004\t\u0015J\u0011\u0001c\u0004.'\u0011\u0019G\u0001g\u0013\"\r\u0015\t\u0001\u0012B\u0005\u0004\u0013\t)\u0011\u0001\u0003\u000bV\u0007!)1\u0001b\u0013\n\u0003!=Qb\u0001\u0003'\u0013\u0005Ay!L\n\u0005G\u0012Aj%\t\u0004\u0006\u0003!%\u0011bA\u0005\u0003\u000b\u0005AA#V\u0002\t\u000b\r!i%C\u0001\t\u00105\u0019AaJ\u0005\u0002\u0011\u001fi\u0003\u0006b\u0002\u0012\r\u0011\u0001\u0001rJ\u000b\u0004\u000b\u0005A9\u0001$\u0001\u0019Qu]A\u0001\u0001E)\u001b\u001d)\u0011\u0001#\u0003\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001A\u0011\f\u000b\u0005AI!\u0003\u0005\n\u000f\u0015\t\u0001\"B\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001E\u001bQ\u0001\u0002\u0015\n\u0003!=Q\"\u0001E\b[s!9\u0001G\u0015\u001e\u000e\u0011\u0001\u00012K\u0007\u0003\u000b\u0005AA\u0003U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0016\u000e\u0005\u0015\t\u0001\u0012\u0006)\u0004\u0002\u0005\u0012Q!\u0001E\u0015#\u000e9A!K\u0005\u0002\u0011Ui\u0011\u0001c\u000b\u000e\u0003!)R\u0016\bC\u00041-jj\u0001\u0002\u0001\tT5\u0011Q!\u0001\u0005\u0015!\u000e\u0001QT\u0002\u0003\u0001\u0011)j!!B\u0001\t*A\u001b\t!\t\u0002\u0006\u0003!%\u0012kA\u0004\u0005W%\t\u0001\"F\u0007\u0002\u0011Wi\u0011\u0001C\u000b.'\u0011\t\u0001tKO\u0007\t\u0001AA&\u0004\u0002\u0006\u0003!\r\u0002k\u0001\u0001\"\u0005\u0015\t\u0001bE)\u0004\u000b\u0011]\u0013\"\u0001\u0005\u0018\u001b\u0005Ay#l\u0011\u0005\u0003amST\u0002\u0003\u0001\u00119j!!B\u0001\t'A\u001b\u0001!(\u0004\u0005\u0001!MSBA\u0003\u0002\u0011Q\u00016\u0011A\u0011\b\u000b\u0005A1\u0003e\t\u0016\u0007\u0015\t\u0001b\u0005G\u0001#\u000e9A1L\u0005\u0002\u0011]i\u0011\u0001C\f\u000e\u0003!-R\u0016\bC\u00041;jj\u0001\u0002\u0001\tT5\u0011Q!\u0001\u0005\u0015!\u000e\u0001QT\u0002\u0003\u0001\u0011)j!!B\u0001\t*A\u001b\t!\t\u0002\u0006\u0003!%\u0012kA\u0004\u0005^%\t\u0001\"F\u0007\u0002\u0011Wi\u0011\u0001C\u000b.'\u0011\t\u0001dLO\u0007\t\u0001Ay&\u0004\u0002\u0006\u0003!\u0015\u0002k\u0001\u0001\"\u0005\u0015\t\u0001bE)\u0004\u000b\u0011y\u0013\"\u0001\u0005\u0018\u001b\u0005A\u0001$,\u000f\u0005\ba\u0001TT\u0002\u0003\u0001\u0011'j!!B\u0001\t)A\u001b\u0001!(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011S\u00016\u0011A\u0011\u0003\u000b\u0005AI#U\u0002\b\tAJ\u0011\u0001C\u000b\u000e\u0003!-R\"\u0001\u0005\u0016[\u0005\"\u0011\u0001'\u0019\u001e\u0016\u0011\u0001\u0001bF\u0007\u0007\u000b\u0005AQ!C\u0002\n\u0005\u0015\t\u0001\u0012\u0005)\u0004\u0001\u0005bQ!\u0001\u0005\u0014!G)Z!B\u0001\t'1\u0005\u0011kA\u0001\u0005\u001dE\u001b\u0011\u0001\u0002\bR\u0007\u0015!\t'C\u0001\t/5\t\u0001\"GW\u001d\t\u000fA\u001a'(\u0004\u0005\u0001!MSBA\u0003\u0002\u0011Q\u00016\u0001AO\u0007\t\u0001A!&\u0004\u0002\u0006\u0003!%\u0002k!\u0001\"\u0005\u0015\t\u0001\u0012F)\u0004\u000f\u0011\r\u0014\"\u0001\u0005\u0016\u001b\u0005AY#D\u0001\t+U\u0002\u0001"})
public final class Renderers {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    @NotNull
    public static final Renderer<Object> TO_STRING;
    @NotNull
    public static final Renderer<String> STRING;
    @NotNull
    public static final Renderer<Throwable> THROWABLE;
    @NotNull
    public static final Renderer<Named> NAME;
    @NotNull
    public static final Renderer<PsiElement> ELEMENT_TEXT;
    @NotNull
    public static final Renderer<JetNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final Renderer<JetClassOrObject> RENDER_CLASS_OR_OBJECT;
    @NotNull
    public static final Renderer<ClassDescriptor> RENDER_CLASS_OR_OBJECT_NAME;
    @NotNull
    public static final Renderer<JetType> RENDER_TYPE;
    @NotNull
    public static final Renderer<Variance> RENDER_POSITION_VARIANCE;
    @NotNull
    public static final Renderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @NotNull
    public static final Renderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @NotNull
    public static final Renderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @NotNull
    public static final Renderer<Collection<? extends JetType>> RENDER_COLLECTION_OF_TYPES;
    @NotNull
    public static final Renderer<ConstraintSystem> RENDER_CONSTRAINT_SYSTEM;
    @NotNull
    public static final Renderer<TypeBounds> RENDER_TYPE_BOUNDS;
    public static final Renderers INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(Renderers.class);
        new Renderers();
    }

    @NotNull
    public final Renderer<Object> getTO_STRING() {
        return TO_STRING;
    }

    @NotNull
    public final Renderer<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public final Renderer<Throwable> getTHROWABLE() {
        return THROWABLE;
    }

    @NotNull
    public final Renderer<Named> getNAME() {
        return NAME;
    }

    @NotNull
    public final Renderer<PsiElement> getELEMENT_TEXT() {
        return ELEMENT_TEXT;
    }

    @NotNull
    public final Renderer<JetNamedDeclaration> getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final Renderer<JetClassOrObject> getRENDER_CLASS_OR_OBJECT() {
        return RENDER_CLASS_OR_OBJECT;
    }

    @NotNull
    public final Renderer<ClassDescriptor> getRENDER_CLASS_OR_OBJECT_NAME() {
        return RENDER_CLASS_OR_OBJECT_NAME;
    }

    @NotNull
    public final Renderer<JetType> getRENDER_TYPE() {
        return RENDER_TYPE;
    }

    @NotNull
    public final Renderer<Variance> getRENDER_POSITION_VARIANCE() {
        return RENDER_POSITION_VARIANCE;
    }

    @NotNull
    public final Renderer<Collection<? extends ResolvedCall<?>>> getAMBIGUOUS_CALLS() {
        return AMBIGUOUS_CALLS;
    }

    @platformStatic
    @NotNull
    public static final <T> Renderer<Collection<? extends T>> commaSeparated(@JetValueParameter(name="itemRenderer") @NotNull Renderer<T> itemRenderer) {
        Intrinsics.checkParameterIsNotNull(itemRenderer, "itemRenderer");
        return new Renderer<Collection<? extends T>>(itemRenderer){
            final /* synthetic */ Renderer $itemRenderer;

            /*
             * WARNING - void declaration
             */
            public final String render(@JetValueParameter(name="collection") Collection<? extends T> collection) {
                void var2_2;
                StringBuilder sb;
                StringBuilder $receiver = sb = new StringBuilder();
                Iterator<T> iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    T next = iterator2.next();
                    $receiver.append(this.$itemRenderer.render(next));
                    if (!iterator2.hasNext()) continue;
                    $receiver.append(", ");
                }
                return var2_2.toString();
            }
            {
                this.$itemRenderer = renderer;
            }
        };
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER() {
        return TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER() {
        return TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER() {
        return TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER() {
        return TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    }

    @NotNull
    public final Renderer<InferenceErrorData> getTYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER() {
        return TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), INSTANCE$.renderDebugMessage("Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> substitutors = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        for (TypeSubstitutor substitutor : substitutors) {
            CallableDescriptor substitutedDescriptor = inferenceErrorData.descriptor.substitute(substitutor);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeParameterDescriptor firstConflictingParameter = ConstraintsUtil.getFirstConflictingParameter(inferenceErrorData.constraintSystem);
        if (firstConflictingParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingParameter.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        for (CallableDescriptor substitutedDescriptor : substitutedDescriptors) {
            JetType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            HashSet<ConstraintPosition> errorPositions = Sets.newHashSet();
            ArrayList<JetType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                JetType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || JetTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<JetType>)parameterTypes, new Predicate<ConstraintPosition>(errorPositions){
                final /* synthetic */ HashSet $errorPositions;

                public final boolean apply(@JetValueParameter(name="it") ConstraintPosition it) {
                    return this.$errorPositions.contains(it);
                }
                {
                    this.$errorPositions = hashSet;
                }
            });
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderTypeConstructorMismatchError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="renderer") @NotNull TabledDescriptorRenderer renderer) {
        Collection destination;
        ConstraintError it;
        Iterable $receiver;
        Iterable $receiver2;
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(renderer, "renderer");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        if (constraintSystem == null) {
            throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
        }
        List<ConstraintError> constraintErrors = ((ConstraintSystemImpl)constraintSystem).getConstraintErrors();
        Iterable iterable = constraintErrors;
        void var5_4 = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            it = (ConstraintError)element;
            if (!(it instanceof TypeConstructorMismatch)) continue;
            destination.add(element);
        }
        $receiver2 = (List)destination;
        $receiver = $receiver2;
        destination = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            it = (ConstraintError)item;
            Collection collection2 = destination;
            ConstraintPosition constraintPosition = it.getConstraintPosition();
            collection2.add(constraintPosition);
        }
        List errorPositions = (List)destination;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, new Predicate<ConstraintPosition>(errorPositions){
            final /* synthetic */ List $errorPositions;

            public final boolean apply(@JetValueParameter(name="it") ConstraintPosition it) {
                return this.$errorPositions.contains(it);
            }
            {
                this.$errorPositions = list;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(tabledDescriptorRenderer, "renderer.table(\n        \u2026ositions.contains(it) }))");
        return tabledDescriptorRenderer;
    }

    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkParameterIsNotNull(result2, "result");
        TypeParameterDescriptor firstUnknownParameter = null;
        for (TypeParameterDescriptor typeParameter : inferenceErrorData.constraintSystem.getTypeVariables()) {
            if (!inferenceErrorData.constraintSystem.getTypeBounds(typeParameter).isEmpty()) continue;
            firstUnknownParameter = typeParameter;
            break;
        }
        if (firstUnknownParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData));
            return result2;
        }
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ");
        TypeParameterDescriptor typeParameterDescriptor = firstUnknownParameter;
        if (typeParameterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        TabledDescriptorRenderer tabledDescriptorRenderer = result2.text(textRenderer.strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkExpressionValueIsNotNull(tabledDescriptorRenderer, "result\n                .\u2026specify it explicitly.\"))");
        return tabledDescriptorRenderer;
    }

    /*
     * WARNING - void declaration
     */
    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        Object v1;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status;
        block7: {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
            Intrinsics.checkParameterIsNotNull(result2, "result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            if (constraintSystem == null) {
                throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
            }
            ConstraintSystemImpl constraintSystem2 = (ConstraintSystemImpl)constraintSystem;
            status = constraintSystem2.getStatus();
            LOG.assertTrue(status.hasViolatedUpperBound(), INSTANCE$.renderDebugMessage("Upper bound violated renderer is applied for incorrect status", inferenceErrorData));
            systemWithoutWeakConstraints = constraintSystem2.getSystemWithoutWeakConstraints();
            Iterable iterable = inferenceErrorData.descriptor.getTypeParameters();
            for (Object element : $receiver) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, it, true))) continue;
                v1 = element;
                break block7;
            }
            v1 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v1;
        if (typeParameterDescriptor == null && status.hasConflictingConstraints()) {
            return Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
        }
        if (typeParameterDescriptor == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData));
            return result2;
        }
        JetType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeParameterDescriptor).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(INSTANCE$.renderDebugMessage("System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        JetType violatedUpperBound = null;
        for (JetType upperBound : typeParameterDescriptor.getUpperBounds()) {
            JetType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || JetTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(INSTANCE$.renderDebugMessage("Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData));
            return result2;
        }
        Renderer<JetType> typeRenderer = result2.getTypeRenderer();
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(inferredValueForTypeParameter)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound)));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @platformStatic
    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@JetValueParameter(name="inferenceErrorData") @NotNull InferenceErrorData inferenceErrorData, @JetValueParameter(name="result") @NotNull TabledDescriptorRenderer result2) {
        CapturedTypeConstructor capturedTypeConstructor;
        TypeConstructor typeConstructor2;
        TypeBounds.Bound boundWithCapturedType;
        Object object;
        Object v5;
        TypeParameterDescriptor typeParameterWithCapturedConstraint;
        block8: {
            void $receiver;
            Object v2;
            Object v1;
            Object element2;
            ConstraintSystemImpl constraintSystem;
            block7: {
                void $receiver2;
                Intrinsics.checkParameterIsNotNull(inferenceErrorData, "inferenceErrorData");
                Intrinsics.checkParameterIsNotNull(result2, "result");
                ConstraintSystem constraintSystem2 = inferenceErrorData.constraintSystem;
                if (constraintSystem2 == null) {
                    throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem! cannot be cast to org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
                }
                constraintSystem = (ConstraintSystemImpl)constraintSystem2;
                List<ConstraintError> errors = constraintSystem.getConstraintErrors();
                Iterable iterable = errors;
                for (Object element2 : $receiver2) {
                    ConstraintError it = (ConstraintError)element2;
                    if (!(it instanceof CannotCapture)) continue;
                    v1 = element2;
                    break block7;
                }
                v1 = v2 = null;
            }
            if (!(v1 instanceof CannotCapture)) {
                v2 = null;
            }
            CannotCapture cannotCapture = v2;
            TypeParameterDescriptor typeParameterDescriptor = typeParameterWithCapturedConstraint = cannotCapture != null ? cannotCapture.getTypeVariable() : null;
            if (typeParameterWithCapturedConstraint == null) {
                LOG.error(INSTANCE$.renderDebugMessage("An error 'cannot capture type parameter' is not found in errors", inferenceErrorData));
                return result2;
            }
            TypeBoundsImpl typeBounds = constraintSystem.getTypeBounds(typeParameterWithCapturedConstraint);
            element2 = typeBounds.getBounds();
            for (Object element3 : $receiver) {
                TypeBounds.Bound it = (TypeBounds.Bound)element3;
                if (!InferencePackage$CapturedTypeConstructor$6c84c44e.isCaptured(it.getConstrainingType())) continue;
                v5 = element3;
                break block8;
            }
            v5 = null;
        }
        if (!(((object = (boundWithCapturedType = (TypeBounds.Bound)v5)) != null && (object = ((TypeBounds.Bound)object).getConstrainingType()) != null ? object.getConstructor() : (typeConstructor2 = null)) instanceof CapturedTypeConstructor)) {
            typeConstructor2 = null;
        }
        if ((capturedTypeConstructor = (CapturedTypeConstructor)typeConstructor2) == null) {
            LOG.error(INSTANCE$.renderDebugMessage("There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData));
            return result2;
        }
        JetType upperBound = typeParameterWithCapturedConstraint.getUpperBoundsAsType();
        String explanation = !KotlinBuiltIns.isNullableAny(upperBound) && Intrinsics.areEqual((Object)capturedTypeConstructor.getTypeProjection().getProjectionKind(), (Object)Variance.IN_VARIANCE) ? "Type parameter has an upper bound '" + result2.getTypeRenderer().render(upperBound) + "'" + " that cannot be satisfied capturing 'in' projection" : "Only top-level type projections can be captured";
        result2.text(TabledDescriptorRenderer.newText().normal("'" + typeParameterWithCapturedConstraint.getName() + "'" + " cannot capture " + "'" + capturedTypeConstructor.getTypeProjection() + "'. " + explanation));
        return result2;
    }

    @NotNull
    public final Renderer<Collection<? extends ClassDescriptor>> getCLASSES_OR_SEPARATED() {
        return CLASSES_OR_SEPARATED;
    }

    private final String renderTypes(@JetValueParameter(name="types") Collection<? extends JetType> types) {
        return StringUtil.join(types, (Function)renderTypes.1.INSTANCE$, ", ");
    }

    @NotNull
    public final Renderer<Collection<? extends JetType>> getRENDER_COLLECTION_OF_TYPES() {
        return RENDER_COLLECTION_OF_TYPES;
    }

    private final String renderConstraintSystem(@JetValueParameter(name="constraintSystem") ConstraintSystem constraintSystem) {
        Set<TypeParameterDescriptor> typeVariables = constraintSystem.getTypeVariables();
        LinkedHashSet<TypeBounds> typeBounds = Sets.newLinkedHashSet();
        for (TypeParameterDescriptor variable2 : typeVariables) {
            typeBounds.add(constraintSystem.getTypeBounds(variable2));
        }
        return "type parameter bounds:\n" + StringUtil.join((Collection)typeBounds, (Function)renderConstraintSystem.1.INSTANCE$, "\n") + "\n" + "status:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    @NotNull
    public final Renderer<ConstraintSystem> getRENDER_CONSTRAINT_SYSTEM() {
        return RENDER_CONSTRAINT_SYSTEM;
    }

    private final String renderTypeBounds(@JetValueParameter(name="typeBounds") TypeBounds typeBounds) {
        String string;
        Function1 renderBound2 = renderTypeBounds.renderBound.1.INSTANCE$;
        Name typeVariableName = typeBounds.getTypeVariable().getName();
        if (typeBounds.isEmpty()) {
            string = typeVariableName.asString();
        } else {
            Function1 function1 = renderBound2;
            string = typeVariableName + " " + StringUtil.join(typeBounds.getBounds(), (Function)(function1 == null ? null : new RenderingPackage$sam$Function$75ae0dca(function1)), ", ");
        }
        return string;
    }

    @NotNull
    public final Renderer<TypeBounds> getRENDER_TYPE_BOUNDS() {
        return RENDER_TYPE_BOUNDS;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderDebugMessage(@JetValueParameter(name="message") String message, @JetValueParameter(name="inferenceErrorData") InferenceErrorData inferenceErrorData) {
        void var3_3;
        StringBuilder sb;
        StringBuilder $receiver = sb = new StringBuilder();
        $receiver.append(message);
        $receiver.append("\nConstraint system: \n");
        $receiver.append(INSTANCE$.getRENDER_CONSTRAINT_SYSTEM().render(inferenceErrorData.constraintSystem));
        $receiver.append("\nDescriptor:\n");
        $receiver.append(inferenceErrorData.descriptor);
        $receiver.append("\nExpected type:\n");
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            $receiver.append(inferenceErrorData.expectedType);
        } else {
            $receiver.append(INSTANCE$.getRENDER_TYPE().render(inferenceErrorData.expectedType));
        }
        $receiver.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            $receiver.append(INSTANCE$.getRENDER_TYPE().render(inferenceErrorData.receiverArgumentType)).append(".");
        }
        StringBuilder stringBuilder = $receiver.append("(");
        Collection collection = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkExpressionValueIsNotNull(collection, "inferenceErrorData.valueArgumentsTypes");
        stringBuilder.append(Renderers.INSTANCE$.renderTypes(collection)).append(")");
        return var3_3.toString();
    }

    Renderers() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(Renderers.class);
        TO_STRING = TO_STRING.1.INSTANCE$;
        STRING = STRING.1.INSTANCE$;
        THROWABLE = THROWABLE.1.INSTANCE$;
        NAME = NAME.1.INSTANCE$;
        ELEMENT_TEXT = ELEMENT_TEXT.1.INSTANCE$;
        DECLARATION_NAME = DECLARATION_NAME.1.INSTANCE$;
        RENDER_CLASS_OR_OBJECT = RENDER_CLASS_OR_OBJECT.1.INSTANCE$;
        RENDER_CLASS_OR_OBJECT_NAME = RENDER_CLASS_OR_OBJECT_NAME.1.INSTANCE$;
        RENDER_TYPE = RENDER_TYPE.1.INSTANCE$;
        RENDER_POSITION_VARIANCE = RENDER_POSITION_VARIANCE.1.INSTANCE$;
        AMBIGUOUS_CALLS = AMBIGUOUS_CALLS.1.INSTANCE$;
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER = TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER.1.INSTANCE$;
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER.1.INSTANCE$;
        CLASSES_OR_SEPARATED = CLASSES_OR_SEPARATED.1.INSTANCE$;
        RENDER_COLLECTION_OF_TYPES = RENDER_COLLECTION_OF_TYPES.1.INSTANCE$;
        RENDER_CONSTRAINT_SYSTEM = RENDER_CONSTRAINT_SYSTEM.1.INSTANCE$;
        RENDER_TYPE_BOUNDS = RENDER_TYPE_BOUNDS.1.INSTANCE$;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$0(@JetValueParameter(name="$this", type="?") Renderers $this) {
        Renderers renderers = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ String access$renderConstraintSystem$2(@JetValueParameter(name="$this", type="?") Renderers $this, @JetValueParameter(name="constraintSystem") @NotNull ConstraintSystem constraintSystem) {
        return $this.renderConstraintSystem(constraintSystem);
    }

    @NotNull
    public static final /* synthetic */ String access$renderTypeBounds$3(@JetValueParameter(name="$this", type="?") Renderers $this, @JetValueParameter(name="typeBounds") @NotNull TypeBounds typeBounds) {
        return $this.renderTypeBounds(typeBounds);
    }
}

