/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataPackage$metadataProperties$768787e4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.NameCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.PropertyCollector;
import org.jetbrains.kotlin.js.inline.util.collectors.ReferenceNameCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class UtilPackage$collectUtils$36e47ae7 {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsName> collectFunctionReferencesInside(@JetValueParameter(name="scope") @NotNull JsNode scope2) {
        void var3_3;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Iterable $receiver2 = UtilPackage$collectUtils$36e47ae7.collectReferencesInside(scope2);
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList();
        for (Object element : $receiver) {
            JsName it = (JsName)element;
            if (!(MetadataPackage$metadataProperties$768787e4.getStaticRef(it) instanceof JsFunction)) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final List<JsName> collectReferencesInside(@JetValueParameter(name="scope") @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        ReferenceNameCollector receiver = new ReferenceNameCollector();
        ReferenceNameCollector $receiver = receiver;
        $receiver.accept(scope2);
        return $receiver.getReferences();
    }

    @NotNull
    public static final List<JsName> collectLocalNames(@JetValueParameter(name="function") @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope functionScope = function.getScope();
        JsScope jsScope = functionScope;
        Intrinsics.checkExpressionValueIsNotNull(jsScope, "functionScope");
        NameCollector receiver = new NameCollector(jsScope);
        NameCollector $receiver = receiver;
        $receiver.accept((JsNode)function.getBody());
        return KotlinPackage.toList((Iterable)$receiver.getNames().values());
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsExpression> collectJsProperties(@JetValueParameter(name="scope") @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        PropertyCollector collector2 = new PropertyCollector();
        collector2.accept(scope2);
        return collector2.getProperties();
    }

    @NotNull
    public static final IdentityHashMap<JsName, JsFunction> collectNamedFunctions(@JetValueParameter(name="scope") @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        IdentityHashMap<JsName, JsFunction> namedFunctions = new IdentityHashMap<JsName, JsFunction>();
        Iterator iterator2 = KotlinPackage.iterator((Map)UtilPackage$collectUtils$36e47ae7.collectJsProperties(scope2));
        while (iterator2.hasNext()) {
            JsFunction function;
            JsFunction jsFunction;
            Map.Entry entry = iterator2.next();
            JsName name = (JsName)KotlinPackage.component1(entry);
            JsExpression value = (JsExpression)KotlinPackage.component2(entry);
            JsExpression jsExpression = value;
            if (jsExpression instanceof JsFunction) {
                jsFunction = (JsFunction)value;
            } else {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(value);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            if ((function = jsFunction) == null) continue;
            KotlinPackage.set(namedFunctions, name, function);
        }
        return namedFunctions;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@JetValueParameter(name="klass") @NotNull Class<T> klass, @JetValueParameter(name="scope") @NotNull JsNode scope2) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        InstanceCollector<JsNode> receiver = new InstanceCollector<JsNode>(klass, false);
        InstanceCollector<JsNode> $receiver = receiver;
        $receiver.accept(scope2);
        return $receiver.getCollected();
    }
}

