/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.test.TestPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorPackage$CallInfo$de0d8664;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorPackage$FunctionCallCases$debd7091;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class CallTranslatorPackage$CallTranslator$4c66b138 {
    public static final boolean expectedReceivers(@JetValueParameter(name="$receiver") ResolvedCall<? extends CallableDescriptor> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    @NotNull
    public static final JsExpression translateCall(@JetValueParameter(name="context") @NotNull TranslationContext context2, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            KotlinPackage.assert(explicitReceivers.getExtensionReceiver() == null, "VariableAsFunctionResolvedCall must have one receiver");
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall();
            if (CallTranslatorPackage$CallTranslator$4c66b138.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE$.translateGet(context2, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                return CallTranslatorPackage$CallTranslator$4c66b138.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2, null));
            }
            JsExpression dispatchReceiver = CallTranslator.INSTANCE$.translateGet(context2, variableCall, null);
            if (explicitReceivers.getExtensionOrDispatchReceiver() == null) {
                return CallTranslatorPackage$CallTranslator$4c66b138.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, null, 2, null));
            }
            return CallTranslatorPackage$CallTranslator$4c66b138.translateFunctionCall(context2, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
        }
        Call call = resolvedCall.getCall();
        if (Intrinsics.areEqual((Object)call.getCallType(), (Object)Call.CallType.INVOKE) && !CallResolverUtil.isInvokeCallOnVariable(call)) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorPackage$CallTranslator$4c66b138.computeExplicitReceiversForInvoke(context2, resolvedCall, explicitReceivers);
            return CallTranslatorPackage$CallTranslator$4c66b138.translateFunctionCall(context2, resolvedCall, explicitReceiversForInvoke);
        }
        return CallTranslatorPackage$CallTranslator$4c66b138.translateFunctionCall(context2, resolvedCall, explicitReceivers);
    }

    @NotNull
    public static final JsExpression translateFunctionCall(@JetValueParameter(name="context") @NotNull TranslationContext context2, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        return CallTranslatorPackage$FunctionCallCases$debd7091.translateFunctionCall(CallTranslatorPackage$CallInfo$de0d8664.getCallInfo(context2, resolvedCall, explicitReceivers));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@JetValueParameter(name="context") @NotNull TranslationContext context2, @JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @JetValueParameter(name="explicitReceivers") @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        void value;
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        JetElement callElement = resolvedCall.getCall().getCallElement();
        boolean bl = explicitReceivers.getExtensionReceiver() == null;
        if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
            String message = "'Invoke' call must have one receiver: " + callElement;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context2){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@JetValueParameter(name="receiver") @NotNull ReceiverValue receiver) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(receiver, "receiver");
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver $receiver = expressionReceiver;
                    ExpressionReceiver it = $receiver;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall.getDispatchReceiver();
        ReceiverValue extensionReceiver2 = resolvedCall.getExtensionReceiver();
        if (dispatchReceiver.exists() && extensionReceiver2.exists()) {
            TestPackage.assertNotNull(explicitReceivers.getExtensionOrDispatchReceiver(), "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement);
        } else {
            void value2;
            boolean bl2 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (KotlinPackage.getASSERTIONS_ENABLED() && value2 == false) {
                String message = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + "\n" + " for 'invoke' resolved call: " + callElement + "\n" + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
        }
        ReceiverValue receiverValue = dispatchReceiver;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "dispatchReceiver");
        JsExpression dispatchReceiverExpression = translateReceiverAsExpression$.invoke(receiverValue);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(dispatchReceiver.exists(), extensionReceiver2.exists());
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, explicitReceivers.getExtensionOrDispatchReceiver());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, null, 2, null);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            ReceiverValue receiverValue2 = extensionReceiver2;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "extensionReceiver");
            explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(receiverValue2), null, 2, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        return explicitReceivers2;
    }
}

