/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.varianceChecker;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.platform.platformStatic;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.source.SourcePackage$KotlinSourceElement$ca3d155f;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingPackage$TypeBinding$19d38625;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"U\u0004)ya+\u0019:jC:\u001cWm\u00115fG.,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0011Xm]8mm\u0016TqB^1sS\u0006t7-Z\"iK\u000e\\WM\u001d\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0003ue\u0006\u001cWM\u0003\u0007CS:$\u0017N\\4Ue\u0006\u001cWMC\u0003dQ\u0016\u001c7NC\u0001d\u0015Y!v\u000e\u001d#po:\fe.\u00197zg&\u001c8i\u001c8uKb$(\u0002B+oSRTAb\u00195fG.\u001cE.Y:tKNTAb\u00195fG.lU-\u001c2feNT\u0011bQ8na\u0006t\u0017n\u001c8\u000b=Y\u000b'/[1oG\u0016\u001cuN\u001c4mS\u000e$H)[1h]>\u001cH/[2ECR\fGK\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!B\u0002\u0005\u0004!%A\u0002A\u0003\u0003\t\u0007AI!B\u0002\u0005\u0004!1A\u0002A\u0003\u0004\t\rAi\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001B\u0002\u0003\u0001\u0019\u000b\u0001\u0002\"\u0007\u0002\u0006\u0003!\u001dA\u0004\u0003O\t[-!\u0011\r\u0002\r\u0005C\t)\u0011\u0001\u0003\u0003V\u0007\u0011)1\u0001\u0002\u0003\n\u0003!%Qf\u0005\u0003\u00011\u0015ij\u0001\u0002\u0001\t\f5\u0011Q!\u0001\u0005\u0006!\u000e\u0001\u0011EA\u0003\u0002\u0011\u0017\t6!\u0002\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\r5\u001aB!\u0001\r\b;\u001b!\u0001\u0001c\u0003\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0006#\u000e)AaB\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004.'\u0011\t\u0001tBO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!)\u0001k\u0001\u0001\"\u0005\u0015\t\u00012B)\u0004\u000b\u0011=\u0011\"\u0001\u0003\u0001\u001b\u0005Aa!.\u000b\u0006(\u0011\u0019\u000f\u0001g\u0002\u001e\u000e\u0011\u0001\u0001\u0002B\u0007\u0003\u000b\u0005AA\u0001U\u0002\u0001C\t)\u0011\u0001#\u0002R\u0007\u0015!9!C\u0001\u0005\u00015\t\u0001\u0012\u0002"})
public final class VarianceChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private final BindingTrace trace;
    public static final Companion Companion;
    @Deprecated
    public static final Companion OBJECT$;

    static {
        $kotlinClass = Reflection.createKotlinClass(VarianceChecker.class);
        OBJECT$ = Companion = org.jetbrains.kotlin.resolve.varianceChecker.VarianceChecker$Companion.access$init$3();
    }

    public final void check(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        this.checkClasses(c);
        this.checkMembers(c);
    }

    private final void checkClasses(@JetValueParameter(name="c") TopDownAnalysisContext c) {
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> map = c.getDeclaredClasses();
        if (map == null) {
            Intrinsics.throwNpe();
        }
        for (JetClassOrObject jetClassOrObject : map.keySet()) {
            if (!(jetClassOrObject instanceof JetClass)) continue;
            for (JetDelegationSpecifier specifier : ((JetClass)jetClassOrObject).getDelegationSpecifiers()) {
                Boolean bl;
                JetTypeReference jetTypeReference = specifier.getTypeReference();
                if (jetTypeReference != null) {
                    BindingContext bindingContext = this.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
                    bl = VarianceChecker.Companion.checkTypePosition(jetTypeReference, bindingContext, Variance.OUT_VARIANCE, this.trace);
                    continue;
                }
                bl = null;
            }
            JetTypeParameterListOwner jetTypeParameterListOwner = jetClassOrObject;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            VarianceChecker.Companion.checkTypeParameters(jetTypeParameterListOwner, bindingContext, Variance.OUT_VARIANCE, this.trace);
        }
    }

    private final void checkMembers(@JetValueParameter(name="c") TopDownAnalysisContext c) {
        Iterator<Map.Entry<JetCallableDeclaration, CallableMemberDescriptor>> iterator2 = KotlinPackage.iterator(c.getMembers());
        while (iterator2.hasNext()) {
            Map.Entry<JetCallableDeclaration, CallableMemberDescriptor> entry = iterator2.next();
            JetCallableDeclaration declaration = KotlinPackage.component1(entry);
            CallableMemberDescriptor descriptor = KotlinPackage.component2(entry);
            if (Visibilities.isPrivate(descriptor.getVisibility())) continue;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            JetCallableDeclaration jetCallableDeclaration = declaration;
            Intrinsics.checkExpressionValueIsNotNull(jetCallableDeclaration, "declaration");
            CallableDescriptor callableDescriptor = descriptor;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "descriptor");
            VarianceChecker.Companion.checkCallableDeclaration(bindingContext, jetCallableDeclaration, callableDescriptor, this.trace);
        }
    }

    public VarianceChecker(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.trace = trace;
    }

    @platformStatic
    public static final void recordPrivateToThisIfNeeded(@JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="descriptor") @NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Companion.recordPrivateToThisIfNeeded(trace, descriptor);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={" \u0006)qb+\u0019:jC:\u001cWmQ8oM2L7\r\u001e#jC\u001etwn\u001d;jG\u0012\u000bG/\u0019\u0006\u0010-\u0006\u0014\u0018.\u00198dK\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u001fY\f'/[1oG\u0016\u001c\u0005.Z2lKJT1!\u00118z\u0015\u0019a\u0014N\\5u})q1m\u001c8uC&t\u0017N\\4UsB,'b\u0002&fiRK\b/\u001a\u0006\u0006if\u0004Xm\u001d\u0006\u000eif\u0004X\rU1sC6,G/\u001a:\u000b/QK\b/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNT!c\\2dkJ\u0014XM\\2f!>\u001c\u0018\u000e^5p]*Aa+\u0019:jC:\u001cWMC\thKR\u001cuN\u001c;bS:Lgn\u001a+za\u0016TQcZ3u\u001f\u000e\u001cWO\u001d:f]\u000e,\u0007k\\:ji&|gN\u0003\thKR$\u0016\u0010]3QCJ\fW.\u001a;fe:T!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001b\u0002\t\b1\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001\"\u0003\t\u000b1\u0001QA\u0001\u0003\u0002\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001Qa\u0001C\u0005\u0011!a\u0001!\u0002\u0002\u0005\n!)QA\u0001C\u0006\u0011\u001b)!\u0001\"\u0003\t\u0011\u0011\u0001AbA\r\u0003\u000b\u0005AA!L\b\u0005A\u0012AJ!\t\u0002\u0006\u0003!)Qk\u0001\u0005\u0006\u0007\u0011%\u0011\"\u0001\u0005\b\u001b\r!\t\"C\u0001\t\u000f5zA\u0001\u0019\u0003\u0019\u0010\u0005\u0012Q!\u0001E\u0007+\u000eAQa\u0001C\b\u0013\u0005A\u0001\"D\u0002\u0005\u0013%\t\u0001\u0002C\u0017\u0010\t\u0001$\u0001DB\u0011\u0003\u000b\u0005Aa!V\u0002\t\u000b\r!a!C\u0001\t\u00105\u0019A1C\u0005\u0002\u0011\u001f)|%\"\u0014\u0005G\u0004AB!(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011\u0015\u00016\u0001AO\u0007\t\u0001Aa!\u0004\u0002\u0006\u0003!1\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001rB\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0002C\t)\u0011\u0001C\u0002R\u0007%!A!C\u0001\u0005\u00015\t\u0001bB\u0007\u0002\u0011\u001fi\u0011\u0001\u0003\u0005"})
    public static final class VarianceConflictDiagnosticData {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final JetType containingType;
        @NotNull
        private final TypeParameterDescriptor typeParameter;
        @NotNull
        private final Variance occurrencePosition;

        static {
            $kotlinClass = Reflection.createKotlinClass(VarianceConflictDiagnosticData.class);
        }

        @NotNull
        public final JetType getContainingType() {
            return this.containingType;
        }

        @NotNull
        public final TypeParameterDescriptor getTypeParameter() {
            return this.typeParameter;
        }

        @NotNull
        public final Variance getOccurrencePosition() {
            return this.occurrencePosition;
        }

        public VarianceConflictDiagnosticData(@JetValueParameter(name="containingType") @NotNull JetType containingType, @JetValueParameter(name="typeParameter") @NotNull TypeParameterDescriptor typeParameter, @JetValueParameter(name="occurrencePosition") @NotNull Variance occurrencePosition) {
            Intrinsics.checkParameterIsNotNull(containingType, "containingType");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            Intrinsics.checkParameterIsNotNull((Object)occurrencePosition, "occurrencePosition");
            this.containingType = containingType;
            this.typeParameter = typeParameter;
            this.occurrencePosition = occurrencePosition;
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"d\n)I1i\\7qC:LwN\u001c\u0006\u0010-\u0006\u0014\u0018.\u00198dK\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u001fY\f'/[1oG\u0016\u001c\u0005.Z2lKJT1!\u00118z\u0015a\u0019\u0007.Z2l\u0007\u0006dG.\u00192mK\u0012+7\r\\1sCRLwN\u001c\u0006\u0006iJ\f7-\u001a\u0006\u000f\u0005&tG-\u001b8h\u0007>tG/\u001a=u\u0015-!Wm\u00197be\u0006$\u0018n\u001c8\u000b-)+GoQ1mY\u0006\u0014G.\u001a#fG2\f'/\u0019;j_:T1\u0001]:j\u0015)!Wm]2sSB$xN\u001d\u0006\u0013\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(B\u00043jC\u001etwn\u001d;jGNKgn\u001b\u0006\u000f\t&\fwM\\8ti&\u001c7+\u001b8l\u0015-!\u0017.Y4o_N$\u0018nY:\u000b\u000f\t{w\u000e\\3b]*a\u0011n]%se\u0016dWM^1oi*\u0019\"/Z2pe\u0012\u0004&/\u001b<bi\u0016$v\u000e\u00165jg*A2)\u00197mC\ndW-T3nE\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\tUs\u0017\u000e\u001e\u0006\u001ce\u0016\u001cwN\u001d3Qe&4\u0018\r^3U_RC\u0017n]%g\u001d\u0016,G-\u001a3\u000b\u0019\tKg\u000eZ5oOR\u0013\u0018mY3\u000b\u0007\u0005tGMC\u0003pi\",'O\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0011DS3u)f\u0004X\rU1sC6,G/\u001a:MSN$xj\u001e8fe*\u00192\r[3dWRK\b/\u001a)be\u0006lW\r^3sg*aA/\u001f9f!>\u001c\u0018\u000e^5p]*Aa+\u0019:jC:\u001cWMC\u0003usB,7O\u0003\tKKR$\u0016\u0010]3SK\u001a,'/\u001a8dK*\t2\r[3dWRK\b/\u001a)pg&$\u0018n\u001c8\u000b\u0011A|7/\u001b;j_:T1\u0002V=qK\nKg\u000eZ5oO*YA/\u001f9f\u0005&tG-\u001b8h\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u001d\r|g\u000e^1j]&tw\rV=qK*9!*\u001a;UsB,\u0007V\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\"\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0004\u0006\u0007\u0011)\u0001B\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0005\u0006\u0007\u00111\u0001r\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0005\u0006\u0007\u00119\u0001\"\u0003\u0007\u0001\u000b\r!9\u0001\u0003\u0006\r\u0001\u0015\u0011A1\u0001\u0005\u0006\u000b\t!Q\u0001\u0003\u0004\u0006\u0005\u00111\u0001rB\u0003\u0003\t\u001dA\u0011\"B\u0002\u0005\r!]A\u0002A\u0003\u0004\t\u000fAA\u0002\u0004\u0001\u0006\u0005\u00111\u0001rC\u0003\u0004\t\u0007AQ\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001\"D\u0003\u0002\u0011;)!\u0001B\u0007\t\u001f\u0015\u0011A1\u0004\u0005\u000b\u000b\r!Q\u0001c\b\r\u0001\u0015\u0011A!\u0001E\u0012\u000b\r!q\u0002C\t\r\u0001\u0015\u0011A!\u0002E\u0010\u000b\t!q\u0002C\t\u0006\u0007\u0011)\u0001B\u0005\u0007\u0001\u000b\t!Q\u0001\u0003\n\u0006\u0005\u0011\r\u0001\u0002F\u0003\u0004\tIA9\u0003\u0004\u0001\u0006\u0003!)RA\u0001\u0003\u0014\u0011W)!\u0001b\n\t\u000e\u0015\u0019A\u0001\u0006E\u0015\u0019\u0001)1\u0001B\b\t.1\u0001QA\u0001\u0003\u0013\u0011O)!\u0001B\b\t.\u0011\u0019\u001d\u0001D\u0002\u001a\u0005\u0015\t\u0001\u0002BW0\t\u0005AB!(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011\u0013\u00016\u0001AO\u0007\t\u0001AY!\u0004\u0002\u0006\u0003!-\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001bB\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0002;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0004\u0005\u0012Q!\u0001\u0005\t#\u000eYA\u0001B\u0005\u0002\t\u0003i\u0011\u0001#\u0005\u000e\u0003!IQ\"\u0001E\n\u001b\u0005A!\"L\n\u0005\u0003aUQT\u0002\u0003\u0001\u0011\u001di!!B\u0001\t\u000eA\u001b\u0001!\t\u0002\u0006\u0003!A\u0011kA\u0003\u0005\u0016%\tA\u0011A\u0007\u0002\u0011'i3\u0003B\u0001\u0019\u0017u5A\u0001\u0001\u0005\b\u001b\t)\u0011\u0001#\u0006Q\u0007\u0001\t#!B\u0001\t\u0017E\u001bQ\u0001B\u0006\n\u0003\u0011\u0001Q\"\u0001E\f[s!\t\u0001'\u0007\u001e\u000e\u0011\u0001\u0001\u0012B\u0007\u0003\u000b\u0005AA\u0002U\u0002\u0001;\u001b!\u0001\u0001C\u0004\u000e\u0005\u0015\t\u0001R\u0003)\u0004\u0002\u0005\u0012Q!\u0001\u0005\f#\u000e9A\u0011D\u0005\u0002\t\u0001i\u0011\u0001#\u0007\u000e\u0003!]Q&\u0007\u0003\u0002+\t)\u0011\u0001\u0003\u0005\u0019\u001cu=A\u0001\u0001\u0005\u000f\u001b\r)\u0011\u0001\u0003\u0005\r\u0002A\u001b\t!\t\u0002\u0006\u0003!A\u0011kA\u0004\u0005\u001c%\tA\u0011A\u0007\u0002\t\u0003i\u0011\u0001\u0003\b.W\u0011\tQCA\u0003\u0002\u0011;A\u0002#(\u0004\u0005\u0001!%QBA\u0003\u0002\u0011\u0013\u00016\u0011AO\u0007\t\u0001A\t#\u0004\u0002\u0006\u0003!}\u0001kA\u0001\u001e\u000e\u0011\u0001\u0001\u0012C\u0007\u0003\u000b\u0005Ay\u0001UB\u0002C\t)\u0011\u0001\u0003\u0005R\u0007-!\u0001#C\u0001\u0005\u00025\t\u0001\u0002E\u0007\u0002\u0011#i\u0011\u0001#\t\u000e\u0003!QQ\u0006\f\u0003\u0002+\t)\u0011\u0001C\t\u0019&u5A\u0001\u0001E\u0005\u001b\t)\u0011\u0001#\u0003Q\u0007\u0003ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\u0010!\u000e\tQT\u0002\u0003\u0001\u0011#i!!B\u0001\t\u0010A\u001b\u0019!I\u0002\u0006\u0003!AA\u0012A)\u0004\u0017\u0011\u0015\u0012\"\u0001\u0005\u000f\u001b\u0005A\u0019#D\u0001\t\u00125\t\u0001\u0012E\u0007\u0002\u0011)is\u0006B\u0001\u0016\r\u0015\t\u0001RE\u0005\u0004\u0013\t)\u0011\u0001#\u000b\u0019&u5A\u0001\u0001\u0005\u0017\u001b\t)\u0011\u0001C\u000bQ\u0007\u0003ij\u0001\u0002\u0001\t'5\u0011Q!\u0001E\u0010!\u000e\tQT\u0002\u0003\u0001\u0011#i!!B\u0001\t\u0010A\u001b\u0019!\t\u0002\u0006\u0003!A\u0011kA\u0006\u0005&%\tA\u0011A\u0007\u0002\u0011Wi\u0011\u0001\u0003\f\u000e\u0003!\u0005R\"\u0001\u0005\u000b[\u0017\"\u0011!\u0006\u0004\u0006\u0003!\u0015\u0012bA\u0005\u0003\u000b\u0005AI\u0003'\n\u001e\u000e\u0011\u0001\u0001bE\u0007\u0003\u000b\u0005Ay\u0002UB\u0001;\u001b!\u0001\u0001#\u0005\u000e\u0005\u0015\t\u0001r\u0002)\u0004\u0003\u0005\u0012Q!\u0001\u0005\t#\u000eIAQE\u0005\u0002\t\u0003i\u0011\u0001c\u000b\u000e\u0003!\u0005R\"\u0001\u0005\u000bk\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @platformStatic
        public final void recordPrivateToThisIfNeeded(@JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="descriptor") @NotNull CallableMemberDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
            if (this.isIrrelevant(descriptor) || Intrinsics.areEqual(descriptor.getVisibility(), Visibilities.PRIVATE) ^ true) {
                return;
            }
            PsiElement psiElement = SourcePackage$KotlinSourceElement$ca3d155f.getPsi(descriptor.getSource());
            if (!(psiElement instanceof JetCallableDeclaration)) {
                return;
            }
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
            JetCallableDeclaration jetCallableDeclaration = (JetCallableDeclaration)psiElement;
            CallableDescriptor callableDescriptor = descriptor;
            DiagnosticSink diagnosticSink = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "DiagnosticSink.DO_NOTHING");
            if (!this.checkCallableDeclaration(bindingContext, jetCallableDeclaration, callableDescriptor, diagnosticSink)) {
                this.recordPrivateToThis(descriptor);
            }
        }

        private final boolean isIrrelevant(@JetValueParameter(name="descriptor") CallableDescriptor descriptor) {
            boolean bl;
            block2: {
                DeclarationDescriptor containingClass = descriptor.getContainingDeclaration();
                if (!(containingClass instanceof ClassDescriptor)) {
                    return true;
                }
                Iterable $receiver = ((ClassDescriptor)containingClass).getTypeConstructor().getParameters();
                for (Object element : $receiver) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element;
                    if (Intrinsics.areEqual((Object)it.getVariance(), (Object)Variance.INVARIANT)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            return bl;
        }

        private final void recordPrivateToThis(@JetValueParameter(name="descriptor") CallableMemberDescriptor descriptor) {
            if (descriptor instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
            } else if (descriptor instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                Iterator<PropertyAccessorDescriptor> iterator2 = ((PropertyDescriptorImpl)descriptor).getAccessors().iterator();
                while (iterator2.hasNext()) {
                    PropertyAccessorDescriptor accessor;
                    PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = iterator2.next();
                    if (propertyAccessorDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor! cannot be cast to org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    }
                    ((PropertyAccessorDescriptorImpl)propertyAccessorDescriptor).setVisibility(Visibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw (Throwable)new IllegalStateException("Unexpected descriptor type: " + descriptor.getClass().getName());
            }
        }

        private final boolean checkCallableDeclaration(@JetValueParameter(name="trace") BindingContext trace, @JetValueParameter(name="declaration") JetCallableDeclaration declaration, @JetValueParameter(name="descriptor") CallableDescriptor descriptor, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            if (this.isIrrelevant(descriptor)) {
                return true;
            }
            boolean noError = true;
            noError &= this.checkTypeParameters(declaration, trace, Variance.IN_VARIANCE, diagnosticSink);
            JetTypeReference jetTypeReference = declaration.getReceiverTypeReference();
            noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            for (JetParameter parameter : declaration.getValueParameters()) {
                JetTypeReference jetTypeReference2 = parameter.getTypeReference();
                noError = this.and(noError, jetTypeReference2 != null ? this.checkTypePosition(jetTypeReference2, trace, Variance.IN_VARIANCE, diagnosticSink) : null);
            }
            Variance returnTypePosition = descriptor instanceof VariableDescriptor && ((VariableDescriptor)descriptor).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            TypeBinding<PsiElement> typeBinding = TypeBindingPackage$TypeBinding$19d38625.createTypeBindingForReturnType(declaration, trace);
            noError = this.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition, diagnosticSink)) : null);
            return noError;
        }

        private final boolean checkTypeParameters(@JetValueParameter(name="$receiver") JetTypeParameterListOwner $receiver, @JetValueParameter(name="trace") BindingContext trace, @JetValueParameter(name="typePosition") Variance typePosition, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            boolean noError = true;
            for (JetTypeParameter typeParameter : $receiver.getTypeParameters()) {
                JetTypeReference jetTypeReference = typeParameter.getExtendsBound();
                noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            for (JetTypeConstraint typeConstraint : $receiver.getTypeConstraints()) {
                JetTypeReference jetTypeReference = typeConstraint.getBoundTypeReference();
                noError = this.and(noError, jetTypeReference != null ? this.checkTypePosition(jetTypeReference, trace, typePosition, diagnosticSink) : null);
            }
            return noError;
        }

        private final Boolean checkTypePosition(@JetValueParameter(name="$receiver") JetTypeReference $receiver, @JetValueParameter(name="trace") BindingContext trace, @JetValueParameter(name="position") Variance position, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            TypeBinding<JetTypeElement> typeBinding = TypeBindingPackage$TypeBinding$19d38625.createTypeBinding($receiver, trace);
            return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position, diagnosticSink)) : null;
        }

        private final boolean checkTypePosition(@JetValueParameter(name="$receiver") TypeBinding<? extends PsiElement> $receiver, @JetValueParameter(name="position") Variance position, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            return this.checkTypePosition($receiver, $receiver.getJetType(), position, diagnosticSink);
        }

        private final boolean checkTypePosition(@JetValueParameter(name="$receiver") TypeBinding<? extends PsiElement> $receiver, @JetValueParameter(name="containingType") JetType containingType, @JetValueParameter(name="position") Variance position, @JetValueParameter(name="diagnosticSink") DiagnosticSink diagnosticSink) {
            ClassifierDescriptor classifierDescriptor = $receiver.getJetType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Variance declarationVariance = ((TypeParameterDescriptor)classifierDescriptor).getVariance();
                if (!declarationVariance.allowsPosition(position)) {
                    PsiElement psiElement = $receiver.getPsiElement();
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "classifierDescriptor");
                    diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on(psiElement, new VarianceConflictDiagnosticData(containingType, typeParameterDescriptor, position)));
                }
                return declarationVariance.allowsPosition(position);
            }
            boolean noError = true;
            for (TypeArgumentBinding<? extends PsiElement> argumentBinding : $receiver.getArgumentBindings()) {
                Variance newPosition;
                Variance variance;
                TypeCheckingProcedure.EnrichedProjectionKind projectionKind;
                TypeCheckingProcedure.EnrichedProjectionKind enrichedProjectionKind;
                if (argumentBinding == null || argumentBinding.getTypeParameterDescriptor() == null) continue;
                if (TypeCheckingProcedure.getEffectiveProjectionKind(argumentBinding.getTypeParameterDescriptor(), argumentBinding.getTypeProjection()) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)(enrichedProjectionKind = projectionKind), (Object)TypeCheckingProcedure.EnrichedProjectionKind.OUT)) {
                    variance = position;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.IN)) {
                    variance = position.opposite();
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.INV)) {
                    variance = Variance.INVARIANT;
                } else if (Intrinsics.areEqual((Object)enrichedProjectionKind, (Object)TypeCheckingProcedure.EnrichedProjectionKind.STAR)) {
                    variance = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((newPosition = variance) == null) continue;
                noError &= this.checkTypePosition(argumentBinding.getTypeBinding(), containingType, newPosition, diagnosticSink);
            }
            return noError;
        }

        private final boolean and(@JetValueParameter(name="$receiver") boolean $receiver, @JetValueParameter(name="other", type="?") Boolean other) {
            return other == null ? $receiver : $receiver & other;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Companion access$init$3() {
            return new Companion();
        }
    }
}

