/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleAwareProjectConfigurable<T extends UnnamedConfigurable>
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final Project myProject;
    private final String myDisplayName;
    private final String myHelpTopic;
    private final Map<Module, T> myModuleConfigurables;

    public ModuleAwareProjectConfigurable(@NotNull Project project, String displayName, String helpTopic) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/application/options/ModuleAwareProjectConfigurable", "<init>"));
        }
        this.myModuleConfigurables = new HashMap<Module, T>();
        this.myProject = project;
        this.myDisplayName = displayName;
        this.myHelpTopic = helpTopic;
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    protected boolean isSuitableForModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/application/options/ModuleAwareProjectConfigurable", "isSuitableForModule"));
        }
        return true;
    }

    public JComponent createComponent() {
        T configurable;
        if (this.myProject.isDefault() && (configurable = this.createDefaultProjectConfigurable()) != null) {
            this.myModuleConfigurables.put(null, configurable);
            return configurable.createComponent();
        }
        List modules = ContainerUtil.filter(ModuleAttachProcessor.getSortedModules(this.myProject), (Condition)new Condition<Module>(){

            public boolean value(Module module) {
                return ModuleAwareProjectConfigurable.this.isSuitableForModule(module);
            }
        });
        if (modules.size() == 1) {
            Module module = (Module)modules.get(0);
            T configurable2 = this.createModuleConfigurable(module);
            this.myModuleConfigurables.put(module, configurable2);
            return configurable2.createComponent();
        }
        Splitter splitter = new Splitter(false, 0.25f);
        final JBList moduleList = new JBList((ListModel)new CollectionListModel(modules));
        new ListSpeedSearch((JList)moduleList, new Function<Object, String>(){

            public String fun(Object o) {
                if (o instanceof Module) {
                    return ((Module)o).getName();
                }
                return null;
            }
        });
        moduleList.setSelectionMode(0);
        moduleList.setCellRenderer((ListCellRenderer)((Object)new ModuleListCellRenderer()));
        splitter.setFirstComponent((JComponent)new JBScrollPane((Component)moduleList));
        final CardLayout layout = new CardLayout();
        final JPanel cardPanel = new JPanel(layout);
        splitter.setSecondComponent((JComponent)cardPanel);
        for (Module module : modules) {
            T configurable3 = this.createModuleConfigurable(module);
            this.myModuleConfigurables.put(module, configurable3);
            JComponent component = configurable3.createComponent();
            cardPanel.add((Component)component, module.getName());
        }
        moduleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Module value = (Module)moduleList.getSelectedValue();
                layout.show(cardPanel, value.getName());
            }
        });
        if (modules.size() > 0) {
            moduleList.setSelectedIndex(0);
            layout.show(cardPanel, ((Module)modules.get(0)).getName());
        }
        return splitter;
    }

    @Nullable
    protected T createDefaultProjectConfigurable() {
        return null;
    }

    @NotNull
    protected abstract T createModuleConfigurable(Module var1);

    public boolean isModified() {
        for (UnnamedConfigurable configurable : this.myModuleConfigurables.values()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (UnnamedConfigurable configurable : this.myModuleConfigurables.values()) {
            configurable.apply();
        }
    }

    public void reset() {
        for (UnnamedConfigurable configurable : this.myModuleConfigurables.values()) {
            configurable.reset();
        }
    }

    public void disposeUIResources() {
        for (UnnamedConfigurable configurable : this.myModuleConfigurables.values()) {
            configurable.disposeUIResources();
        }
        this.myModuleConfigurables.clear();
    }

    @NotNull
    public String getId() {
        String string = this.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/ModuleAwareProjectConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/ModuleAwareProjectConfigurable", "getProject"));
        }
        return project;
    }
}

