/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRulesControl
extends ArrangementMatchingRulesControl {
    @NotNull
    public static final DataKey<ArrangementSectionRulesControl> KEY = DataKey.create((String)"Arrangement.Rule.Match.Control");
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)("#" + ArrangementSectionRulesControl.class.getName()));
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @Nullable
    private final ArrangementSectionRuleManager mySectionRuleManager;
    @Nullable
    private ArrangementStandardSettingsManager myExtendedSettingsManager;

    public ArrangementSectionRulesControl(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl.RepresentationCallback callback) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "<init>"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "<init>"));
        }
        super(settingsManager, colorsProvider, callback);
        this.mySectionRuleManager = ArrangementSectionRuleManager.getInstance(language, settingsManager, colorsProvider, this);
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
    }

    private static void appendBufferedSectionRules(@NotNull List<ArrangementSectionRule> result, @NotNull List<StdArrangementMatchRule> buffer, @Nullable String currentSectionStart) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "appendBufferedSectionRules"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "appendBufferedSectionRules"));
        }
        if (currentSectionStart == null) {
            return;
        }
        if (buffer.isEmpty()) {
            result.add(ArrangementSectionRule.create((String)currentSectionStart, null, (StdArrangementMatchRule[])new StdArrangementMatchRule[0]));
        } else {
            result.add(ArrangementSectionRule.create((String)currentSectionStart, null, (StdArrangementMatchRule[])new StdArrangementMatchRule[]{buffer.get(0)}));
            for (int j = 1; j < buffer.size(); ++j) {
                result.add(ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{buffer.get(j)}));
            }
            buffer.clear();
        }
    }

    @Override
    protected ArrangementMatchingRulesControl.MatchingRulesRendererBase createRender() {
        return new MatchingRulesRenderer();
    }

    @Override
    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        ArrangementSectionRulesValidator arrangementSectionRulesValidator = new ArrangementSectionRulesValidator(this.getModel(), this.mySectionRuleManager);
        if (arrangementSectionRulesValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "createValidator"));
        }
        return arrangementSectionRulesValidator;
    }

    @Nullable
    public ArrangementSectionRuleManager getSectionRuleManager() {
        return this.mySectionRuleManager;
    }

    public List<ArrangementSectionRule> getSections() {
        if (this.getModel().getSize() <= 0) {
            return Collections.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        ArrayList buffer = ContainerUtil.newArrayList();
        String currentSectionStart = null;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ArrangementSectionRuleManager.ArrangementSectionRuleData sectionRule;
            Object element = this.getModel().getElementAt(i);
            if (!(element instanceof StdArrangementMatchRule)) continue;
            ArrangementSectionRuleManager.ArrangementSectionRuleData arrangementSectionRuleData = sectionRule = this.mySectionRuleManager == null ? null : this.mySectionRuleManager.getSectionRuleData((StdArrangementMatchRule)element);
            if (sectionRule != null) {
                if (sectionRule.isSectionStart()) {
                    ArrangementSectionRulesControl.appendBufferedSectionRules(result, buffer, currentSectionStart);
                    currentSectionStart = sectionRule.getText();
                    continue;
                }
                result.add(ArrangementSectionRule.create((String)StringUtil.notNullize(currentSectionStart), (String)sectionRule.getText(), (List)buffer));
                buffer.clear();
                currentSectionStart = null;
                continue;
            }
            if (currentSectionStart == null) {
                result.add(ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)element}));
                continue;
            }
            buffer.add((StdArrangementMatchRule)element);
        }
        ArrangementSectionRulesControl.appendBufferedSectionRules(result, buffer, currentSectionStart);
        return result;
    }

    public void setSections(@Nullable List<ArrangementSectionRule> sections) {
        List rules = sections == null ? null : ArrangementUtil.collectMatchRules(sections);
        this.myComponents.clear();
        this.getModel().clear();
        if (rules == null) {
            return;
        }
        for (StdArrangementMatchRule rule : rules) {
            this.getModel().add(rule);
        }
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info("Arrangement matching rules list is refreshed. Given rules:");
            for (StdArrangementMatchRule rule : rules) {
                LOG.info("  " + rule.toString());
            }
        }
    }

    @Nullable
    public Collection<StdArrangementRuleAliasToken> getRulesAliases() {
        return this.myExtendedSettingsManager == null ? null : this.myExtendedSettingsManager.getRuleAliases();
    }

    public void setRulesAliases(@Nullable Collection<StdArrangementRuleAliasToken> aliases) {
        if (aliases != null) {
            this.myExtendedSettingsManager = new ArrangementStandardSettingsManager(this.mySettingsManager.getDelegate(), this.myColorsProvider, aliases);
            this.myEditor = new ArrangementMatchingRuleEditor(this.myExtendedSettingsManager, this.myColorsProvider, this);
        }
    }

    @Override
    public void showEditor(int rowToEdit) {
        if (this.mySectionRuleManager != null && this.mySectionRuleManager.isSectionRule(this.getModel().getElementAt(rowToEdit))) {
            this.mySectionRuleManager.showEditor(rowToEdit);
        } else {
            super.showEditor(rowToEdit);
        }
    }

    @NotNull
    public ArrangementRuleAliasDialog createRuleAliasEditDialog() {
        THashSet tokenIds = new THashSet();
        List<ArrangementSectionRule> sections = this.getSections();
        for (ArrangementSectionRule section : sections) {
            for (StdArrangementMatchRule rule : section.getMatchRules()) {
                rule.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor((Set)tokenIds){
                    final /* synthetic */ Set val$tokenIds;
                    {
                        this.val$tokenIds = set;
                    }

                    public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                        if (condition == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl$1", "visit"));
                        }
                        if (ArrangementUtil.isAliasedCondition((ArrangementAtomMatchCondition)condition)) {
                            this.val$tokenIds.add(condition.getType().getId());
                        }
                    }

                    public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                        if (condition == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl$1", "visit"));
                        }
                        for (ArrangementMatchCondition operand : condition.getOperands()) {
                            operand.invite((ArrangementMatchConditionVisitor)this);
                        }
                    }
                });
            }
        }
        Collection<StdArrangementRuleAliasToken> aliases = this.getRulesAliases();
        assert (aliases != null);
        ArrangementRuleAliasDialog arrangementRuleAliasDialog = new ArrangementRuleAliasDialog(null, this.mySettingsManager, this.myColorsProvider, aliases, (Set<String>)tokenIds);
        if (arrangementRuleAliasDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl", "createRuleAliasEditDialog"));
        }
        return arrangementRuleAliasDialog;
    }

    private class MatchingRulesRenderer
    extends ArrangementMatchingRulesControl.MatchingRulesRendererBase {
        private MatchingRulesRenderer() {
        }

        @Override
        public boolean allowModifications(StdArrangementMatchRule rule) {
            return ArrangementSectionRulesControl.this.mySectionRuleManager == null || !ArrangementSectionRulesControl.this.mySectionRuleManager.isSectionRule(rule);
        }
    }
}

