/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericsHighlightUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil");
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final MethodSignature ourValuesEnumSyntheticMethod = MethodSignatureUtil.createMethodSignature((String)"values", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);

    private GenericsHighlightUtil() {
    }

    @Nullable
    static HighlightInfo checkInferredTypeArguments(PsiTypeParameterListOwner listOwner, PsiElement call, PsiSubstitutor substitutor) {
        return GenericsHighlightUtil.checkInferredTypeArguments(listOwner.getTypeParameters(), call, substitutor);
    }

    @Nullable
    static HighlightInfo checkInferredTypeArguments(PsiTypeParameter[] typeParameters, PsiElement call, PsiSubstitutor substitutor) {
        Pair inferredTypeArgument = GenericsUtil.findTypeParameterWithBoundError((PsiTypeParameter[])typeParameters, (PsiSubstitutor)substitutor, (PsiElement)call, (boolean)false);
        if (inferredTypeArgument != null) {
            PsiType extendsType = (PsiType)inferredTypeArgument.second;
            PsiTypeParameter typeParameter = (PsiTypeParameter)inferredTypeArgument.first;
            PsiClass boundClass = extendsType instanceof PsiClassType ? ((PsiClassType)extendsType).resolve() : null;
            String messageKey = boundClass == null || typeParameter.isInterface() == boundClass.isInterface() ? "generics.inferred.type.for.type.parameter.is.not.within.its.bound.extend" : "generics.inferred.type.for.type.parameter.is.not.within.its.bound.implement";
            String description = JavaErrorMessages.message(messageKey, HighlightUtil.formatClass((PsiClass)typeParameter), JavaHighlightUtil.formatType(extendsType), JavaHighlightUtil.formatType(substitutor.substitute(typeParameter)));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(call).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkParameterizedReferenceTypeArguments(PsiElement resolved, PsiJavaCodeReferenceElement referenceElement, PsiSubstitutor substitutor, @NotNull JavaSdkVersion javaSdkVersion) {
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkParameterizedReferenceTypeArguments"));
        }
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            return null;
        }
        PsiTypeParameterListOwner typeParameterListOwner = (PsiTypeParameterListOwner)resolved;
        return GenericsHighlightUtil.checkReferenceTypeArgumentList(typeParameterListOwner, referenceElement.getParameterList(), substitutor, true, javaSdkVersion);
    }

    @Nullable
    static HighlightInfo checkReferenceTypeArgumentList(PsiTypeParameterListOwner typeParameterListOwner, PsiReferenceParameterList referenceParameterList, PsiSubstitutor substitutor, boolean registerIntentions, @NotNull JavaSdkVersion javaSdkVersion) {
        block15: {
            int refParametersNum;
            if (javaSdkVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkReferenceTypeArgumentList"));
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = null;
            PsiTypeElement[] referenceElements = null;
            if (referenceParameterList != null && (referenceElements = referenceParameterList.getTypeParameterElements()).length == 1 && referenceElements[0].getType() instanceof PsiDiamondType) {
                if (!typeParameterListOwner.hasTypeParameters()) {
                    String description = JavaErrorMessages.message("generics.diamond.not.applicable", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)referenceElements[0]).descriptionAndTooltip(description).create();
                }
                inferenceResult = ((PsiDiamondType)referenceElements[0].getType()).resolveInferredTypes();
                String errorMessage = inferenceResult.getErrorMessage();
                if (errorMessage != null) {
                    PsiType expectedType = GenericsHighlightUtil.detectExpectedType(referenceParameterList);
                    if (!(inferenceResult.failedToInfer() && expectedType instanceof PsiClassType && ((PsiClassType)expectedType).isRaw())) {
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)referenceElements[0]).descriptionAndTooltip(errorMessage).create();
                    }
                }
            }
            PsiTypeParameter[] typeParameters = typeParameterListOwner.getTypeParameters();
            int targetParametersNum = typeParameters.length;
            int n = refParametersNum = referenceParameterList == null ? 0 : referenceParameterList.getTypeArguments().length;
            if (targetParametersNum != refParametersNum && refParametersNum != 0) {
                String description = targetParametersNum == 0 ? (PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCall.class) != null && typeParameterListOwner instanceof PsiMethod && (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7) || GenericsHighlightUtil.hasSuperMethodsWithTypeParams((PsiMethod)typeParameterListOwner)) ? null : JavaErrorMessages.message("generics.type.or.method.does.not.have.type.parameters", GenericsHighlightUtil.typeParameterListOwnerCategoryDescription(typeParameterListOwner), GenericsHighlightUtil.typeParameterListOwnerDescription(typeParameterListOwner))) : JavaErrorMessages.message("generics.wrong.number.of.type.arguments", refParametersNum, targetParametersNum);
                if (description != null) {
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)referenceParameterList).descriptionAndTooltip(description).create();
                    if (registerIntentions) {
                        PsiElement variable;
                        PsiElement grandParent;
                        if (typeParameterListOwner instanceof PsiClass) {
                            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeClassSignatureFromUsageFix((PsiClass)typeParameterListOwner, referenceParameterList));
                        }
                        if ((grandParent = referenceParameterList.getParent().getParent()) instanceof PsiTypeElement && (variable = grandParent.getParent()) instanceof PsiVariable) {
                            if (targetParametersNum == 0) {
                                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createRemoveTypeArgumentsFix(variable));
                            }
                            GenericsHighlightUtil.registerVariableParameterizedTypeFixes(highlightInfo, (PsiVariable)variable, referenceParameterList, javaSdkVersion);
                        }
                    }
                    return highlightInfo;
                }
            }
            if (targetParametersNum <= 0 || refParametersNum == 0) break block15;
            if (inferenceResult != null) {
                PsiType[] types = inferenceResult.getTypes();
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiType type = types[i];
                    HighlightInfo highlightInfo = GenericsHighlightUtil.checkTypeParameterWithinItsBound(typeParameters[i], substitutor, type, (PsiElement)referenceElements[0], referenceParameterList);
                    if (highlightInfo == null) continue;
                    return highlightInfo;
                }
            } else {
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeElement typeElement = referenceElements[i];
                    HighlightInfo highlightInfo = GenericsHighlightUtil.checkTypeParameterWithinItsBound(typeParameters[i], substitutor, typeElement.getType(), (PsiElement)typeElement, referenceParameterList);
                    if (highlightInfo == null) continue;
                    return highlightInfo;
                }
            }
        }
        return null;
    }

    private static boolean hasSuperMethodsWithTypeParams(PsiMethod method) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            if (!superMethod.hasTypeParameters()) continue;
            return true;
        }
        return false;
    }

    private static PsiType detectExpectedType(PsiReferenceParameterList referenceParameterList) {
        PsiParameterList parameterList;
        Object[] expressions;
        int idx;
        PsiMethod method;
        PsiElement pParent;
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiNewExpression.class);
        LOG.assertTrue(newExpression != null);
        PsiElement parent = newExpression.getParent();
        PsiType expectedType = null;
        if (parent instanceof PsiVariable && newExpression.equals(((PsiVariable)parent).getInitializer())) {
            expectedType = ((PsiVariable)parent).getType();
        } else if (parent instanceof PsiAssignmentExpression && newExpression.equals(((PsiAssignmentExpression)parent).getRExpression())) {
            expectedType = ((PsiAssignmentExpression)parent).getLExpression().getType();
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement method2 = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (method2 instanceof PsiMethod) {
                expectedType = ((PsiMethod)method2).getReturnType();
            }
        } else if (parent instanceof PsiExpressionList && (pParent = parent.getParent()) instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList()) && (method = ((PsiCallExpression)pParent).resolveMethod()) != null && (idx = ArrayUtilRt.find((Object[])(expressions = ((PsiCallExpression)pParent).getArgumentList().getExpressions()), (Object)newExpression)) > -1 && idx < (parameterList = method.getParameterList()).getParametersCount()) {
            expectedType = parameterList.getParameters()[idx].getType();
        }
        return expectedType;
    }

    @Nullable
    private static HighlightInfo checkTypeParameterWithinItsBound(PsiTypeParameter classParameter, PsiSubstitutor substitutor, PsiType type, PsiElement typeElement2Highlight, PsiReferenceParameterList referenceParameterList) {
        PsiClassType[] bounds;
        PsiClass referenceClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
        PsiType psiType = substitutor.substitute(classParameter);
        if (psiType instanceof PsiClassType && !(PsiUtil.resolveClassInType((PsiType)psiType) instanceof PsiTypeParameter) && GenericsUtil.checkNotInBounds((PsiType)type, (PsiType)psiType, (PsiReferenceParameterList)referenceParameterList)) {
            String description = "Actual type argument and inferred type contradict each other";
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement2Highlight).descriptionAndTooltip("Actual type argument and inferred type contradict each other").create();
        }
        for (PsiClassType type1 : bounds = classParameter.getSuperTypes()) {
            PsiType bound = substitutor.substitute((PsiType)type1);
            if (bound.equalsToText("java.lang.Object") || !GenericsUtil.checkNotInBounds((PsiType)type, (PsiType)bound, (PsiReferenceParameterList)referenceParameterList)) continue;
            PsiClass boundClass = bound instanceof PsiClassType ? ((PsiClassType)bound).resolve() : null;
            String messageKey = boundClass == null || referenceClass == null || referenceClass.isInterface() == boundClass.isInterface() ? "generics.type.parameter.is.not.within.its.bound.extend" : "generics.type.parameter.is.not.within.its.bound.implement";
            String description = JavaErrorMessages.message(messageKey, referenceClass != null ? HighlightUtil.formatClass(referenceClass) : type.getPresentableText(), JavaHighlightUtil.formatType(bound));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(typeElement2Highlight).descriptionAndTooltip(description).create();
            if (bound instanceof PsiClassType && referenceClass != null && info != null) {
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(referenceClass, (PsiClassType)bound, true), null);
            }
            return info;
        }
        return null;
    }

    private static String typeParameterListOwnerDescription(PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return HighlightUtil.formatClass((PsiClass)typeParameterListOwner);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaHighlightUtil.formatMethod((PsiMethod)typeParameterListOwner);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    private static String typeParameterListOwnerCategoryDescription(PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return JavaErrorMessages.message("generics.holder.type", new Object[0]);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaErrorMessages.message("generics.holder.method", new Object[0]);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    @Nullable
    static HighlightInfo checkElementInTypeParameterExtendsList(@NotNull PsiReferenceList referenceList, @NotNull PsiClass aClass, @NotNull JavaResolveResult resolveResult, @NotNull PsiElement element, @NotNull LanguageLevel languageLevel) {
        String description;
        if (referenceList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceList", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkElementInTypeParameterExtendsList"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkElementInTypeParameterExtendsList"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkElementInTypeParameterExtendsList"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkElementInTypeParameterExtendsList"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkElementInTypeParameterExtendsList"));
        }
        PsiJavaCodeReferenceElement[] referenceElements = referenceList.getReferenceElements();
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom == null) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (!extendFrom.isInterface() && referenceElements.length != 0 && element != referenceElements[0]) {
            description = JavaErrorMessages.message("interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createMoveBoundClassToFrontFix(aClass, type), null);
        } else if (referenceElements.length != 0 && element != referenceElements[0] && referenceElements[0].resolve() instanceof PsiTypeParameter) {
            description = JavaErrorMessages.message("type.parameter.cannot.be.followed.by.other.bounds", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(aClass, type, false), null);
        }
        if (errorResult == null && languageLevel.isAtLeast(LanguageLevel.JDK_1_7) && referenceElements.length > 1) {
            Collection<HighlightInfo> result = GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass);
            return result != null && !result.isEmpty() ? result.iterator().next() : null;
        }
        return errorResult;
    }

    static HighlightInfo checkInterfaceMultipleInheritance(PsiClass aClass) {
        PsiClassType[] types = aClass.getSuperTypes();
        if (types.length < 2) {
            return null;
        }
        com.intellij.util.containers.HashMap inheritedClasses = new com.intellij.util.containers.HashMap();
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass, (PsiElement)aClass, PsiSubstitutor.EMPTY, (Map<PsiClass, PsiSubstitutor>)inheritedClasses, (Set<PsiClass>)new HashSet(), textRange);
    }

    private static HighlightInfo checkInterfaceMultipleInheritance(PsiClass aClass, PsiElement place, PsiSubstitutor derivedSubstitutor, Map<PsiClass, PsiSubstitutor> inheritedClasses, Set<PsiClass> visited, TextRange textRange) {
        PsiClassType[] superTypes;
        for (PsiClassType superType : superTypes = aClass.getSuperTypes()) {
            PsiClassType.ClassResolveResult result;
            PsiClass superClass;
            if ((superType = PsiClassImplUtil.correctType(superType, place.getResolveScope())) == null || (superClass = (result = superType.resolveGenerics()).getElement()) == null || visited.contains(superClass)) continue;
            PsiSubstitutor superTypeSubstitutor = result.getSubstitutor();
            superTypeSubstitutor = MethodSignatureUtil.combineSubstitutors((PsiSubstitutor)superTypeSubstitutor, (PsiSubstitutor)derivedSubstitutor);
            PsiSubstitutor inheritedSubstitutor = inheritedClasses.get(superClass);
            if (inheritedSubstitutor != null) {
                PsiTypeParameter[] typeParameters;
                for (PsiTypeParameter typeParameter : typeParameters = superClass.getTypeParameters()) {
                    PsiType type2;
                    PsiType type1 = inheritedSubstitutor.substitute(typeParameter);
                    if (Comparing.equal((Object)type1, (Object)(type2 = superTypeSubstitutor.substitute(typeParameter)))) continue;
                    String description = JavaErrorMessages.message("generics.cannot.be.inherited.with.different.type.arguments", HighlightUtil.formatClass(superClass), JavaHighlightUtil.formatType(type1), JavaHighlightUtil.formatType(type2));
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
                }
            }
            inheritedClasses.put(superClass, superTypeSubstitutor);
            visited.add(superClass);
            HighlightInfo highlightInfo = GenericsHighlightUtil.checkInterfaceMultipleInheritance(superClass, place, superTypeSubstitutor, inheritedClasses, visited, textRange);
            visited.remove(superClass);
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    static Collection<HighlightInfo> checkOverrideEquivalentMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkOverrideEquivalentMethods"));
        }
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        Collection signaturesWithSupers = aClass.getVisibleSignatures();
        PsiManager manager = aClass.getManager();
        THashMap sameErasureMethods = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashSet foundProblems = new THashSet(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        for (HierarchicalMethodSignature signature : signaturesWithSupers) {
            HighlightInfo info = GenericsHighlightUtil.checkSameErasureNotSubSignatureInner(signature, manager, aClass, (Map<MethodSignature, MethodSignatureBackedByPsiMethod>)sameErasureMethods);
            if (info != null && foundProblems.add(signature)) {
                result.add(info);
            }
            if (!(aClass instanceof PsiTypeParameter) || (info = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, signature.getSuperSignatures(), true, HighlightNamesUtil.getClassDeclarationTextRange(aClass))) == null) continue;
            result.add(info);
        }
        return result.isEmpty() ? null : result;
    }

    static HighlightInfo checkDefaultMethodOverrideEquivalentToObjectNonPrivate(@NotNull LanguageLevel languageLevel, @NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull PsiElement methodIdentifier) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkDefaultMethodOverrideEquivalentToObjectNonPrivate"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkDefaultMethodOverrideEquivalentToObjectNonPrivate"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkDefaultMethodOverrideEquivalentToObjectNonPrivate"));
        }
        if (methodIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodIdentifier", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkDefaultMethodOverrideEquivalentToObjectNonPrivate"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && aClass.isInterface() && method.hasModifierProperty("default")) {
            HierarchicalMethodSignature sig = method.getHierarchicalMethodSignature();
            for (HierarchicalMethodSignature methodSignature : sig.getSuperSignatures()) {
                PsiMethod objectMethod = methodSignature.getMethod();
                PsiClass containingClass = objectMethod.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName()) || !objectMethod.hasModifierProperty("public")) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Default method '" + sig.getName() + "' overrides a member of 'java.lang.Object'").range(methodIdentifier).create();
            }
        }
        return null;
    }

    static HighlightInfo checkUnrelatedDefaultMethods(@NotNull PsiClass aClass, @NotNull Collection<HierarchicalMethodSignature> signaturesWithSupers, @NotNull PsiIdentifier classIdentifier) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkUnrelatedDefaultMethods"));
        }
        if (signaturesWithSupers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signaturesWithSupers", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkUnrelatedDefaultMethods"));
        }
        if (classIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classIdentifier", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkUnrelatedDefaultMethods"));
        }
        for (HierarchicalMethodSignature methodSignature : signaturesWithSupers) {
            PsiMethod method = methodSignature.getMethod();
            boolean isAbstract = method.hasModifierProperty("abstract");
            if (!method.hasModifierProperty("default") && !isAbstract) continue;
            PsiClass containingClass = method.getContainingClass();
            List superSignatures = methodSignature.getSuperSignatures();
            if (superSignatures.isEmpty()) continue;
            for (HierarchicalMethodSignature signature : superSignatures) {
                PsiMethod superMethod = signature.getMethod();
                PsiClass superContainingClass = superMethod.getContainingClass();
                if (containingClass == null || superContainingClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)superContainingClass, (boolean)true)) continue;
                boolean isDefault = superMethod.hasModifierProperty("default");
                if (!(aClass.hasModifierProperty("abstract") || isDefault || isAbstract)) {
                    String message = JavaErrorMessages.message(aClass instanceof PsiEnumConstantInitializer ? "enum.constant.should.implement.method" : "class.must.be.abstract", HighlightUtil.formatClass(superContainingClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superContainingClass, false));
                    HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)classIdentifier).descriptionAndTooltip(message).create();
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
                    return info;
                }
                if (!isDefault && (isAbstract || !superMethod.hasModifierProperty("abstract"))) continue;
                String message = isDefault && !isAbstract ? " inherits unrelated defaults for " : " inherits abstract and default for ";
                String inheritUnrelatedDefaultsMessage = HighlightUtil.formatClass(aClass) + message + JavaHighlightUtil.formatMethod(method) + " from types " + HighlightUtil.formatClass(containingClass) + " and " + HighlightUtil.formatClass(superContainingClass);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)classIdentifier).descriptionAndTooltip(inheritUnrelatedDefaultsMessage).create();
                QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
                return info;
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSameErasureNotSubSignatureInner(@NotNull HierarchicalMethodSignature signature, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull Map<MethodSignature, MethodSignatureBackedByPsiMethod> sameErasureMethods) {
        HighlightInfo info;
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkSameErasureNotSubSignatureInner"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkSameErasureNotSubSignatureInner"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkSameErasureNotSubSignatureInner"));
        }
        if (sameErasureMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sameErasureMethods", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkSameErasureNotSubSignatureInner"));
        }
        PsiMethod method = signature.getMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (!facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) {
            return null;
        }
        MethodSignature signatureToErase = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignatureBackedByPsiMethod sameErasure = sameErasureMethods.get(signatureToErase);
        if (sameErasure != null) {
            if ((aClass instanceof PsiTypeParameter || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)sameErasure.getMethod(), (boolean)false) != null || !InheritanceUtil.isInheritorOrSelf((PsiClass)sameErasure.getMethod().getContainingClass(), (PsiClass)method.getContainingClass(), (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)sameErasure.getMethod().getContainingClass(), (boolean)true)) && (info = GenericsHighlightUtil.checkSameErasureNotSubSignatureOrSameClass(sameErasure, signature, aClass, method)) != null) {
                return info;
            }
        } else {
            sameErasureMethods.put(signatureToErase, (MethodSignatureBackedByPsiMethod)signature);
        }
        List supers = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            info = GenericsHighlightUtil.checkSameErasureNotSubSignatureInner(superSignature, manager, aClass, sameErasureMethods);
            if (info != null) {
                return info;
            }
            if (!superSignature.isRaw() || signature.isRaw()) continue;
            PsiType[] parameterTypes = signature.getParameterTypes();
            PsiType[] erasedTypes = superSignature.getErasedParameterTypes();
            for (int i = 0; i < erasedTypes.length; ++i) {
                if (Comparing.equal((Object)parameterTypes[i], (Object)erasedTypes[i])) continue;
                return GenericsHighlightUtil.getSameErasureMessage(false, method, superSignature.getMethod(), HighlightNamesUtil.getClassDeclarationTextRange(aClass));
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSameErasureNotSubSignatureOrSameClass(MethodSignatureBackedByPsiMethod signatureToCheck, HierarchicalMethodSignature superSignature, PsiClass aClass, PsiMethod superMethod) {
        PsiType retErasure2;
        boolean differentReturnTypeErasure;
        PsiMethod checkMethod = signatureToCheck.getMethod();
        if (superMethod.equals(checkMethod)) {
            return null;
        }
        PsiClass checkContainingClass = checkMethod.getContainingClass();
        LOG.assertTrue(checkContainingClass != null);
        PsiClass superContainingClass = superMethod.getContainingClass();
        boolean checkEqualsSuper = checkContainingClass.equals(superContainingClass);
        if (checkMethod.isConstructor() ? !superMethod.isConstructor() || !checkEqualsSuper : superMethod.isConstructor()) {
            return null;
        }
        boolean atLeast17 = JavaVersionService.getInstance().isAtLeast((PsiElement)aClass, JavaSdkVersion.JDK_1_7);
        if (checkMethod.hasModifierProperty("static") && !checkEqualsSuper && !atLeast17) {
            return null;
        }
        if (superMethod.hasModifierProperty("static") && superContainingClass != null && superContainingClass.isInterface() && PsiUtil.isLanguageLevel8OrHigher((PsiElement)superContainingClass)) {
            return null;
        }
        PsiType retErasure1 = TypeConversionUtil.erasure((PsiType)checkMethod.getReturnType());
        boolean bl = differentReturnTypeErasure = !Comparing.equal((Object)retErasure1, (Object)(retErasure2 = TypeConversionUtil.erasure((PsiType)superMethod.getReturnType())));
        if (checkEqualsSuper && atLeast17) {
            if (retErasure1 != null && retErasure2 != null) {
                differentReturnTypeErasure = !TypeConversionUtil.isAssignable((PsiType)retErasure1, (PsiType)retErasure2);
            } else {
                boolean bl2 = differentReturnTypeErasure = retErasure1 != null || retErasure2 != null;
            }
        }
        if (!(!differentReturnTypeErasure || TypeConversionUtil.isVoidType((PsiType)retErasure1) || TypeConversionUtil.isVoidType((PsiType)retErasure2) || checkEqualsSuper && Arrays.equals(superSignature.getParameterTypes(), signatureToCheck.getParameterTypes()) || atLeast17)) {
            int idx = 0;
            PsiType[] erasedTypes = signatureToCheck.getErasedParameterTypes();
            boolean erasure = erasedTypes.length > 0;
            for (PsiType type : superSignature.getParameterTypes()) {
                erasure &= Comparing.equal((Object)type, (Object)erasedTypes[idx]);
                ++idx;
            }
            if (!erasure) {
                return null;
            }
        }
        if (!checkEqualsSuper && MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)signatureToCheck)) {
            return null;
        }
        if (superContainingClass != null && !superContainingClass.isInterface() && checkContainingClass.isInterface() && !aClass.equals(superContainingClass)) {
            return null;
        }
        if (aClass.equals(checkContainingClass)) {
            boolean sameClass = aClass.equals(superContainingClass);
            return GenericsHighlightUtil.getSameErasureMessage(sameClass, checkMethod, superMethod, HighlightNamesUtil.getMethodDeclarationTextRange(checkMethod));
        }
        return GenericsHighlightUtil.getSameErasureMessage(false, checkMethod, superMethod, HighlightNamesUtil.getClassDeclarationTextRange(aClass));
    }

    private static HighlightInfo getSameErasureMessage(boolean sameClass, @NotNull PsiMethod method, @NotNull PsiMethod superMethod, TextRange textRange) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "getSameErasureMessage"));
        }
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "getSameErasureMessage"));
        }
        String key = sameClass ? "generics.methods.have.same.erasure" : (method.hasModifierProperty("static") ? "generics.methods.have.same.erasure.hide" : "generics.methods.have.same.erasure.override");
        String description = JavaErrorMessages.message(key, HighlightMethodUtil.createClashMethodMessage(method, superMethod, !sameClass));
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
    }

    static HighlightInfo checkTypeParameterInstantiation(PsiNewExpression expression) {
        PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
        if (classReference == null) {
            return null;
        }
        JavaResolveResult result = classReference.advancedResolve(false);
        PsiElement element = result.getElement();
        if (element instanceof PsiTypeParameter) {
            String description = JavaErrorMessages.message("generics.type.parameter.cannot.be.instantiated", HighlightUtil.formatClass((PsiClass)((PsiTypeParameter)element)));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)classReference).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkWildcardUsage(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (type instanceof PsiWildcardType) {
            if (typeElement.getParent() instanceof PsiReferenceParameterList) {
                PsiElement refPParent;
                PsiElement parent = typeElement.getParent().getParent();
                LOG.assertTrue(parent instanceof PsiJavaCodeReferenceElement, (Object)parent);
                PsiElement refParent = parent.getParent();
                if (refParent instanceof PsiAnonymousClass) {
                    refParent = refParent.getParent();
                }
                if (refParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)refParent;
                    if (!(newExpression.getType() instanceof PsiArrayType)) {
                        String description = JavaErrorMessages.message("wildcard.type.cannot.be.instantiated", JavaHighlightUtil.formatType(type));
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                    }
                } else if (refParent instanceof PsiReferenceList && (!((refPParent = refParent.getParent()) instanceof PsiTypeParameter) || refParent != ((PsiTypeParameter)refPParent).getExtendsList())) {
                    String description = JavaErrorMessages.message("generics.wildcard.not.expected", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                }
            } else {
                String description = JavaErrorMessages.message("generics.wildcards.may.be.used.only.as.reference.parameters", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    static HighlightInfo checkReferenceTypeUsedAsTypeArgument(PsiTypeElement typeElement) {
        PsiType type = typeElement.getType();
        if (type != PsiType.NULL && type instanceof PsiPrimitiveType || type instanceof PsiWildcardType && ((PsiWildcardType)type).getBound() instanceof PsiPrimitiveType) {
            PsiClassType boxedType;
            PsiElement element = new PsiMatcherImpl((PsiElement)typeElement).parent(PsiMatchers.hasClass(PsiReferenceParameterList.class)).parent(PsiMatchers.hasClass(PsiJavaCodeReferenceElement.class, PsiNewExpression.class)).getElement();
            if (element == null) {
                return null;
            }
            String description = JavaErrorMessages.message("generics.type.argument.cannot.be.of.primitive.type", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            PsiType toConvert = type;
            if (type instanceof PsiWildcardType) {
                toConvert = ((PsiWildcardType)type).getBound();
            }
            if (toConvert instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)toConvert).getBoxedType((PsiElement)typeElement)) != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createReplacePrimitiveWithBoxedTypeAction(typeElement, toConvert.getPresentableText(), ((PsiPrimitiveType)toConvert).getBoxedTypeName()));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkForeachExpressionTypeIsIterable(PsiExpression expression) {
        if (expression == null || expression.getType() == null) {
            return null;
        }
        PsiType itemType = JavaGenericsUtil.getCollectionItemType(expression);
        if (itemType == null) {
            String description = JavaErrorMessages.message("foreach.not.applicable", JavaHighlightUtil.formatType(expression.getType()));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkForEachParameterType(@NotNull PsiForeachStatement statement, @NotNull PsiParameter parameter) {
        PsiType itemType;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkForEachParameterType"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkForEachParameterType"));
        }
        PsiExpression expression = statement.getIteratedValue();
        PsiType psiType = itemType = expression == null ? null : JavaGenericsUtil.getCollectionItemType(expression);
        if (itemType == null) {
            return null;
        }
        PsiType parameterType = parameter.getType();
        if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(itemType, parameterType, parameter.getTextRange(), 0);
        HighlightUtil.registerChangeVariableTypeFixes((PsiVariable)parameter, itemType, expression, highlightInfo);
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkAccessStaticFieldFromEnumConstructor(@NotNull PsiReferenceExpression expr, @NotNull JavaResolveResult result) {
        PsiType type;
        PsiClass aClass;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkAccessStaticFieldFromEnumConstructor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkAccessStaticFieldFromEnumConstructor"));
        }
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        if (!((PsiModifierListOwner)resolved).hasModifierProperty("static")) {
            return null;
        }
        if (expr.getParent() instanceof PsiSwitchLabelStatement) {
            return null;
        }
        PsiMember constructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr);
        if (constructorOrInitializer == null) {
            return null;
        }
        if (constructorOrInitializer.hasModifierProperty("static")) {
            return null;
        }
        PsiClass psiClass = aClass = constructorOrInitializer instanceof PsiEnumConstantInitializer ? (PsiClass)constructorOrInitializer : constructorOrInitializer.getContainingClass();
        if (aClass == null || !aClass.isEnum() && !(aClass instanceof PsiEnumConstantInitializer)) {
            return null;
        }
        PsiField field = (PsiField)resolved;
        if (aClass instanceof PsiEnumConstantInitializer ? field.getContainingClass() != aClass.getSuperClass() : field.getContainingClass() != aClass) {
            return null;
        }
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)field, JavaSdkVersion.JDK_1_6) && (type = field.getType()) instanceof PsiClassType && ((PsiClassType)type).resolve() == aClass) {
            return null;
        }
        if (PsiUtil.isCompileTimeConstant((PsiField)field)) {
            return null;
        }
        String description = JavaErrorMessages.message("illegal.to.access.static.member.from.enum.constructor.or.instance.initializer", HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkEnumInstantiation(PsiElement expression, PsiClass aClass) {
        if (aClass != null && aClass.isEnum() && (!(expression instanceof PsiNewExpression) || ((PsiNewExpression)expression).getArrayDimensions().length == 0 && ((PsiNewExpression)expression).getArrayInitializer() == null)) {
            String description = JavaErrorMessages.message("enum.types.cannot.be.instantiated", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkGenericArrayCreation(PsiElement element, PsiType type) {
        if (type instanceof PsiArrayType && !JavaGenericsUtil.isReifiableType(((PsiArrayType)type).getComponentType())) {
            String description = JavaErrorMessages.message("generic.array.creation", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static boolean isEnumSyntheticMethod(MethodSignature methodSignature, Project project) {
        if (methodSignature.equals(ourValuesEnumSyntheticMethod)) {
            return true;
        }
        PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        MethodSignature valueOfMethod = MethodSignatureUtil.createMethodSignature((String)"valueOf", (PsiType[])new PsiType[]{javaLangString}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return valueOfMethod.equals(methodSignature);
    }

    @Nullable
    static HighlightInfo checkTypeParametersList(PsiTypeParameterList list, PsiTypeParameter[] parameters, @NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkTypeParametersList"));
        }
        PsiElement parent = list.getParent();
        if (parent instanceof PsiClass && ((PsiClass)parent).isEnum()) {
            String description = JavaErrorMessages.message("generics.enum.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            String description = JavaErrorMessages.message("generics.annotation.members.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType()) {
            String description = JavaErrorMessages.message("annotation.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiTypeParameter typeParameter1 = parameters[i];
            HighlightInfo cyclicInheritance = HighlightClassUtil.checkCyclicInheritance((PsiClass)typeParameter1);
            if (cyclicInheritance != null) {
                return cyclicInheritance;
            }
            String name1 = typeParameter1.getName();
            for (int j = i + 1; j < parameters.length; ++j) {
                PsiTypeParameter typeParameter2 = parameters[j];
                String name2 = typeParameter2.getName();
                if (!Comparing.strEqual((String)name1, (String)name2)) continue;
                String message = JavaErrorMessages.message("generics.duplicate.type.parameter", name1);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeParameter2).descriptionAndTooltip(message).create();
            }
            if (level.isAtLeast(LanguageLevel.JDK_1_7)) continue;
            for (PsiJavaCodeReferenceElement referenceElement : typeParameter1.getExtendsList().getReferenceElements()) {
                PsiElement resolve = referenceElement.resolve();
                if (!(resolve instanceof PsiTypeParameter) || ArrayUtilRt.find((Object[])parameters, (Object)resolve) <= i) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(referenceElement.getTextRange()).descriptionAndTooltip("Illegal forward reference").create();
            }
        }
        return null;
    }

    @Nullable
    static Collection<HighlightInfo> checkCatchParameterIsClass(PsiParameter parameter) {
        if (!(parameter.getDeclarationScope() instanceof PsiCatchSection)) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
            if (!(aClass instanceof PsiTypeParameter)) continue;
            String message = JavaErrorMessages.message("generics.cannot.catch.type.parameters", new Object[0]);
            result.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(message).create());
        }
        return result;
    }

    static HighlightInfo checkInstanceOfGenericType(PsiInstanceOfExpression expression) {
        PsiTypeElement checkTypeElement = expression.getCheckType();
        if (checkTypeElement == null) {
            return null;
        }
        PsiJavaCodeReferenceElement ref = checkTypeElement.getInnermostComponentReferenceElement();
        while (ref instanceof PsiJavaCodeReferenceElement) {
            HighlightInfo result = GenericsHighlightUtil.isIllegalForInstanceOf(ref, checkTypeElement);
            if (result != null) {
                return result;
            }
            ref = ((PsiQualifiedReference)ref).getQualifier();
        }
        return null;
    }

    private static HighlightInfo isIllegalForInstanceOf(PsiJavaCodeReferenceElement ref, PsiTypeElement typeElement) {
        PsiType[] parameters;
        PsiClass containingClass;
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiTypeParameter) {
            String description = JavaErrorMessages.message("generics.cannot.instanceof.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create();
        }
        if (resolved instanceof PsiClass && (containingClass = ((PsiClass)resolved).getContainingClass()) != null && ref.getQualifier() == null && containingClass.getTypeParameters().length > 0 && !((PsiClass)resolved).hasModifierProperty("static") && ((PsiClass)resolved).getTypeParameters().length == 0) {
            String description = JavaErrorMessages.message("illegal.generic.type.for.instanceof", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        for (PsiType parameterType : parameters = ref.getTypeParameters()) {
            if (parameterType == null || parameterType instanceof PsiWildcardType && ((PsiWildcardType)parameterType).getBound() == null) continue;
            String description = JavaErrorMessages.message("illegal.generic.type.for.instanceof", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        PsiType arrayComponentType;
        PsiType type = expression.getOperand().getType();
        if (type instanceof PsiClassType) {
            return GenericsHighlightUtil.canSelectFrom((PsiClassType)type, expression.getOperand());
        }
        if (type instanceof PsiArrayType && (arrayComponentType = type.getDeepComponentType()) instanceof PsiClassType) {
            return GenericsHighlightUtil.canSelectFrom((PsiClassType)arrayComponentType, expression.getOperand());
        }
        return null;
    }

    @Nullable
    private static HighlightInfo canSelectFrom(PsiClassType type, PsiTypeElement operand) {
        PsiClass aClass = type.resolve();
        if (aClass instanceof PsiTypeParameter) {
            String description = JavaErrorMessages.message("cannot.select.dot.class.from.type.variable", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)operand).descriptionAndTooltip(description).create();
        }
        if (type.getParameters().length > 0) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)operand).descriptionAndTooltip("Cannot select from parameterized type").create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkOverrideAnnotation(@NotNull PsiMethod method, @NotNull PsiAnnotation overrideAnnotation, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkOverrideAnnotation"));
        }
        if (overrideAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideAnnotation", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkOverrideAnnotation"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkOverrideAnnotation"));
        }
        try {
            PsiMethod psiMethod;
            PsiClass containingClass;
            MethodSignatureBackedByPsiMethod superMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superMethod != null && method.getContainingClass().isInterface() && (containingClass = (psiMethod = superMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && psiMethod.hasModifierProperty("protected")) {
                superMethod = null;
            }
            if (superMethod == null) {
                String description = JavaErrorMessages.message("method.does.not.override.super", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)overrideAnnotation).descriptionAndTooltip(description).create();
                QUICK_FIX_FACTORY.registerPullAsAbstractUpFixes(method, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(highlightInfo));
                return highlightInfo;
            }
            PsiClass superClass = superMethod.getMethod().getContainingClass();
            if (languageLevel.equals((Object)LanguageLevel.JDK_1_5) && superClass != null && superClass.isInterface()) {
                String description = JavaErrorMessages.message("override.not.allowed.in.interfaces", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)overrideAnnotation).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_6));
                return info;
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    @Nullable
    static HighlightInfo checkSafeVarargsAnnotation(PsiMethod method, LanguageLevel languageLevel) {
        PsiModifierList list = method.getModifierList();
        PsiAnnotation safeVarargsAnnotation = list.findAnnotation("java.lang.SafeVarargs");
        if (safeVarargsAnnotation == null) {
            return null;
        }
        try {
            PsiElement element;
            if (!method.isVarArgs()) {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)safeVarargsAnnotation).descriptionAndTooltip("@SafeVarargs is not allowed on methods with fixed arity").create();
            }
            if (!GenericsHighlightUtil.isSafeVarargsNoOverridingCondition(method, languageLevel)) {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)safeVarargsAnnotation).descriptionAndTooltip("@SafeVarargs is not allowed on non-final instance methods").create();
            }
            PsiParameter varParameter = method.getParameterList().getParameters()[method.getParameterList().getParametersCount() - 1];
            for (PsiReference reference : ReferencesSearch.search((PsiElement)varParameter)) {
                element = reference.getElement();
                if (!(element instanceof PsiExpression) || PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)element))) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(element).descriptionAndTooltip("@SafeVarargs do not suppress potentially unsafe operations").create();
            }
            LOG.assertTrue(varParameter.isVarArgs());
            PsiEllipsisType ellipsisType = (PsiEllipsisType)varParameter.getType();
            PsiType componentType = ellipsisType.getComponentType();
            if (JavaGenericsUtil.isReifiableType(componentType)) {
                element = varParameter.getTypeElement();
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(element).descriptionAndTooltip("@SafeVarargs is not applicable for reifiable types").create();
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public static boolean isSafeVarargsNoOverridingCondition(PsiMethod method, LanguageLevel languageLevel) {
        return method.hasModifierProperty("final") || method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") && languageLevel.isAtLeast(LanguageLevel.JDK_1_9);
    }

    static void checkEnumConstantForConstructorProblems(@NotNull PsiEnumConstant enumConstant, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (enumConstant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumConstant", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkEnumConstantForConstructorProblems"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkEnumConstantForConstructorProblems"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkEnumConstantForConstructorProblems"));
        }
        PsiClass containingClass = enumConstant.getContainingClass();
        if (enumConstant.getInitializingClass() == null) {
            HighlightInfo highlightInfo = HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, (PsiElement)enumConstant.getNameIdentifier());
            if (highlightInfo != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix((PsiElement)enumConstant));
                holder.add(highlightInfo);
                return;
            }
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods(enumConstant.getContainingClass(), (PsiElement)enumConstant, enumConstant.getNameIdentifier().getTextRange());
            if (highlightInfo != null) {
                holder.add(highlightInfo);
                return;
            }
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)holder.getProject()).getElementFactory().createType(containingClass);
        HighlightMethodUtil.checkConstructorCall(type.resolveGenerics(), (PsiConstructorCall)enumConstant, (PsiType)type, null, holder, javaSdkVersion);
    }

    @Nullable
    static HighlightInfo checkEnumSuperConstructorCall(PsiMethodCallExpression expr) {
        PsiClass aClass;
        PsiMember constructor;
        PsiReferenceExpression methodExpression = expr.getMethodExpression();
        PsiElement refNameElement = methodExpression.getReferenceNameElement();
        if (refNameElement != null && "super".equals(refNameElement.getText()) && (constructor = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr)) instanceof PsiMethod && (aClass = constructor.getContainingClass()) != null && aClass.isEnum()) {
            String message = JavaErrorMessages.message("call.to.super.is.not.allowed.in.enum.constructor", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkVarArgParameterIsLast(@NotNull PsiParameter parameter) {
        PsiParameter[] params;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkVarArgParameterIsLast"));
        }
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod && (params = ((PsiMethod)declarationScope).getParameterList().getParameters())[params.length - 1] != parameter) {
            String description = JavaErrorMessages.message("vararg.not.last.parameter", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)parameter).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createMakeVarargParameterLastFix(parameter));
            return info;
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkEnumConstantModifierList(PsiModifierList modifierList) {
        PsiElement[] children;
        ArrayList<HighlightInfo> list = null;
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            if (list == null) {
                list = new ArrayList<HighlightInfo>();
            }
            String description = JavaErrorMessages.message("modifiers.for.enum.constants", new Object[0]);
            list.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(child).descriptionAndTooltip(description).create());
        }
        return list;
    }

    @Nullable
    static HighlightInfo checkParametersAllowed(PsiReferenceParameterList refParamList) {
        PsiElement grandParent;
        PsiElement parent = refParamList.getParent();
        if (parent instanceof PsiReferenceExpression && !((grandParent = parent.getParent()) instanceof PsiMethodCallExpression) && !(parent instanceof PsiMethodReferenceExpression)) {
            String message = JavaErrorMessages.message("generics.reference.parameters.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refParamList).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkParametersOnRaw(PsiReferenceParameterList refParamList) {
        JavaResolveResult resolveResult = null;
        PsiElement parent = refParamList.getParent();
        PsiElement qualifier = null;
        if (parent instanceof PsiJavaCodeReferenceElement) {
            resolveResult = ((PsiJavaCodeReferenceElement)parent).advancedResolve(false);
            qualifier = ((PsiJavaCodeReferenceElement)parent).getQualifier();
        } else if (parent instanceof PsiCallExpression) {
            resolveResult = ((PsiCallExpression)parent).resolveMethodGenerics();
            if (parent instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent).getMethodExpression();
                qualifier = methodExpression.getQualifier();
            }
        }
        if (resolveResult != null) {
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            if (((PsiModifierListOwner)element).hasModifierProperty("static")) {
                return null;
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiTypeParameter) {
                return null;
            }
            PsiClass containingClass = ((PsiMember)element).getContainingClass();
            if (containingClass != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)resolveResult.getSubstitutor())) {
                if ((parent instanceof PsiCallExpression || parent instanceof PsiMethodReferenceExpression) && PsiUtil.isLanguageLevel7OrHigher((PsiElement)parent)) {
                    return null;
                }
                if (element instanceof PsiMethod) {
                    if (((PsiMethod)element).findSuperMethods().length > 0) {
                        return null;
                    }
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiType type = ((PsiReferenceExpression)qualifier).getType();
                        boolean isJavac7 = JavaVersionService.getInstance().isAtLeast((PsiElement)containingClass, JavaSdkVersion.JDK_1_7);
                        if (type instanceof PsiClassType && isJavac7 && ((PsiClassType)type).isRaw()) {
                            return null;
                        }
                        PsiClass typeParameter = PsiUtil.resolveClassInType((PsiType)type);
                        if (typeParameter instanceof PsiTypeParameter) {
                            if (isJavac7) {
                                return null;
                            }
                            for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                                PsiMethod[] superMethods;
                                PsiClass resolve = classType.resolve();
                                if (resolve == null) continue;
                                for (PsiMethod superMethod : superMethods = resolve.findMethodsBySignature((PsiMethod)element, true)) {
                                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)superMethod, (PsiSubstitutor)resolveResult.getSubstitutor())) continue;
                                    return null;
                                }
                            }
                        }
                    }
                }
                String message = element instanceof PsiClass ? JavaErrorMessages.message("generics.type.arguments.on.raw.type", new Object[0]) : JavaErrorMessages.message("generics.type.arguments.on.raw.method", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)refParamList).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    static HighlightInfo checkCannotInheritFromEnum(PsiClass superClass, PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        if (Comparing.strEqual((String)"java.lang.Enum", (String)superClass.getQualifiedName())) {
            String message = JavaErrorMessages.message("classes.extends.enum", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(message).create();
        }
        return errorResult;
    }

    static HighlightInfo checkGenericCannotExtendException(PsiReferenceList list) {
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        if (!aClass.hasTypeParameters() || aClass.getExtendsList() != list) {
            return null;
        }
        PsiJavaCodeReferenceElement[] referenceElements = list.getReferenceElements();
        PsiClass throwableClass = null;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            PsiElement resolved = referenceElement.resolve();
            if (!(resolved instanceof PsiClass)) continue;
            if (throwableClass == null) {
                throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)resolved), throwableClass, (boolean)true)) continue;
            String message = JavaErrorMessages.message("generic.extend.exception", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)referenceElement).descriptionAndTooltip(message).create();
            PsiClassType classType = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType((PsiClass)resolved);
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(aClass, classType, false));
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkEnumMustNotBeLocal(PsiClass aClass) {
        if (!aClass.isEnum()) {
            return null;
        }
        PsiElement parent = aClass.getParent();
        if (!(parent instanceof PsiClass || parent instanceof PsiFile || parent instanceof PsiClassLevelDeclarationStatement)) {
            String description = JavaErrorMessages.message("local.enum", new Object[0]);
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkEnumWithoutConstantsCantHaveAbstractMethods(PsiClass aClass) {
        if (!aClass.isEnum()) {
            return null;
        }
        for (PsiField psiField : aClass.getFields()) {
            if (!(psiField instanceof PsiEnumConstant)) continue;
            return null;
        }
        for (PsiField psiField : aClass.getMethods()) {
            if (!psiField.hasModifierProperty("abstract")) continue;
            String description = "Enum declaration without enum constants cannot have abstract methods";
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip("Enum declaration without enum constants cannot have abstract methods").create();
        }
        return null;
    }

    static HighlightInfo checkSelectStaticClassFromParameterizedType(PsiElement resolved, PsiJavaCodeReferenceElement ref) {
        PsiReferenceParameterList parameterList;
        PsiElement qualifier;
        if (resolved instanceof PsiClass && ((PsiClass)resolved).hasModifierProperty("static") && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && (parameterList = ((PsiJavaCodeReferenceElement)qualifier).getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            String message = JavaErrorMessages.message("generics.select.static.class.from.parameterized.type", HighlightUtil.formatClass((PsiClass)resolved));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)parameterList).descriptionAndTooltip(message).create();
        }
        return null;
    }

    static HighlightInfo checkCannotInheritFromTypeParameter(PsiClass superClass, PsiJavaCodeReferenceElement toHighlight) {
        if (superClass instanceof PsiTypeParameter) {
            String description = JavaErrorMessages.message("class.cannot.inherit.from.its.type.parameter", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)toHighlight).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkRawOnParameterizedType(@NotNull PsiJavaCodeReferenceElement parent, PsiElement resolved) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "checkRawOnParameterizedType"));
        }
        PsiReferenceParameterList list = parent.getParameterList();
        if (list == null || list.getTypeArguments().length > 0) {
            return null;
        }
        PsiElement qualifier = parent.getQualifier();
        if (qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).getTypeParameters().length > 0 && resolved instanceof PsiTypeParameterListOwner && ((PsiTypeParameterListOwner)resolved).hasTypeParameters() && !((PsiTypeParameterListOwner)resolved).hasModifierProperty("static")) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)parent).descriptionAndTooltip("Improper formed type; some type parameters are missing").create();
        }
        return null;
    }

    static HighlightInfo checkCannotPassInner(PsiJavaCodeReferenceElement ref) {
        if (ref.getParent() instanceof PsiTypeElement) {
            PsiElement qualifier;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            if (psiClass == null) {
                return null;
            }
            if ((PsiTreeUtil.isAncestor((PsiElement)psiClass.getExtendsList(), (PsiElement)ref, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getImplementsList(), (PsiElement)ref, (boolean)false)) && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() == psiClass) {
                PsiClass containingClass;
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiJavaCodeReferenceElement.class);
                if (referenceElement == null) {
                    return null;
                }
                PsiElement typeClass = referenceElement.resolve();
                if (!(typeClass instanceof PsiClass)) {
                    return null;
                }
                PsiElement resolve = ref.resolve();
                PsiClass psiClass2 = containingClass = resolve != null ? ((PsiClass)resolve).getContainingClass() : null;
                if (containingClass == null) {
                    return null;
                }
                if (psiClass.isInheritor(containingClass, true) || GenericsHighlightUtil.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve).getExtendsList()) || GenericsHighlightUtil.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve).getImplementsList())) {
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(((PsiClass)resolve).getName() + " is not accessible in current context").range((PsiElement)ref).create();
                }
            }
        }
        return null;
    }

    private static boolean unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance(PsiClass containingClass, PsiReferenceList referenceList) {
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
                PsiClass superContainingClass;
                PsiElement superClass;
                if (referenceElement.isQualified() || !((superClass = referenceElement.resolve()) instanceof PsiClass) || (superContainingClass = ((PsiClass)superClass).getContainingClass()) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)superContainingClass, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)superContainingClass, (PsiElement)containingClass, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    private static void registerVariableParameterizedTypeFixes(HighlightInfo highlightInfo, @NotNull PsiVariable variable, @NotNull PsiReferenceParameterList parameterList, @NotNull JavaSdkVersion version) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "registerVariableParameterizedTypeFixes"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "registerVariableParameterizedTypeFixes"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "registerVariableParameterizedTypeFixes"));
        }
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        if (DumbService.getInstance((Project)variable.getProject()).isDumb()) {
            return;
        }
        String shortName = ((PsiClassType)type).getClassName();
        PsiManager manager = parameterList.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiShortNamesCache shortNamesCache = PsiShortNamesCache.getInstance((Project)parameterList.getProject());
        PsiClass[] classes = shortNamesCache.getClassesByName(shortName, GlobalSearchScope.allScope((Project)manager.getProject()));
        PsiElementFactory factory = facade.getElementFactory();
        for (PsiClass aClass : classes) {
            if (GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)aClass, parameterList, PsiSubstitutor.EMPTY, false, version) != null) continue;
            PsiType[] actualTypeParameters = parameterList.getTypeArguments();
            PsiTypeParameter[] classTypeParameters = aClass.getTypeParameters();
            HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
            for (int j = 0; j < classTypeParameters.length; ++j) {
                PsiTypeParameter classTypeParameter = classTypeParameters[j];
                PsiType actualTypeParameter = actualTypeParameters[j];
                map.put(classTypeParameter, actualTypeParameter);
            }
            PsiSubstitutor substitutor = factory.createSubstitutor(map);
            PsiClassType suggestedType = factory.createType(aClass, substitutor);
            HighlightUtil.registerChangeVariableTypeFixes(variable, (PsiType)suggestedType, variable.getInitializer(), highlightInfo);
        }
    }

    static HighlightInfo checkInferredIntersections(PsiSubstitutor substitutor, TextRange ref) {
        for (Map.Entry typeEntry : substitutor.getSubstitutionMap().entrySet()) {
            PsiType type = (PsiType)typeEntry.getValue();
            if (!(type instanceof PsiIntersectionType)) continue;
            PsiType[] conjuncts = ((PsiIntersectionType)type).getConjuncts();
            for (int i = 0; i < conjuncts.length; ++i) {
                PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjuncts[i]);
                if (conjunct == null || conjunct.isInterface()) continue;
                for (int i1 = i + 1; i1 < conjuncts.length; ++i1) {
                    PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjuncts[i1]);
                    if (oppositeConjunct == null || oppositeConjunct.isInterface() || conjunct.isInheritor(oppositeConjunct, true) || oppositeConjunct.isInheritor(conjunct, true)) continue;
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Type parameter " + ((PsiTypeParameter)typeEntry.getKey()).getName() + " has incompatible upper bounds: " + conjunct.getName() + " and " + oppositeConjunct.getName()).range(ref).create();
                }
            }
        }
        return null;
    }

    static HighlightInfo areSupersAccessible(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "areSupersAccessible"));
        }
        return GenericsHighlightUtil.areSupersAccessible(aClass, aClass.getResolveScope(), HighlightNamesUtil.getClassDeclarationTextRange(aClass));
    }

    static HighlightInfo areSupersAccessible(@NotNull PsiClass aClass, PsiElement ref) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "areSupersAccessible"));
        }
        return GenericsHighlightUtil.areSupersAccessible(aClass, ref.getResolveScope(), ref.getTextRange());
    }

    private static HighlightInfo areSupersAccessible(@NotNull PsiClass aClass, GlobalSearchScope resolveScope, TextRange range) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/GenericsHighlightUtil", "areSupersAccessible"));
        }
        JavaPsiFacade factory = JavaPsiFacade.getInstance((Project)aClass.getProject());
        for (PsiClassType superType : aClass.getSuperTypes()) {
            String notAccessibleErrorMessage = GenericsHighlightUtil.isSuperTypeAccessible((PsiType)superType, (HashSet<PsiClass>)new HashSet(), resolveScope, factory);
            if (notAccessibleErrorMessage == null) continue;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip(notAccessibleErrorMessage).range(range).create();
        }
        return null;
    }

    @Nullable
    private static String isSuperTypeAccessible(PsiType superType, HashSet<PsiClass> classes, GlobalSearchScope resolveScope, JavaPsiFacade factory) {
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)superType);
        if (aClass != null && classes.add((Object)aClass)) {
            String notAccessibleMessage;
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName != null && factory.findClass(qualifiedName, resolveScope) == null) {
                return "Cannot access " + HighlightUtil.formatClass(aClass);
            }
            if (superType instanceof PsiClassType) {
                for (PsiClassType psiClassType : ((PsiClassType)superType).getParameters()) {
                    notAccessibleMessage = GenericsHighlightUtil.isSuperTypeAccessible((PsiType)psiClassType, classes, resolveScope, factory);
                    if (notAccessibleMessage == null) continue;
                    return notAccessibleMessage;
                }
            }
            for (PsiClassType psiClassType : aClass.getSuperTypes()) {
                notAccessibleMessage = GenericsHighlightUtil.isSuperTypeAccessible((PsiType)psiClassType, classes, resolveScope, factory);
                if (notAccessibleMessage == null) continue;
                return notAccessibleMessage;
            }
        }
        return null;
    }
}

