/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtilBase;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsConditionalFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeNewOperatorTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteRepeatedInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.FlipIntersectionSidesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyWithThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityActionWrapper;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.EnclosingLoopMatcherExpression;
import com.intellij.psi.util.EnclosingLoopOrSwitchMatcherExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMatchers;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUtil
extends HighlightUtilBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil");
    @NotNull
    private static final Map<String, Set<String>> ourInterfaceIncompatibleModifiers = new THashMap(7);
    @NotNull
    private static final Map<String, Set<String>> ourMethodIncompatibleModifiers = new THashMap(11);
    @NotNull
    private static final Map<String, Set<String>> ourFieldIncompatibleModifiers = new THashMap(8);
    @NotNull
    private static final Map<String, Set<String>> ourClassIncompatibleModifiers = new THashMap(8);
    @NotNull
    private static final Map<String, Set<String>> ourClassInitializerIncompatibleModifiers = new THashMap(1);
    @NotNull
    private static final Set<String> ourConstructorNotAllowedModifiers = ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "static", "native", "final", "strictfp", "synchronized"});
    @NonNls
    private static final String SERIAL_PERSISTENT_FIELDS_FIELD_NAME = "serialPersistentFields";
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final Pattern FP_LITERAL_PARTS;

    private HighlightUtil() {
    }

    @Nullable
    private static String getIncompatibleModifier(String modifier, @Nullable PsiModifierList modifierList, @NotNull Map<String, Set<String>> incompatibleModifiersHash) {
        if (incompatibleModifiersHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleModifiersHash", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getIncompatibleModifier"));
        }
        if (modifierList == null) {
            return null;
        }
        PsiElement[] modifiers = modifierList.getChildren();
        int modifierCount = 0;
        for (PsiElement otherModifier : modifiers) {
            if (!Comparing.equal((String)modifier, (String)otherModifier.getText(), (boolean)true)) continue;
            ++modifierCount;
        }
        if (modifierCount > 1) {
            return modifier;
        }
        Set<String> incompatibles = incompatibleModifiersHash.get(modifier);
        if (incompatibles == null) {
            return null;
        }
        boolean level8OrHigher = PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierList);
        boolean level9OrHigher = PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierList);
        for (String incompatible : incompatibles) {
            PsiClass containingClass;
            PsiElement parent;
            if (level8OrHigher && modifier.equals("static") && incompatible.equals("abstract") || level9OrHigher && modifier.equals("private") && incompatible.equals("public") || modifier.equals("static") && incompatible.equals("final") && (parent = modifierList.getParent()) instanceof PsiMethod && ((containingClass = ((PsiMethod)parent).getContainingClass()) == null || !containingClass.isInterface())) continue;
            if (modifierList.hasModifierProperty(incompatible)) {
                return incompatible;
            }
            if (!"abstract".equals(incompatible) || !modifierList.hasExplicitModifier(incompatible)) continue;
            return incompatible;
        }
        return null;
    }

    static void registerAccessQuickFixAction(@NotNull PsiMember refElement, @NotNull PsiJavaCodeReferenceElement place, @Nullable HighlightInfo errorResult, PsiElement fileResolveScope) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerAccessQuickFixAction"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerAccessQuickFixAction"));
        }
        if (errorResult == null) {
            return;
        }
        PsiClass accessObjectClass = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)((PsiExpression)qualifier)).getElement();
        }
        HighlightUtil.registerReplaceInaccessibleFieldWithGetterSetterFix(refElement, place, accessObjectClass, errorResult);
        if (refElement instanceof PsiCompiledElement) {
            return;
        }
        PsiModifierList modifierList = refElement.getModifierList();
        if (modifierList == null) {
            return;
        }
        PsiClass packageLocalClassInTheMiddle = HighlightUtil.getPackageLocalClassInTheMiddle((PsiElement)place);
        if (packageLocalClassInTheMiddle != null) {
            LocalQuickFixAndIntentionActionOnPsiElement fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)packageLocalClassInTheMiddle, "public", true, true);
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)fix);
            return;
        }
        try {
            Project project = refElement.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiModifierList modifierListCopy = facade.getElementFactory().createFieldFromText("int a;", null).getModifierList();
            modifierListCopy.setModifierProperty("static", modifierList.hasModifierProperty("static"));
            String minModifier = "packageLocal";
            if (refElement.hasModifierProperty("packageLocal")) {
                minModifier = "protected";
            }
            if (refElement.hasModifierProperty("protected")) {
                minModifier = "public";
            }
            Object[] modifiers = new String[]{"packageLocal", "protected", "public"};
            for (int i = ArrayUtil.indexOf((Object[])modifiers, (Object)minModifier); i < modifiers.length; ++i) {
                Object modifier = modifiers[i];
                modifierListCopy.setModifierProperty((String)modifier, true);
                if (!facade.getResolveHelper().isAccessible(refElement, modifierListCopy, (PsiElement)place, accessObjectClass, fileResolveScope)) continue;
                LocalQuickFixAndIntentionActionOnPsiElement fix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)refElement, (String)modifier, true, true);
                TextRange fixRange = new TextRange(errorResult.startOffset, errorResult.endOffset);
                PsiElement ref = place.getReferenceNameElement();
                if (ref != null) {
                    fixRange = fixRange.union(ref.getTextRange());
                }
                QuickFixAction.registerQuickFixAction(errorResult, fixRange, (IntentionAction)fix);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static PsiClass getPackageLocalClassInTheMiddle(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getPackageLocalClassInTheMiddle"));
        }
        if (place instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)place;
            while (true) {
                PsiField field;
                PsiClass aClass;
                PsiElement resolved;
                if ((resolved = expression.resolve()) instanceof PsiField && (aClass = (field = (PsiField)resolved).getContainingClass()) != null && aClass.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, place)) {
                    return aClass;
                }
                PsiExpression qualifier = expression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) break;
                expression = (PsiReferenceExpression)qualifier;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkInstanceOfApplicable(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkInstanceOfApplicable"));
        }
        PsiExpression operand = expression.getOperand();
        PsiTypeElement typeElement = expression.getCheckType();
        if (typeElement == null) {
            return null;
        }
        PsiType checkType = typeElement.getType();
        PsiType operandType = operand.getType();
        if (operandType == null) {
            return null;
        }
        if (operandType instanceof PsiLambdaExpressionType) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip("Lambda expression is not expected here").create();
        }
        if (operandType instanceof PsiMethodReferenceType) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip("Method reference expression is not expected here").create();
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operandType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)checkType) || !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)checkType)) {
            String message = JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(checkType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIntersectionInTypeCast(@NotNull PsiTypeCastExpression expression, @NotNull LanguageLevel languageLevel) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIntersectionInTypeCast"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIntersectionInTypeCast"));
        }
        PsiTypeElement castTypeElement = expression.getCastType();
        if (castTypeElement == null) {
            return null;
        }
        PsiType castType = castTypeElement.getType();
        if (HighlightUtil.isIntersection(castTypeElement, castType)) {
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                PsiTypeElement[] conjuncts = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class);
                if (conjuncts != null) {
                    Ref differentArgumentsMessage;
                    com.intellij.util.containers.hash.HashSet erasures = new com.intellij.util.containers.hash.HashSet(conjuncts.length);
                    erasures.add(TypeConversionUtil.erasure((PsiType)conjuncts[0].getType()));
                    ArrayList<PsiTypeElement> conjList = new ArrayList<PsiTypeElement>(Arrays.asList(conjuncts));
                    for (int i = 1; i < conjuncts.length; ++i) {
                        PsiTypeElement conjunct = conjuncts[i];
                        PsiType conjType = conjunct.getType();
                        if (conjType instanceof PsiClassType) {
                            PsiClass aClass = ((PsiClassType)conjType).resolve();
                            if (aClass != null && !aClass.isInterface()) {
                                HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip(JavaErrorMessages.message("interface.expected", new Object[0])).create();
                                QuickFixAction.registerQuickFixAction(errorResult, new FlipIntersectionSidesFix(aClass.getName(), conjList, conjunct, castTypeElement), null);
                                return errorResult;
                            }
                        } else {
                            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip("Unexpected type: class is expected").create();
                        }
                        if (erasures.add(TypeConversionUtil.erasure((PsiType)conjType))) continue;
                        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)conjunct).descriptionAndTooltip("Repeated interface").create();
                        QuickFixAction.registerQuickFixAction(highlightInfo, new DeleteRepeatedInterfaceFix(conjunct, conjList), null);
                        return highlightInfo;
                    }
                    List typeList = ContainerUtil.map(conjList, (Function)new Function<PsiTypeElement, PsiType>(){

                        public PsiType fun(PsiTypeElement element) {
                            return element.getType();
                        }
                    });
                    PsiClass sameGenericParameterization = InferenceSession.findParameterizationOfTheSameGenericClass(typeList, new Processor<Pair<PsiType, PsiType>>(differentArgumentsMessage = new Ref()){
                        final /* synthetic */ Ref val$differentArgumentsMessage;
                        {
                            this.val$differentArgumentsMessage = ref;
                        }

                        public boolean process(Pair<PsiType, PsiType> pair) {
                            if (!TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second))) {
                                return true;
                            }
                            this.val$differentArgumentsMessage.set((Object)(((PsiType)pair.first).getPresentableText() + " and " + ((PsiType)pair.second).getPresentableText()));
                            return false;
                        }
                    });
                    if (sameGenericParameterization != null) {
                        String message = HighlightUtil.formatClass(sameGenericParameterization) + " cannot be inherited with different arguments: " + (String)differentArgumentsMessage.get();
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                    }
                }
            } else {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip("Intersection types in cast are not supported at this language level").create();
            }
        }
        return null;
    }

    private static boolean isIntersection(PsiTypeElement castTypeElement, PsiType castType) {
        if (castType instanceof PsiIntersectionType) {
            return true;
        }
        return castType instanceof PsiClassType && PsiTreeUtil.getChildrenOfType((PsiElement)castTypeElement, PsiTypeElement.class) != null;
    }

    @Nullable
    static HighlightInfo checkInconvertibleTypeCast(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkInconvertibleTypeCast"));
        }
        PsiTypeElement castTypeElement = expression.getCastType();
        if (castTypeElement == null) {
            return null;
        }
        PsiType castType = castTypeElement.getType();
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            return null;
        }
        PsiType operandType = operand.getType();
        if (operandType != null && !TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)castType, (LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)expression)) && !RedundantCastUtil.isInPolymorphicCall((PsiTypeCastExpression)expression)) {
            String message = JavaErrorMessages.message("inconvertible.type.cast", JavaHighlightUtil.formatType(operandType), JavaHighlightUtil.formatType(castType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkVariableExpected(@NotNull PsiExpression expression) {
        PsiExpression lValue;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkVariableExpected"));
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            lValue = assignment.getLExpression();
        } else {
            lValue = PsiUtil.isIncrementDecrementOperation((PsiElement)expression) ? (expression instanceof PsiPostfixExpression ? ((PsiPostfixExpression)expression).getOperand() : ((PsiPrefixExpression)expression).getOperand()) : null;
        }
        HighlightInfo errorResult = null;
        if (lValue != null && !TypeConversionUtil.isLValue((PsiExpression)lValue)) {
            String description = JavaErrorMessages.message("variable.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)lValue).descriptionAndTooltip(description).create();
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentOperatorApplicable(@NotNull PsiAssignmentExpression assignment, @NotNull PsiFile containingFile) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAssignmentOperatorApplicable"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAssignmentOperatorApplicable"));
        }
        PsiJavaToken operationSign = assignment.getOperationSign();
        IElementType eqOpSign = operationSign.getTokenType();
        IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)eqOpSign);
        if (opSign == null) {
            return null;
        }
        PsiType lType = assignment.getLExpression().getType();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return null;
        }
        PsiType rType = rExpression.getType();
        HighlightInfo errorResult = null;
        if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)opSign, (PsiType)lType, (PsiType)rType, (boolean)true) || PsiType.getJavaLangObject((PsiManager)containingFile.getManager(), (GlobalSearchScope)assignment.getResolveScope()).equals((Object)lType)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message = JavaErrorMessages.message("binary.operator.not.applicable", operatorText, JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
            errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)assignment).descriptionAndTooltip(message).create();
        }
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkAssignmentCompatibleTypes(@NotNull PsiAssignmentExpression assignment) {
        HighlightInfo highlightInfo;
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAssignmentCompatibleTypes"));
        }
        PsiExpression lExpr = assignment.getLExpression();
        PsiExpression rExpr = assignment.getRExpression();
        if (rExpr == null) {
            return null;
        }
        PsiType lType = lExpr.getType();
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return null;
        }
        IElementType sign = assignment.getOperationTokenType();
        if (JavaTokenType.EQ.equals(sign)) {
            highlightInfo = HighlightUtil.checkAssignability(lType, rType, rExpr, (PsiElement)assignment);
        } else {
            IElementType opSign = TypeConversionUtil.convertEQtoOperation((IElementType)sign);
            PsiType type = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)opSign, (boolean)true);
            if (type == null || lType == null || TypeConversionUtil.areTypesConvertible((PsiType)type, (PsiType)lType)) {
                return null;
            }
            highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, type, assignment.getTextRange(), 0);
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createChangeToAppendFix(sign, lType, assignment));
        }
        if (highlightInfo == null) {
            return null;
        }
        HighlightUtil.registerChangeVariableTypeFixes(lExpr, rType, rExpr, highlightInfo);
        if (lType != null) {
            HighlightUtil.registerChangeVariableTypeFixes(rExpr, lType, lExpr, highlightInfo);
        }
        return highlightInfo;
    }

    private static void registerChangeVariableTypeFixes(@NotNull PsiExpression expression, @NotNull PsiType type, @Nullable PsiExpression lExpr, @Nullable HighlightInfo highlightInfo) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerChangeVariableTypeFixes"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerChangeVariableTypeFixes"));
        }
        if (highlightInfo == null || !(expression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement element = ((PsiReferenceExpression)expression).resolve();
        if (!(element instanceof PsiVariable)) {
            return;
        }
        HighlightUtil.registerChangeVariableTypeFixes((PsiVariable)element, type, lExpr, highlightInfo);
    }

    private static boolean isCastIntentionApplicable(@NotNull PsiExpression expression, @Nullable PsiType toType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "isCastIntentionApplicable"));
        }
        while (expression instanceof PsiTypeCastExpression || expression instanceof PsiParenthesizedExpression) {
            if (expression instanceof PsiTypeCastExpression) {
                expression = ((PsiTypeCastExpression)expression).getOperand();
            }
            if (!(expression instanceof PsiParenthesizedExpression)) continue;
            expression = ((PsiParenthesizedExpression)expression).getExpression();
        }
        if (expression == null) {
            return false;
        }
        PsiType rType = expression.getType();
        return rType != null && toType != null && TypeConversionUtil.areTypesConvertible((PsiType)rType, (PsiType)toType);
    }

    @Nullable
    static HighlightInfo checkVariableInitializerType(@NotNull PsiVariable variable) {
        int end;
        int start;
        PsiType rType;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkVariableInitializerType"));
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
            return null;
        }
        PsiType lType = variable.getType();
        HighlightInfo highlightInfo = HighlightUtil.checkAssignability(lType, rType = initializer.getType(), initializer, new TextRange(start = variable.getTypeElement().getTextRange().getStartOffset(), end = variable.getTextRange().getEndOffset()), 0);
        if (highlightInfo != null) {
            HighlightUtil.registerChangeVariableTypeFixes(variable, rType, variable.getInitializer(), highlightInfo);
            HighlightUtil.registerChangeVariableTypeFixes(initializer, lType, null, highlightInfo);
        }
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression, @NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAssignability"));
        }
        TextRange textRange = elementToHighlight.getTextRange();
        return HighlightUtil.checkAssignability(lType, rType, expression, textRange, 0);
    }

    @Nullable
    private static HighlightInfo checkAssignability(@Nullable PsiType lType, @Nullable PsiType rType, @Nullable PsiExpression expression, @NotNull TextRange textRange, int navigationShift) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAssignability"));
        }
        if (lType == rType) {
            return null;
        }
        if (expression == null ? rType == null || lType == null || TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)rType) : TypeConversionUtil.areTypesAssignmentCompatible((PsiType)lType, (PsiExpression)expression)) {
            return null;
        }
        if (rType == null) {
            rType = expression.getType();
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(lType, rType, textRange, navigationShift);
        if (rType != null && expression != null && HighlightUtil.isCastIntentionApplicable(expression, lType)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddTypeCastFix(lType, expression));
        }
        if (expression != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createWrapExpressionFix(lType, expression));
            AddTypeArgumentsConditionalFix.register(highlightInfo, expression, lType);
        }
        ChangeNewOperatorTypeFix.register(highlightInfo, expression, lType);
        return highlightInfo;
    }

    @Nullable
    static HighlightInfo checkReturnStatementType(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReturnStatementType"));
        }
        PsiMethod method = null;
        PsiLambdaExpression lambda = null;
        PsiElement parent = statement.getParent();
        while (!(parent instanceof PsiFile) && !(parent instanceof PsiClassInitializer)) {
            if (parent instanceof PsiLambdaExpression) {
                lambda = (PsiLambdaExpression)parent;
                break;
            }
            if (parent instanceof PsiMethod) {
                method = (PsiMethod)parent;
                break;
            }
            parent = parent.getParent();
        }
        HighlightInfo errorResult = null;
        if (method != null || lambda == null) {
            if (method == null && !(parent instanceof ServerPageFile)) {
                String description = JavaErrorMessages.message("return.outside.method", new Object[0]);
                errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            } else {
                PsiType returnType = method != null ? method.getReturnType() : null;
                boolean isMethodVoid = returnType == null || PsiType.VOID.equals((Object)returnType);
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    PsiType valueType = RefactoringChangeUtil.getTypeByExpression(returnValue);
                    if (isMethodVoid) {
                        String description = JavaErrorMessages.message("return.from.void.method", new Object[0]);
                        errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
                        if (valueType != null) {
                            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true));
                        }
                    } else {
                        TextRange textRange = statement.getTextRange();
                        errorResult = HighlightUtil.checkAssignability(returnType, valueType, returnValue, textRange, returnValue.getStartOffsetInParent());
                        if (errorResult != null && valueType != null) {
                            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, valueType, true));
                            HighlightUtil.registerChangeParameterClassFix(returnType, valueType, errorResult);
                            if (returnType instanceof PsiArrayType && TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)returnType).getComponentType(), (PsiType)valueType)) {
                                QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSurroundWithArrayFix(null, returnValue));
                            }
                        }
                    }
                } else if (!isMethodVoid) {
                    String description = JavaErrorMessages.message("missing.return.value", new Object[0]);
                    errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).navigationShift("return".length()).create();
                    QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.VOID, true));
                }
            }
        }
        return errorResult;
    }

    @NotNull
    public static String getUnhandledExceptionsDescriptor(@NotNull Collection<PsiClassType> unhandled) {
        if (unhandled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandled", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getUnhandledExceptionsDescriptor"));
        }
        String string = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getUnhandledExceptionsDescriptor"));
        }
        return string;
    }

    @NotNull
    private static String getUnhandledExceptionsDescriptor(@NotNull Collection<PsiClassType> unhandled, @Nullable String source) {
        if (unhandled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandled", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getUnhandledExceptionsDescriptor"));
        }
        String exceptions = HighlightUtil.formatTypes(unhandled);
        String string = source != null ? JavaErrorMessages.message("unhandled.close.exceptions", exceptions, unhandled.size(), source) : JavaErrorMessages.message("unhandled.exceptions", exceptions, unhandled.size());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getUnhandledExceptionsDescriptor"));
        }
        return string;
    }

    @NotNull
    private static String formatTypes(@NotNull Collection<PsiClassType> unhandled) {
        if (unhandled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandled", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatTypes"));
        }
        String string = StringUtil.join(unhandled, (Function)new Function<PsiClassType, String>(){

            @NotNull
            public String fun(PsiClassType type) {
                String string = JavaHighlightUtil.formatType((PsiType)type);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil$3", "fun"));
                }
                return string;
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatTypes"));
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkVariableAlreadyDefined(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkVariableAlreadyDefined"));
        }
        if (variable instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        boolean isIncorrect = false;
        PsiElement declarationScope = null;
        if (variable instanceof PsiLocalVariable || variable instanceof PsiParameter && ((declarationScope = ((PsiParameter)variable).getDeclarationScope()) instanceof PsiCatchSection || declarationScope instanceof PsiForeachStatement || declarationScope instanceof PsiLambdaExpression)) {
            PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class, PsiResourceList.class});
            VariablesNotProcessor proc = new VariablesNotProcessor(variable, false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return (var instanceof PsiLocalVariable || var instanceof PsiParameter) && super.check(var, state);
                }
            };
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
            if (scope instanceof PsiResourceList && proc.size() == 0) {
                scope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiFile.class, PsiMethod.class, PsiClassInitializer.class});
                PsiScopesUtil.treeWalkUp(proc, (PsiElement)identifier, scope);
            }
            if (proc.size() > 0) {
                isIncorrect = true;
            } else if (declarationScope instanceof PsiLambdaExpression) {
                isIncorrect = HighlightUtil.checkSameNames(variable);
            }
        } else if (variable instanceof PsiField) {
            PsiField field = (PsiField)variable;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiField fieldByName = aClass.findFieldByName(variable.getName(), false);
            if (fieldByName != null && fieldByName != field) {
                isIncorrect = true;
            }
        } else {
            isIncorrect = HighlightUtil.checkSameNames(variable);
        }
        if (isIncorrect) {
            String description = JavaErrorMessages.message("variable.already.defined", variable.getName());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(description).create();
            if (variable instanceof PsiLocalVariable) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createReuseVariableDeclarationFix((PsiLocalVariable)variable));
            }
            return highlightInfo;
        }
        return null;
    }

    private static boolean checkSameNames(PsiVariable variable) {
        PsiElement[] children;
        PsiElement scope = variable.getParent();
        for (PsiElement child : children = scope.getChildren()) {
            if (!(child instanceof PsiVariable) || child.equals(variable) || !variable.getName().equals(((PsiVariable)child).getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkUnderscore(@NotNull PsiIdentifier identifier, @NotNull PsiVariable variable, @NotNull LanguageLevel languageLevel) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnderscore"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnderscore"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnderscore"));
        }
        if ("_".equals(variable.getName()) && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiLambdaExpression) {
            String message = JavaErrorMessages.message("underscore.lambda.identifier", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatClass"));
        }
        String string = HighlightUtil.formatClass(aClass, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatClass"));
        }
        return string;
    }

    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, boolean fqn) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatClass"));
        }
        String string = PsiFormatUtil.formatClass((PsiClass)aClass, (int)(0x8001 | (fqn ? 2048 : 0)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatClass"));
        }
        return string;
    }

    @NotNull
    static String formatField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatField"));
        }
        String string = PsiFormatUtil.formatVariable((PsiVariable)field, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "formatField"));
        }
        return string;
    }

    @Nullable
    static HighlightInfo checkUnhandledExceptions(@NotNull PsiElement element, @Nullable TextRange textRange) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnhandledExceptions"));
        }
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        if (unhandledExceptions.isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType(element);
        if (highlightType == null) {
            return null;
        }
        if (textRange == null) {
            textRange = element.getTextRange();
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandledExceptions);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(highlightType).range(textRange).descriptionAndTooltip(description).create();
        HighlightUtil.registerUnhandledExceptionFixes(element, errorResult, unhandledExceptions);
        return errorResult;
    }

    @Nullable
    static HighlightInfo checkUnhandledCloserExceptions(@NotNull PsiResourceVariable resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnhandledCloserExceptions"));
        }
        List<PsiClassType> unhandled = ExceptionUtil.getUnhandledCloserExceptions(resource, null);
        if (unhandled.isEmpty()) {
            return null;
        }
        HighlightInfoType highlightType = HighlightUtil.getUnhandledExceptionHighlightType((PsiElement)resource);
        if (highlightType == null) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled, "auto-closeable resource");
        HighlightInfo highlight = HighlightInfo.newHighlightInfo(highlightType).range((PsiElement)resource).descriptionAndTooltip(description).create();
        HighlightUtil.registerUnhandledExceptionFixes((PsiElement)resource, highlight, unhandled);
        return highlight;
    }

    private static void registerUnhandledExceptionFixes(@NotNull PsiElement element, HighlightInfo errorResult, @NotNull List<PsiClassType> unhandled) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerUnhandledExceptionFixes"));
        }
        if (unhandled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandled", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerUnhandledExceptionFixes"));
        }
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddExceptionToCatchFix());
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createAddExceptionToThrowsFix(element));
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createSurroundWithTryCatchFix(element));
        if (unhandled.size() == 1) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createGeneralizeCatchFix(element, unhandled.get(0)));
        }
    }

    @Nullable
    private static HighlightInfoType getUnhandledExceptionHighlightType(PsiElement element) {
        if (!FileTypeUtils.isInServerPageFile((PsiElement)element)) {
            return HighlightInfoType.UNHANDLED_EXCEPTION;
        }
        PsiMethod targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (!(targetMethod instanceof SyntheticElement)) {
            return HighlightInfoType.UNHANDLED_EXCEPTION;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkBreakOutsideLoop(@NotNull PsiBreakStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkBreakOutsideLoop"));
        }
        if (statement.getLabelIdentifier() == null && new PsiMatcherImpl((PsiElement)statement).ancestor(EnclosingLoopOrSwitchMatcherExpression.INSTANCE).getElement() == null) {
            String description = JavaErrorMessages.message("break.outside.switch.or.loop", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkContinueOutsideLoop(@NotNull PsiContinueStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkContinueOutsideLoop"));
        }
        if (statement.getLabelIdentifier() == null) {
            if (new PsiMatcherImpl((PsiElement)statement).ancestor(EnclosingLoopMatcherExpression.INSTANCE).getElement() == null) {
                String description = JavaErrorMessages.message("continue.outside.loop", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            }
        } else {
            PsiStatement exitedStatement = statement.findContinuedStatement();
            if (exitedStatement == null) {
                return null;
            }
            if (!(exitedStatement instanceof PsiForStatement || exitedStatement instanceof PsiWhileStatement || exitedStatement instanceof PsiDoWhileStatement || exitedStatement instanceof PsiForeachStatement)) {
                String description = JavaErrorMessages.message("not.loop.label", statement.getLabelIdentifier().getText());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalModifierCombination(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIllegalModifierCombination"));
        }
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIllegalModifierCombination"));
        }
        String modifier = keyword.getText();
        String incompatible = HighlightUtil.getIncompatibleModifier(modifier, modifierList);
        if (incompatible != null) {
            String message = JavaErrorMessages.message("incompatible.modifiers", modifier, incompatible);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private static Map<String, Set<String>> getIncompatibleModifierMap(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getIncompatibleModifierMap"));
        }
        PsiElement parent = modifierList.getParent();
        if (parent == null || PsiUtilCore.hasErrorElementChild((PsiElement)parent)) {
            return null;
        }
        return parent instanceof PsiClass ? (((PsiClass)parent).isInterface() ? ourInterfaceIncompatibleModifiers : ourClassIncompatibleModifiers) : (parent instanceof PsiMethod ? ourMethodIncompatibleModifiers : (parent instanceof PsiVariable ? ourFieldIncompatibleModifiers : (parent instanceof PsiClassInitializer ? ourClassInitializerIncompatibleModifiers : null)));
    }

    @Nullable
    static String getIncompatibleModifier(String modifier, @NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getIncompatibleModifier"));
        }
        PsiElement parent = modifierList.getParent();
        if (parent == null || PsiUtilCore.hasErrorElementChild((PsiElement)parent)) {
            return null;
        }
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierList);
        if (incompatibleModifierMap == null) {
            return null;
        }
        return HighlightUtil.getIncompatibleModifier(modifier, modifierList, incompatibleModifierMap);
    }

    @Nullable
    static HighlightInfo checkNotAllowedModifier(@NotNull PsiKeyword keyword, @NotNull PsiModifierList modifierList) {
        PsiElement modifierOwnerParent;
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkNotAllowedModifier"));
        }
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkNotAllowedModifier"));
        }
        PsiElement modifierOwner = modifierList.getParent();
        if (modifierOwner == null) {
            return null;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)modifierOwner)) {
            return null;
        }
        String modifier = keyword.getText();
        Map<String, Set<String>> incompatibleModifierMap = HighlightUtil.getIncompatibleModifierMap(modifierList);
        if (incompatibleModifierMap == null) {
            return null;
        }
        Set<String> incompatibles = incompatibleModifierMap.get(modifier);
        Object object = modifierOwnerParent = modifierOwner instanceof PsiMember ? ((PsiMember)modifierOwner).getContainingClass() : modifierOwner.getParent();
        if (modifierOwnerParent == null) {
            modifierOwnerParent = modifierOwner.getParent();
        }
        boolean isAllowed = true;
        if (modifierOwner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)modifierOwner;
            if (aClass.isInterface()) {
                if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiClass;
                }
            } else {
                if ("public".equals(modifier)) {
                    isAllowed = modifierOwnerParent instanceof PsiJavaFile || modifierOwnerParent instanceof PsiClass && (modifierOwnerParent instanceof PsiSyntheticClass || ((PsiClass)modifierOwnerParent).getQualifiedName() != null);
                } else if ("static".equals(modifier) || "private".equals(modifier) || "protected".equals(modifier) || "packageLocal".equals(modifier)) {
                    boolean bl = isAllowed = modifierOwnerParent instanceof PsiClass && ((PsiClass)modifierOwnerParent).getQualifiedName() != null || FileTypeUtils.isInServerPageFile((PsiElement)modifierOwnerParent);
                }
                if (aClass.isEnum()) {
                    isAllowed &= !"final".equals(modifier) && !"abstract".equals(modifier);
                }
                if (aClass.getContainingClass() instanceof PsiAnonymousClass) {
                    isAllowed &= !"private".equals(modifier) && !"protected".equals(modifier);
                }
            }
        } else if (modifierOwner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)modifierOwner;
            isAllowed = !method.isConstructor() || !ourConstructorNotAllowedModifiers.contains(modifier);
            PsiClass containingClass = method.getContainingClass();
            if ((method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && method.isConstructor() && containingClass != null && containingClass.isEnum()) {
                isAllowed = false;
            }
            if ("private".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && (!((PsiClass)modifierOwnerParent).isInterface() || PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierOwner));
            } else if ("strictfp".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && (!((PsiClass)modifierOwnerParent).isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierOwner));
            } else if ("protected".equals(modifier) || "transient".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed &= modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
            if (containingClass != null && containingClass.isInterface()) {
                isAllowed &= !"native".equals(modifier);
            }
            if (containingClass != null && containingClass.isAnnotationType()) {
                isAllowed &= !"static".equals(modifier);
                isAllowed &= !"default".equals(modifier);
            }
        } else if (modifierOwner instanceof PsiField) {
            if ("private".equals(modifier) || "protected".equals(modifier) || "transient".equals(modifier) || "strictfp".equals(modifier) || "synchronized".equals(modifier)) {
                isAllowed = modifierOwnerParent instanceof PsiClass && !((PsiClass)modifierOwnerParent).isInterface();
            }
        } else if (modifierOwner instanceof PsiClassInitializer) {
            isAllowed = "static".equals(modifier);
        } else if (modifierOwner instanceof PsiLocalVariable || modifierOwner instanceof PsiParameter) {
            isAllowed = "final".equals(modifier);
        }
        if (!(isAllowed &= incompatibles != null)) {
            String message = JavaErrorMessages.message("modifier.not.allowed", modifier);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(modifierList, modifier, false, false));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo checkLiteralExpressionParsingError(@NotNull PsiLiteralExpression expression, LanguageLevel level, PsiFile file) {
        Number number;
        int success;
        Object chars;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkLiteralExpressionParsingError"));
        }
        PsiElement literal = expression.getFirstChild();
        assert (literal instanceof PsiJavaToken) : literal;
        IElementType type = ((PsiJavaToken)literal).getTokenType();
        if (type == JavaTokenType.TRUE_KEYWORD || type == JavaTokenType.FALSE_KEYWORD || type == JavaTokenType.NULL_KEYWORD) {
            return null;
        }
        boolean isInt = PsiLiteralExpressionImpl.INTEGER_LITERALS.contains(type);
        boolean isFP = PsiLiteralExpressionImpl.REAL_LITERALS.contains(type);
        String text = isInt || isFP ? literal.getText().toLowerCase() : literal.getText();
        Object value = expression.getValue();
        if (level != null && file != null) {
            HighlightInfo info;
            if (isFP && text.startsWith("0x") && (info = HighlightUtil.checkFeature((PsiElement)expression, Feature.HEX_FP_LITERALS, level, file)) != null) {
                return info;
            }
            if (isInt && text.startsWith("0b") && (info = HighlightUtil.checkFeature((PsiElement)expression, Feature.BIN_LITERALS, level, file)) != null) {
                return info;
            }
            if ((isInt || isFP) && text.contains("_")) {
                info = HighlightUtil.checkFeature((PsiElement)expression, Feature.UNDERSCORES, level, file);
                if (info != null) {
                    return info;
                }
                info = HighlightUtil.checkUnderscores((PsiElement)expression, text, isInt);
                if (info != null) {
                    return info;
                }
            }
        }
        PsiElement parent = expression.getParent();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            if (!text.equals(PsiLiteralExpressionImpl._2_IN_31) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (text.equals("0x")) {
                    String message = JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
                if (text.equals("0b")) {
                    String message = JavaErrorMessages.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
                if (value == null || text.equals(PsiLiteralExpressionImpl._2_IN_31)) {
                    String message = JavaErrorMessages.message("integer.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
            }
        } else if (type == JavaTokenType.LONG_LITERAL) {
            String mText;
            String string = mText = text.endsWith("l") ? text.substring(0, text.length() - 1) : text;
            if (!mText.equals(PsiLiteralExpressionImpl._2_IN_63) || !(parent instanceof PsiPrefixExpression) || ((PsiPrefixExpression)parent).getOperationTokenType() != JavaTokenType.MINUS) {
                if (mText.equals("0x")) {
                    String message = JavaErrorMessages.message("hexadecimal.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
                if (mText.equals("0b")) {
                    String message = JavaErrorMessages.message("binary.numbers.must.contain.at.least.one.hexadecimal.digit", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
                if (value == null || mText.equals(PsiLiteralExpressionImpl._2_IN_63)) {
                    String message = JavaErrorMessages.message("long.number.too.large", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
            }
        } else if (isFP) {
            if (value == null) {
                String message = JavaErrorMessages.message("malformed.floating.point.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
        } else if (type == JavaTokenType.CHARACTER_LITERAL) {
            if (value != null) {
                if (!StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
                    String message = JavaErrorMessages.message("unclosed.char.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
            } else {
                if (!StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                    return null;
                }
                if (StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
                    if (text.length() == 1) {
                        String message = JavaErrorMessages.message("illegal.line.end.in.character.literal", new Object[0]);
                        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                    }
                } else {
                    String message = JavaErrorMessages.message("illegal.line.end.in.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
                text = text.substring(1, text.length() - 1);
                chars = new StringBuilder();
                success = PsiLiteralExpressionImpl.parseStringCharacters(text, (StringBuilder)chars, null) ? 1 : 0;
                if (success == 0) {
                    String message = JavaErrorMessages.message("illegal.escape.character.in.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
                int length = ((StringBuilder)chars).length();
                if (length > 1) {
                    String message = JavaErrorMessages.message("too.many.characters.in.character.literal", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createConvertToStringLiteralAction());
                    return info;
                }
                if (length == 0) {
                    String message = JavaErrorMessages.message("empty.character.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
            }
        } else if (type == JavaTokenType.STRING_LITERAL && value == null) {
            String message;
            for (PsiElement element : expression.getChildren()) {
                if (!(element instanceof OuterLanguageElement)) continue;
                return null;
            }
            if (!StringUtil.startsWithChar((CharSequence)text, (char)'\"')) {
                return null;
            }
            if (StringUtil.endsWithChar((CharSequence)text, (char)'\"')) {
                if (text.length() == 1) {
                    message = JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
                }
            } else {
                message = JavaErrorMessages.message("illegal.line.end.in.string.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
            text = text.substring(1, text.length() - 1);
            chars = new StringBuilder();
            success = PsiLiteralExpressionImpl.parseStringCharacters(text, (StringBuilder)chars, null) ? 1 : 0;
            if (success == 0) {
                String message2 = JavaErrorMessages.message("illegal.escape.character.in.string.literal", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message2).create();
            }
        }
        if (value instanceof Float) {
            number = (Float)value;
            if (((Float)number).isInfinite()) {
                String message = JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
            if (((Float)number).floatValue() == 0.0f && !TypeConversionUtil.isFPZero((String)text)) {
                String message = JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
        } else if (value instanceof Double) {
            number = (Double)value;
            if (((Double)number).isInfinite()) {
                String message = JavaErrorMessages.message("floating.point.number.too.large", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
            if ((Double)number == 0.0 && !TypeConversionUtil.isFPZero((String)text)) {
                String message = JavaErrorMessages.message("floating.point.number.too.small", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkUnderscores(PsiElement expression, String text, boolean isInt) {
        String[] parts = ArrayUtil.EMPTY_STRING_ARRAY;
        if (isInt) {
            int start = 0;
            int end = text.length();
            if (text.startsWith("0x") || text.startsWith("0b")) {
                start += 2;
            }
            if (StringUtil.endsWithChar((CharSequence)text, (char)'l')) {
                --end;
            }
            parts = new String[]{text.substring(start, end)};
        } else {
            Matcher matcher = FP_LITERAL_PARTS.matcher(text);
            if (matcher.matches()) {
                parts = new String[matcher.groupCount()];
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    parts[i] = matcher.group(i + 1);
                }
            }
        }
        for (String part : parts) {
            if (part == null || !StringUtil.startsWithChar((CharSequence)part, (char)'_') && !StringUtil.endsWithChar((CharSequence)part, (char)'_')) continue;
            String message = JavaErrorMessages.message("illegal.underscore", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMustBeBoolean(@NotNull PsiExpression expr, PsiType type) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMustBeBoolean"));
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement && expr.equals(((PsiForStatement)parent).getCondition()) || parent instanceof PsiDoWhileStatement && expr.equals(((PsiDoWhileStatement)parent).getCondition())) {
            if (expr.getNextSibling() instanceof PsiErrorElement) {
                return null;
            }
            if (!TypeConversionUtil.isBooleanType((PsiType)type)) {
                PsiMethodCallExpression methodCall;
                PsiMethod method;
                HighlightInfo info = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type, expr.getTextRange(), 0);
                if (expr instanceof PsiMethodCallExpression && (method = (methodCall = (PsiMethodCallExpression)expr).resolveMethod()) != null && PsiType.VOID.equals((Object)method.getReturnType())) {
                    QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, (PsiType)PsiType.BOOLEAN, true));
                }
                return info;
            }
        }
        return null;
    }

    @NotNull
    static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiTryStatement statement) {
        PsiResourceList resources;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "collectUnhandledExceptions"));
        }
        HashSet thrownTypes = ContainerUtil.newHashSet();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock));
        }
        if ((resources = statement.getResourceList()) != null) {
            thrownTypes.addAll(ExceptionUtil.collectUnhandledExceptions((PsiElement)resources, (PsiElement)resources));
        }
        HashSet hashSet = thrownTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "collectUnhandledExceptions"));
        }
        return hashSet;
    }

    @Nullable
    static List<HighlightInfo> checkExceptionThrownInTry(@NotNull PsiParameter parameter, @NotNull Set<PsiClassType> thrownTypes) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkExceptionThrownInTry"));
        }
        if (thrownTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownTypes", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkExceptionThrownInTry"));
        }
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (!(declarationScope instanceof PsiCatchSection)) {
            return null;
        }
        PsiType caughtType = parameter.getType();
        if (caughtType instanceof PsiClassType) {
            HighlightInfo info = HighlightUtil.checkSimpleCatchParameter(parameter, thrownTypes, (PsiClassType)caughtType);
            return info == null ? null : Collections.singletonList(info);
        }
        if (caughtType instanceof PsiDisjunctionType) {
            return HighlightUtil.checkMultiCatchParameter(parameter, thrownTypes);
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkSimpleCatchParameter(@NotNull PsiParameter parameter, @NotNull Collection<PsiClassType> thrownTypes, @NotNull PsiClassType caughtType) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSimpleCatchParameter"));
        }
        if (thrownTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownTypes", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSimpleCatchParameter"));
        }
        if (caughtType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caughtType", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSimpleCatchParameter"));
        }
        if (ExceptionUtil.isUncheckedExceptionOrSuperclass(caughtType)) {
            return null;
        }
        for (PsiClassType exceptionType : thrownTypes) {
            if (!exceptionType.isAssignableFrom((PsiType)caughtType) && !caughtType.isAssignableFrom((PsiType)exceptionType)) continue;
            return null;
        }
        String description = JavaErrorMessages.message("exception.never.thrown.try", JavaHighlightUtil.formatType((PsiType)caughtType));
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)parameter).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createDeleteCatchFix(parameter));
        return errorResult;
    }

    @Nullable
    private static List<HighlightInfo> checkMultiCatchParameter(@NotNull PsiParameter parameter, @NotNull Collection<PsiClassType> thrownTypes) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMultiCatchParameter"));
        }
        if (thrownTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownTypes", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMultiCatchParameter"));
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(typeElements.size());
        for (PsiTypeElement typeElement : typeElements) {
            PsiType catchType = typeElement.getType();
            if (catchType instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)catchType)) continue;
            boolean used = false;
            for (PsiClassType exceptionType : thrownTypes) {
                if (!exceptionType.isAssignableFrom(catchType) && !catchType.isAssignableFrom((PsiType)exceptionType)) continue;
                used = true;
                break;
            }
            if (used) continue;
            String description = JavaErrorMessages.message("exception.never.thrown.try", JavaHighlightUtil.formatType(catchType));
            HighlightInfo highlight = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlight, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(typeElement));
            highlights.add(highlight);
        }
        return highlights;
    }

    @Nullable
    static Collection<HighlightInfo> checkWithImprovedCatchAnalysis(@NotNull PsiParameter parameter, @NotNull Collection<PsiClassType> thrownInTryStatement, @NotNull PsiFile containingFile) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkWithImprovedCatchAnalysis"));
        }
        if (thrownInTryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownInTryStatement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkWithImprovedCatchAnalysis"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkWithImprovedCatchAnalysis"));
        }
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int idx = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection);
        if (idx <= 0) {
            return null;
        }
        HashSet thrownTypes = ContainerUtil.newHashSet(thrownInTryStatement);
        PsiManager manager = containingFile.getManager();
        GlobalSearchScope parameterResolveScope = parameter.getResolveScope();
        thrownTypes.add(PsiType.getJavaLangError((PsiManager)manager, (GlobalSearchScope)parameterResolveScope));
        thrownTypes.add(PsiType.getJavaLangRuntimeException((PsiManager)manager, (GlobalSearchScope)parameterResolveScope));
        ArrayList result = ContainerUtil.newArrayList();
        List parameterTypeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        boolean isMultiCatch = parameterTypeElements.size() > 1;
        for (PsiTypeElement catchTypeElement : parameterTypeElements) {
            List caught;
            final PsiType catchType = catchTypeElement.getType();
            if (ExceptionUtil.isGeneralExceptionType(catchType) || (caught = ContainerUtil.findAll((Collection)thrownTypes, (Condition)new Condition<PsiClassType>(){

                public boolean value(@NotNull PsiClassType type) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil$5", "value"));
                    }
                    return catchType.isAssignableFrom((PsiType)type);
                }
            })).isEmpty()) continue;
            HashSet caughtCopy = ContainerUtil.newHashSet((Iterable)caught);
            block1: for (int i = 0; i < idx; ++i) {
                PsiParameter prevCatchParameter = allCatchSections[i].getParameter();
                if (prevCatchParameter == null) continue;
                for (PsiTypeElement prevCatchTypeElement : PsiUtil.getParameterTypeElements((PsiParameter)prevCatchParameter)) {
                    PsiType prevCatchType = prevCatchTypeElement.getType();
                    Iterator iterator = caught.iterator();
                    while (iterator.hasNext()) {
                        if (!prevCatchType.isAssignableFrom((PsiType)iterator.next())) continue;
                        iterator.remove();
                    }
                    if (!caught.isEmpty()) continue;
                    continue block1;
                }
            }
            if (!caught.isEmpty()) continue;
            String message = JavaErrorMessages.message("exception.already.caught.warn", HighlightUtil.formatTypes(caughtCopy), caughtCopy.size());
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range((PsiElement)catchSection).descriptionAndTooltip(message).create();
            if (isMultiCatch) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(catchTypeElement));
            } else {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteCatchFix(parameter));
            }
            result.add(highlightInfo);
        }
        return result;
    }

    @Nullable
    static HighlightInfo checkNotAStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkNotAStatement"));
        }
        if (!PsiUtil.isStatement((PsiElement)statement) && !PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
            String description = JavaErrorMessages.message("not.a.statement", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSwitchSelectorType(@NotNull PsiSwitchStatement statement, @NotNull LanguageLevel level) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSwitchSelectorType"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSwitchSelectorType"));
        }
        PsiExpression expression = statement.getExpression();
        if (expression == null) {
            return null;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return null;
        }
        SelectorKind kind = HighlightUtil.getSwitchSelectorKind(type);
        if (kind == SelectorKind.INT) {
            return null;
        }
        LanguageLevel requiredLevel = null;
        if (kind == SelectorKind.ENUM) {
            requiredLevel = LanguageLevel.JDK_1_5;
        }
        if (kind == SelectorKind.STRING) {
            requiredLevel = LanguageLevel.JDK_1_7;
        }
        if (kind == null || requiredLevel != null && !level.isAtLeast(requiredLevel)) {
            boolean is7 = level.isAtLeast(LanguageLevel.JDK_1_7);
            String expected = JavaErrorMessages.message(is7 ? "valid.switch.17.selector.types" : "valid.switch.selector.types", new Object[0]);
            String message = JavaErrorMessages.message("incompatible.types", expected, JavaHighlightUtil.formatType(type));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createConvertSwitchToIfIntention(statement));
            if (PsiType.LONG.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type)) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddTypeCastFix((PsiType)PsiType.INT, expression));
            }
            if (requiredLevel != null) {
                QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(requiredLevel));
            }
            return info;
        }
        PsiClass member = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (member != null && !PsiUtil.isAccessible((Project)member.getProject(), (PsiMember)member, (PsiElement)expression, null)) {
            String className = PsiFormatUtil.formatClass((PsiClass)member, (int)2049);
            String message = JavaErrorMessages.message("inaccessible.type", className);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
        }
        return null;
    }

    private static SelectorKind getSwitchSelectorKind(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getSwitchSelectorKind"));
        }
        if (TypeConversionUtil.getTypeRank((PsiType)type) <= 4) {
            return SelectorKind.INT;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return SelectorKind.ENUM;
            }
            if (Comparing.strEqual((String)psiClass.getQualifiedName(), (String)"java.lang.String")) {
                return SelectorKind.STRING;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPolyadicOperatorApplicable(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkPolyadicOperatorApplicable"));
        }
        PsiExpression[] operands = expression.getOperands();
        PsiType lType = operands[0].getType();
        IElementType operationSign = expression.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            PsiType rType = operand.getType();
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationSign, (PsiType)lType, (PsiType)rType, (boolean)false)) {
                PsiJavaToken token = expression.getTokenBeforeOperand(operand);
                String message = JavaErrorMessages.message("binary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rType));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(message).create();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)operationSign, (boolean)true);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnaryOperatorApplicable(@Nullable PsiJavaToken token, @Nullable PsiExpression expression) {
        if (token != null && expression != null && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)token, (PsiExpression)expression)) {
            PsiType type = expression.getType();
            if (type == null) {
                return null;
            }
            String message = JavaErrorMessages.message("unary.operator.not.applicable", token.getText(), JavaHighlightUtil.formatType(type));
            PsiElement parentExpr = token.getParent();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(parentExpr).descriptionAndTooltip(message).create();
            if (parentExpr instanceof PsiPrefixExpression && token.getTokenType() == JavaTokenType.EXCL) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createNegationBroadScopeFix((PsiPrefixExpression)parentExpr));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkThisOrSuperExpressionInIllegalContext(@NotNull PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull LanguageLevel languageLevel) {
        PsiMethod psiMethod;
        PsiClass classT;
        PsiClass aClass;
        PsiElement parent;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkThisOrSuperExpressionInIllegalContext"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkThisOrSuperExpressionInIllegalContext"));
        }
        if (expr instanceof PsiSuperExpression && !((parent = expr.getParent()) instanceof PsiReferenceExpression)) {
            int o = expr.getTextRange().getEndOffset();
            String description = JavaErrorMessages.message("dot.expected.after.super.or.this", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(o, o + 1).descriptionAndTooltip(description).create();
        }
        if (qualifier != null) {
            PsiElement resolved = qualifier.advancedResolve(true).getElement();
            if (resolved != null && !(resolved instanceof PsiClass)) {
                String description = JavaErrorMessages.message("class.expected", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
            }
            aClass = (PsiClass)resolved;
        } else {
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class);
        }
        if (aClass == null) {
            return null;
        }
        if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)expr, (boolean)false, (boolean)false) && !HighlightUtil.resolvesToImmediateSuperInterface(expr, qualifier, aClass, languageLevel)) {
            return HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)expr, null, aClass, (PsiElement)expr);
        }
        if (qualifier != null && aClass.isInterface() && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (classT = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) != null) {
            for (PsiClass superClass : classT.getSupers()) {
                if (!superClass.isInterface() || !superClass.isInheritor(aClass, true)) continue;
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(JavaErrorMessages.message("bad.qualifier.in.super.method.reference", HighlightUtil.format((PsiElement)aClass), HighlightUtil.formatClass(superClass))).create();
            }
            if (expr instanceof PsiSuperExpression && !classT.isInheritor(aClass, false)) {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(JavaErrorMessages.message("no.enclosing.instance.in.scope", HighlightUtil.format((PsiElement)aClass))).create();
            }
        }
        if (expr instanceof PsiThisExpression && ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class)) == null || psiMethod.getContainingClass() != aClass && !HighlightUtil.isInsideDefaultMethod(psiMethod, aClass))) {
            PsiClass parentClass;
            if (aClass.isInterface()) {
                return HighlightUtil.thisNotFoundInInterfaceInfo(expr);
            }
            if (aClass instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)aClass).getArgumentList(), (PsiElement)expr, (boolean)true) && (parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true)) != null && parentClass.isInterface()) {
                return HighlightUtil.thisNotFoundInInterfaceInfo(expr);
            }
        }
        return null;
    }

    static HighlightInfo checkUnqualifiedSuperInDefaultMethod(@NotNull LanguageLevel languageLevel, @NotNull PsiReferenceExpression expr, PsiExpression qualifier) {
        PsiMethod method;
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnqualifiedSuperInDefaultMethod"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnqualifiedSuperInDefaultMethod"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && qualifier instanceof PsiSuperExpression && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class)) != null && method.hasModifierProperty("default") && ((PsiSuperExpression)qualifier).getQualifier() == null) {
            String description = JavaErrorMessages.message("unqualified.super.disallowed", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip(description).create();
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifier, info);
            return info;
        }
        return null;
    }

    private static boolean isInsideDefaultMethod(PsiMethod method, PsiClass aClass) {
        while (method != null && method.getContainingClass() != aClass) {
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)true);
        }
        return method != null && method.hasModifierProperty("default");
    }

    private static HighlightInfo thisNotFoundInInterfaceInfo(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "thisNotFoundInInterfaceInfo"));
        }
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expr).descriptionAndTooltip("Cannot find symbol variable this").create();
    }

    private static boolean resolvesToImmediateSuperInterface(@NotNull PsiExpression expr, @Nullable PsiJavaCodeReferenceElement qualifier, @NotNull PsiClass aClass, @NotNull LanguageLevel languageLevel) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "resolvesToImmediateSuperInterface"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "resolvesToImmediateSuperInterface"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "resolvesToImmediateSuperInterface"));
        }
        if (!(expr instanceof PsiSuperExpression) || qualifier == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return false;
        }
        PsiType superType = expr.getType();
        if (!(superType instanceof PsiClassType)) {
            return false;
        }
        PsiClass superClass = ((PsiClassType)superType).resolve();
        return superClass != null && aClass.equals(superClass) && PsiUtil.getEnclosingStaticElement((PsiElement)expr, (PsiClass)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class))) == null;
    }

    @NotNull
    static String buildProblemWithStaticDescription(@NotNull PsiElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithStaticDescription"));
        }
        String type = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE)).getType(refElement);
        String name = HighlightMessageUtil.getSymbolName(refElement, PsiSubstitutor.EMPTY);
        String string = JavaErrorMessages.message("non.static.symbol.referenced.from.static.context", type, name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithStaticDescription"));
        }
        return string;
    }

    static void registerStaticProblemQuickFixAction(@NotNull PsiElement refElement, HighlightInfo errorResult, @NotNull PsiJavaCodeReferenceElement place) {
        PsiModifierListOwner staticParent;
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerStaticProblemQuickFixAction"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerStaticProblemQuickFixAction"));
        }
        if (refElement instanceof PsiModifierListOwner) {
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)refElement, "static", true, false));
        }
        if ((staticParent = PsiUtil.getEnclosingStaticElement((PsiElement)place, null)) != null && HighlightUtil.isInstanceReference(place)) {
            QuickFixAction.registerQuickFixAction(errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix(staticParent, "static", false, false));
        }
        if (place instanceof PsiReferenceExpression && refElement instanceof PsiField) {
            QuickFixAction.registerQuickFixAction(errorResult, QUICK_FIX_FACTORY.createCreateFieldFromUsageFix((PsiReferenceExpression)place));
        }
    }

    private static boolean isInstanceReference(@NotNull PsiJavaCodeReferenceElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "isInstanceReference"));
        }
        PsiElement qualifier = place.getQualifier();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement q = ((PsiReference)qualifier).resolve();
        if (q instanceof PsiClass) {
            return false;
        }
        if (q != null) {
            return true;
        }
        String qname = ((PsiJavaCodeReferenceElement)qualifier).getQualifiedName();
        return qname == null || !Character.isLowerCase(qname.charAt(0));
    }

    @NotNull
    static String buildProblemWithAccessDescription(@NotNull PsiElement reference, @NotNull JavaResolveResult result) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        String string = HighlightUtil.buildProblemWithAccessDescription(reference, result, result.getElement());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        return string;
    }

    @NotNull
    private static String buildProblemWithAccessDescription(@NotNull PsiElement reference, @NotNull JavaResolveResult result, @NotNull PsiElement resolved) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        assert (resolved instanceof PsiModifierListOwner) : resolved;
        PsiModifierListOwner refElement = (PsiModifierListOwner)resolved;
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        if (refElement.hasModifierProperty("private")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            String string = JavaErrorMessages.message("private.symbol", symbolName, containerName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
            }
            return string;
        }
        if (refElement.hasModifierProperty("protected")) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            String string = JavaErrorMessages.message("protected.symbol", symbolName, containerName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
            }
            return string;
        }
        PsiClass packageLocalClass = HighlightUtil.getPackageLocalClassInTheMiddle(reference);
        if (packageLocalClass != null) {
            refElement = packageLocalClass;
            symbolName = HighlightMessageUtil.getSymbolName((PsiElement)refElement, result.getSubstitutor());
        }
        if (refElement.hasModifierProperty("packageLocal") || packageLocalClass != null) {
            String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
            String string = JavaErrorMessages.message("package.local.symbol", symbolName, containerName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
            }
            return string;
        }
        String containerName = HighlightUtil.getContainerName(refElement, result.getSubstitutor());
        String string = JavaErrorMessages.message("visibility.access.problem", symbolName, containerName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "buildProblemWithAccessDescription"));
        }
        return string;
    }

    private static PsiElement getContainer(PsiModifierListOwner refElement) {
        for (ContainerProvider provider : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider.getContainer((PsiElement)refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    private static String getContainerName(PsiModifierListOwner refElement, PsiSubstitutor substitutor) {
        PsiElement container = HighlightUtil.getContainer(refElement);
        return container == null ? "?" : HighlightMessageUtil.getSymbolName(container, substitutor);
    }

    @Nullable
    static HighlightInfo checkValidArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkValidArrayAccessExpression"));
        }
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        PsiType arrayExpressionType = arrayExpression.getType();
        if (arrayExpressionType != null && !(arrayExpressionType instanceof PsiArrayType)) {
            String description = JavaErrorMessages.message("array.type.expected", JavaHighlightUtil.formatType(arrayExpressionType));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)arrayExpression).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createReplaceWithListAccessFix(arrayAccessExpression));
            return info;
        }
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        return indexExpression != null ? HighlightUtil.checkAssignability((PsiType)PsiType.INT, indexExpression.getType(), indexExpression, (PsiElement)indexExpression) : null;
    }

    @Nullable
    static HighlightInfo checkCatchParameterIsThrowable(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkCatchParameterIsThrowable"));
        }
        if (parameter.getDeclarationScope() instanceof PsiCatchSection) {
            PsiType type = parameter.getType();
            return HighlightUtil.checkMustBeThrowable(type, (PsiElement)parameter, true);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkTryResourceIsAutoCloseable(@NotNull PsiResourceVariable resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkTryResourceIsAutoCloseable"));
        }
        PsiType type = resource.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)resource.getProject()).getElementFactory();
        PsiClassType autoCloseable = factory.createTypeByFQClassName("java.lang.AutoCloseable", resource.getResolveScope());
        if (TypeConversionUtil.isAssignable((PsiType)autoCloseable, (PsiType)type)) {
            return null;
        }
        return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)autoCloseable, type, resource.getTextRange(), 0);
    }

    @Nullable
    static Collection<HighlightInfo> checkArrayInitializer(PsiExpression initializer, PsiType type) {
        PsiExpression[] initializers;
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        if (!(type instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)type).getComponentType();
        PsiArrayInitializerExpression arrayInitializer = (PsiArrayInitializerExpression)initializer;
        boolean arrayTypeFixChecked = false;
        VariableArrayTypeFix fix = null;
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiExpression expression : initializers = arrayInitializer.getInitializers()) {
            HighlightInfo info = HighlightUtil.checkArrayInitializerCompatibleTypes(expression, componentType);
            if (info == null) continue;
            result.add(info);
            if (!arrayTypeFixChecked) {
                PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                fix = checkResult != null ? new VariableArrayTypeFix(arrayInitializer, checkResult) : null;
                arrayTypeFixChecked = true;
            }
            if (fix == null) continue;
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter((LocalQuickFixOnPsiElement)fix));
        }
        return result;
    }

    @Nullable
    private static HighlightInfo checkArrayInitializerCompatibleTypes(@NotNull PsiExpression initializer, PsiType componentType) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkArrayInitializerCompatibleTypes"));
        }
        PsiType initializerType = initializer.getType();
        if (initializerType == null) {
            String description = JavaErrorMessages.message("illegal.initializer", JavaHighlightUtil.formatType(componentType));
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)initializer).descriptionAndTooltip(description).create();
        }
        PsiExpression expression = initializer instanceof PsiArrayInitializerExpression ? null : initializer;
        return HighlightUtil.checkAssignability(componentType, initializerType, expression, (PsiElement)initializer);
    }

    @Nullable
    static HighlightInfo checkExpressionRequired(@NotNull PsiReferenceExpression expression, @NotNull JavaResolveResult resultForIncompleteCode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkExpressionRequired"));
        }
        if (resultForIncompleteCode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultForIncompleteCode", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkExpressionRequired"));
        }
        if (expression.getNextSibling() instanceof PsiErrorElement) {
            return null;
        }
        PsiElement resolved = resultForIncompleteCode.getElement();
        if (resolved == null || resolved instanceof PsiVariable) {
            return null;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            return null;
        }
        String description = JavaErrorMessages.message("expression.expected", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes(expression, new QuickFixActionRegistrarImpl(info));
        return info;
    }

    @Nullable
    static HighlightInfo checkArrayInitializerApplicable(@NotNull PsiArrayInitializerExpression expression) {
        PsiVariable variable;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkArrayInitializerApplicable"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiVariable ? (variable = (PsiVariable)parent).getType() instanceof PsiArrayType : parent instanceof PsiNewExpression || parent instanceof PsiArrayInitializerExpression) {
            return null;
        }
        String description = JavaErrorMessages.message("array.initializer.not.allowed", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createAddNewArrayExpressionFix(expression));
        return info;
    }

    @Nullable
    static HighlightInfo checkCaseStatement(@NotNull PsiSwitchLabelStatement statement) {
        PsiStatement[] statements;
        HighlightInfo highlightInfo;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkCaseStatement"));
        }
        PsiSwitchStatement switchStatement = statement.getEnclosingSwitchStatement();
        if (switchStatement == null) {
            String description = JavaErrorMessages.message("case.statement.outside.switch", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        if (switchStatement.getBody() == null) {
            return null;
        }
        PsiExpression switchExpression = switchStatement.getExpression();
        PsiPrimitiveType switchType = switchExpression == null ? PsiType.INT : switchExpression.getType();
        PsiExpression caseValue = statement.getCaseValue();
        if (caseValue != null && switchExpression != null && (highlightInfo = HighlightUtil.checkAssignability((PsiType)switchType, caseValue.getType(), caseValue, (PsiElement)caseValue)) != null) {
            return highlightInfo;
        }
        Object value = null;
        boolean isEnumSwitch = false;
        if (!statement.isDefaultCase() && caseValue != null) {
            PsiElement element;
            if (caseValue instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)caseValue).resolve()) instanceof PsiEnumConstant) {
                isEnumSwitch = true;
                value = ((PsiEnumConstant)element).getName();
                if (((PsiReferenceExpression)caseValue).getQualifier() != null) {
                    String message = JavaErrorMessages.message("qualified.enum.constant.in.switch", new Object[0]);
                    return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)caseValue).descriptionAndTooltip(message).create();
                }
            }
            if (!isEnumSwitch) {
                value = ConstantExpressionUtil.computeCastTo((PsiExpression)caseValue, (PsiType)switchType);
            }
            if (value == null) {
                String description = JavaErrorMessages.message("constant.expression.required", new Object[0]);
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)caseValue).descriptionAndTooltip(description).create();
            }
        }
        for (PsiStatement st : statements = switchStatement.getBody().getStatements()) {
            PsiElement element;
            PsiSwitchLabelStatement labelStatement;
            if (st == statement || !(st instanceof PsiSwitchLabelStatement) || (labelStatement = (PsiSwitchLabelStatement)st).isDefaultCase() != statement.isDefaultCase()) continue;
            PsiExpression caseExpr = labelStatement.getCaseValue();
            if (!isEnumSwitch || !(caseExpr instanceof PsiReferenceExpression) ? !TypeConversionUtil.areTypesAssignmentCompatible((PsiType)switchType, (PsiExpression)caseExpr) || !Comparing.equal((Object)ConstantExpressionUtil.computeCastTo((PsiExpression)caseExpr, (PsiType)switchType), (Object)value) : !((element = ((PsiReferenceExpression)caseExpr).resolve()) instanceof PsiEnumConstant) || !Comparing.equal((Object)((PsiEnumConstant)element).getName(), (Object)value)) continue;
            String description = statement.isDefaultCase() ? JavaErrorMessages.message("duplicate.default.switch.label", new Object[0]) : JavaErrorMessages.message("duplicate.switch.label", value);
            PsiSwitchLabelStatement element2 = value == null ? statement : caseValue;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element2).descriptionAndTooltip(description).create();
        }
        PsiElement lastChild = statement.getLastChild();
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            lastChild = lastChild.getPrevSibling();
        }
        if (!(lastChild instanceof PsiJavaToken) || ((PsiJavaToken)lastChild).getTokenType() != JavaTokenType.COLON) {
            int start = statement.getTextRange().getEndOffset();
            int end = statement.getTextRange().getEndOffset() + 1;
            String description = JavaErrorMessages.message("switch.colon.expected.after.case.label", new Object[0]);
            CharSequence chars = statement.getContainingFile().getViewProvider().getContents();
            boolean isAfterEndOfLine = end >= chars.length() || chars.charAt(start) == '\n' || chars.charAt(start) == '\r';
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description);
            if (isAfterEndOfLine) {
                builder.endOfLine();
            }
            return builder.create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIllegalForwardReferenceToField"));
        }
        if (referencedField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedField", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIllegalForwardReferenceToField"));
        }
        Boolean isIllegalForwardReference = HighlightUtil.isIllegalForwardReferenceToField(expression, referencedField, false);
        if (isIllegalForwardReference == null) {
            return null;
        }
        String description = isIllegalForwardReference != false ? JavaErrorMessages.message("illegal.forward.reference", new Object[0]) : JavaErrorMessages.message("illegal.self.reference", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
    }

    public static Boolean isIllegalForwardReferenceToField(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField, boolean acceptQualified) {
        boolean inStaticContext;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "isIllegalForwardReferenceToField"));
        }
        if (referencedField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedField", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "isIllegalForwardReferenceToField"));
        }
        PsiClass containingClass = referencedField.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        if (expression.getContainingFile() != referencedField.getContainingFile()) {
            return null;
        }
        if (expression.getTextRange().getStartOffset() >= referencedField.getTextRange().getEndOffset()) {
            return null;
        }
        if (!acceptQualified && expression.getQualifierExpression() != null) {
            return null;
        }
        PsiField initField = HighlightUtil.findEnclosingFieldInitializer((PsiElement)expression);
        PsiClassInitializer classInitializer = HighlightUtil.findParentClassInitializer((PsiElement)expression);
        if (initField == null && classInitializer == null) {
            return null;
        }
        boolean isStaticClassInitializer = classInitializer != null && classInitializer.hasModifierProperty("static");
        boolean isStaticInitField = initField != null && initField.hasModifierProperty("static");
        boolean bl = inStaticContext = isStaticInitField || isStaticClassInitializer;
        if (!inStaticContext && referencedField.hasModifierProperty("static")) {
            return null;
        }
        if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression) && !PsiUtil.isAccessedForReading((PsiExpression)expression)) {
            return null;
        }
        if (!containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class))) {
            return null;
        }
        return initField != referencedField;
    }

    @Nullable
    static PsiField findEnclosingFieldInitializer(@Nullable PsiElement element) {
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == ((PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    @Nullable
    private static PsiClassInitializer findParentClassInitializer(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof PsiClassInitializer) {
                return (PsiClassInitializer)element;
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalType(@Nullable PsiTypeElement typeElement) {
        PsiClass aClass;
        if (typeElement == null || typeElement.getParent() instanceof PsiTypeElement) {
            return null;
        }
        if (PsiUtil.isInsideJavadocComment((PsiElement)typeElement)) {
            return null;
        }
        PsiType type = typeElement.getType();
        PsiType componentType = type.getDeepComponentType();
        if (componentType instanceof PsiClassType && (aClass = PsiUtil.resolveClassInType((PsiType)componentType)) == null) {
            String canonicalText = type.getCanonicalText();
            String description = JavaErrorMessages.message("unknown.class", canonicalText);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkIllegalVoidType(@NotNull PsiKeyword type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkIllegalVoidType"));
        }
        if (!"void".equals(type.getText())) {
            return null;
        }
        PsiElement parent = type.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiMethod method;
            PsiElement typeOwner = parent.getParent();
            if (typeOwner != null && PsiUtilCore.hasErrorElementChild((PsiElement)typeOwner)) {
                return null;
            }
            if (typeOwner instanceof PsiMethod ? (method = (PsiMethod)typeOwner).getReturnTypeElement() == parent && PsiType.VOID.equals((Object)method.getReturnType()) : (typeOwner instanceof PsiClassObjectAccessExpression ? TypeConversionUtil.isVoidType((PsiType)((PsiClassObjectAccessExpression)typeOwner).getOperand().getType()) : typeOwner instanceof JavaCodeFragment && typeOwner.getUserData(PsiUtil.VALID_VOID_TYPE_IN_CODE_FRAGMENT) != null)) {
                return null;
            }
        }
        String description = JavaErrorMessages.message("illegal.type.void", new Object[0]);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)type).descriptionAndTooltip(description).create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static HighlightInfo checkMemberReferencedBeforeConstructorCalled(@NotNull PsiElement expression, PsiElement resolved, @NotNull PsiFile containingFile) {
        String resolvedName;
        PsiClass referencedClass;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMemberReferencedBeforeConstructorCalled"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMemberReferencedBeforeConstructorCalled"));
        }
        if (expression instanceof PsiJavaCodeReferenceElement) {
            if ("this".equals(((PsiJavaCodeReferenceElement)expression).getReferenceName()) && resolved instanceof PsiMethod && ((PsiMethod)resolved).isConstructor()) {
                return null;
            }
            PsiElement qualifier = ((PsiJavaCodeReferenceElement)expression).getQualifier();
            PsiType type = qualifier instanceof PsiExpression ? ((PsiExpression)qualifier).getType() : null;
            referencedClass = PsiUtil.resolveClassInType((PsiType)type);
            boolean isSuperCall = RefactoringChangeUtil.isSuperMethodCall(expression.getParent());
            if (resolved == null && isSuperCall) {
                if (qualifier instanceof PsiReferenceExpression) {
                    resolved = ((PsiReferenceExpression)qualifier).resolve();
                    expression = qualifier;
                    type = ((PsiReferenceExpression)qualifier).getType();
                    referencedClass = PsiUtil.resolveClassInType((PsiType)type);
                } else if (qualifier == null) {
                    resolved = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                    if (resolved != null) {
                        referencedClass = ((PsiMethod)resolved).getContainingClass();
                    }
                } else if (qualifier instanceof PsiThisExpression) {
                    referencedClass = PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)qualifier).getType());
                }
            }
            if (resolved instanceof PsiField) {
                PsiField referencedField = (PsiField)resolved;
                if (referencedField.hasModifierProperty("static")) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatVariable((PsiVariable)referencedField, (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                referencedClass = referencedField.getContainingClass();
            } else if (resolved instanceof PsiMethod) {
                String name;
                PsiMethod method = (PsiMethod)resolved;
                if (method.hasModifierProperty("static")) {
                    return null;
                }
                PsiElement nameElement = expression instanceof PsiThisExpression ? expression : ((PsiJavaCodeReferenceElement)expression).getReferenceNameElement();
                String string = name = nameElement == null ? null : nameElement.getText();
                if (isSuperCall) {
                    if (referencedClass == null) {
                        return null;
                    }
                    if (qualifier == null) {
                        PsiClass superClass = referencedClass.getSuperClass();
                        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)referencedClass, (PsiClass)superClass.getContainingClass(), (boolean)true)) return null;
                        resolvedName = "this";
                    } else {
                        resolvedName = qualifier.getText();
                    }
                } else if ("this".equals(name)) {
                    resolvedName = "this";
                } else {
                    resolvedName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
                    if (referencedClass == null) {
                        referencedClass = method.getContainingClass();
                    }
                }
            } else {
                if (!(resolved instanceof PsiClass)) return null;
                PsiClass aClass = (PsiClass)resolved;
                if (aClass.hasModifierProperty("static")) {
                    return null;
                }
                referencedClass = aClass.getContainingClass();
                if (referencedClass == null) {
                    return null;
                }
                resolvedName = PsiFormatUtil.formatClass((PsiClass)aClass, (int)1);
            }
        } else {
            if (!(expression instanceof PsiThisExpression)) return null;
            PsiThisExpression thisExpression = (PsiThisExpression)expression;
            PsiType type = thisExpression.getType();
            referencedClass = PsiUtil.resolveClassInType((PsiType)type);
            resolvedName = thisExpression.getQualifier() != null ? (referencedClass == null ? null : PsiFormatUtil.formatClass((PsiClass)referencedClass, (int)1) + ".this") : "this";
        }
        if (referencedClass != null) return HighlightUtil.checkReferenceToOurInstanceInsideThisOrSuper(expression, referencedClass, resolvedName, containingFile);
        return null;
    }

    @Nullable
    private static HighlightInfo checkReferenceToOurInstanceInsideThisOrSuper(@NotNull PsiElement expression, @NotNull PsiClass referencedClass, String resolvedName, @NotNull PsiFile containingFile) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReferenceToOurInstanceInsideThisOrSuper"));
        }
        if (referencedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReferenceToOurInstanceInsideThisOrSuper"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReferenceToOurInstanceInsideThisOrSuper"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, PsiReferenceParameterList.class) != null) {
            return null;
        }
        PsiElement element = expression.getParent();
        while (element != null) {
            PsiReferenceExpressionImpl referenceExpression;
            JavaResolveResult[] results;
            PsiElement resolve;
            if (RefactoringChangeUtil.isSuperOrThisMethodCall(element)) {
                PsiElement parentClass = new PsiMatcherImpl(element).parent(PsiMatchers.hasClass(PsiExpressionStatement.class)).parent(PsiMatchers.hasClass(PsiCodeBlock.class)).parent(PsiMatchers.hasClass(PsiMethod.class)).dot(JavaMatchers.isConstructor(true)).parent(PsiMatchers.hasClass(PsiClass.class)).getElement();
                if (parentClass == null) {
                    return null;
                }
                PsiClass aClass = (PsiClass)parentClass;
                if (PsiUtil.isInnerClass((PsiClass)aClass) && referencedClass == aClass.getContainingClass()) {
                    return null;
                }
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)referencedClass, (boolean)true)) {
                    return null;
                }
                if (expression instanceof PsiReferenceExpression && !HighlightUtil.thisOrSuperReference(((PsiReferenceExpression)expression).getQualifierExpression(), aClass)) {
                    return null;
                }
                if (expression instanceof PsiJavaCodeReferenceElement && !aClass.equals(PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) && PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTypeElement.class) != null) {
                    return null;
                }
                if (expression instanceof PsiJavaCodeReferenceElement && PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClassObjectAccessExpression.class) != null) {
                    return null;
                }
                HighlightInfo highlightInfo = HighlightUtil.createMemberReferencedError(resolvedName, expression.getTextRange());
                if (expression instanceof PsiReferenceExpression && PsiUtil.isInnerClass((PsiClass)aClass)) {
                    String referenceName = ((PsiReferenceExpression)expression).getReferenceName();
                    PsiClass containingClass = aClass.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    PsiField fieldInContainingClass = containingClass.findFieldByName(referenceName, true);
                    if (fieldInContainingClass != null && ((PsiReferenceExpression)expression).getQualifierExpression() == null) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, new QualifyWithThisFix(containingClass, expression));
                    }
                }
                return highlightInfo;
            }
            if (element instanceof PsiReferenceExpression && (resolve = element instanceof PsiReferenceExpressionImpl ? ((results = JavaResolveUtil.resolveWithContainingFile(referenceExpression = (PsiReferenceExpressionImpl)element, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE, true, false, containingFile)).length == 1 ? results[0].getElement() : null) : ((PsiReferenceExpression)element).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static")) {
                return null;
            }
            if (!((element = element.getParent()) instanceof PsiClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)element), (PsiClass)referencedClass, (boolean)true)) continue;
            return null;
        }
        return null;
    }

    private static HighlightInfo createMemberReferencedError(@NonNls String resolvedName, @NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "createMemberReferencedError"));
        }
        String description = JavaErrorMessages.message("member.referenced.before.constructor.called", resolvedName);
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
    }

    @Nullable
    static HighlightInfo checkImplicitThisReferenceBeforeSuper(@NotNull PsiClass aClass, @NotNull JavaSdkVersion javaSdkVersion) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkImplicitThisReferenceBeforeSuper"));
        }
        if (javaSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSdkVersion", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkImplicitThisReferenceBeforeSuper"));
        }
        if (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            return null;
        }
        if (aClass instanceof PsiAnonymousClass || aClass instanceof PsiTypeParameter) {
            return null;
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null || !PsiUtil.isInnerClass((PsiClass)superClass)) {
            return null;
        }
        PsiClass outerClass = superClass.getContainingClass();
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)outerClass, (boolean)true)) {
            return null;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            TextRange range = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", range);
        }
        for (PsiMethod constructor : constructors) {
            if (HighlightUtil.isSuperCalledInConstructor(constructor)) continue;
            return HighlightUtil.createMemberReferencedError(aClass.getName() + ".this", HighlightNamesUtil.getMethodDeclarationTextRange(constructor));
        }
        return null;
    }

    private static boolean isSuperCalledInConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "isSuperCalledInConstructor"));
        }
        PsiCodeBlock body = constructor.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        PsiElement element = new PsiMatcherImpl((PsiElement)statement).dot(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiReferenceExpression.class)).firstChild(PsiMatchers.hasClass(PsiKeyword.class)).dot(PsiMatchers.hasText("super")).getElement();
        return element != null;
    }

    private static boolean thisOrSuperReference(@Nullable PsiExpression qualifierExpression, PsiClass aClass) {
        PsiJavaCodeReferenceElement qualifier;
        if (qualifierExpression == null) {
            return true;
        }
        if (qualifierExpression instanceof PsiThisExpression) {
            qualifier = ((PsiThisExpression)qualifierExpression).getQualifier();
        } else if (qualifierExpression instanceof PsiSuperExpression) {
            qualifier = ((PsiSuperExpression)qualifierExpression).getQualifier();
        } else {
            return false;
        }
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = qualifier.resolve();
        return resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)((PsiClass)resolved), (boolean)true);
    }

    @Nullable
    static HighlightInfo checkLabelWithoutStatement(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkLabelWithoutStatement"));
        }
        if (statement.getStatement() == null) {
            String description = JavaErrorMessages.message("label.without.statement", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkLabelAlreadyInUse(@NotNull PsiLabeledStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkLabelAlreadyInUse"));
        }
        PsiIdentifier identifier = statement.getLabelIdentifier();
        String text = identifier.getText();
        for (PsiLabeledStatement element = statement; element != null && !(element instanceof PsiMethod) && !(element instanceof PsiClass); element = element.getParent()) {
            if (!(element instanceof PsiLabeledStatement) || element == statement || !Comparing.equal((String)element.getLabelIdentifier().getText(), (String)text)) continue;
            String description = JavaErrorMessages.message("duplicate.label", text);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkUnclosedComment(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkUnclosedComment"));
        }
        if (!(comment instanceof PsiDocComment) && comment.getTokenType() != JavaTokenType.C_STYLE_COMMENT) {
            return null;
        }
        if (!comment.getText().endsWith("*/")) {
            int start = comment.getTextRange().getEndOffset() - 1;
            int end = start + 1;
            String description = JavaErrorMessages.message("unclosed.comment", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static Collection<HighlightInfo> checkCatchTypeIsDisjoint(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkCatchTypeIsDisjoint"));
        }
        if (!(parameter.getType() instanceof PsiDisjunctionType)) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        int size = typeElements.size();
        block0: for (int i = 0; i < size; ++i) {
            PsiClass class1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(i)).getType());
            if (class1 == null) continue;
            for (int j = i + 1; j < size; ++j) {
                PsiClass class2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiTypeElement)typeElements.get(j)).getType());
                if (class2 == null) continue;
                boolean sub = InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)class2, (boolean)true);
                boolean sup = InheritanceUtil.isInheritorOrSelf((PsiClass)class2, (PsiClass)class1, (boolean)true);
                if (!sub && !sup) continue;
                String name1 = PsiFormatUtil.formatClass((PsiClass)class1, (int)2049);
                String name2 = PsiFormatUtil.formatClass((PsiClass)class2, (int)2049);
                String message = JavaErrorMessages.message("exception.must.be.disjoint", sub ? name1 : name2, sub ? name2 : name1);
                PsiElement element = (PsiElement)typeElements.get(sub ? i : j);
                result.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(message).create());
                continue block0;
            }
        }
        return result;
    }

    @Nullable
    static Collection<HighlightInfo> checkExceptionAlreadyCaught(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkExceptionAlreadyCaught"));
        }
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiCatchSection)) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)scope;
        Object[] allCatchSections = catchSection.getTryStatement().getCatchSections();
        int startFrom = ArrayUtilRt.find((Object[])allCatchSections, (Object)catchSection) - 1;
        if (startFrom < 0) {
            return null;
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
        boolean isInMultiCatch = typeElements.size() > 1;
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass catchClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
            if (catchClass == null) continue;
            for (int i = startFrom; i >= 0; --i) {
                boolean highlight;
                Object upperCatchSection = allCatchSections[i];
                PsiType upperCatchType = upperCatchSection.getCatchType();
                boolean bl = highlight = upperCatchType instanceof PsiDisjunctionType ? HighlightUtil.checkMultipleTypes(catchClass, ((PsiDisjunctionType)upperCatchType).getDisjunctions()) : HighlightUtil.checkSingleType(catchClass, upperCatchType);
                if (!highlight) continue;
                String className = PsiFormatUtil.formatClass((PsiClass)catchClass, (int)2049);
                String description = JavaErrorMessages.message("exception.already.caught", className);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                result.add(highlightInfo);
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createMoveCatchUpFix(catchSection, (PsiCatchSection)upperCatchSection));
                if (isInMultiCatch) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteMultiCatchFix(typeElement));
                    continue;
                }
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createDeleteCatchFix(parameter));
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static boolean checkMultipleTypes(PsiClass catchClass, @NotNull List<PsiType> upperCatchTypes) {
        if (upperCatchTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperCatchTypes", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMultipleTypes"));
        }
        for (int i = upperCatchTypes.size() - 1; i >= 0; --i) {
            if (!HighlightUtil.checkSingleType(catchClass, upperCatchTypes.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSingleType(PsiClass catchClass, PsiType upperCatchType) {
        PsiClass upperCatchClass = PsiUtil.resolveClassInType((PsiType)upperCatchType);
        return upperCatchClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)catchClass, (PsiClass)upperCatchClass, (boolean)true);
    }

    @Nullable
    static HighlightInfo checkTernaryOperatorConditionIsBoolean(@NotNull PsiExpression expression, PsiType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkTernaryOperatorConditionIsBoolean"));
        }
        if (expression.getParent() instanceof PsiConditionalExpression && ((PsiConditionalExpression)expression.getParent()).getCondition() == expression && !TypeConversionUtil.isBooleanType((PsiType)type)) {
            return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type, expression.getTextRange(), 0);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkStatementPrependedWithCaseInsideSwitch(@NotNull PsiStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkStatementPrependedWithCaseInsideSwitch"));
        }
        if (!(statement instanceof PsiSwitchLabelStatement) && statement.getParent() instanceof PsiCodeBlock && statement.getParent().getParent() instanceof PsiSwitchStatement && ((PsiCodeBlock)statement.getParent()).getStatements().length != 0 && statement == ((PsiCodeBlock)statement.getParent()).getStatements()[0]) {
            String description = JavaErrorMessages.message("statement.must.be.prepended.with.case.label", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkAssertOperatorTypes(@NotNull PsiExpression expression, @Nullable PsiType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAssertOperatorTypes"));
        }
        if (type == null) {
            return null;
        }
        if (!(expression.getParent() instanceof PsiAssertStatement)) {
            return null;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)expression.getParent();
        if (expression == assertStatement.getAssertCondition() && !TypeConversionUtil.isBooleanType((PsiType)type)) {
            return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)PsiType.BOOLEAN, type, expression.getTextRange(), 0);
        }
        if (expression == assertStatement.getAssertDescription() && TypeConversionUtil.isVoidType((PsiType)type)) {
            String description = JavaErrorMessages.message("void.type.is.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkSynchronizedExpressionType(@NotNull PsiExpression expression, @Nullable PsiType type, @NotNull PsiFile containingFile) {
        PsiSynchronizedStatement synchronizedStatement;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSynchronizedExpressionType"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSynchronizedExpressionType"));
        }
        if (type == null) {
            return null;
        }
        if (expression.getParent() instanceof PsiSynchronizedStatement && expression == (synchronizedStatement = (PsiSynchronizedStatement)expression.getParent()).getLockExpression() && (type instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)type))) {
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)containingFile.getManager(), (GlobalSearchScope)expression.getResolveScope());
            return HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)objectType, type, expression.getTextRange(), 0);
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkConditionalExpressionBranchTypesMatch(@NotNull PsiExpression expression, PsiType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkConditionalExpressionBranchTypesMatch"));
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiConditionalExpression)) {
            return null;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
        if (conditionalExpression.getElseExpression() != expression) {
            return null;
        }
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        assert (thenExpression != null);
        PsiType thenType = thenExpression.getType();
        PsiType elseType = type;
        if (thenType == null || elseType == null) {
            return null;
        }
        if (conditionalExpression.getType() == null) {
            return HighlightUtil.createIncompatibleTypeHighlightInfo(thenType, elseType, expression.getTextRange(), 0);
        }
        return null;
    }

    static HighlightInfo createIncompatibleTypeHighlightInfo(PsiType lType, PsiType rType, @NotNull TextRange textRange, int navigationShift) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "createIncompatibleTypeHighlightInfo"));
        }
        PsiType lType1 = lType;
        PsiType rType1 = rType;
        PsiTypeParameter[] lTypeParams = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor lTypeSubstitutor = PsiSubstitutor.EMPTY;
        if (lType1 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)lType1).resolveGenerics();
            lTypeSubstitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass instanceof PsiAnonymousClass) {
                lType1 = ((PsiAnonymousClass)psiClass).getBaseClassType();
                resolveResult = ((PsiClassType)lType1).resolveGenerics();
                lTypeSubstitutor = resolveResult.getSubstitutor();
                psiClass = resolveResult.getElement();
            }
            lTypeParams = psiClass == null ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        PsiTypeParameter[] rTypeParams = PsiTypeParameter.EMPTY_ARRAY;
        PsiSubstitutor rTypeSubstitutor = PsiSubstitutor.EMPTY;
        if (rType1 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)rType1).resolveGenerics();
            rTypeSubstitutor = resolveResult.getSubstitutor();
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass instanceof PsiAnonymousClass) {
                rType1 = ((PsiAnonymousClass)psiClass).getBaseClassType();
                resolveResult = ((PsiClassType)rType1).resolveGenerics();
                rTypeSubstitutor = resolveResult.getSubstitutor();
                psiClass = resolveResult.getElement();
            }
            rTypeParams = psiClass == null ? PsiTypeParameter.EMPTY_ARRAY : psiClass.getTypeParameters();
        }
        int typeParamColumns = Math.max(lTypeParams.length, rTypeParams.length);
        String requiredRow = "";
        String foundRow = "";
        for (int i = 0; i < typeParamColumns; ++i) {
            PsiTypeParameter lTypeParameter = i >= lTypeParams.length ? null : lTypeParams[i];
            PsiTypeParameter rTypeParameter = i >= rTypeParams.length ? null : rTypeParams[i];
            PsiType lSubstitutedType = lTypeParameter == null ? null : lTypeSubstitutor.substitute(lTypeParameter);
            PsiType rSubstitutedType = rTypeParameter == null ? null : rTypeSubstitutor.substitute(rTypeParameter);
            boolean matches = Comparing.equal((Object)lSubstitutedType, (Object)rSubstitutedType);
            String openBrace = i == 0 ? "&lt;" : "";
            String closeBrace = i == typeParamColumns - 1 ? "&gt;" : ",";
            requiredRow = requiredRow + "<td>" + (lTypeParams.length == 0 ? "" : openBrace) + HighlightUtil.redIfNotMatch(lSubstitutedType, matches) + (i < lTypeParams.length ? closeBrace : "") + "</td>";
            foundRow = foundRow + "<td>" + (rTypeParams.length == 0 ? "" : openBrace) + HighlightUtil.redIfNotMatch(rSubstitutedType, matches) + (i < rTypeParams.length ? closeBrace : "") + "</td>";
        }
        PsiType lRawType = lType1 instanceof PsiClassType ? ((PsiClassType)lType1).rawType() : lType1;
        PsiType rRawType = rType1 instanceof PsiClassType ? ((PsiClassType)rType1).rawType() : rType1;
        boolean assignable = lRawType == null || rRawType == null || TypeConversionUtil.isAssignable((PsiType)lRawType, (PsiType)rRawType);
        String toolTip = JavaErrorMessages.message("incompatible.types.html.tooltip", HighlightUtil.redIfNotMatch(lRawType, assignable), requiredRow, HighlightUtil.redIfNotMatch(rRawType, assignable), foundRow);
        String description = JavaErrorMessages.message("incompatible.types", JavaHighlightUtil.formatType(lType1), JavaHighlightUtil.formatType(rType1));
        return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
    }

    @Nullable
    static HighlightInfo checkSingleImportClassConflict(@NotNull PsiImportStatement statement, @NotNull Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> importedClasses, @NotNull PsiFile containingFile) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSingleImportClassConflict"));
        }
        if (importedClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedClasses", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSingleImportClassConflict"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkSingleImportClassConflict"));
        }
        if (statement.isOnDemand()) {
            return null;
        }
        PsiElement element = statement.resolve();
        if (element instanceof PsiClass) {
            PsiClass importedClass;
            String name = ((PsiClass)element).getName();
            Pair<PsiImportStaticReferenceElement, PsiClass> imported = importedClasses.get(name);
            PsiClass psiClass = importedClass = imported == null ? null : (PsiClass)imported.getSecond();
            if (importedClass != null && !containingFile.getManager().areElementsEquivalent((PsiElement)importedClass, element)) {
                String description = JavaErrorMessages.message("single.import.class.conflict", HighlightUtil.formatClass(importedClass));
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(description).create();
            }
            importedClasses.put(name, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.create((Object)null, (Object)((PsiClass)element)));
        }
        return null;
    }

    @NonNls
    private static String redIfNotMatch(PsiType type, boolean matches) {
        if (matches) {
            return HighlightUtil.getFQName(type, false);
        }
        String color = UIUtil.isUnderDarcula() ? "FF6B68" : "red";
        return "<font color='" + color + "'><b>" + HighlightUtil.getFQName(type, true) + "</b></font>";
    }

    private static String getFQName(@Nullable PsiType type, boolean longName) {
        if (type == null) {
            return "";
        }
        return XmlStringUtil.escapeString((String)(longName ? type.getInternalCanonicalText() : type.getPresentableText()));
    }

    @Nullable
    static HighlightInfo checkMustBeThrowable(@Nullable PsiType type, @NotNull PsiElement context, boolean addCastIntention) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMustBeThrowable"));
        }
        if (type == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", context.getResolveScope());
        if (!TypeConversionUtil.isAssignable((PsiType)throwable, (PsiType)type)) {
            PsiClass aClass;
            HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo((PsiType)throwable, type, context.getTextRange(), 0);
            if (addCastIntention && TypeConversionUtil.areTypesConvertible((PsiType)type, (PsiType)throwable) && context instanceof PsiExpression) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createAddTypeCastFix((PsiType)throwable, (PsiExpression)context));
            }
            if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(aClass, throwable, true));
            }
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private static HighlightInfo checkMustBeThrowable(@Nullable PsiClass aClass, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkMustBeThrowable"));
        }
        if (aClass == null) {
            return null;
        }
        PsiClassType type = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
        return HighlightUtil.checkMustBeThrowable((PsiType)type, context, false);
    }

    @Nullable
    static HighlightInfo checkLabelDefined(@Nullable PsiIdentifier labelIdentifier, @Nullable PsiStatement exitedStatement) {
        if (labelIdentifier == null) {
            return null;
        }
        String label = labelIdentifier.getText();
        if (label == null) {
            return null;
        }
        if (exitedStatement == null) {
            String message = JavaErrorMessages.message("unresolved.label", label);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)labelIdentifier).descriptionAndTooltip(message).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkReference(@NotNull PsiJavaCodeReferenceElement ref, @NotNull JavaResolveResult result, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        PsiElement parent;
        String description;
        PsiElement granny;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReference"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReference"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReference"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkReference"));
        }
        PsiElement refName = ref.getReferenceNameElement();
        if (!(refName instanceof PsiIdentifier) && !(refName instanceof PsiKeyword)) {
            return null;
        }
        PsiElement resolved = result.getElement();
        HighlightInfo highlightInfo = HighlightUtil.checkMemberReferencedBeforeConstructorCalled((PsiElement)ref, resolved, containingFile);
        if (highlightInfo != null) {
            return highlightInfo;
        }
        PsiElement refParent = ref.getParent();
        if (refParent instanceof PsiReferenceExpression && (granny = refParent.getParent()) instanceof PsiMethodCallExpression) {
            PsiElement qualifier;
            PsiReferenceExpression referenceToMethod = ((PsiMethodCallExpression)granny).getMethodExpression();
            PsiExpression qualifierExpression = referenceToMethod.getQualifierExpression();
            if (qualifierExpression == ref && (qualifier = resolved) != null && !(qualifier instanceof PsiClass) && !(qualifier instanceof PsiVariable)) {
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range((PsiElement)qualifierExpression).descriptionAndTooltip("Qualifier must be an expression").create();
            }
        } else if (refParent instanceof PsiMethodCallExpression) {
            return null;
        }
        if (resolved == null) {
            if (HighlightUtil.isInsidePackageStatement(refName)) {
                return null;
            }
            if (result.isPackagePrefixPackageReference()) {
                return null;
            }
            JavaResolveResult[] results = ref.multiResolve(true);
            if (results.length > 1) {
                String t1 = HighlightUtil.format(results[0].getElement());
                String t2 = HighlightUtil.format(results[1].getElement());
                description = JavaErrorMessages.message("ambiguous.reference", refName.getText(), t1, t2);
            } else {
                description = JavaErrorMessages.message("cannot.resolve.symbol", refName.getText());
            }
            HighlightInfoType type = HighlightInfoType.WRONG_REF;
            if (PsiUtil.isInsideJavadocComment((PsiElement)ref)) {
                return null;
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(type).range(refName).descriptionAndTooltip(description).create();
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(ref, new QuickFixActionRegistrarImpl(info));
            return info;
        }
        if (!result.isValidResult() && !PsiUtil.isInsideJavadocComment((PsiElement)ref)) {
            HighlightInfo info;
            String description2;
            if (!result.isAccessible()) {
                description2 = HighlightUtil.buildProblemWithAccessDescription((PsiElement)ref, result, resolved);
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description2).create();
                if (result.isStaticsScopeCorrect()) {
                    HighlightUtil.registerAccessQuickFixAction((PsiMember)resolved, ref, info, result.getCurrentFileResolveScope());
                    if (ref instanceof PsiReferenceExpression) {
                        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRenameWrongRefFix((PsiReferenceExpression)ref));
                    }
                }
                UnresolvedReferenceQuickFixProvider.registerReferenceFixes(ref, new QuickFixActionRegistrarImpl(info));
                return info;
            }
            if (!result.isStaticsScopeCorrect()) {
                description2 = HighlightUtil.buildProblemWithStaticDescription(resolved);
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description2).create();
                HighlightUtil.registerStaticProblemQuickFixAction(resolved, info, ref);
                if (ref instanceof PsiReferenceExpression) {
                    QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRenameWrongRefFix((PsiReferenceExpression)ref));
                }
                return info;
            }
        }
        if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(resolved instanceof ImplicitVariable)) {
            highlightInfo = HighlightControlFlowUtil.checkVariableMustBeFinal((PsiVariable)resolved, ref, languageLevel);
        } else if (resolved instanceof PsiClass && Comparing.strEqual((String)((PsiClass)resolved).getQualifiedName(), (String)((PsiClass)resolved).getName()) && ((parent = ref.getParent()) instanceof PsiImportStaticReferenceElement || parent instanceof PsiImportStatementBase)) {
            description = JavaErrorMessages.message("cannot.resolve.symbol", refName.getText());
            return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refName).descriptionAndTooltip(description).create();
        }
        return highlightInfo;
    }

    @NotNull
    private static String format(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "format"));
        }
        if (element instanceof PsiClass) {
            String string = HighlightUtil.formatClass((PsiClass)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "format"));
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            String string = JavaHighlightUtil.formatMethod((PsiMethod)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "format"));
            }
            return string;
        }
        if (element instanceof PsiField) {
            String string = HighlightUtil.formatField((PsiField)element);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "format"));
            }
            return string;
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "format"));
        }
        return string;
    }

    private static boolean isInsidePackageStatement(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof PsiPackageStatement) {
                return true;
            }
            if (!(element instanceof PsiIdentifier) && !(element instanceof PsiJavaCodeReferenceElement)) {
                return false;
            }
            element = element.getParent();
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkPackageAndClassConflict(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        Module module;
        VirtualFile file;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkPackageAndClassConflict"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkPackageAndClassConflict"));
        }
        if (ref.isQualified() && HighlightUtil.isInsidePackageStatement((PsiElement)ref) && (file = containingFile.getVirtualFile()) != null && (module = ProjectFileIndex.SERVICE.getInstance((Project)ref.getProject()).getModuleForFile(file)) != null) {
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass(ref.getCanonicalText(), scope);
            if (aClass != null) {
                String message = JavaErrorMessages.message("package.clashes.with.class", ref.getText());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(message).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkElementInReferenceList(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiReferenceList referenceList, @NotNull JavaResolveResult resolveResult, @NotNull LanguageLevel languageLevel) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkElementInReferenceList"));
        }
        if (referenceList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceList", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkElementInReferenceList"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkElementInReferenceList"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkElementInReferenceList"));
        }
        PsiElement resolved = resolveResult.getElement();
        HighlightInfo highlightInfo = null;
        PsiElement refGrandParent = referenceList.getParent();
        if (resolved instanceof PsiClass) {
            PsiClass aClass = (PsiClass)resolved;
            if (refGrandParent instanceof PsiClass) {
                if (refGrandParent instanceof PsiTypeParameter) {
                    highlightInfo = GenericsHighlightUtil.checkElementInTypeParameterExtendsList(referenceList, (PsiClass)refGrandParent, resolveResult, (PsiElement)ref, languageLevel);
                } else {
                    highlightInfo = HighlightClassUtil.checkExtendsClassAndImplementsInterface(referenceList, resolveResult, ref);
                    if (highlightInfo == null) {
                        highlightInfo = HighlightClassUtil.checkCannotInheritFromFinal(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromEnum(aClass, (PsiElement)ref);
                    }
                    if (highlightInfo == null) {
                        highlightInfo = GenericsHighlightUtil.checkCannotInheritFromTypeParameter(aClass, ref);
                    }
                }
            } else if (refGrandParent instanceof PsiMethod && ((PsiMethod)refGrandParent).getThrowsList() == referenceList) {
                highlightInfo = HighlightUtil.checkMustBeThrowable(aClass, (PsiElement)ref);
            }
        } else if (refGrandParent instanceof PsiMethod && referenceList == ((PsiMethod)refGrandParent).getThrowsList()) {
            String description = JavaErrorMessages.message("class.name.expected", new Object[0]);
            highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create();
        }
        return highlightInfo;
    }

    public static boolean isSerializationImplicitlyUsedField(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "isSerializationImplicitlyUsedField"));
        }
        String name = field.getName();
        if (!"serialVersionUID".equals(name) && !SERIAL_PERSISTENT_FIELDS_FIELD_NAME.equals(name)) {
            return false;
        }
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return aClass == null || JavaHighlightUtil.isSerializable(aClass);
    }

    @Nullable
    static HighlightInfo checkClassReferenceAfterQualifier(@NotNull PsiReferenceExpression expression, PsiElement resolved) {
        PsiElement qualifierResolved;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkClassReferenceAfterQualifier"));
        }
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        if (qualifier instanceof PsiReferenceExpression && ((qualifierResolved = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass || qualifierResolved instanceof PsiPackage)) {
            return null;
        }
        String description = JavaErrorMessages.message("expected.class.or.package", new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)qualifier).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createRemoveQualifierFix(qualifier, expression, (PsiClass)resolved));
        return info;
    }

    static void registerChangeVariableTypeFixes(@NotNull PsiVariable parameter, PsiType itemType, @Nullable PsiExpression expr, @NotNull HighlightInfo highlightInfo) {
        PsiMethod method;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerChangeVariableTypeFixes"));
        }
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "registerChangeVariableTypeFixes"));
        }
        for (IntentionAction action : HighlightUtil.getChangeVariableTypeFixes(parameter, itemType)) {
            QuickFixAction.registerQuickFixAction(highlightInfo, action);
        }
        if (expr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)expr).resolveMethod()) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)PriorityActionWrapper.lowPriority((PsiElement)method, (LocalQuickFixAndIntentionActionOnPsiElement)QUICK_FIX_FACTORY.createMethodReturnFix(method, parameter.getType(), true)));
        }
    }

    @NotNull
    public static List<IntentionAction> getChangeVariableTypeFixes(@NotNull PsiVariable parameter, PsiType itemType) {
        IntentionAction changeFix;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getChangeVariableTypeFixes"));
        }
        if (itemType instanceof PsiMethodReferenceType) {
            List<IntentionAction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getChangeVariableTypeFixes"));
            }
            return list;
        }
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : (ChangeVariableTypeQuickFixProvider[])Extensions.getExtensions((ExtensionPointName)ChangeVariableTypeQuickFixProvider.EP_NAME)) {
                Collections.addAll(result, fixProvider.getFixes(parameter, itemType));
            }
        }
        if ((changeFix = HighlightUtil.getChangeParameterClassFix(parameter.getType(), itemType)) != null) {
            result.add(changeFix);
        }
        ArrayList<IntentionAction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "getChangeVariableTypeFixes"));
        }
        return arrayList;
    }

    @Nullable
    static HighlightInfo checkAnnotationMethodParameters(@NotNull PsiParameterList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkAnnotationMethodParameters"));
        }
        PsiElement parent = list.getParent();
        if (PsiUtil.isAnnotationMethod((PsiElement)parent) && list.getParametersCount() > 0) {
            String message = JavaErrorMessages.message("annotation.interface.members.may.not.have.parameters", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QUICK_FIX_FACTORY.createRemoveParameterListFix((PsiMethod)parent));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkForStatement"));
        }
        PsiStatement init = statement.getInitialization();
        if (!(init == null || init instanceof PsiEmptyStatement || init instanceof PsiDeclarationStatement || init instanceof PsiExpressionStatement || init instanceof PsiExpressionListStatement)) {
            String message = JavaErrorMessages.message("invalid.statement", new Object[0]);
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)init).descriptionAndTooltip(message).create();
        }
        return null;
    }

    private static void registerChangeParameterClassFix(PsiType lType, PsiType rType, HighlightInfo info) {
        QuickFixAction.registerQuickFixAction(info, HighlightUtil.getChangeParameterClassFix(lType, rType));
    }

    @Nullable
    private static IntentionAction getChangeParameterClassFix(PsiType lType, PsiType rType) {
        PsiClass lClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)lType);
        PsiClass rClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rType);
        if (rClass == null || lClass == null) {
            return null;
        }
        if (rClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (rClass.isInheritor(lClass, true)) {
            return null;
        }
        if (lClass.isInheritor(rClass, true)) {
            return null;
        }
        if (lClass == rClass) {
            return null;
        }
        return QUICK_FIX_FACTORY.createChangeParameterClassFix(rClass, (PsiClassType)lType);
    }

    private static void registerReplaceInaccessibleFieldWithGetterSetterFix(PsiMember refElement, PsiJavaCodeReferenceElement place, PsiClass accessObjectClass, HighlightInfo error) {
        PsiField psiField;
        PsiClass containingClass;
        if (refElement instanceof PsiField && place instanceof PsiReferenceExpression && (containingClass = (psiField = (PsiField)refElement).getContainingClass()) != null) {
            PsiMethod getterPrototype;
            PsiMethod getter;
            if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)place))) {
                PsiElement element;
                PsiMethod setterPrototype = PropertyUtil.generateSetterPrototype((PsiField)psiField);
                PsiMethod setter = containingClass.findMethodBySignature(setterPrototype, true);
                if (setter != null && PsiUtil.isAccessible((PsiMember)setter, (PsiElement)place, (PsiClass)accessObjectClass) && (element = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{PsiParenthesizedExpression.class})) instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getOperationTokenType() == JavaTokenType.EQ) {
                    QuickFixAction.registerQuickFixAction(error, QUICK_FIX_FACTORY.createReplaceInaccessibleFieldWithGetterSetterFix((PsiElement)place, setter, true));
                }
            } else if (PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)place)) && (getter = containingClass.findMethodBySignature(getterPrototype = PropertyUtil.generateGetterPrototype((PsiField)psiField), true)) != null && PsiUtil.isAccessible((PsiMember)getter, (PsiElement)place, (PsiClass)accessObjectClass)) {
                QuickFixAction.registerQuickFixAction(error, QUICK_FIX_FACTORY.createReplaceInaccessibleFieldWithGetterSetterFix((PsiElement)place, getter, false));
            }
        }
    }

    @Nullable
    static HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull Feature feature, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkFeature"));
        }
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkFeature"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkFeature"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil", "checkFeature"));
        }
        if (file.getManager().isInProject((PsiElement)file) && !level.isAtLeast(feature.level)) {
            String message = JavaErrorMessages.message("insufficient.language.level", JavaErrorMessages.message(feature.key, new Object[0]));
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element).descriptionAndTooltip(message).create();
            QuickFixAction.registerQuickFixAction(info, QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(feature.level));
            QuickFixAction.registerQuickFixAction(info, (IntentionAction)QUICK_FIX_FACTORY.createShowModulePropertiesFix(element));
            return info;
        }
        return null;
    }

    static {
        ourClassIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final"}));
        ourClassIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourClassIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourClassIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourClassIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourClassIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourClassIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourClassIncompatibleModifiers.put("static", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("abstract", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourInterfaceIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourInterfaceIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourInterfaceIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourInterfaceIncompatibleModifiers.put("strictfp", Collections.emptySet());
        ourInterfaceIncompatibleModifiers.put("static", Collections.emptySet());
        ourMethodIncompatibleModifiers.put("abstract", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"native", "static", "final", "private", "strictfp", "synchronized", "default"}));
        ourMethodIncompatibleModifiers.put("native", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "strictfp"}));
        ourMethodIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourMethodIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourMethodIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourMethodIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourMethodIncompatibleModifiers.put("static", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "default", "final"}));
        ourMethodIncompatibleModifiers.put("default", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "static", "final"}));
        ourMethodIncompatibleModifiers.put("synchronized", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourMethodIncompatibleModifiers.put("strictfp", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourMethodIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"abstract"}));
        ourFieldIncompatibleModifiers.put("final", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"volatile"}));
        ourFieldIncompatibleModifiers.put("packageLocal", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"private", "public", "protected"}));
        ourFieldIncompatibleModifiers.put("private", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "protected"}));
        ourFieldIncompatibleModifiers.put("public", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "private", "protected"}));
        ourFieldIncompatibleModifiers.put("protected", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"packageLocal", "public", "private"}));
        ourFieldIncompatibleModifiers.put("static", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("transient", Collections.emptySet());
        ourFieldIncompatibleModifiers.put("volatile", (Set<String>)ContainerUtil.newTroveSet((Object[])new String[]{"final"}));
        ourClassInitializerIncompatibleModifiers.put("static", Collections.emptySet());
        FP_LITERAL_PARTS = Pattern.compile("(?:(?:0x([_\\p{XDigit}]*)\\.?([_\\p{XDigit}]*)p[+-]?([_\\d]*))|(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)))[fd]?");
    }

    public static enum Feature {
        GENERICS(LanguageLevel.JDK_1_5, "feature.generics"),
        ANNOTATIONS(LanguageLevel.JDK_1_5, "feature.annotations"),
        STATIC_IMPORTS(LanguageLevel.JDK_1_5, "feature.static.imports"),
        FOR_EACH(LanguageLevel.JDK_1_5, "feature.for.each"),
        VARARGS(LanguageLevel.JDK_1_5, "feature.varargs"),
        HEX_FP_LITERALS(LanguageLevel.JDK_1_5, "feature.hex.fp.literals"),
        DIAMOND_TYPES(LanguageLevel.JDK_1_7, "feature.diamond.types"),
        MULTI_CATCH(LanguageLevel.JDK_1_7, "feature.multi.catch"),
        TRY_WITH_RESOURCES(LanguageLevel.JDK_1_7, "feature.try.with.resources"),
        BIN_LITERALS(LanguageLevel.JDK_1_7, "feature.binary.literals"),
        UNDERSCORES(LanguageLevel.JDK_1_7, "feature.underscores.in.literals"),
        EXTENSION_METHODS(LanguageLevel.JDK_1_8, "feature.extension.methods"),
        METHOD_REFERENCES(LanguageLevel.JDK_1_8, "feature.method.references"),
        LAMBDA_EXPRESSIONS(LanguageLevel.JDK_1_8, "feature.lambda.expressions"),
        TYPE_ANNOTATIONS(LanguageLevel.JDK_1_8, "feature.type.annotations");

        private final LanguageLevel level;
        private final String key;

        private Feature(LanguageLevel level, String key) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil$Feature", "<init>"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/analysis/HighlightUtil$Feature", "<init>"));
            }
            this.level = level;
            this.key = key;
        }
    }

    private static enum SelectorKind {
        INT,
        ENUM,
        STRING;

    }
}

