/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsTree;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class IntentionSettingsPanel
implements MasterDetails {
    private JPanel myPanel;
    private final IntentionSettingsTree myIntentionSettingsTree;
    private final IntentionDescriptionPanel myIntentionDescriptionPanel;
    private JPanel myTreePanel;
    private JPanel myDescriptionPanel;
    private DetailsComponent myDetailsComponent;
    private final Alarm myResetAlarm;

    public IntentionSettingsPanel() {
        this.$$$setupUI$$$();
        this.myIntentionDescriptionPanel = new IntentionDescriptionPanel();
        this.myResetAlarm = new Alarm();
        this.myIntentionSettingsTree = new IntentionSettingsTree(){

            @Override
            protected void selectionChanged(Object selected) {
                if (selected instanceof IntentionActionMetaData) {
                    final IntentionActionMetaData actionMetaData = (IntentionActionMetaData)selected;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            IntentionSettingsPanel.this.intentionSelected(actionMetaData);
                            if (IntentionSettingsPanel.this.myDetailsComponent != null) {
                                String[] text = new String[actionMetaData.myCategory.length + 1];
                                System.arraycopy(actionMetaData.myCategory, 0, text, 0, actionMetaData.myCategory.length);
                                text[text.length - 1] = actionMetaData.getFamily();
                                IntentionSettingsPanel.this.myDetailsComponent.setText(text);
                            }
                        }
                    };
                    IntentionSettingsPanel.this.myResetAlarm.cancelAllRequests();
                    IntentionSettingsPanel.this.myResetAlarm.addRequest(runnable, 100);
                } else {
                    IntentionSettingsPanel.this.categorySelected((String)selected);
                    if (IntentionSettingsPanel.this.myDetailsComponent != null) {
                        IntentionSettingsPanel.this.myDetailsComponent.setText(new String[]{(String)selected});
                    }
                }
            }

            @Override
            protected List<IntentionActionMetaData> filterModel(String filter, boolean force) {
                List<IntentionActionMetaData> list = IntentionManagerSettings.getInstance().getMetaData();
                if (filter == null || filter.length() == 0) {
                    return list;
                }
                HashSet<String> quoted = new HashSet<String>();
                List<Set<String>> keySetList = SearchUtil.findKeys(filter, quoted);
                List<IntentionActionMetaData> result = new ArrayList<IntentionActionMetaData>();
                for (IntentionActionMetaData metaData : list) {
                    if (!IntentionSettingsPanel.isIntentionAccepted(metaData, filter, force, keySetList, quoted)) continue;
                    result.add(metaData);
                }
                Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter);
                if (force && result.isEmpty() && filters.size() > 1) {
                    result = this.filterModel(filter, false);
                }
                return result;
            }
        };
        this.myTreePanel.setLayout(new BorderLayout());
        this.myTreePanel.add((Component)this.myIntentionSettingsTree.getComponent(), "Center");
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        this.myDescriptionPanel.setLayout(new BorderLayout());
        this.myDescriptionPanel.add((Component)this.myIntentionDescriptionPanel.getComponent(), "Center");
    }

    private void intentionSelected(IntentionActionMetaData actionMetaData) {
        this.myIntentionDescriptionPanel.reset(actionMetaData, this.myIntentionSettingsTree.getFilter());
    }

    private void categorySelected(String intentionCategory) {
        this.myIntentionDescriptionPanel.reset(intentionCategory);
    }

    public void reset() {
        this.myIntentionSettingsTree.reset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntentionSettingsPanel.this.myIntentionDescriptionPanel.init(IntentionSettingsPanel.this.myPanel.getWidth() / 2);
            }
        });
    }

    public void initUi() {
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myDescriptionPanel);
    }

    public JComponent getToolbar() {
        return this.myIntentionSettingsTree.getToolbarPanel();
    }

    public JComponent getMaster() {
        return this.myTreePanel;
    }

    public DetailsComponent getDetails() {
        return this.myDetailsComponent;
    }

    public void apply() {
        this.myIntentionSettingsTree.apply();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public JTree getIntentionTree() {
        return this.myIntentionSettingsTree.getTree();
    }

    public boolean isModified() {
        return this.myIntentionSettingsTree.isModified();
    }

    public void dispose() {
        this.myIntentionSettingsTree.dispose();
        this.myIntentionDescriptionPanel.dispose();
    }

    public void selectIntention(String familyName) {
        this.myIntentionSettingsTree.selectIntention(familyName);
    }

    private static boolean isIntentionAccepted(IntentionActionMetaData metaData, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, HashSet<String> quoted) {
        if (StringUtil.containsIgnoreCase((String)metaData.getFamily(), (String)filter)) {
            return true;
        }
        for (String category : metaData.myCategory) {
            if (category == null || !StringUtil.containsIgnoreCase((String)category, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)metaData.getFamily(), (String)string)) {
                return true;
            }
            for (String category : metaData.myCategory) {
                if (category == null || !StringUtil.containsIgnoreCase((String)category, (String)string)) continue;
                return true;
            }
            try {
                TextDescriptor description = metaData.getDescription();
                if (StringUtil.containsIgnoreCase((String)description.getText(), (String)string)) {
                    if (forceInclude) continue;
                    return true;
                }
                if (!forceInclude) continue;
                return false;
            }
            catch (IOException iOException) {
            }
        }
        for (Set set : keySetList) {
            if (set.contains(metaData.getFamily())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    public Runnable showOption(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                IntentionSettingsPanel.this.myIntentionSettingsTree.filter(IntentionSettingsPanel.this.myIntentionSettingsTree.filterModel(option, true));
                IntentionSettingsPanel.this.myIntentionSettingsTree.setFilter(option);
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(557);
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myDescriptionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 5), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel4);
        this.myTreePanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

