/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPackage;

class PackageLookupItem
extends LookupItem<PsiPackage> {
    public PackageLookupItem(PsiPackage pkg) {
        super(pkg, StringUtil.notNullize((String)pkg.getName()));
        this.setTailType(TailType.DOT);
    }

    @Override
    public void handleInsert(InsertionContext context) {
        super.handleInsert(context);
        if (this.getTailType() == TailType.DOT || context.getCompletionChar() == '.') {
            AutoPopupController.getInstance(context.getProject()).scheduleAutoPopup(context.getEditor());
        }
    }
}

