/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBListWithHintProvider;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtil {
    private NavigationUtil() {
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, String title) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, new DefaultPsiElementCellRenderer(), title);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, @NotNull PsiElementListCellRenderer<PsiElement> renderer, String title) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup((PsiElement[])elements, renderer, (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/navigation/NavigationUtil$1", "execute"));
                }
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)element);
                if (descriptor != null && descriptor.canNavigate()) {
                    descriptor.navigate(true);
                }
                return true;
            }
        });
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, String title, @NotNull PsiElementProcessor<T> processor) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, renderer, (String)title, processor, null);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, @Nullable String title, @NotNull PsiElementProcessor<T> processor, @Nullable T selection) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBListWithHintProvider list = new JBListWithHintProvider(elements){

            @Nullable
            protected PsiElement getPsiElementForHint(Object selectedValue) {
                return (PsiElement)selectedValue;
            }
        };
        list.setCellRenderer(renderer);
        if (selection != null) {
            list.setSelectedValue(selection, true);
        }
        Runnable runnable = new Runnable((JList)list, processor){
            final /* synthetic */ JList val$list;
            final /* synthetic */ PsiElementProcessor val$processor;
            {
                this.val$list = jList;
                this.val$processor = psiElementProcessor;
            }

            @Override
            public void run() {
                int[] ids = this.val$list.getSelectedIndices();
                if (ids == null || ids.length == 0) {
                    return;
                }
                for (Object element : this.val$list.getSelectedValues()) {
                    if (element == null) continue;
                    this.val$processor.execute((PsiElement)element);
                }
            }
        };
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        if (title != null) {
            builder.setTitle(title);
        }
        renderer.installSpeedSearch(builder, true);
        JBPopup jBPopup = builder.setItemChoosenCallback(runnable).createPopup();
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/navigation/NavigationUtil", "activateFileWithPsiElement"));
        }
        return NavigationUtil.activateFileWithPsiElement(elt, true);
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt, boolean searchForOpen) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/navigation/NavigationUtil", "activateFileWithPsiElement"));
        }
        return NavigationUtil.openFileWithPsiElement(elt, searchForOpen, true);
    }

    public static boolean openFileWithPsiElement(PsiElement element, boolean searchForOpen, boolean requestFocus) {
        VirtualFile virtualFile;
        boolean openAsNative = false;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            openAsNative = ElementBase.isNativeFileType((FileType)virtualFile.getFileType());
        }
        if (searchForOpen) {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        } else {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)true);
        }
        if (openAsNative || !NavigationUtil.activatePsiElementIfOpen(element, searchForOpen, requestFocus)) {
            NavigationItem navigationItem = (NavigationItem)element;
            if (!navigationItem.canNavigate()) {
                return false;
            }
            navigationItem.navigate(requestFocus);
            return true;
        }
        element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        return false;
    }

    private static boolean activatePsiElementIfOpen(@NotNull PsiElement elt, boolean searchForOpen, boolean requestFocus) {
        FileEditor[] editors;
        TextRange range;
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/navigation/NavigationUtil", "activatePsiElementIfOpen"));
        }
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file = (elt = elt.getNavigationElement()).getContainingFile();
        if (file == null || !file.isValid()) {
            return false;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (!EditorHistoryManager.getInstance(elt.getProject()).hasBeenOpen(vFile)) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance((Project)elt.getProject());
        if (!fem.isFileOpen(vFile)) {
            fem.openFile(vFile, requestFocus, searchForOpen);
        }
        if ((range = elt.getTextRange()) == null) {
            return false;
        }
        for (FileEditor editor : editors = fem.getEditors(vFile)) {
            Editor text;
            int offset;
            if (!(editor instanceof TextEditor) || !range.containsOffset(offset = (text = ((TextEditor)editor).getEditor()).getCaretModel().getOffset())) continue;
            fem.openFile(vFile, requestFocus, searchForOpen);
            return true;
        }
        return false;
    }

    public static TextAttributes patchAttributesColor(TextAttributes attributes, @NotNull TextRange range, @NotNull Editor editor) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/navigation/NavigationUtil", "patchAttributesColor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/NavigationUtil", "patchAttributesColor"));
        }
        MarkupModel model = DocumentMarkupModel.forDocument(editor.getDocument(), editor.getProject(), false);
        if (model != null && !((MarkupModelEx)model).processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                TextAttributes textAttributes;
                if (highlighter.isValid() && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE && (textAttributes = highlighter.getTextAttributes()) != null) {
                    Color color = textAttributes.getBackgroundColor();
                    return color == null || color.getBlue() <= 128 || color.getRed() >= 128 || color.getGreen() >= 128;
                }
                return true;
            }
        })) {
            TextAttributes clone = attributes.clone();
            clone.setForegroundColor(Color.orange);
            clone.setEffectColor(Color.orange);
            return clone;
        }
        return attributes;
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items, String title) {
        Object[] elements = new Object[items.size()];
        final HashMap<PsiElement, GotoRelatedItem> itemsMap = new HashMap<PsiElement, GotoRelatedItem>();
        for (int i = 0; i < items.size(); ++i) {
            GotoRelatedItem item = items.get(i);
            elements[i] = item.getElement() != null ? item.getElement() : item;
            itemsMap.put(item.getElement(), item);
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, itemsMap, title, new Processor<Object>(){

            public boolean process(Object element) {
                if (element instanceof PsiElement) {
                    ((GotoRelatedItem)itemsMap.get(element)).navigate();
                } else {
                    ((GotoRelatedItem)element).navigate();
                }
                return true;
            }
        });
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getRelatedItemsPopup"));
        }
        return jBPopup;
    }

    private static JBPopup getPsiElementPopup(Object[] elements, final Map<PsiElement, GotoRelatedItem> itemsMap, String title, final Processor<Object> processor) {
        final Ref hasMnemonic = Ref.create((Object)false);
        final DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){
            {
                this.setFocusBorderEnabled(false);
            }

            @Override
            public String getElementText(PsiElement element) {
                String customName = ((GotoRelatedItem)itemsMap.get(element)).getCustomName();
                return customName != null ? customName : super.getElementText(element);
            }

            @Override
            protected Icon getIcon(PsiElement element) {
                Icon customIcon = ((GotoRelatedItem)itemsMap.get(element)).getCustomIcon();
                return customIcon != null ? customIcon : super.getIcon(element);
            }

            @Override
            public String getContainerText(PsiElement element, String name) {
                String customContainerName = ((GotoRelatedItem)itemsMap.get(element)).getCustomContainerName();
                if (customContainerName != null) {
                    return customContainerName;
                }
                PsiFile file = element.getContainingFile();
                return file != null && !this.getElementText(element).equals(file.getName()) ? "(" + file.getName() + ")" : null;
            }

            @Override
            protected DefaultListCellRenderer getRightCellRenderer(Object value) {
                return null;
            }

            @Override
            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
                GotoRelatedItem item = (GotoRelatedItem)value;
                Color color = list.getForeground();
                SimpleTextAttributes nameAttributes = new SimpleTextAttributes(0, color);
                String name = item.getCustomName();
                if (name == null) {
                    return false;
                }
                renderer.append(name, nameAttributes);
                renderer.setIcon(item.getCustomIcon());
                return true;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel component = (JPanel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!((Boolean)hasMnemonic.get()).booleanValue()) {
                    return component;
                }
                JPanel panelWithMnemonic = new JPanel(new BorderLayout());
                int mnemonic = NavigationUtil.getMnemonic(value, itemsMap);
                JLabel label = new JLabel("");
                if (mnemonic != -1) {
                    label.setText(mnemonic + ".");
                    label.setDisplayedMnemonicIndex(0);
                }
                label.setPreferredSize(new JLabel("8.").getPreferredSize());
                JComponent leftRenderer = (JComponent)component.getComponents()[0];
                component.remove(leftRenderer);
                panelWithMnemonic.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                panelWithMnemonic.setBackground(leftRenderer.getBackground());
                label.setBackground(leftRenderer.getBackground());
                panelWithMnemonic.add((Component)label, "West");
                panelWithMnemonic.add((Component)leftRenderer, "Center");
                component.add(panelWithMnemonic);
                return component;
            }
        };
        final ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<Object>(title, Arrays.asList(elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(Object value) {
                if (value instanceof GotoRelatedItem) {
                    return ((GotoRelatedItem)value).getCustomName();
                }
                PsiElement element = (PsiElement)value;
                return renderer.getElementText(element) + " " + renderer.getContainerText(element, (String)null);
            }

            public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
                processor.process(selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }
        }){};
        popup.getList().setCellRenderer(new PopupListElementRenderer(popup){
            Map<Object, String> separators;
            {
                super(x0);
                this.separators = new HashMap<Object, String>();
                ListModel model = popup.getList().getModel();
                String current = null;
                boolean hasTitle = false;
                for (int i = 0; i < model.getSize(); ++i) {
                    Object element = model.getElementAt(i);
                    GotoRelatedItem item = (GotoRelatedItem)itemsMap.get(element);
                    if (item == null || StringUtil.equals(current, (CharSequence)item.getGroup())) continue;
                    current = item.getGroup();
                    this.separators.put(element, current);
                    if (hasTitle || StringUtil.isEmpty((String)current)) continue;
                    hasTitle = true;
                }
                if (!hasTitle) {
                    this.separators.remove(model.getElementAt(0));
                }
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String separator = this.separators.get(value);
                if (separator != null) {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add(component, "Center");
                    SeparatorWithText sep = new SeparatorWithText(){

                        protected void paintComponent(Graphics g) {
                            g.setColor((Color)new JBColor(Color.WHITE, UIUtil.getSeparatorColor()));
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paintComponent(g);
                        }
                    };
                    sep.setCaption(separator);
                    panel.add((Component)sep, "North");
                    return panel;
                }
                return component;
            }
        });
        popup.setMinimumSize(new Dimension(200, -1));
        for (Object item : elements) {
            int mnemonic = NavigationUtil.getMnemonic(item, itemsMap);
            if (mnemonic == -1) continue;
            Action action = NavigationUtil.createNumberAction(mnemonic, popup, itemsMap, processor);
            popup.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke(String.valueOf(mnemonic)), action);
            popup.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke("NUMPAD" + String.valueOf(mnemonic)), action);
            hasMnemonic.set((Object)true);
        }
        return popup;
    }

    private static Action createNumberAction(final int mnemonic, final ListPopupImpl listPopup, final Map<PsiElement, GotoRelatedItem> itemsMap, final Processor<Object> processor) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (final Object item : listPopup.getListStep().getValues()) {
                    if (NavigationUtil.getMnemonic(item, itemsMap) != mnemonic) continue;
                    listPopup.setFinalRunnable(new Runnable(){

                        @Override
                        public void run() {
                            processor.process(item);
                        }
                    });
                    listPopup.closeOk(null);
                }
            }
        };
    }

    private static int getMnemonic(Object item, Map<PsiElement, GotoRelatedItem> itemsMap) {
        return (item instanceof GotoRelatedItem ? (GotoRelatedItem)item : itemsMap.get((PsiElement)item)).getMnemonic();
    }

    @NotNull
    public static List<GotoRelatedItem> collectRelatedItems(@NotNull PsiElement contextElement, @Nullable DataContext dataContext) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInsight/navigation/NavigationUtil", "collectRelatedItems"));
        }
        LinkedHashSet items = ContainerUtil.newLinkedHashSet();
        for (GotoRelatedProvider provider : (GotoRelatedProvider[])Extensions.getExtensions((ExtensionPointName)GotoRelatedProvider.EP_NAME)) {
            items.addAll(provider.getItems(contextElement));
            if (dataContext == null) continue;
            items.addAll(provider.getItems(dataContext));
        }
        GotoRelatedItem[] result = items.toArray(new GotoRelatedItem[items.size()]);
        Arrays.sort(result, new Comparator<GotoRelatedItem>(){

            @Override
            public int compare(GotoRelatedItem i1, GotoRelatedItem i2) {
                String o1 = i1.getGroup();
                String o2 = i2.getGroup();
                return StringUtil.isEmpty((String)o1) ? 1 : (StringUtil.isEmpty((String)o2) ? -1 : o1.compareTo(o2));
            }
        });
        List<GotoRelatedItem> list = Arrays.asList(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "collectRelatedItems"));
        }
        return list;
    }
}

