/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class HKey {
    @NotNull
    final byte[] key;
    final int dirKey;
    final boolean stable;

    HKey(@NotNull byte[] key, int dirKey, boolean stable) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/HKey", "<init>"));
        }
        this.key = key;
        this.dirKey = dirKey;
        this.stable = stable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HKey hKey = (HKey)o;
        if (this.dirKey != hKey.dirKey) {
            return false;
        }
        if (this.stable != hKey.stable) {
            return false;
        }
        return Arrays.equals(this.key, hKey.key);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.key);
        result = 31 * result + this.dirKey;
        result = 31 * result + (this.stable ? 1 : 0);
        return result;
    }

    HKey negate() {
        return new HKey(this.key, this.dirKey, !this.stable);
    }

    HKey mkStable() {
        return this.stable ? this : new HKey(this.key, this.dirKey, true);
    }

    HKey mkUnstable() {
        return this.stable ? new HKey(this.key, this.dirKey, false) : this;
    }

    public HKey mkBase() {
        return this.dirKey == 0 ? this : new HKey(this.key, 0, this.stable);
    }

    HKey updateDirection(int newDirKey) {
        return new HKey(this.key, newDirKey, this.stable);
    }
}

