/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityEditorDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JList myOptionsList;
    private final ColorAndFontDescriptionPanel myOptionsPanel;
    private SeverityRegistrar.SeverityBasedTextAttributes myCurrentSelection;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.SeverityEditorDialog");
    private final SeverityRegistrar mySeverityRegistrar;
    private final boolean myCloseDialogWhenSettingsShown;
    private final CardLayout myCard;
    private final JPanel myRightPanel;
    @NonNls
    private static final String DEFAULT = "DEFAULT";
    @NonNls
    private static final String EDITABLE = "EDITABLE";

    public SeverityEditorDialog(JComponent parent, @Nullable HighlightSeverity selectedSeverity, @NotNull SeverityRegistrar severityRegistrar, boolean closeDialogWhenSettingsShown) {
        if (severityRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityRegistrar", "com/intellij/codeInspection/ex/SeverityEditorDialog", "<init>"));
        }
        super((Component)parent, true);
        this.myOptionsList = new JBList();
        this.myOptionsPanel = new ColorAndFontDescriptionPanel();
        this.mySeverityRegistrar = severityRegistrar;
        this.myCloseDialogWhenSettingsShown = closeDialogWhenSettingsShown;
        this.myOptionsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof SeverityRegistrar.SeverityBasedTextAttributes) {
                    this.setText(((SeverityRegistrar.SeverityBasedTextAttributes)value).getSeverity().getName());
                }
                return rendererComponent;
            }
        });
        this.myOptionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SeverityEditorDialog.this.myCurrentSelection != null) {
                    SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
                }
                SeverityEditorDialog.this.myCurrentSelection = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue();
                if (SeverityEditorDialog.this.myCurrentSelection != null) {
                    SeverityEditorDialog.this.reset(SeverityEditorDialog.this.myCurrentSelection);
                    SeverityEditorDialog.this.myCard.show(SeverityEditorDialog.this.myRightPanel, SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(SeverityEditorDialog.this.myCurrentSelection.getSeverity()) ? SeverityEditorDialog.DEFAULT : SeverityEditorDialog.EDITABLE);
                }
            }
        });
        this.myOptionsList.setSelectionMode(0);
        JPanel leftPanel = ToolbarDecorator.createDecorator((JList)this.myOptionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String name = Messages.showInputDialog((Component)SeverityEditorDialog.this.myPanel, (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.name.label", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"highlight.severity.create.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

                    public boolean checkInput(String inputString) {
                        ListModel listModel = SeverityEditorDialog.this.myOptionsList.getModel();
                        for (int i = 0; i < listModel.getSize(); ++i) {
                            String severityName = ((SeverityRegistrar.SeverityBasedTextAttributes)listModel.getElementAt((int)i)).getSeverity().myName;
                            if (!Comparing.strEqual((String)severityName, (String)inputString)) continue;
                            return false;
                        }
                        return true;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (name == null) {
                    return;
                }
                TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(name, 50), TextAttributesKey.createTextAttributesKey((String)name));
                SeverityRegistrar.SeverityBasedTextAttributes newSeverityBasedTextAttributes = new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info);
                ((DefaultListModel)SeverityEditorDialog.this.myOptionsList.getModel()).addElement(newSeverityBasedTextAttributes);
                SeverityEditorDialog.this.myOptionsList.clearSelection();
                ListScrollingUtil.selectItem((JList)SeverityEditorDialog.this.myOptionsList, (Object)newSeverityBasedTextAttributes);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
                ListUtil.moveSelectedItemsUp((JList)SeverityEditorDialog.this.myOptionsList);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SeverityEditorDialog.this.apply(SeverityEditorDialog.this.myCurrentSelection);
                ListUtil.moveSelectedItemsDown((JList)SeverityEditorDialog.this.myOptionsList);
            }
        }).createPanel();
        ToolbarDecorator.findRemoveButton((JComponent)leftPanel).addCustomUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(((SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue()).getSeverity());
            }
        });
        ToolbarDecorator.findUpButton((JComponent)leftPanel).addCustomUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                SeverityRegistrar.SeverityBasedTextAttributes pair;
                boolean canMove = ListUtil.canMoveSelectedItemsUp((JList)SeverityEditorDialog.this.myOptionsList);
                if (canMove && (pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue()) != null && SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                    int newPosition = SeverityEditorDialog.this.myOptionsList.getSelectedIndex() - 1;
                    pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getModel().getElementAt(newPosition);
                    if (SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                        canMove = false;
                    }
                }
                return canMove;
            }
        });
        ToolbarDecorator.findDownButton((JComponent)leftPanel).addCustomUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                SeverityRegistrar.SeverityBasedTextAttributes pair;
                boolean canMove = ListUtil.canMoveSelectedItemsDown((JList)SeverityEditorDialog.this.myOptionsList);
                if (canMove && (pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getSelectedValue()) != null && SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                    int newPosition = SeverityEditorDialog.this.myOptionsList.getSelectedIndex() + 1;
                    pair = (SeverityRegistrar.SeverityBasedTextAttributes)SeverityEditorDialog.this.myOptionsList.getModel().getElementAt(newPosition);
                    if (SeverityEditorDialog.this.mySeverityRegistrar.isDefaultSeverity(pair.getSeverity())) {
                        canMove = false;
                    }
                }
                return canMove;
            }
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)leftPanel, "Center");
        this.myCard = new CardLayout();
        this.myRightPanel = new JPanel(this.myCard);
        JPanel disabled = new JPanel(new GridBagLayout());
        JButton button = new JButton(InspectionsBundle.message((String)"severities.default.settings.message", (Object[])new Object[0]));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeverityEditorDialog.this.editColorsAndFonts();
            }
        });
        disabled.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myRightPanel.add(DEFAULT, disabled);
        this.myRightPanel.add(EDITABLE, this.myOptionsPanel);
        this.myCard.show(this.myRightPanel, EDITABLE);
        this.myPanel.add((Component)this.myRightPanel, "East");
        this.fillList(selectedSeverity);
        this.init();
        this.setTitle(InspectionsBundle.message((String)"severities.editor.dialog.title", (Object[])new Object[0]));
        this.reset((SeverityRegistrar.SeverityBasedTextAttributes)this.myOptionsList.getSelectedValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editColorsAndFonts() {
        final String toConfigure = this.getSelectedType().getSeverity(null).myName;
        if (this.myCloseDialogWhenSettingsShown) {
            this.doOKAction();
        }
        this.myOptionsList.clearSelection();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel);
        Settings settings = (Settings)Settings.KEY.getData(dataContext);
        if (settings != null) {
            ColorAndFontOptions colorAndFontOptions = settings.find(ColorAndFontOptions.class);
            assert (colorAndFontOptions != null);
            final SearchableConfigurable javaPage = colorAndFontOptions.findSubConfigurable(InspectionColorSettingsPage.class);
            LOG.assertTrue(javaPage != null);
            settings.select((Configurable)javaPage).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    Runnable runnable = javaPage.enableSearch(toConfigure);
                    if (runnable != null) {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            });
        } else {
            ColorAndFontOptions colorAndFontOptions = new ColorAndFontOptions();
            Configurable[] configurables = colorAndFontOptions.buildConfigurables();
            try {
                SearchableConfigurable javaPage = colorAndFontOptions.findSubConfigurable(InspectionColorSettingsPage.class);
                LOG.assertTrue(javaPage != null);
                ShowSettingsUtil.getInstance().editConfigurable((Project)CommonDataKeys.PROJECT.getData(dataContext), (Configurable)javaPage);
            }
            finally {
                for (Configurable configurable : configurables) {
                    configurable.disposeUIResources();
                }
                colorAndFontOptions.disposeUIResources();
            }
        }
    }

    private void fillList(@Nullable HighlightSeverity severity) {
        DefaultListModel<SeverityRegistrar.SeverityBasedTextAttributes> model = new DefaultListModel<SeverityRegistrar.SeverityBasedTextAttributes>();
        model.removeAllElements();
        ArrayList<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = new ArrayList<SeverityRegistrar.SeverityBasedTextAttributes>();
        infoTypes.addAll(SeverityUtil.getRegisteredHighlightingInfoTypes(this.mySeverityRegistrar));
        Collections.sort(infoTypes, new Comparator<SeverityRegistrar.SeverityBasedTextAttributes>(){

            @Override
            public int compare(SeverityRegistrar.SeverityBasedTextAttributes attributes1, SeverityRegistrar.SeverityBasedTextAttributes attributes2) {
                return -SeverityEditorDialog.this.mySeverityRegistrar.compare(attributes1.getSeverity(), attributes2.getSeverity());
            }
        });
        SeverityRegistrar.SeverityBasedTextAttributes preselection = null;
        for (SeverityRegistrar.SeverityBasedTextAttributes type : infoTypes) {
            model.addElement(type);
            if (!type.getSeverity().equals((Object)severity)) continue;
            preselection = type;
        }
        if (preselection == null && !infoTypes.isEmpty()) {
            preselection = (SeverityRegistrar.SeverityBasedTextAttributes)infoTypes.get(0);
        }
        this.myOptionsList.setModel(model);
        this.myOptionsList.setSelectedValue(preselection, true);
    }

    private void apply(SeverityRegistrar.SeverityBasedTextAttributes info) {
        if (info == null) {
            return;
        }
        MyTextAttributesDescription description = new MyTextAttributesDescription(info.getType().toString(), null, new TextAttributes(), info.getType().getAttributesKey());
        this.myOptionsPanel.apply(description, null);
        Element textAttributes = new Element("temp");
        try {
            description.getTextAttributes().writeExternal(textAttributes);
            info.getAttributes().readExternal(textAttributes);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void reset(SeverityRegistrar.SeverityBasedTextAttributes info) {
        if (info == null) {
            return;
        }
        MyTextAttributesDescription description = new MyTextAttributesDescription(info.getType().toString(), null, info.getAttributes(), info.getType().getAttributesKey());
        Element textAttributes = new Element("temp");
        try {
            info.getAttributes().writeExternal(textAttributes);
            description.getTextAttributes().readExternal(textAttributes);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        this.myOptionsPanel.reset(description);
    }

    protected void doOKAction() {
        this.apply((SeverityRegistrar.SeverityBasedTextAttributes)this.myOptionsList.getSelectedValue());
        HashSet<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = new HashSet<SeverityRegistrar.SeverityBasedTextAttributes>(SeverityUtil.getRegisteredHighlightingInfoTypes(this.mySeverityRegistrar));
        ListModel listModel = this.myOptionsList.getModel();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>();
        for (int i = listModel.getSize() - 1; i >= 0; --i) {
            boolean exists;
            SeverityRegistrar.SeverityBasedTextAttributes info = (SeverityRegistrar.SeverityBasedTextAttributes)listModel.getElementAt(i);
            order.add(info.getSeverity());
            if (this.mySeverityRegistrar.isDefaultSeverity(info.getSeverity())) continue;
            infoTypes.remove(info);
            Color stripeColor = info.getAttributes().getErrorStripeColor();
            boolean bl = exists = this.mySeverityRegistrar.getSeverity(info.getSeverity().getName()) != null;
            if (exists) {
                info.getType().getAttributesKey().getDefaultAttributes().setErrorStripeColor(stripeColor);
            } else {
                HighlightInfoType.HighlightInfoTypeImpl type = info.getType();
                TextAttributesKey key = type.getAttributesKey();
                TextAttributes defaultAttributes = key.getDefaultAttributes().clone();
                defaultAttributes.setErrorStripeColor(stripeColor);
                key = TextAttributesKey.createTextAttributesKey((String)key.getExternalName(), (TextAttributes)defaultAttributes);
                type = new HighlightInfoType.HighlightInfoTypeImpl(type.getSeverity(null), key);
                info = new SeverityRegistrar.SeverityBasedTextAttributes(info.getAttributes(), type);
            }
            this.mySeverityRegistrar.registerSeverity(info, stripeColor != null ? stripeColor : LightColors.YELLOW);
        }
        for (SeverityRegistrar.SeverityBasedTextAttributes info : infoTypes) {
            this.mySeverityRegistrar.unregisterSeverity(info.getSeverity());
        }
        this.mySeverityRegistrar.setOrder(order);
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public HighlightInfoType getSelectedType() {
        SeverityRegistrar.SeverityBasedTextAttributes selection = (SeverityRegistrar.SeverityBasedTextAttributes)this.myOptionsList.getSelectedValue();
        return selection != null ? selection.getType() : null;
    }

    private static class MyTextAttributesDescription
    extends TextAttributesDescription {
        public MyTextAttributesDescription(String name, String group, TextAttributes attributes, TextAttributesKey type) {
            super(name, group, attributes, type, null, null, null);
        }

        @Override
        public void apply(EditorColorsScheme scheme) {
        }

        @Override
        public boolean isErrorStripeEnabled() {
            return true;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return super.getTextAttributes();
        }
    }
}

