/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInspection.inferNullity.AnnotateTask;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.TitledSeparator;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InferNullityAnnotationsAction
extends BaseAnalysisAction {
    @NonNls
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    @NonNls
    private static final String ANNOTATE_LOCAL_VARIABLES = "annotate.local.variables";
    private JCheckBox myAnnotateLocalVariablesCb;

    public InferNullityAnnotationsAction() {
        super("Infer Nullity", INFER_NULLITY_ANNOTATIONS);
    }

    @Override
    protected void analyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "analyze"));
        }
        PropertiesComponent.getInstance().setValue(ANNOTATE_LOCAL_VARIABLES, String.valueOf(this.myAnnotateLocalVariablesCb.isSelected()));
        ProgressManager progressManager = ProgressManager.getInstance();
        final HashSet modulesWithoutAnnotations = new HashSet();
        final HashSet modulesWithLL = new HashSet();
        final JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        final String defaultNullable = NullableNotNullManager.getInstance((Project)project).getDefaultNullable();
        final int[] fileCount = new int[]{0};
        if (!progressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                scope.accept(new PsiElementVisitor(){
                    private final Set<Module> processed = new HashSet<Module>();

                    public void visitFile(PsiFile file) {
                        Module module;
                        fileCount[0] = fileCount[0] + 1;
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            VirtualFile virtualFile = file.getVirtualFile();
                            if (virtualFile != null) {
                                progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                            }
                            progressIndicator.setText(AnalysisScopeBundle.message((String)"scanning.scope.progress.title", (Object[])new Object[0]));
                        }
                        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null && this.processed.add(module)) {
                            if (PsiUtil.getLanguageLevel((PsiElement)file).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                                modulesWithLL.add(module);
                            } else if (javaPsiFacade.findClass(defaultNullable, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) == null) {
                                modulesWithoutAnnotations.add(module);
                            }
                        }
                    }
                });
            }
        }, "Check Applicability...", true, project)) {
            return;
        }
        if (!modulesWithLL.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)"Infer Nullity Annotations requires the project language level be set to 1.5 or greater.", (String)INFER_NULLITY_ANNOTATIONS);
            return;
        }
        if (!modulesWithoutAnnotations.isEmpty()) {
            final Library annotationsLib = LibraryUtil.findLibraryByClass((String)defaultNullable, (Project)project);
            if (annotationsLib != null) {
                String message = "Module" + (modulesWithoutAnnotations.size() == 1 ? " " : "s ");
                message = message + StringUtil.join(modulesWithoutAnnotations, (Function)new Function<Module, String>(){

                    public String fun(Module module) {
                        return module.getName();
                    }
                }, (String)", ");
                message = message + (modulesWithoutAnnotations.size() == 1 ? " doesn't" : " don't");
                message = message + " refer to the existing '" + annotationsLib.getName() + "' library with IDEA nullity annotations. Would you like to add the dependenc";
                if (Messages.showOkCancelDialog((Project)project, (String)(message = message + (modulesWithoutAnnotations.size() == 1 ? "y" : "ies") + " now?"), (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            for (Module module : modulesWithoutAnnotations) {
                                ModuleRootModificationUtil.addDependency((Module)module, (Library)annotationsLib);
                            }
                        }
                    });
                    this.restartAnalysis(project, scope);
                }
            } else if (Messages.showOkCancelDialog((Project)project, (String)"Infer Nullity Annotations requires that the nullity annotations be available in all your project sources.\n\nYou will need to add annotations.jar as a library. It is possible to configure custom JAR in e.g. Constant Conditions & Exceptions inspection or use JetBrains annotations available in installation.  IntelliJ IDEA nullity annotations are freely usable and redistributable under the Apache 2.0 license. Would you like to do it now?", (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final String path = OrderEntryFix.locateAnnotationsJar((Module)modulesWithoutAnnotations.iterator().next());
                        if (path != null) {
                            new WriteCommandAction(project, new PsiFile[0]){

                                protected void run(@NotNull Result result) throws Throwable {
                                    if (result == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction$4$1", "run"));
                                    }
                                    for (Module module : modulesWithoutAnnotations) {
                                        OrderEntryFix.addBundledJarToRoots(project, null, module, null, "org.jetbrains.annotations.NotNull", path);
                                    }
                                }
                            }.execute();
                            InferNullityAnnotationsAction.this.restartAnalysis(project, scope);
                        }
                    }
                });
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final UsageInfo[] usageInfos = this.findUsages(project, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        if (usageInfos.length < 5) {
            SwingUtilities.invokeLater(InferNullityAnnotationsAction.applyRunnable(project, new Computable<UsageInfo[]>(){

                public UsageInfo[] compute() {
                    return usageInfos;
                }
            }));
        } else {
            this.showUsageView(project, usageInfos, scope);
        }
    }

    private UsageInfo[] findUsages(final @NotNull Project project, final @NotNull AnalysisScope scope, final int fileCount) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "findUsages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "findUsages"));
        }
        final NullityInferrer inferrer = new NullityInferrer(this.myAnnotateLocalVariablesCb.isSelected(), project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        Runnable searchForUsages = new Runnable(){

            @Override
            public void run() {
                scope.accept(new PsiElementVisitor(){
                    int myFileCount = 0;

                    public void visitFile(PsiFile file) {
                        Document document;
                        ++this.myFileCount;
                        VirtualFile virtualFile = file.getVirtualFile();
                        FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                        Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                        if (document == null || virtualFile.getFileType().isBinary()) {
                            return;
                        }
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                            progressIndicator.setFraction((double)this.myFileCount / (double)fileCount);
                        }
                        if (file instanceof PsiJavaFile) {
                            inferrer.collect(file);
                        }
                    }
                });
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(searchForUsages, INFER_NULLITY_ANNOTATIONS, true, project)) {
                return null;
            }
        } else {
            searchForUsages.run();
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        inferrer.collect(usages);
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    private static Runnable applyRunnable(final Project project, final Computable<UsageInfo[]> computable) {
        return new Runnable(){

            @Override
            public void run() {
                LocalHistoryAction action = LocalHistory.getInstance().startAction(InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS);
                try {
                    new WriteCommandAction(project, InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction$7$1", "run"));
                            }
                            UsageInfo[] infos = (UsageInfo[])computable.compute();
                            if (infos.length > 0) {
                                LinkedHashSet elements = new LinkedHashSet();
                                for (UsageInfo info : infos) {
                                    PsiElement element = info.getElement();
                                    if (element == null) continue;
                                    ContainerUtil.addIfNotNull(elements, (Object)element.getContainingFile());
                                }
                                if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                    return;
                                }
                                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS, false);
                                progressTask.setMinIterationTime(200L);
                                progressTask.setTask(new AnnotateTask(project, progressTask, infos));
                                ProgressManager.getInstance().run((Task)progressTask);
                            } else {
                                NullityInferrer.nothingFoundMessage(project);
                            }
                        }
                    }.execute();
                }
                finally {
                    action.finish();
                }
            }
        };
    }

    private void restartAnalysis(final Project project, final AnalysisScope scope) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                InferNullityAnnotationsAction.this.analyze(project, scope);
            }
        });
    }

    private void showUsageView(@NotNull Project project, final UsageInfo[] usageInfos, @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "showUsageView"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "showUsageView"));
        }
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        final Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos));
                    }
                });
            }
        }, "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        final UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, this.rerunFactory(project, scope));
        Runnable refactoringRunnable = InferNullityAnnotationsAction.applyRunnable(project, new Computable<UsageInfo[]>(){

            public UsageInfo[] compute() {
                Set<UsageInfo> infos = UsageViewUtil.getNotExcludedUsageInfos(usageView);
                return infos.toArray(new UsageInfo[infos.size()]);
            }
        });
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "rerunFactory"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "rerunFactory"));
        }
        Factory<UsageSearcher> factory = new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new UsageInfoSearcherAdapter(){

                    protected UsageInfo[] findUsages() {
                        return InferNullityAnnotationsAction.this.findUsages(project, scope, scope.getFileCount());
                    }

                    public void generate(@NotNull Processor<Usage> processor) {
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction$11$1", "generate"));
                        }
                        this.processUsages(processor, project);
                    }
                };
            }
        };
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "rerunFactory"));
        }
        return factory;
    }

    @Override
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new TitledSeparator());
        this.myAnnotateLocalVariablesCb = new JCheckBox("Annotate local variables", PropertiesComponent.getInstance().getBoolean(ANNOTATE_LOCAL_VARIABLES, false));
        panel.add(this.myAnnotateLocalVariablesCb);
        return panel;
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myAnnotateLocalVariablesCb = null;
    }
}

