/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.java18StreamApi.StaticPseudoFunctionalStyleMethodOptions;
import com.intellij.codeInspection.java18StreamApi.StreamApiConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.ClassNameReferenceEditor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMethodsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddMethodsDialog.class);
    @NotNull
    private final Project myProject;
    private JPanel myPanel;
    private ComboBox myPatternsCombo;
    private ClassNameReferenceEditor myClassNameEditor;
    private ComboBox myMethodNameCombo;

    protected AddMethodsDialog(final @NotNull Project project, @NotNull Component parent, boolean canBeParent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18StreamApi/AddMethodsDialog", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInspection/java18StreamApi/AddMethodsDialog", "<init>"));
        }
        super(parent, canBeParent);
        this.myProject = project;
        this.$$$setupUI$$$();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        this.myPatternsCombo.setModel(model);
        for (String methodName : (Set)StreamApiConstants.STREAM_STREAM_API_METHODS.getValue()) {
            model.addElement(methodName);
        }
        model.addElement("#findMatched");
        this.myPatternsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(JList list, String methodName, int index, boolean selected, boolean hasFocus) {
                this.append("stream.");
                if (((Set)StreamApiConstants.STREAM_STREAM_API_METHODS.getValue()).contains(methodName)) {
                    this.append(methodName + "()", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    LOG.assertTrue("#findMatched".equals(methodName));
                    this.append(String.format("filter(%s).findFirst().get()", "condition"), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    this.append(" or ");
                    this.append(String.format("filter(%s).findFirst().orElseGet(() -> %s)", "condition", "defaultValue"), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        });
        this.myMethodNameCombo.setModel(new DefaultComboBoxModel());
        this.myClassNameEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                String classFqn = e.getDocument().getText();
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(classFqn, GlobalSearchScope.allScope((Project)project));
                DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)AddMethodsDialog.this.myMethodNameCombo.getModel();
                comboBoxModel.removeAllElements();
                if (aClass == null) {
                    AddMethodsDialog.this.myMethodNameCombo.setEnabled(false);
                } else {
                    for (String name : ContainerUtil.newTreeSet((Iterable)ContainerUtil.mapNotNull((Object[])aClass.getMethods(), (Function)new Function<PsiMethod, String>(){

                        public String fun(PsiMethod method) {
                            if (method.isConstructor() || !method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                                return null;
                            }
                            return method.getName();
                        }
                    }))) {
                        comboBoxModel.addElement(name);
                    }
                    AddMethodsDialog.this.myMethodNameCombo.setEnabled(true);
                }
            }
        });
        this.init();
    }

    private void createUIComponents() {
        this.myClassNameEditor = new ClassNameReferenceEditor(this.myProject, null);
    }

    public StaticPseudoFunctionalStyleMethodOptions.PipelineElement getSelectedElement() {
        return new StaticPseudoFunctionalStyleMethodOptions.PipelineElement(this.myClassNameEditor.getText(), (String)this.myMethodNameCombo.getSelectedItem(), (String)this.myPatternsCombo.getSelectedItem());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameEditor;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Fully qualified class name:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Method name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Stream API replacement:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myPatternsCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        ClassNameReferenceEditor classNameReferenceEditor = this.myClassNameEditor;
        jPanel.add((Component)((Object)classNameReferenceEditor), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myMethodNameCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

