/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.impl.java.JavacCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacManager;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    private final EvaluationContextImpl myEvaluationContext;
    private static final Key<ExternalJavacManager> JAVAC_MANAGER_KEY = Key.create((String)"_external_java_compiler_manager_");

    public CompilingEvaluatorImpl(EvaluationContextImpl evaluationContext, @NotNull PsiElement context, @NotNull ExtractLightMethodObjectHandler.ExtractedData data) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "<init>"));
        }
        super(context, data);
        this.myEvaluationContext = evaluationContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected Collection<OutputFileObject> compile(@Nullable JavaSdkVersion debuggeeVersion) throws EvaluateException {
        OutputCollector outputSink;
        block15: {
            JavaSdkVersion buildRuntimeVersion;
            Pair<Sdk, JavaSdkVersion> runtime = BuildManager.getBuildProcessRuntimeSdk(this.myEvaluationContext.getProject());
            Module module = (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

                public Module compute() {
                    return ModuleUtilCore.findModuleForPsiElement((PsiElement)CompilingEvaluatorImpl.this.myPsiContext);
                }
            });
            String javaHome = null;
            Sdk sdk = (Sdk)runtime.getFirst();
            SdkTypeId type = sdk.getSdkType();
            if (type instanceof JavaSdkType) {
                javaHome = sdk.getHomePath();
            }
            if (javaHome == null) {
                throw new EvaluateException("Was not able to determine JDK for current evaluation context");
            }
            ArrayList<String> options = new ArrayList<String>();
            options.add("-proc:none");
            options.add("-encoding");
            options.add("UTF-8");
            ArrayList platformClasspath = new ArrayList();
            ArrayList classpath = new ArrayList();
            if (module != null) {
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                rootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().addAllFiles(classpath);
                rootManager.orderEntries().compileOnly().sdkOnly().getPathsList().addAllFiles(platformClasspath);
            }
            if ((buildRuntimeVersion = (JavaSdkVersion)runtime.getSecond()) != null && debuggeeVersion != null) {
                JavaSdkVersion minVersion = buildRuntimeVersion.ordinal() > debuggeeVersion.ordinal() ? debuggeeVersion : buildRuntimeVersion;
                String sourceOption = CompilingEvaluatorImpl.getSourceOption(minVersion.getMaxLanguageLevel());
                options.add("-source");
                options.add(sourceOption);
                options.add("-target");
                options.add(sourceOption);
            }
            File sourceFile = null;
            outputSink = new OutputCollector();
            try {
                Set<File> sources;
                List sourcePath;
                ExternalJavacManager javacManager = this.getJavacManager();
                if (javacManager == null) {
                    throw new EvaluateException("Cannot compile java code");
                }
                sourceFile = this.generateTempSourceFile(javacManager.getWorkingDir());
                File srcDir = sourceFile.getParentFile();
                Map<File, Set<File>> output = Collections.singletonMap(srcDir, Collections.singleton(srcDir));
                DiagnosticCollector diagnostic = new DiagnosticCollector();
                List vmOptions = Collections.emptyList();
                boolean compiledOK = javacManager.forkJavac(javaHome, -1, vmOptions, options, platformClasspath, classpath, sourcePath = Collections.emptyList(), sources = Collections.singleton(sourceFile), output, (DiagnosticOutputConsumer)diagnostic, (OutputFileConsumer)outputSink, (JavaCompilingTool)new JavacCompilerTool(), CanceledStatus.NULL);
                if (!compiledOK) {
                    StringBuilder res = new StringBuilder("Compilation failed:\n");
                    Iterator<Diagnostic<? extends JavaFileObject>> iterator = diagnostic.getDiagnostics().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw new EvaluateException(res.toString());
                        }
                        Diagnostic<? extends JavaFileObject> d = iterator.next();
                        if (d.getKind() != Diagnostic.Kind.ERROR) continue;
                        res.append(d.getMessage(Locale.US));
                    }
                }
                if (sourceFile == null) break block15;
            }
            catch (EvaluateException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new EvaluateException(e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (sourceFile != null) {
                        FileUtil.delete(sourceFile);
                    }
                    throw throwable;
                }
            }
            FileUtil.delete((File)sourceFile);
        }
        List<OutputFileObject> list = outputSink.getCompiledClasses();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "compile"));
        }
        return list;
    }

    @NotNull
    private static String getSourceOption(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "getSourceOption"));
        }
        String string = "1." + Integer.valueOf(3 + languageLevel.ordinal());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl", "getSourceOption"));
        }
        return string;
    }

    private File generateTempSourceFile(File workingDir) throws IOException {
        Pair fileData = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<String, String>>(){

            public Pair<String, String> compute() {
                PsiFile file = CompilingEvaluatorImpl.this.myData.getGeneratedInnerClass().getContainingFile();
                return Pair.create((Object)file.getName(), (Object)file.getText());
            }
        });
        if (fileData.first == null) {
            throw new IOException("Class file name not specified");
        }
        if (fileData.second == null) {
            throw new IOException("Class source code not specified");
        }
        File file = new File(workingDir, "src/" + (String)fileData.first);
        FileUtil.writeToFile((File)file, (String)((String)fileData.second));
        return file;
    }

    @Nullable
    private ExternalJavacManager getJavacManager() throws IOException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        final DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        ExternalJavacManager manager = (ExternalJavacManager)JAVAC_MANAGER_KEY.get((UserDataHolder)debugProcess);
        if (manager == null && debugProcess.isAttached()) {
            File compilerWorkingDir = this.getCompilerWorkingDir();
            if (compilerWorkingDir == null) {
                return null;
            }
            int listenPort = NetUtils.findAvailableSocketPort();
            manager = new ExternalJavacManager(compilerWorkingDir);
            manager.start(listenPort);
            final ExternalJavacManager _manager = manager;
            debugProcess.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapter(){

                public void processDetached(DebugProcess process, boolean closedByUser) {
                    if (process == debugProcess) {
                        _manager.stop();
                    }
                }
            });
            JAVAC_MANAGER_KEY.set((UserDataHolder)debugProcess, (Object)manager);
        }
        return manager;
    }

    @Nullable
    private File getCompilerWorkingDir() {
        File projectBuildDir = BuildManager.getInstance().getProjectSystemDirectory(this.myEvaluationContext.getProject());
        if (projectBuildDir == null) {
            return null;
        }
        File root = new File(projectBuildDir, "debugger");
        root.mkdirs();
        return root;
    }

    private static class OutputCollector
    implements OutputFileConsumer {
        private List<OutputFileObject> myClasses = new ArrayList<OutputFileObject>();

        private OutputCollector() {
        }

        public void save(@NotNull OutputFileObject fileObject) {
            if (fileObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl$OutputCollector", "save"));
            }
            this.myClasses.add(fileObject);
        }

        public List<OutputFileObject> getCompiledClasses() {
            return this.myClasses;
        }
    }

    private static class DiagnosticCollector
    implements DiagnosticOutputConsumer {
        private final List<Diagnostic<? extends JavaFileObject>> myDiagnostics = new ArrayList<Diagnostic<? extends JavaFileObject>>();

        private DiagnosticCollector() {
        }

        public void outputLineAvailable(String line) {
        }

        public void registerImports(String className, Collection<String> imports, Collection<String> staticImports) {
        }

        public void javaFileLoaded(File file) {
        }

        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.myDiagnostics.add(diagnostic);
        }

        public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
            return this.myDiagnostics;
        }
    }
}

