/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.TestSuiteStack;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GeneralToSMTRunnerEventsConvertor.class.getName());
    private final Map<String, SMTestProxy> myRunningTestsFullNameToProxy;
    private final Set<AbstractTestProxy> myFailedTestsSet;
    private final TestSuiteStack mySuitesStack;
    private final List<SMTRunnerEventsListener> myEventsListeners;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator;
    private boolean myTreeBuildBeforeStart;

    public GeneralToSMTRunnerEventsConvertor(@NotNull SMTestProxy.SMRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        if (testsRootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRootNode", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "<init>"));
        }
        this.myRunningTestsFullNameToProxy = new HashMap<String, SMTestProxy>();
        this.myFailedTestsSet = new HashSet<AbstractTestProxy>();
        this.mySuitesStack = new TestSuiteStack();
        this.myEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLocator = null;
        this.myTreeBuildBeforeStart = false;
        this.myTestsRootNode = testsRootNode;
        this.myTestFrameworkName = testFrameworkName;
    }

    @Override
    public void setLocator(@NotNull SMTestLocator locator) {
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "setLocator"));
        }
        this.myLocator = locator;
    }

    @Override
    public void addEventsListener(@NotNull SMTRunnerEventsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "addEventsListener"));
        }
        this.myEventsListeners.add(listener);
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.pushSuite(GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode);
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setStarted();
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestingStarted();
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setTestsReporterAttached();
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GeneralToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GeneralToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                if (!GeneralTestEventsProcessor.isTreeComplete(GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.keySet(), GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode)) {
                    GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setTerminated();
                    GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                }
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.clear();
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setFinished();
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }
        });
        this.stopEventProcessing();
    }

    @Override
    public void onRootPresentationAdded(final String rootName, final String comment, final String rootLocation) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setPresentation(rootName);
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setComment(comment);
                GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setRootLocationUrl(rootLocation);
                if (GeneralToSMTRunnerEventsConvertor.this.myLocator != null) {
                    GeneralToSMTRunnerEventsConvertor.this.myTestsRootNode.setLocator(GeneralToSMTRunnerEventsConvertor.this.myLocator);
                }
            }
        });
    }

    @Override
    public void onSuiteTreeNodeAdded(final String testName, final String locationHint) {
        this.myTreeBuildBeforeStart = true;
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy testProxy = new SMTestProxy(testName, false, locationHint);
                if (GeneralToSMTRunnerEventsConvertor.this.myLocator != null) {
                    testProxy.setLocator(GeneralToSMTRunnerEventsConvertor.this.myLocator);
                }
                GeneralToSMTRunnerEventsConvertor.this.getCurrentSuite().addChild(testProxy);
                GeneralToSMTRunnerEventsConvertor.this.fireOnSuiteTreeNodeAdded(testProxy);
            }
        });
    }

    @Override
    public void onSuiteTreeStarted(final String suiteName, final String locationHint) {
        this.myTreeBuildBeforeStart = true;
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy parentSuite = GeneralToSMTRunnerEventsConvertor.this.getCurrentSuite();
                SMTestProxy newSuite = new SMTestProxy(suiteName, true, locationHint);
                if (GeneralToSMTRunnerEventsConvertor.this.myLocator != null) {
                    newSuite.setLocator(GeneralToSMTRunnerEventsConvertor.this.myLocator);
                }
                parentSuite.addChild(newSuite);
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.pushSuite(newSuite);
                GeneralToSMTRunnerEventsConvertor.this.fireOnSuiteTreeStarted(newSuite);
            }
        });
    }

    @Override
    public void onSuiteTreeEnded(final String suiteName) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.popSuite(suiteName);
            }
        });
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printerProvider", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "setPrinterProvider"));
        }
    }

    @Override
    public void onTestStarted(final @NotNull TestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onTestStarted"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy parentSuite;
                SMTestProxy testProxy;
                String testName = testStartedEvent.getName();
                String locationUrl = testStartedEvent.getLocationUrl();
                boolean isConfig = testStartedEvent.isConfig();
                String fullName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                if (GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test [" + fullName + "] has been already started");
                    if (SMTestRunnerConnectionUtil.isInDebugMode()) {
                        return;
                    }
                }
                if ((testProxy = GeneralToSMTRunnerEventsConvertor.this.findChildByName(parentSuite = GeneralToSMTRunnerEventsConvertor.this.getCurrentSuite(), fullName)) == null) {
                    testProxy = new SMTestProxy(testName, false, locationUrl);
                    testProxy.setConfig(isConfig);
                    if (GeneralToSMTRunnerEventsConvertor.this.myLocator != null) {
                        testProxy.setLocator(GeneralToSMTRunnerEventsConvertor.this.myLocator);
                    }
                    parentSuite.addChild(testProxy);
                }
                GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
                testProxy.setStarted();
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestStarted(testProxy);
            }
        });
    }

    @Override
    public void onSuiteStarted(final @NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteStartedEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onSuiteStarted"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String suiteName = suiteStartedEvent.getName();
                String locationUrl = suiteStartedEvent.getLocationUrl();
                SMTestProxy parentSuite = GeneralToSMTRunnerEventsConvertor.this.getCurrentSuite();
                SMTestProxy newSuite = GeneralToSMTRunnerEventsConvertor.this.findChildByName(parentSuite, suiteName);
                if (newSuite == null) {
                    newSuite = new SMTestProxy(suiteName, true, locationUrl);
                    if (GeneralToSMTRunnerEventsConvertor.this.myLocator != null) {
                        newSuite.setLocator(GeneralToSMTRunnerEventsConvertor.this.myLocator);
                    }
                    parentSuite.addChild(newSuite);
                }
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.pushSuite(newSuite);
                newSuite.setStarted();
                GeneralToSMTRunnerEventsConvertor.this.fireOnSuiteStarted(newSuite);
            }
        });
    }

    private SMTestProxy findChildByName(SMTestProxy parentSuite, String fullName) {
        if (this.myTreeBuildBeforeStart) {
            for (SMTestProxy sMTestProxy : parentSuite.getChildren()) {
                if (!fullName.equals(sMTestProxy.getName()) || sMTestProxy.isFinal()) continue;
                return sMTestProxy;
            }
        }
        return null;
    }

    @Override
    public void onTestFinished(final @NotNull TestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onTestFinished"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String testName = testFinishedEvent.getName();
                long duration = testFinishedEvent.getDuration();
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                testProxy.setDuration(duration);
                testProxy.setFinished();
                GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.remove(fullTestName);
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
            }
        });
    }

    @Override
    public void onSuiteFinished(final @NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteFinishedEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onSuiteFinished"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String suiteName = suiteFinishedEvent.getName();
                SMTestProxy mySuite = GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.popSuite(suiteName);
                if (mySuite != null) {
                    mySuite.setFinished();
                    GeneralToSMTRunnerEventsConvertor.this.fireOnSuiteFinished(mySuite);
                }
            }
        });
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onUncapturedOutput"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy currentProxy = GeneralToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    currentProxy.addStdErr(text);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    currentProxy.addSystemOutput(text);
                } else {
                    currentProxy.addStdOutput(text, outputType);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isCritical) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onError"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                SMTestProxy currentProxy = GeneralToSMTRunnerEventsConvertor.this.findCurrentTestOrSuite();
                currentProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onCustomProgressTestsCategory(final @Nullable String categoryName, final int testCount) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestStarted();
            }
        });
    }

    @Override
    public void onCustomProgressTestFinished() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFinished();
            }
        });
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFailed();
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull TestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailedEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onTestFailure"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String testName = testFailedEvent.getName();
                if (testName == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("No test name specified in " + testFailedEvent);
                    return;
                }
                String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                boolean isTestError = testFailedEvent.isTestError();
                String comparisionFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisionFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                boolean inDebugMode = SMTestRunnerConnectionUtil.isInDebugMode();
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}" + ", message = {" + localizedMessage + "}" + ", stackTrace = {" + stackTrace + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    if (inDebugMode) {
                        return;
                    }
                    if (!GeneralToSMTRunnerEventsConvertor.this.myFailedTestsSet.contains(testProxy)) {
                        GeneralToSMTRunnerEventsConvertor.this.onTestStarted(new TestStartedEvent(testName, null));
                        testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                    }
                }
                if (testProxy == null) {
                    return;
                }
                if (comparisionFailureActualText != null && comparisionFailureExpectedText != null) {
                    if (GeneralToSMTRunnerEventsConvertor.this.myFailedTestsSet.contains(testProxy)) {
                        GeneralToSMTRunnerEventsConvertor.this.logProblem("Duplicate failure for test [" + fullTestName + "]: msg = " + localizedMessage + ", stacktrace = " + stackTrace);
                        if (inDebugMode) {
                            return;
                        }
                    }
                    testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisionFailureActualText, comparisionFailureExpectedText, testFailedEvent.getFilePath());
                } else if (comparisionFailureActualText == null && comparisionFailureExpectedText == null) {
                    testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
                } else {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisionFailureExpectedText + "\n" + "Actual:\n" + comparisionFailureActualText);
                }
                GeneralToSMTRunnerEventsConvertor.this.myFailedTestsSet.add(testProxy);
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull TestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnoredEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onTestIgnored"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String testName = (String)ObjectUtils.assertNotNull((Object)testIgnoredEvent.getName());
                String ignoreComment = testIgnoredEvent.getIgnoreComment();
                if (StringUtil.isEmpty((String)ignoreComment)) {
                    ignoreComment = SMTestsRunnerBundle.message("sm.test.runner.states.test.is.ignored", new Object[0]);
                }
                String stackTrace = testIgnoredEvent.getStacktrace();
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    boolean debugMode = SMTestRunnerConnectionUtil.isInDebugMode();
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, " + "message = {" + ignoreComment + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    if (debugMode) {
                        return;
                    }
                    GeneralToSMTRunnerEventsConvertor.this.onTestStarted(new TestStartedEvent(testName, null));
                    testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                }
                if (testProxy == null) {
                    return;
                }
                testProxy.setTestIgnored(ignoreComment, stackTrace);
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull TestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testOutputEvent", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "onTestOutput"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                String testName = testOutputEvent.getName();
                String text = testOutputEvent.getText();
                boolean stdOut = testOutputEvent.isStdOut();
                String fullTestName = GeneralToSMTRunnerEventsConvertor.this.getFullTestName(testName);
                SMTestProxy testProxy = GeneralToSMTRunnerEventsConvertor.this.getProxyByFullTestName(fullTestName);
                if (testProxy == null) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, " + "isStdOut = " + stdOut + ", " + "text = {" + text + "}. " + GeneralToSMTRunnerEventsConvertor.this.cannotFindFullTestNameMsg(fullTestName));
                    return;
                }
                if (stdOut) {
                    testProxy.addStdOutput(text, ProcessOutputTypes.STDOUT);
                } else {
                    testProxy.addStdErr(text);
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GeneralToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    @NotNull
    protected final SMTestProxy getCurrentSuite() {
        SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
        if (currentSuite != null) {
            SMTestProxy sMTestProxy = currentSuite;
            if (sMTestProxy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "getCurrentSuite"));
            }
            return sMTestProxy;
        }
        this.logProblem("Current suite is undefined. Root suite will be used.");
        SMTestProxy.SMRootTestProxy sMRootTestProxy = this.myTestsRootNode;
        if (sMRootTestProxy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/GeneralToSMTRunnerEventsConvertor", "getCurrentSuite"));
        }
        return sMRootTestProxy;
    }

    protected String getFullTestName(String testName) {
        return testName;
    }

    protected int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    protected Set<AbstractTestProxy> getFailedTestsSet() {
        return Collections.unmodifiableSet(this.myFailedTestsSet);
    }

    @Nullable
    protected SMTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    protected void clearInternalSuitesStack() {
        this.mySuitesStack.clear();
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    private void fireOnTestingStarted() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootNode);
        }
    }

    private void fireOnTestingFinished() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootNode);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteTreeNodeAdded(SMTestProxy testProxy) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onSuiteTreeNodeAdded(testProxy);
        }
    }

    private void fireOnSuiteTreeStarted(SMTestProxy suite) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onSuiteTreeStarted(suite);
        }
    }

    private void fireOnTestStarted(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(SMTestProxy test) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(SMTestProxy suite) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnSuiteFinished(SMTestProxy suite) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onSuiteFinished(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFinished() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFinished();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (SMTRunnerEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GeneralToSMTRunnerEventsConvertor.this.myEventsListeners.clear();
                if (!(GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GeneralToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed! " + GeneralToSMTRunnerEventsConvertor.this.dumpRunningTestsNames());
                }
                GeneralToSMTRunnerEventsConvertor.this.myRunningTestsFullNameToProxy.clear();
                GeneralToSMTRunnerEventsConvertor.this.mySuitesStack.clear();
            }
        });
    }

    private SMTestProxy findCurrentTestOrSuite() {
        SMTestProxy currentProxy = this.myRunningTestsFullNameToProxy.size() == 1 ? this.myRunningTestsFullNameToProxy.values().iterator().next() : (this.mySuitesStack.isEmpty() ? this.myTestsRootNode : this.getCurrentSuite());
        return currentProxy;
    }

    public static String getTFrameworkPrefix(String testFrameworkName) {
        return "[" + testFrameworkName + "]: ";
    }

    private void logProblem(String msg) {
        GeneralToSMTRunnerEventsConvertor.logProblem(LOG, msg, this.myTestFrameworkName);
    }

    public static void logProblem(Logger log, String msg, String testFrameworkName) {
        GeneralToSMTRunnerEventsConvertor.logProblem(log, msg, SMTestRunnerConnectionUtil.isInDebugMode(), testFrameworkName);
    }

    public static void logProblem(Logger log, String msg, boolean throwError, String testFrameworkName) {
        String text = GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix(testFrameworkName) + msg;
        if (throwError) {
            log.error(text);
        } else {
            log.warn(text);
        }
    }
}

