/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestContentHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportedToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @NotNull
    private final TestConsoleProperties myConsoleProperties;
    @NotNull
    private final File myFile;
    @NotNull
    private final ProcessHandler myHandler;

    public ImportedToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull File file, @NotNull ProcessHandler handler) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        super(testFrameworkName, consoleProperties);
        this.myConsoleProperties = consoleProperties;
        this.myFile = file;
        this.myHandler = handler;
    }

    @Override
    public void onStartTesting() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ImportedToGeneralTestEventsConverter.this.parseTestResults();
                ImportedToGeneralTestEventsConverter.this.myHandler.detachProcess();
            }
        });
    }

    private void parseTestResults() {
        try {
            ImportedToGeneralTestEventsConverter.parseTestResults(new InputStreamReader((InputStream)new FileInputStream(this.myFile), CharsetToolkit.UTF8_CHARSET), this.getProcessor());
        }
        catch (IOException e) {
            final String message = e.getMessage();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)ImportedToGeneralTestEventsConverter.this.myConsoleProperties.getProject(), (String)message, (String)("Failed to Parse " + ImportedToGeneralTestEventsConverter.this.myFile.getName()));
                }
            });
        }
    }

    public static void parseTestResults(Reader reader, GeneralTestEventsProcessor processor) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(reader), (DefaultHandler)new ImportedTestContentHandler(processor));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }
}

