/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestRunnableState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractImportTestsAction.class.getName()));
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    public static final String TEST_HISTORY_SIZE = "test_history_size";
    private SMTRunnerConsoleProperties myProperties;

    public AbstractImportTestsAction(@Nullable String text, @Nullable String description) {
        super(text, description, null);
    }

    public AbstractImportTestsAction(SMTRunnerConsoleProperties properties, @Nullable String text, @Nullable String description) {
        this(text, description);
        this.myProperties = properties;
    }

    public static File getTestHistoryRoot(Project project) {
        return new File(TEST_HISTORY_PATH, FileUtil.sanitizeFileName((String)project.getName()));
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    @Nullable
    public abstract VirtualFile getFile(@NotNull Project var1);

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        VirtualFile file = this.getFile(project);
        if (file != null) {
            try {
                ImportRunProfile profile = new ImportRunProfile(file, project);
                SMTRunnerConsoleProperties properties = profile.getProperties();
                if (properties == null) {
                    properties = this.myProperties;
                    LOG.info("Failed to detect test framework in " + file.getPath() + "; use " + (properties != null ? properties.getTestFrameworkName() + " from toolbar" : "no properties"));
                }
                Executor executor = properties != null ? properties.getExecutor() : ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
                ExecutionEnvironmentBuilder.create((Project)project, (Executor)executor, (RunProfile)profile).buildAndExecute();
            }
            catch (ExecutionException e1) {
                Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Import Failed");
            }
        }
    }

    public static void adjustHistory(Project project) {
        int historySize;
        try {
            historySize = Math.max(0, Integer.parseInt(PropertiesComponent.getInstance().getValue(TEST_HISTORY_SIZE, "10")));
        }
        catch (NumberFormatException e) {
            historySize = 5;
        }
        File[] files = AbstractImportTestsAction.getTestHistoryRoot(project).listFiles();
        if (files != null && files.length >= historySize) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long l2;
                    long l1 = o1.lastModified();
                    if (l1 == (l2 = o2.lastModified())) {
                        return 0;
                    }
                    return l1 < l2 ? -1 : 1;
                }
            });
            FileUtil.delete((File)files[0]);
        }
    }

    public static class ImportRunProfile
    implements RunProfile {
        private final VirtualFile myFile;
        private final Project myProject;
        private RunnerAndConfigurationSettingsImpl mySettings;
        private boolean myImported;
        private SMTRunnerConsoleProperties myProperties;

        public ImportRunProfile(VirtualFile file, Project project) {
            block5: {
                this.myFile = file;
                this.myProject = project;
                try {
                    Document document = JDOMUtil.loadDocument((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
                    Element config = document.getRootElement().getChild("config");
                    if (config == null) break block5;
                    this.mySettings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl(project));
                    try {
                        RunConfiguration configuration;
                        this.mySettings.readExternal(config);
                        Executor executor = ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
                        if (executor != null && (configuration = this.mySettings.getConfiguration()) instanceof SMRunnerConsolePropertiesProvider) {
                            this.myProperties = ((SMRunnerConsolePropertiesProvider)configuration).createTestConsoleProperties(executor);
                        }
                    }
                    catch (InvalidDataException e) {
                        LOG.info((Throwable)e);
                        this.mySettings = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile", "getState"));
            }
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile", "getState"));
            }
            if (!this.myImported) {
                this.myImported = true;
                return new ImportedTestRunnableState(this, VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            }
            if (this.mySettings != null) {
                try {
                    RunConfiguration configuration = this.mySettings.getConfiguration();
                    if (configuration instanceof UserDataHolder) {
                        ((UserDataHolder)configuration).putUserData(TestResultsXmlFormatter.SETTINGS, (Object)this.mySettings);
                    }
                    return configuration.getState(executor, environment);
                }
                catch (Throwable e) {
                    LOG.info(e);
                    throw new ExecutionException("Unable to run the configuration: settings are corrupted");
                }
            }
            throw new ExecutionException("Unable to run the configuration: failed to detect test framework");
        }

        public String getName() {
            return this.myImported && this.mySettings != null ? this.mySettings.getName() : this.myFile.getNameWithoutExtension();
        }

        @Nullable
        public Icon getIcon() {
            return this.myProperties != null ? this.myProperties.getConfiguration().getIcon() : null;
        }

        public SMTRunnerConsoleProperties getProperties() {
            return this.myProperties;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

