/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsFromHistoryAction
extends AbstractImportTestsAction {
    private String myFileName;

    public ImportTestsFromHistoryAction(SMTRunnerConsoleProperties properties, String name) {
        super(properties, ImportTestsFromHistoryAction.getPresentableText(name), ImportTestsFromHistoryAction.getPresentableText(name));
        this.myFileName = name;
    }

    private static String getPresentableText(String name) {
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)name);
        int lastIndexOf = nameWithoutExtension.lastIndexOf(" - ");
        if (lastIndexOf > 0) {
            String date = nameWithoutExtension.substring(lastIndexOf + 3);
            try {
                Date creationDate = new SimpleDateFormat("yyyy.MM.dd 'at' HH'h' mm'm' ss's'").parse(date);
                return nameWithoutExtension.substring(0, lastIndexOf) + " (" + DateFormatUtil.formatDateTime((Date)creationDate) + ")";
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return nameWithoutExtension;
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsFromHistoryAction", "getFile"));
        }
        return LocalFileSystem.getInstance().findFileByPath(AbstractImportTestsAction.getTestHistoryRoot(project).getPath() + "/" + this.myFileName);
    }
}

