/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.ReadOnlyBlockContainer;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.ReadOnlyBlockInformationProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InitialInfoBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.InitialInfoBuilder");
    private final Map<AbstractBlockWrapper, Block> myResult;
    private final FormattingDocumentModel myModel;
    private final FormatTextRanges myAffectedRanges;
    private final int myPositionOfInterest;
    @NotNull
    private final FormattingProgressCallback myProgressCallback;
    private final FormatterTagHandler myFormatterTagHandler;
    private final CommonCodeStyleSettings.IndentOptions myOptions;
    private final Stack<State> myStates;
    private WhiteSpace myCurrentWhiteSpace;
    private CompositeBlockWrapper myRootBlockWrapper;
    private LeafBlockWrapper myPreviousBlock;
    private LeafBlockWrapper myFirstTokenBlock;
    private LeafBlockWrapper myLastTokenBlock;
    private SpacingImpl myCurrentSpaceProperty;
    private ReadOnlyBlockInformationProvider myReadOnlyBlockInformationProvider;
    private boolean myInsideFormatRestrictingTag;
    private static final boolean INLINE_TABS_ENABLED = "true".equalsIgnoreCase(System.getProperty("inline.tabs.enabled"));
    private Set<Alignment> myAlignmentsInsideRangeToModify;
    private boolean myCollectAlignmentsInsideFormattingRange;

    private InitialInfoBuilder(Block rootBlock, FormattingDocumentModel model, @Nullable FormatTextRanges affectedRanges, @NotNull CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, int positionOfInterest, @NotNull FormattingProgressCallback progressCallback) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/formatting/InitialInfoBuilder", "<init>"));
        }
        if (progressCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressCallback", "com/intellij/formatting/InitialInfoBuilder", "<init>"));
        }
        this.myResult = new THashMap();
        this.myStates = new Stack();
        this.myAlignmentsInsideRangeToModify = ContainerUtil.newHashSet();
        this.myCollectAlignmentsInsideFormattingRange = false;
        this.myModel = model;
        this.myAffectedRanges = affectedRanges;
        this.myProgressCallback = progressCallback;
        this.myCurrentWhiteSpace = new WhiteSpace(this.getStartOffset(rootBlock), true);
        this.myOptions = options;
        this.myPositionOfInterest = positionOfInterest;
        this.myInsideFormatRestrictingTag = false;
        this.myFormatterTagHandler = new FormatterTagHandler(settings);
    }

    protected static InitialInfoBuilder prepareToBuildBlocksSequentially(Block root, FormattingDocumentModel model, @Nullable FormatTextRanges affectedRanges, @NotNull CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, int interestingOffset, @NotNull FormattingProgressCallback progressCallback) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/formatting/InitialInfoBuilder", "prepareToBuildBlocksSequentially"));
        }
        if (progressCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressCallback", "com/intellij/formatting/InitialInfoBuilder", "prepareToBuildBlocksSequentially"));
        }
        InitialInfoBuilder builder = new InitialInfoBuilder(root, model, affectedRanges, settings, options, interestingOffset, progressCallback);
        builder.buildFrom(root, 0, null, null, null, true);
        return builder;
    }

    private int getStartOffset(@NotNull Block rootBlock) {
        if (rootBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "com/intellij/formatting/InitialInfoBuilder", "getStartOffset"));
        }
        int minOffset = rootBlock.getTextRange().getStartOffset();
        if (this.myAffectedRanges != null) {
            for (FormatTextRanges.FormatTextRange range : this.myAffectedRanges.getRanges()) {
                if (range.getStartOffset() >= minOffset) continue;
                minOffset = range.getStartOffset();
            }
        }
        return minOffset;
    }

    int getEndOffset() {
        int maxOffset;
        int maxDocOffset = this.myModel.getTextLength();
        int n = maxOffset = this.myRootBlockWrapper != null ? this.myRootBlockWrapper.getEndOffset() : 0;
        if (this.myAffectedRanges != null) {
            for (FormatTextRanges.FormatTextRange range : this.myAffectedRanges.getRanges()) {
                if (range.getTextRange().getEndOffset() <= maxOffset) continue;
                maxOffset = range.getTextRange().getEndOffset();
            }
        }
        return maxOffset < maxDocOffset ? maxOffset : maxDocOffset;
    }

    public boolean iteration() {
        if (this.myStates.isEmpty()) {
            return true;
        }
        State state = (State)this.myStates.peek();
        this.doIteration(state);
        return this.myStates.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBlockWrapper buildFrom(Block rootBlock, int index, @Nullable CompositeBlockWrapper parent, @Nullable WrapImpl currentWrapParent, @Nullable Block parentBlock, boolean rootBlockIsRightBlock) {
        WrapImpl wrap = (WrapImpl)rootBlock.getWrap();
        if (wrap != null) {
            wrap.registerParent(currentWrapParent);
            currentWrapParent = wrap;
        }
        TextRange textRange = rootBlock.getTextRange();
        int blockStartOffset = textRange.getStartOffset();
        if (parent != null) {
            if (textRange.getStartOffset() < parent.getStartOffset()) {
                InitialInfoBuilder.assertInvalidRanges(textRange.getStartOffset(), parent.getStartOffset(), this.myModel, "child block start is less than parent block start");
            }
            if (textRange.getEndOffset() > parent.getEndOffset()) {
                InitialInfoBuilder.assertInvalidRanges(textRange.getEndOffset(), parent.getEndOffset(), this.myModel, "child block end is after parent block end");
            }
        }
        this.myCurrentWhiteSpace.append(blockStartOffset, this.myModel, this.myOptions);
        boolean isInsideFormattingRanges = this.isInsideFormattingRanges(rootBlock, rootBlockIsRightBlock);
        if (this.myCollectAlignmentsInsideFormattingRange && rootBlock.getAlignment() != null && isInsideFormattingRanges && !this.myInsideFormatRestrictingTag) {
            this.myAlignmentsInsideRangeToModify.add(rootBlock.getAlignment());
        }
        ReadOnlyBlockInformationProvider previousProvider = this.myReadOnlyBlockInformationProvider;
        try {
            List subBlocks;
            if (rootBlock instanceof ReadOnlyBlockInformationProvider) {
                this.myReadOnlyBlockInformationProvider = (ReadOnlyBlockInformationProvider)rootBlock;
            }
            if ((subBlocks = rootBlock.getSubBlocks()).isEmpty() || this.myReadOnlyBlockInformationProvider != null && this.myReadOnlyBlockInformationProvider.isReadOnly(rootBlock)) {
                AbstractBlockWrapper wrapper = this.processSimpleBlock(rootBlock, parent, false, index, parentBlock);
                if (!subBlocks.isEmpty()) {
                    wrapper.setIndent((IndentImpl)((Block)subBlocks.get(0)).getIndent());
                }
                AbstractBlockWrapper abstractBlockWrapper = wrapper;
                return abstractBlockWrapper;
            }
            CompositeBlockWrapper compositeBlockWrapper = this.buildCompositeBlock(rootBlock, parent, index, currentWrapParent, rootBlockIsRightBlock);
            return compositeBlockWrapper;
        }
        finally {
            this.myReadOnlyBlockInformationProvider = previousProvider;
        }
    }

    private CompositeBlockWrapper buildCompositeBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, int index, @Nullable WrapImpl currentWrapParent, boolean rootBlockIsRightBlock) {
        CompositeBlockWrapper wrappedRootBlock = new CompositeBlockWrapper(rootBlock, this.myCurrentWhiteSpace, parent);
        if (index == 0) {
            wrappedRootBlock.arrangeParentTextRange();
        }
        if (this.myRootBlockWrapper == null) {
            this.myRootBlockWrapper = wrappedRootBlock;
            this.myRootBlockWrapper.setIndent((IndentImpl)Indent.getNoneIndent());
        }
        boolean blocksMayBeOfInterest = false;
        if (this.myPositionOfInterest != -1) {
            this.myResult.put(wrappedRootBlock, rootBlock);
            blocksMayBeOfInterest = true;
        }
        boolean blocksAreReadOnly = rootBlock instanceof ReadOnlyBlockContainer || blocksMayBeOfInterest;
        State state = new State(rootBlock, wrappedRootBlock, currentWrapParent, blocksAreReadOnly, rootBlockIsRightBlock);
        this.myStates.push((Object)state);
        return wrappedRootBlock;
    }

    private void doIteration(@NotNull State state) {
        AbstractBlockWrapper wrapper;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/formatting/InitialInfoBuilder", "doIteration"));
        }
        List subBlocks = state.parentBlock.getSubBlocks();
        int subBlocksCount = subBlocks.size();
        int childBlockIndex = state.getIndexOfChildBlockToProcess();
        Block block = (Block)subBlocks.get(childBlockIndex);
        if (state.previousBlock != null || this.myCurrentWhiteSpace != null && this.myCurrentWhiteSpace.isIsFirstWhiteSpace()) {
            this.myCurrentSpaceProperty = (SpacingImpl)state.parentBlock.getSpacing(state.previousBlock, block);
        }
        boolean childBlockIsRightBlock = false;
        if (childBlockIndex == subBlocksCount - 1 && state.parentBlockIsRightBlock) {
            childBlockIsRightBlock = true;
        }
        if ((wrapper = this.buildFrom(block, childBlockIndex, state.wrappedBlock, state.parentBlockWrap, state.parentBlock, childBlockIsRightBlock)).getIndent() == null) {
            wrapper.setIndent((IndentImpl)block.getIndent());
        }
        if (!state.readOnly) {
            try {
                subBlocks.set(childBlockIndex, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (state.childBlockProcessed(block, wrapper)) {
            while (!this.myStates.isEmpty() && ((State)this.myStates.peek()).isProcessed()) {
                this.myStates.pop();
            }
        }
    }

    private void setDefaultIndents(List<AbstractBlockWrapper> list) {
        if (!list.isEmpty()) {
            for (AbstractBlockWrapper wrapper : list) {
                if (wrapper.getIndent() != null) continue;
                wrapper.setIndent((IndentImpl)Indent.getContinuationWithoutFirstIndent((boolean)this.myOptions.USE_RELATIVE_INDENTS));
            }
        }
    }

    private AbstractBlockWrapper processSimpleBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, boolean readOnly, int index, @Nullable Block parentBlock) {
        LeafBlockWrapper result = this.doProcessSimpleBlock(rootBlock, parent, readOnly, index, parentBlock);
        this.myProgressCallback.afterWrappingBlock(result);
        return result;
    }

    private LeafBlockWrapper doProcessSimpleBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, boolean readOnly, int index, @Nullable Block parentBlock) {
        if (!INLINE_TABS_ENABLED && !this.myCurrentWhiteSpace.containsLineFeeds()) {
            this.myCurrentWhiteSpace.setForceSkipTabulationsUsage(true);
        }
        LeafBlockWrapper info = new LeafBlockWrapper(rootBlock, parent, this.myCurrentWhiteSpace, this.myModel, this.myOptions, this.myPreviousBlock, readOnly);
        if (index == 0) {
            info.arrangeParentTextRange();
        }
        switch (this.myFormatterTagHandler.getFormatterTag(rootBlock)) {
            case ON: {
                this.myInsideFormatRestrictingTag = false;
                break;
            }
            case OFF: {
                this.myInsideFormatRestrictingTag = true;
                break;
            }
        }
        TextRange textRange = rootBlock.getTextRange();
        if (textRange.getLength() == 0) {
            InitialInfoBuilder.assertInvalidRanges(textRange.getStartOffset(), textRange.getEndOffset(), this.myModel, "empty block");
        }
        if (this.myPreviousBlock != null) {
            this.myPreviousBlock.setNextBlock(info);
        }
        if (this.myFirstTokenBlock == null) {
            this.myFirstTokenBlock = info;
        }
        this.myLastTokenBlock = info;
        if (this.currentWhiteSpaceIsReadOnly()) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        if (this.myCurrentSpaceProperty != null) {
            this.myCurrentWhiteSpace.setIsSafe(this.myCurrentSpaceProperty.isSafe());
            this.myCurrentWhiteSpace.setKeepFirstColumn(this.myCurrentSpaceProperty.shouldKeepFirstColumn());
        }
        if (info.isEndOfCodeBlock()) {
            this.myCurrentWhiteSpace.setBeforeCodeBlockEnd(true);
        }
        info.setSpaceProperty(this.myCurrentSpaceProperty);
        this.myCurrentWhiteSpace = new WhiteSpace(textRange.getEndOffset(), false);
        if (this.myInsideFormatRestrictingTag) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        this.myPreviousBlock = info;
        if (this.myPositionOfInterest != -1 && (textRange.contains(this.myPositionOfInterest) || textRange.getEndOffset() == this.myPositionOfInterest)) {
            this.myResult.put(info, rootBlock);
            if (parent != null) {
                this.myResult.put(parent, parentBlock);
            }
        }
        return info;
    }

    private boolean currentWhiteSpaceIsReadOnly() {
        if (this.myCurrentSpaceProperty != null && this.myCurrentSpaceProperty.isReadOnly()) {
            return true;
        }
        if (this.myAffectedRanges == null) {
            return false;
        }
        return this.myAffectedRanges.isWhitespaceReadOnly(this.myCurrentWhiteSpace.getTextRange());
    }

    private boolean isInsideFormattingRanges(Block block, boolean rootIsRightBlock) {
        if (this.myAffectedRanges == null) {
            return true;
        }
        return !this.myAffectedRanges.isReadOnly(block.getTextRange(), rootIsRightBlock);
    }

    public Map<AbstractBlockWrapper, Block> getBlockToInfoMap() {
        return this.myResult;
    }

    public CompositeBlockWrapper getRootBlockWrapper() {
        return this.myRootBlockWrapper;
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myFirstTokenBlock;
    }

    public LeafBlockWrapper getLastTokenBlock() {
        return this.myLastTokenBlock;
    }

    public static void assertInvalidRanges(int startOffset, int newEndOffset, FormattingDocumentModel model, String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Invalid formatting blocks:").append(message).append("\n");
        buffer.append("Start offset:");
        buffer.append(startOffset);
        buffer.append(" end offset:");
        buffer.append(newEndOffset);
        buffer.append("\n");
        int minOffset = Math.max(Math.min(startOffset, newEndOffset) - 20, 0);
        int maxOffset = Math.min(Math.max(startOffset, newEndOffset) + 20, model.getTextLength());
        buffer.append("Affected text fragment:[").append(minOffset).append(",").append(maxOffset).append("] - '").append(model.getText(new TextRange(minOffset, maxOffset))).append("'\n");
        StringBuilder messageBuffer = new StringBuilder();
        messageBuffer.append("Invalid ranges during formatting");
        if (model instanceof FormattingDocumentModelImpl) {
            messageBuffer.append(" in ").append(((FormattingDocumentModelImpl)model).getFile().getLanguage());
        }
        buffer.append("File text:(").append(model.getTextLength()).append(")\n'");
        buffer.append(model.getText(new TextRange(0, model.getTextLength())).toString());
        buffer.append("'\n");
        buffer.append("model (").append(model.getClass()).append("): ").append(model);
        Throwable currentThrowable = new Throwable();
        if (model instanceof FormattingDocumentModelImpl) {
            FormattingDocumentModelImpl modelImpl = (FormattingDocumentModelImpl)model;
            buffer.append("Psi Tree:\n");
            PsiFile file = modelImpl.getFile();
            List roots = file.getViewProvider().getAllFiles();
            for (PsiFile root : roots) {
                buffer.append("Root ");
                DebugUtil.treeToBuffer(buffer, (ASTNode)root.getNode(), 0, false, true, true, true);
            }
            buffer.append('\n');
            currentThrowable = InitialInfoBuilder.makeLanguageStackTrace(currentThrowable, file);
        }
        LogMessageEx.error(LOG, messageBuffer.toString(), currentThrowable, buffer.toString());
    }

    private static Throwable makeLanguageStackTrace(@NotNull Throwable currentThrowable, @NotNull PsiFile file) {
        if (currentThrowable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThrowable", "com/intellij/formatting/InitialInfoBuilder", "makeLanguageStackTrace"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/InitialInfoBuilder", "makeLanguageStackTrace"));
        }
        Throwable langThrowable = new Throwable();
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (builder == null) {
            return currentThrowable;
        }
        Class<?> builderClass = builder.getClass();
        Class<?> declaringClass = builderClass.getDeclaringClass();
        String guessedFileName = (declaringClass == null ? builderClass.getSimpleName() : declaringClass.getSimpleName()) + ".java";
        StackTraceElement ste = new StackTraceElement(builder.getClass().getName(), "createModel", guessedFileName, 1);
        StackTraceElement[] originalStackTrace = currentThrowable.getStackTrace();
        StackTraceElement[] modifiedStackTrace = new StackTraceElement[originalStackTrace.length + 1];
        System.arraycopy(originalStackTrace, 0, modifiedStackTrace, 1, originalStackTrace.length);
        modifiedStackTrace[0] = ste;
        langThrowable.setStackTrace(modifiedStackTrace);
        return langThrowable;
    }

    public Set<Alignment> getAlignmentsInsideRangeToModify() {
        return this.myAlignmentsInsideRangeToModify;
    }

    public void setCollectAlignmentsInsideFormattingRange(boolean value) {
        this.myCollectAlignmentsInsideFormattingRange = value;
    }

    private class State {
        public final Block parentBlock;
        public final WrapImpl parentBlockWrap;
        public final CompositeBlockWrapper wrappedBlock;
        public final boolean readOnly;
        public final boolean parentBlockIsRightBlock;
        public Block previousBlock;
        private final List<AbstractBlockWrapper> myWrappedChildren;

        State(@NotNull Block parentBlock, @Nullable CompositeBlockWrapper wrappedBlock, WrapImpl parentBlockWrap, boolean readOnly, boolean parentBlockIsRightBlock) {
            if (parentBlock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentBlock", "com/intellij/formatting/InitialInfoBuilder$State", "<init>"));
            }
            if (wrappedBlock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedBlock", "com/intellij/formatting/InitialInfoBuilder$State", "<init>"));
            }
            this.myWrappedChildren = new ArrayList<AbstractBlockWrapper>();
            this.parentBlock = parentBlock;
            this.wrappedBlock = wrappedBlock;
            this.parentBlockWrap = parentBlockWrap;
            this.readOnly = readOnly;
            this.parentBlockIsRightBlock = parentBlockIsRightBlock;
        }

        public int getIndexOfChildBlockToProcess() {
            return this.myWrappedChildren.size();
        }

        public boolean childBlockProcessed(@NotNull Block child, @NotNull AbstractBlockWrapper wrappedChild) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/formatting/InitialInfoBuilder$State", "childBlockProcessed"));
            }
            if (wrappedChild == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappedChild", "com/intellij/formatting/InitialInfoBuilder$State", "childBlockProcessed"));
            }
            this.myWrappedChildren.add(wrappedChild);
            this.previousBlock = child;
            int subBlocksNumber = this.parentBlock.getSubBlocks().size();
            if (this.myWrappedChildren.size() > subBlocksNumber) {
                return true;
            }
            if (this.myWrappedChildren.size() == subBlocksNumber) {
                InitialInfoBuilder.this.setDefaultIndents(this.myWrappedChildren);
                this.wrappedBlock.setChildren(this.myWrappedChildren);
                return true;
            }
            return false;
        }

        public boolean isProcessed() {
            return this.myWrappedChildren.size() == this.parentBlock.getSubBlocks().size();
        }
    }
}

