/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserConfigurationHelper {
    private static final String START_MENU_KEY = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Clients\\StartMenuInternet";

    @NotNull
    public static Map<BrowserFamily, String> getBrowserPathsFromRegistry() {
        EnumMap<BrowserFamily, String> map = new EnumMap<BrowserFamily, String>(BrowserFamily.class);
        List sections = WindowsRegistryUtil.readRegistryBranch((String)START_MENU_KEY);
        for (String section : sections) {
            String pathToExe;
            BrowserFamily family = BrowserConfigurationHelper.getFamily(section);
            if (family == null || (pathToExe = WindowsRegistryUtil.readRegistryDefault((String)("HKEY_LOCAL_MACHINE\\SOFTWARE\\Clients\\StartMenuInternet\\" + section + "\\shell\\open\\command"))) == null) continue;
            map.put(family, pathToExe);
        }
        EnumMap<BrowserFamily, String> enumMap = map;
        if (enumMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/impl/BrowserConfigurationHelper", "getBrowserPathsFromRegistry"));
        }
        return enumMap;
    }

    @Nullable
    private static BrowserFamily getFamily(String registryName) {
        registryName = registryName.toLowerCase();
        for (BrowserFamily family : BrowserFamily.values()) {
            if (!registryName.contains(family.getName().toLowerCase(Locale.US))) continue;
            return family;
        }
        return null;
    }
}

