/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExtensionsRootType", storages={@Storage(file="$APP_CONFIG$/extensionsRootType.xml")})
class ResourceVersions
implements PersistentStateComponent<State> {
    private State myState = new State();

    ResourceVersions() {
    }

    @NotNull
    public static ResourceVersions getInstance() {
        ResourceVersions resourceVersions = (ResourceVersions)ServiceManager.getService(ResourceVersions.class);
        if (resourceVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions", "getInstance"));
        }
        return resourceVersions;
    }

    public boolean shouldUpdateResourcesOf(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/extensionResources/ResourceVersions", "shouldUpdateResourcesOf"));
        }
        return this.myState.isNewOrUpgraded(plugin);
    }

    public void resourcesUpdated(@NotNull IdeaPluginDescriptor of) {
        if (of == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "of", "com/intellij/ide/extensionResources/ResourceVersions", "resourcesUpdated"));
        }
        this.myState.rememberPlugin(of);
    }

    @Nullable
    public State getState() {
        return this.myState.clone();
    }

    public void loadState(State loaded) {
        loaded.forgetDisabledPlugins();
        this.myState = loaded;
    }

    static class State
    implements Serializable,
    Cloneable {
        @Tag(value="pluginVersions")
        @MapAnnotation(entryTagName="plugin", keyAttributeName="id", valueAttributeName="version", surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false)
        private Map<String, String> myPluginIdToVersion = ContainerUtil.newHashMap();

        State() {
        }

        public boolean isNewOrUpgraded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/extensionResources/ResourceVersions$State", "isNewOrUpgraded"));
            }
            return !StringUtil.equals((CharSequence)this.myPluginIdToVersion.get(State.getId(pluginDescriptor)), (CharSequence)State.getVersion(pluginDescriptor));
        }

        public void rememberPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/ide/extensionResources/ResourceVersions$State", "rememberPlugin"));
            }
            this.myPluginIdToVersion.put(State.getId(pluginDescriptor), State.getVersion(pluginDescriptor));
        }

        public void forgetDisabledPlugins() {
            HashMap newMapping = ContainerUtil.newHashMap();
            for (String pluginIdString : this.myPluginIdToVersion.keySet()) {
                IdeaPluginDescriptor plugin = PluginManager.getPlugin(PluginId.findId((String[])new String[]{pluginIdString}));
                if (plugin == null || !plugin.isEnabled()) continue;
                newMapping.put(pluginIdString, this.myPluginIdToVersion.get(pluginIdString));
            }
            this.myPluginIdToVersion = newMapping;
        }

        public State clone() {
            try {
                return (State)super.clone();
            }
            catch (CloneNotSupportedException e) {
                ExtensionsRootType.LOG.error((Throwable)e);
                return null;
            }
        }

        private static String getId(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/extensionResources/ResourceVersions$State", "getId"));
            }
            return plugin.isBundled() ? "com.intellij" : plugin.getPluginId().getIdString();
        }

        @NotNull
        private static String getVersion(@NotNull IdeaPluginDescriptor plugin) {
            if (plugin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
            }
            if (!plugin.isBundled()) {
                String string = (String)ObjectUtils.assertNotNull((Object)plugin.getVersion());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
                }
                return string;
            }
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            BuildNumber build = appInfo.getBuild();
            if (!build.isSnapshot()) {
                String string = build.asStringWithAllDetails();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
                }
                return string;
            }
            String string = build.getProductCode() + "-" + build.getBaselineVersion() + "-" + appInfo.getBuildDate().getTimeInMillis();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/extensionResources/ResourceVersions$State", "getVersion"));
            }
            return string;
        }
    }
}

