/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockLocalFileSystem
extends LocalFileSystem {
    private final MockVirtualFileSystem myDelegate = new MockVirtualFileSystem();

    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "findFileByIoFile"));
        }
        return this.myDelegate.findFileByPath(FileUtil.toSystemIndependentName((String)file.getPath()));
    }

    @Nullable
    public VirtualFile findFileByIoFile(@NotNull IFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "findFileByIoFile"));
        }
        return this.myDelegate.findFileByPath(FileUtil.toSystemIndependentName((String)file.getPath()));
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "refreshAndFindFileByIoFile"));
        }
        return this.findFileByIoFile(file);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(@NotNull IFile ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/mock/MockLocalFileSystem", "refreshAndFindFileByIoFile"));
        }
        return this.findFileByIoFile(ioFile);
    }

    public void refreshIoFiles(@NotNull Iterable<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/mock/MockLocalFileSystem", "refreshIoFiles"));
        }
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/mock/MockLocalFileSystem", "refreshFiles"));
        }
    }

    public void refreshIoFiles(@NotNull Iterable<File> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/mock/MockLocalFileSystem", "refreshIoFiles"));
        }
    }

    public void refreshFiles(@NotNull Iterable<VirtualFile> files, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/mock/MockLocalFileSystem", "refreshFiles"));
        }
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPaths", "com/intellij/mock/MockLocalFileSystem", "addRootsToWatch"));
        }
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void removeWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> rootsToWatch) {
        if (rootsToWatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToWatch", "com/intellij/mock/MockLocalFileSystem", "removeWatchedRoots"));
        }
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchRequests", "com/intellij/mock/MockLocalFileSystem", "replaceWatchedRoots"));
        }
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/mock/MockLocalFileSystem", "registerAuxiliaryFileOperationsHandler"));
        }
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/mock/MockLocalFileSystem", "unregisterAuxiliaryFileOperationsHandler"));
        }
    }

    public boolean processCachedFilesInSubtree(@NotNull VirtualFile file, @NotNull Processor<VirtualFile> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "processCachedFilesInSubtree"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/mock/MockLocalFileSystem", "processCachedFilesInSubtree"));
        }
        throw new UnsupportedOperationException("'processCachedFilesInSubtree' not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public String getProtocol() {
        if ("file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "getProtocol"));
        }
        return "file";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockLocalFileSystem", "findFileByPath"));
        }
        return this.myDelegate.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockLocalFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockLocalFileSystem", "deleteFile"));
        }
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockLocalFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/mock/MockLocalFileSystem", "moveFile"));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockLocalFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/mock/MockLocalFileSystem", "renameFile"));
        }
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/mock/MockLocalFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/mock/MockLocalFileSystem", "createChildFile"));
        }
        VirtualFile virtualFile = this.myDelegate.createChildFile(requestor, vDir, fileName);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "createChildFile"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/mock/MockLocalFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/mock/MockLocalFileSystem", "createChildDirectory"));
        }
        VirtualFile virtualFile = this.myDelegate.createChildDirectory(requestor, vDir, dirName);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "createChildDirectory"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/mock/MockLocalFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/mock/MockLocalFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/mock/MockLocalFileSystem", "copyFile"));
        }
        VirtualFile virtualFile2 = this.myDelegate.copyFile(requestor, virtualFile, newParent, copyName);
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "copyFile"));
        }
        return virtualFile2;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockLocalFileSystem", "extractRootPath"));
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "extractRootPath"));
        }
        return string;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockLocalFileSystem", "findFileByPathIfCached"));
        }
        return this.findFileByPath(path);
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDirectory", "com/intellij/mock/MockLocalFileSystem", "exists"));
        }
        return false;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "getInputStream"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "contentsToByteArray"));
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "getLength"));
        }
        return 0L;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "getOutputStream"));
        }
        throw new UnsupportedOperationException();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "getTimeStamp"));
        }
        return 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "isDirectory"));
        }
        return false;
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "isWritable"));
        }
        return false;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "list"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockLocalFileSystem", "list"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "setTimeStamp"));
        }
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "setWritable"));
        }
    }

    public int getRank() {
        return 1;
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockLocalFileSystem", "getAttributes"));
        }
        return null;
    }
}

