/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ComponentManagerConfigurator {
    private final ComponentManagerImpl myComponentManager;

    public ComponentManagerConfigurator(@NotNull ComponentManagerImpl componentManager) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/ComponentManagerConfigurator", "<init>"));
        }
        this.myComponentManager = componentManager;
    }

    private void loadSingleConfig(@NotNull ComponentConfig config, @Nullable PluginDescriptor descriptor, boolean defaultProject) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/openapi/components/impl/ComponentManagerConfigurator", "loadSingleConfig"));
        }
        if (defaultProject && !config.isLoadForDefaultProject()) {
            return;
        }
        if (!this.myComponentManager.isComponentSuitable(config.options)) {
            return;
        }
        this.myComponentManager.registerComponent(config, descriptor);
    }

    void loadComponentsConfiguration(@NotNull ComponentConfig[] components, @Nullable PluginDescriptor descriptor, boolean defaultProject) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/openapi/components/impl/ComponentManagerConfigurator", "loadComponentsConfiguration"));
        }
        for (ComponentConfig config : components) {
            this.loadSingleConfig(config, descriptor, defaultProject);
        }
    }
}

