/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ModuleStoreImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.module.impl.ModuleImpl;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ModuleStateStorageManager
extends StateStorageManagerImpl {
    @NonNls
    private static final String ROOT_TAG_NAME = "module";
    private final ModuleImpl myModule;

    public ModuleStateStorageManager(@NotNull TrackingPathMacroSubstitutor pathMacroManager, @NotNull ModuleImpl module) {
        if (pathMacroManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMacroManager", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ROOT_TAG_NAME, "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "<init>"));
        }
        super(pathMacroManager, ROOT_TAG_NAME, (Disposable)module, (PicoContainer)module.getPicoContainer());
        this.myModule = module;
    }

    @Override
    @NotNull
    protected StorageData createStorageData(@NotNull String fileSpec, @NotNull String filePath) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "createStorageData"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "createStorageData"));
        }
        ModuleStoreImpl.ModuleFileData moduleFileData = new ModuleStoreImpl.ModuleFileData(ROOT_TAG_NAME, this.myModule);
        if (moduleFileData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "createStorageData"));
        }
        return moduleFileData;
    }

    @Override
    @NotNull
    public StateStorageManager.ExternalizationSession startExternalization() {
        StateStorageManagerImpl.StateStorageManagerExternalizationSession stateStorageManagerExternalizationSession = new StateStorageManagerImpl.StateStorageManagerExternalizationSession(){

            @Override
            @NotNull
            public List<StateStorage.SaveSession> createSaveSessions() {
                if (ModuleStateStorageManager.this.myModule.getStateStore().getMainStorageData().isDirty()) {
                    this.getExternalizationSession(ModuleStateStorageManager.this.myModule.getStateStore().getMainStorage());
                }
                List<StateStorage.SaveSession> list = super.createSaveSessions();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager$1", "createSaveSessions"));
                }
                return list;
            }
        };
        if (stateStorageManagerExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "startExternalization"));
        }
        return stateStorageManagerExternalizationSession;
    }

    @Override
    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "getOldStorageSpec"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "getOldStorageSpec"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "getOldStorageSpec"));
        }
        return "$MODULE_FILE$";
    }

    @Override
    @NotNull
    protected StateStorage.Listener createStorageTopicListener() {
        StateStorage.Listener listener = (StateStorage.Listener)this.myModule.getProject().getMessageBus().syncPublisher(StateStorage.PROJECT_STORAGE_TOPIC);
        if (listener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ModuleStateStorageManager", "createStorageTopicListener"));
        }
        return listener;
    }
}

