/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.util.Condition;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StreamProvider {
    public static final StreamProvider[] EMPTY_ARRAY = new StreamProvider[0];

    public boolean isEnabled() {
        return true;
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StreamProvider", "isApplicable"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StreamProvider", "isApplicable"));
        }
        return true;
    }

    public abstract void saveContent(@NotNull String var1, @NotNull byte[] var2, int var3, @NotNull RoamingType var4) throws IOException;

    @Nullable
    public abstract InputStream loadContent(@NotNull String var1, @NotNull RoamingType var2) throws IOException;

    @NotNull
    public Collection<String> listSubFiles(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StreamProvider", "listSubFiles"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StreamProvider", "listSubFiles"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StreamProvider", "listSubFiles"));
        }
        return list;
    }

    public void processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Condition<String> filter, @NotNull ChildrenProcessor processor) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/components/impl/stores/StreamProvider", "processChildren"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/StreamProvider", "processChildren"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/components/impl/stores/StreamProvider", "processChildren"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/components/impl/stores/StreamProvider", "processChildren"));
        }
        for (String name : this.listSubFiles(path, roamingType)) {
            InputStream input;
            if (!filter.value((Object)name)) continue;
            try {
                input = this.loadContent(path + '/' + name, roamingType);
            }
            catch (IOException e) {
                StorageUtil.LOG.error((Throwable)e);
                continue;
            }
            if (input == null || processor.process(name, input)) continue;
            break;
        }
    }

    public abstract void delete(@NotNull String var1, @NotNull RoamingType var2);

    public static abstract class ChildrenProcessor {
        public abstract boolean process(@NotNull String var1, @NotNull InputStream var2);
    }
}

