/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeOperations {
    private final DiffPanelImpl myDiffPanel;
    private final FragmentSide mySide;
    private static final List<Operation> NO_OPERATIONS = ContainerUtil.emptyList();
    private static final Condition<Fragment> NOT_EQUAL_FRAGMENT = new Condition<Fragment>(){

        public boolean value(Fragment fragment) {
            return fragment.getType() != null;
        }
    };

    public MergeOperations(DiffPanelImpl diffPanel, FragmentSide side) {
        this.myDiffPanel = diffPanel;
        this.mySide = side;
    }

    @NotNull
    public List<Operation> getOperations() {
        Fragment fragment = this.getCurrentFragment();
        if (fragment == null) {
            List<Operation> list = NO_OPERATIONS;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/MergeOperations", "getOperations"));
            }
            return list;
        }
        ArrayList<Operation> operations = new ArrayList<Operation>(3);
        TextRange range = fragment.getRange(this.mySide);
        if (range.getLength() > 0) {
            if (this.isWritable(this.mySide)) {
                operations.add(MergeOperations.removeOperation(range, this.getDocument()));
            }
            TextRange otherRange = fragment.getRange(this.mySide.otherSide());
            boolean otherIsWritable = this.isWritable(this.mySide.otherSide());
            if (otherIsWritable) {
                operations.add(MergeOperations.insertOperation(range, otherRange.getEndOffset(), this.getDocument(), this.getOtherDocument()));
            }
            if (otherRange.getLength() > 0 && otherIsWritable) {
                operations.add(MergeOperations.replaceOperation(range, otherRange, this.getDocument(), this.getOtherDocument()));
            }
        }
        ArrayList<Operation> arrayList = operations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/MergeOperations", "getOperations"));
        }
        return arrayList;
    }

    private boolean isWritable(FragmentSide side) {
        Editor editor = this.myDiffPanel.getEditor(side);
        return !editor.isViewer() && MergeOperations.canMakeWritable(editor.getDocument());
    }

    private static boolean canMakeWritable(Document document) {
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return file != null && file.isInLocalFileSystem();
    }

    public void selectSuggestion() {
        Fragment fragment = this.getCurrentFragment();
        if (fragment == null) {
            return;
        }
        this.setSelection(fragment, this.mySide);
        this.setSelection(fragment, this.mySide.otherSide());
    }

    private void setSelection(Fragment fragment, FragmentSide side) {
        TextRange range = fragment.getRange(side);
        if (range.getLength() > 0) {
            this.myDiffPanel.getEditor(side).getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static Operation replaceOperation(TextRange range, TextRange otherRange, Document document, Document otherDocument) {
        return new Operation(DiffBundle.message((String)"merge.editor.replace.operation.name", (Object[])new Object[0]), AllIcons.Diff.Arrow, otherDocument, MergeOperations.replaceModification(range, document, otherRange, otherDocument));
    }

    @Nullable
    public static Operation mostSensible(Document document, Document otherDocument, TextRange range, TextRange otherRange) {
        if (!MergeOperations.canMakeWritable(document) && !MergeOperations.canMakeWritable(otherDocument)) {
            return null;
        }
        if (range.getLength() != 0) {
            if (MergeOperations.canMakeWritable(otherDocument)) {
                return otherRange.getLength() != 0 ? MergeOperations.replaceOperation(range, otherRange, document, otherDocument) : MergeOperations.insertOperation(range, otherRange.getEndOffset(), document, otherDocument);
            }
            return otherRange.getLength() == 0 ? MergeOperations.removeOperation(range, document) : null;
        }
        return null;
    }

    private static Runnable replaceModification(TextRange range, Document document, final TextRange otherRange, final Document otherDocument) {
        final String replacement = MergeOperations.getSubstring(document, range);
        return new Runnable(){

            @Override
            public void run() {
                otherDocument.replaceString(otherRange.getStartOffset(), otherRange.getEndOffset(), (CharSequence)replacement);
            }
        };
    }

    private static Operation insertOperation(TextRange range, int offset, Document document, Document otherDocument) {
        return new Operation(DiffBundle.message((String)"merge.editor.insert.operation.name", (Object[])new Object[0]), AllIcons.Diff.ArrowLeftDown, otherDocument, MergeOperations.insertModification(range, document, offset, otherDocument));
    }

    private static Runnable insertModification(TextRange range, Document document, final int offset, final Document otherDocument) {
        final String insertion = MergeOperations.getSubstring(document, range);
        return new Runnable(){

            @Override
            public void run() {
                otherDocument.insertString(offset, (CharSequence)insertion);
            }
        };
    }

    private static String getSubstring(Document document, TextRange range) {
        return document.getText(range);
    }

    private Document getOtherDocument() {
        return this.myDiffPanel.getEditor(this.mySide.otherSide()).getDocument();
    }

    private static Operation removeOperation(TextRange range, Document document) {
        return new Operation(DiffBundle.message((String)"merge.editor.remove.operation.name", (Object[])new Object[0]), AllIcons.Diff.Remove, document, MergeOperations.removeModification(range, document));
    }

    private static Runnable removeModification(final TextRange range, final Document document) {
        return new Runnable(){

            @Override
            public void run() {
                document.deleteString(range.getStartOffset(), range.getEndOffset());
            }
        };
    }

    private Document getDocument() {
        return this.myDiffPanel.getEditor(this.mySide).getDocument();
    }

    public Fragment getCurrentFragment() {
        FragmentList fragments = this.myDiffPanel.getFragments();
        int caretPosition = this.myDiffPanel.getEditor(this.mySide).getCaretModel().getOffset();
        return fragments.getFragmentAt(caretPosition, this.mySide, NOT_EQUAL_FRAGMENT);
    }

    public static class Operation {
        private final String myName;
        private final Document myDocument;
        private final Runnable myModification;
        private final Icon myGutterIcon;
        private boolean myPerformed = false;

        public Operation(String name, Icon icon, Document document, Runnable modification) {
            this.myName = name;
            this.myGutterIcon = icon;
            this.myDocument = document;
            this.myModification = modification;
        }

        public Icon getGutterIcon() {
            return this.myGutterIcon;
        }

        public String getName() {
            return this.myName;
        }

        public void perform(final Project project) {
            if (this.myPerformed) {
                return;
            }
            this.myPerformed = true;
            if (!this.myDocument.isWritable()) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(this.myDocument);
                ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{file});
                if (status.hasReadonlyFiles()) {
                    return;
                }
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project, Operation.this.myModification, Operation.this.getName(), null);
                }
            });
        }
    }
}

