/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.apply.SequenceDescriptor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class GenericPatchApplier {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier");
    private static final int ourMaxWalk = 1000;
    private final TreeMap<TextRange, MyAppliedData> myTransformations;
    private final List<String> myLines;
    private final List<PatchHunk> myHunks;
    private boolean myHadAlreadyAppliedMet;
    private final ArrayList<SplitHunk> myNotBound;
    private final ArrayList<SplitHunk> myNotExact;
    private boolean mySuppressNewLineInEnd;

    private void debug(String s) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(s);
        }
    }

    public GenericPatchApplier(CharSequence text, List<PatchHunk> hunks) {
        this.debug("GenericPatchApplier created, hunks: " + hunks.size());
        this.myLines = new ArrayList<String>();
        Collections.addAll(this.myLines, LineTokenizer.tokenize((CharSequence)text, (boolean)false));
        this.myHunks = hunks;
        this.myTransformations = new TreeMap(new Comparator<TextRange>(){

            @Override
            public int compare(TextRange o1, TextRange o2) {
                return new Integer(o1.getStartOffset()).compareTo(new Integer(o2.getStartOffset()));
            }
        });
        this.myNotExact = new ArrayList();
        this.myNotBound = new ArrayList();
    }

    public ApplyPatchStatus getStatus() {
        if (!this.myNotExact.isEmpty()) {
            return ApplyPatchStatus.FAILURE;
        }
        if (this.myTransformations.isEmpty() && this.myHadAlreadyAppliedMet) {
            return ApplyPatchStatus.ALREADY_APPLIED;
        }
        boolean haveAlreadyApplied = this.myHadAlreadyAppliedMet;
        boolean haveTrue = false;
        for (MyAppliedData data : this.myTransformations.values()) {
            if (data.isHaveAlreadyApplied()) {
                haveAlreadyApplied |= true;
                continue;
            }
            haveTrue = true;
        }
        if (haveAlreadyApplied && !haveTrue) {
            return ApplyPatchStatus.ALREADY_APPLIED;
        }
        if (haveAlreadyApplied) {
            return ApplyPatchStatus.PARTIAL;
        }
        return ApplyPatchStatus.SUCCESS;
    }

    private void printTransformations(String comment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(comment + " GenericPatchApplier.printTransformations ---->");
            int cnt = 0;
            for (Map.Entry<TextRange, MyAppliedData> entry : this.myTransformations.entrySet()) {
                TextRange key = entry.getKey();
                MyAppliedData value = entry.getValue();
                LOG.info(String.valueOf(cnt) + " lines " + key.getStartOffset() + ":" + key.getEndOffset() + " will replace into: " + StringUtil.join(value.getList(), (String)"\n"));
            }
            LOG.debug("<------ GenericPatchApplier.printTransformations");
        }
    }

    public int weightContextMatch(int maxWalk, int maxPartsToCheck) {
        ArrayList<SplitHunk> hunks = new ArrayList<SplitHunk>(this.myHunks.size());
        for (PatchHunk hunk : this.myHunks) {
            hunks.addAll(SplitHunk.read(hunk));
        }
        int cntPlus = 0;
        int cnt = maxPartsToCheck;
        for (SplitHunk hunk : hunks) {
            SplitHunk copy = this.createWithAllContextCopy(hunk);
            if (copy.isInsertion()) continue;
            if (this.testForPartialContextMatch(copy, new ExactMatchSolver(copy), maxWalk)) {
                ++cntPlus;
            }
            if (--cnt != 0) continue;
            break;
        }
        return cntPlus;
    }

    public boolean execute() {
        SplitHunk copy;
        this.debug("GenericPatchApplier execute started");
        if (!this.myHunks.isEmpty()) {
            this.mySuppressNewLineInEnd = this.myHunks.get(this.myHunks.size() - 1).isNoNewLineAtEnd();
        }
        for (PatchHunk patchHunk : this.myHunks) {
            this.myNotExact.addAll(SplitHunk.read(patchHunk));
        }
        Iterator<SplitHunk> iterator = this.myNotExact.iterator();
        while (iterator.hasNext()) {
            SplitHunk splitHunk = iterator.next();
            copy = this.createWithAllContextCopy(splitHunk);
            if (!this.testForExactMatch(copy)) continue;
            iterator.remove();
        }
        this.printTransformations("after exact match");
        iterator = this.myNotExact.iterator();
        while (iterator.hasNext()) {
            SplitHunk splitHunk = iterator.next();
            copy = this.createWithAllContextCopy(splitHunk);
            if (copy.isInsertion() || !this.testForPartialContextMatch(copy, new ExactMatchSolver(copy), 1000)) continue;
            iterator.remove();
        }
        this.printTransformations("after exact but without context");
        for (SplitHunk splitHunk : this.myNotExact) {
            this.complementInsertAndDelete(splitHunk);
        }
        iterator = this.myNotExact.iterator();
        while (iterator.hasNext()) {
            SplitHunk splitHunk = iterator.next();
            if (splitHunk.isInsertion() || !this.testForPartialContextMatch(splitHunk, new ExactMatchSolver(splitHunk), 1000)) continue;
            iterator.remove();
        }
        this.printTransformations("after variable place match");
        return this.myNotExact.isEmpty();
    }

    private SplitHunk createWithAllContextCopy(SplitHunk hunk) {
        SplitHunk copy = new SplitHunk(hunk.getStartLineBefore(), new ArrayList<BeforeAfter<List<String>>>(hunk.getPatchSteps()), new ArrayList<String>(), new ArrayList<String>());
        List<BeforeAfter<List<String>>> steps = copy.getPatchSteps();
        BeforeAfter<List<String>> first = steps.get(0);
        BeforeAfter<List<String>> last = steps.get(steps.size() - 1);
        BeforeAfter<List<String>> firstCopy = this.copyBeforeAfter(first);
        steps.set(0, firstCopy);
        ((List)firstCopy.getBefore()).addAll(0, hunk.getContextBefore());
        ((List)firstCopy.getAfter()).addAll(0, hunk.getContextBefore());
        if (first == last) {
            ((List)firstCopy.getBefore()).addAll(hunk.getContextAfter());
            ((List)firstCopy.getAfter()).addAll(hunk.getContextAfter());
        } else {
            BeforeAfter<List<String>> lastCopy = this.copyBeforeAfter(last);
            ((List)lastCopy.getBefore()).addAll(hunk.getContextAfter());
            ((List)lastCopy.getAfter()).addAll(hunk.getContextAfter());
        }
        return copy;
    }

    private BeforeAfter<List<String>> copyBeforeAfter(BeforeAfter<List<String>> first) {
        return new BeforeAfter(new ArrayList((Collection)first.getBefore()), new ArrayList((Collection)first.getAfter()));
    }

    private void complementInsertAndDelete(SplitHunk hunk) {
        List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
        BeforeAfter<List<String>> first = steps.get(0);
        BeforeAfter<List<String>> last = steps.get(steps.size() - 1);
        boolean complementFirst = ((List)first.getBefore()).isEmpty() || ((List)first.getAfter()).isEmpty();
        boolean complementLast = ((List)last.getBefore()).isEmpty() || ((List)last.getAfter()).isEmpty();
        List<String> contextBefore = hunk.getContextBefore();
        if (complementFirst && !contextBefore.isEmpty()) {
            String firstContext = contextBefore.get(contextBefore.size() - 1);
            ((List)first.getBefore()).add(0, firstContext);
            ((List)first.getAfter()).add(0, firstContext);
            contextBefore.remove(contextBefore.size() - 1);
        }
        List<String> contextAfter = hunk.getContextAfter();
        if (complementLast && !contextAfter.isEmpty()) {
            String firstContext = contextAfter.get(0);
            ((List)last.getBefore()).add(firstContext);
            ((List)last.getAfter()).add(firstContext);
            contextAfter.remove(0);
        }
    }

    private boolean complementIfShort(SplitHunk hunk) {
        boolean complementFirst;
        List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
        if (steps.size() > 1) {
            return false;
        }
        BeforeAfter<List<String>> first = steps.get(0);
        boolean bl = complementFirst = ((List)first.getBefore()).isEmpty() || ((List)first.getAfter()).isEmpty() || ((List)first.getBefore()).size() == 1 || ((List)first.getAfter()).size() == 1;
        if (!complementFirst) {
            return false;
        }
        List<String> contextBefore = hunk.getContextBefore();
        if (!contextBefore.isEmpty()) {
            String firstContext = contextBefore.get(contextBefore.size() - 1);
            ((List)first.getBefore()).add(0, firstContext);
            ((List)first.getAfter()).add(0, firstContext);
            contextBefore.remove(contextBefore.size() - 1);
            return true;
        }
        List<String> contextAfter = hunk.getContextAfter();
        if (!contextAfter.isEmpty()) {
            String firstContext = contextAfter.get(0);
            ((List)first.getBefore()).add(firstContext);
            ((List)first.getAfter()).add(firstContext);
            contextAfter.remove(0);
            return true;
        }
        return false;
    }

    public void trySolveSomehow() {
        assert (!this.myNotExact.isEmpty());
        for (SplitHunk hunk : this.myNotExact) {
            hunk.cutSameTail();
            if (this.testForPartialContextMatch(hunk, new LongTryMismatchSolver(hunk), 1000)) continue;
            if (this.complementIfShort(hunk)) {
                if (this.testForPartialContextMatch(hunk, new LongTryMismatchSolver(hunk), 1000)) continue;
                this.myNotBound.add(hunk);
                continue;
            }
            this.myNotBound.add(hunk);
        }
        Collections.sort(this.myNotBound, HunksComparator.getInstance());
        this.myNotExact.clear();
    }

    private boolean testForPartialContextMatch(SplitHunk splitHunk, MismatchSolver mismatchSolver, int maxWalkFromBinding) {
        List<BeforeAfter<List<String>>> steps = splitHunk.getPatchSteps();
        BeforeAfter<List<String>> first = steps.get(0);
        BetterPoint betterPoint = new BetterPoint();
        if (splitHunk.isInsertion()) {
            return false;
        }
        Iterator<FirstLineDescriptor> iterator = mismatchSolver.getStartLineVariationsIterator();
        while (iterator.hasNext() && (betterPoint.getPoint() == null || !betterPoint.getPoint().idealFound())) {
            FirstLineDescriptor descriptor = iterator.next();
            Iterator<Integer> matchingIterator = this.getMatchingIterator(descriptor.getLine(), splitHunk.getStartLineBefore() + descriptor.getOffset(), maxWalkFromBinding);
            while (matchingIterator.hasNext() && (betterPoint.getPoint() == null || !betterPoint.getPoint().idealFound())) {
                UnfairTextRange textRangeInOldDocument;
                List<BeforeAfter<List<String>>> list;
                Integer lineNumber = matchingIterator.next();
                List<BeforeAfter<List<String>>> patchSteps = splitHunk.getPatchSteps();
                BeforeAfter<List<String>> step = patchSteps.get(descriptor.getStepNumber());
                FragmentResult fragmentResult = this.checkFragmented(lineNumber, descriptor.getOffsetInStep(), step, descriptor.isIsInBefore());
                if (descriptor.getStepNumber() > 0 && fragmentResult.isStartAtEdge()) {
                    list = Collections.unmodifiableList(patchSteps.subList(0, descriptor.getStepNumber()));
                    int offsetForStart = -descriptor.getOffsetInStep() - 1;
                    SequentialStepsChecker backChecker = new SequentialStepsChecker(lineNumber + offsetForStart, false);
                    backChecker.go(list);
                    fragmentResult.setContainAlreadyApplied(fragmentResult.isContainAlreadyApplied() || backChecker.isUsesAlreadyApplied());
                    fragmentResult.setStart(fragmentResult.getStart() - backChecker.getSizeOfFragmentToBeReplaced());
                    fragmentResult.addDistance(backChecker.getDistance());
                    fragmentResult.setStartAtEdge(backChecker.getDistance() == 0);
                }
                if (steps.size() > descriptor.getStepNumber() + 1 && fragmentResult.isEndAtEdge() && !(list = Collections.unmodifiableList(patchSteps.subList(descriptor.getStepNumber() + 1, patchSteps.size()))).isEmpty()) {
                    SequentialStepsChecker checker = new SequentialStepsChecker(fragmentResult.getEnd() + 1, true);
                    checker.go(list);
                    fragmentResult.setContainAlreadyApplied(fragmentResult.isContainAlreadyApplied() || checker.isUsesAlreadyApplied());
                    fragmentResult.setEnd(fragmentResult.getEnd() + checker.getSizeOfFragmentToBeReplaced());
                    fragmentResult.addDistance(checker.getDistance());
                    fragmentResult.setEndAtEdge(checker.getDistance() == 0);
                }
                if (!this.pointCanBeUsed((TextRange)(textRangeInOldDocument = new UnfairTextRange(fragmentResult.getStart(), fragmentResult.getEnd())))) continue;
                int distance = fragmentResult.myDistance;
                int commonPart = fragmentResult.getEnd() - fragmentResult.getStart() + 1;
                int contextDistance = 0;
                if (distance == 0 || commonPart < 2) {
                    int distanceBack = this.getDistanceBack(fragmentResult.getStart() - 1, splitHunk.getContextBefore());
                    int distanceInContextAfter = this.getDistance(fragmentResult.getEnd() + 1, splitHunk.getContextAfter());
                    contextDistance = distanceBack + distanceInContextAfter;
                }
                betterPoint.feed(new Point(distance, (TextRange)textRangeInOldDocument, fragmentResult.isContainAlreadyApplied(), contextDistance, commonPart));
            }
        }
        Point pointPoint = betterPoint.getPoint();
        if (pointPoint == null) {
            return false;
        }
        if (!mismatchSolver.isAllowMismatch()) {
            int contextCommon;
            if (pointPoint.getDistance() > 0) {
                return false;
            }
            if (pointPoint.myCommon < 2 && (contextCommon = splitHunk.getContextBefore().size() + splitHunk.getContextAfter().size() - pointPoint.myContextDistance) == 0) {
                return false;
            }
        }
        this.putCutIntoTransformations(pointPoint.getInOldDocument(), new MyAppliedData(splitHunk.getAfterAll(), pointPoint.myUsesAlreadyApplied, false, pointPoint.getDistance() == 0, ChangeType.REPLACE));
        return true;
    }

    private FragmentResult checkFragmented(int lineInTheMiddle, int offsetInStep, BeforeAfter<List<String>> step, boolean inBefore) {
        List lines = inBefore ? (List)step.getBefore() : (List)step.getAfter();
        List<String> start = lines.subList(0, offsetInStep);
        int startDistance = 0;
        if (!start.isEmpty()) {
            startDistance = lineInTheMiddle - 1 < 0 ? start.size() : this.getDistanceBack(lineInTheMiddle - 1, start);
        }
        List<String> end = lines.subList(offsetInStep, lines.size());
        int endDistance = 0;
        if (!end.isEmpty()) {
            endDistance = this.getDistance(lineInTheMiddle, end);
        }
        FragmentResult fragmentResult = new FragmentResult(lineInTheMiddle - (start.size() - startDistance), lineInTheMiddle + (end.size() - endDistance) - 1, !inBefore);
        fragmentResult.addDistance(startDistance + endDistance);
        fragmentResult.setStartAtEdge(startDistance == 0);
        fragmentResult.setEndAtEdge(endDistance == 0);
        return fragmentResult;
    }

    private int getDistanceBack(int idxStart, List<String> lines) {
        if (idxStart < 0) {
            return lines.size();
        }
        int cnt = lines.size() - 1;
        for (int i = idxStart; i >= 0 && cnt >= 0; --i, --cnt) {
            if (this.myLines.get(i).equals(lines.get(cnt))) continue;
            return cnt + 1;
        }
        return cnt + 1;
    }

    private int getDistance(int idxStart, List<String> lines) {
        if (idxStart >= this.myLines.size()) {
            return lines.size();
        }
        int cnt = 0;
        for (int i = idxStart; i < this.myLines.size() && cnt < lines.size(); ++i, ++cnt) {
            if (this.myLines.get(i).equals(lines.get(cnt))) continue;
            return lines.size() - cnt;
        }
        return lines.size() - cnt;
    }

    public void putCutIntoTransformations(TextRange range, MyAppliedData value) {
        int j;
        int i;
        List<String> list = value.getList();
        int cnt = list.size() - 1;
        for (i = range.getEndOffset(); i > range.getStartOffset() && cnt >= 0 && list.get(cnt).equals(this.myLines.get(i)); --i, --cnt) {
        }
        int endSize = list.size();
        if (cnt + 1 <= list.size() - 1) {
            endSize = cnt + 1;
        }
        int cntStart = 0;
        if (endSize > 0) {
            for (j = range.getStartOffset(); j < range.getEndOffset() && cntStart < list.size() && list.get(cntStart).equals(this.myLines.get(j)); ++j, ++cntStart) {
            }
        }
        if (j != range.getStartOffset() || i != range.getEndOffset()) {
            if (cntStart >= endSize) {
                if (list.size() == range.getLength() + 1) {
                    this.myHadAlreadyAppliedMet = value.isHaveAlreadyApplied();
                } else {
                    this.myTransformations.put((TextRange)new UnfairTextRange(j, i + (cntStart - endSize)), new MyAppliedData(Collections.<String>emptyList(), value.isHaveAlreadyApplied(), value.isPlaceCoinside(), value.isChangedCoinside(), value.myChangeType));
                }
            } else {
                if (i < j) {
                    assert (cntStart > 0);
                    MyAppliedData newData = new MyAppliedData(new ArrayList<String>(list.subList(cntStart - (j - i), endSize)), value.isHaveAlreadyApplied(), value.isPlaceCoinside(), value.isChangedCoinside(), value.myChangeType);
                    TextRange newRange = new TextRange(i, i);
                    this.myTransformations.put(newRange, newData);
                    return;
                }
                MyAppliedData newData = new MyAppliedData(new ArrayList<String>(list.subList(cntStart, endSize)), value.isHaveAlreadyApplied(), value.isPlaceCoinside(), value.isChangedCoinside(), value.myChangeType);
                TextRange newRange = new TextRange(j, i);
                this.myTransformations.put(newRange, newData);
            }
        } else {
            this.myTransformations.put(range, value);
        }
    }

    private boolean pointCanBeUsed(TextRange range) {
        Map.Entry<TextRange, MyAppliedData> entry = this.myTransformations.ceilingEntry(range);
        return entry == null || !entry.getKey().intersects(range);
    }

    private Iterator<Integer> getMatchingIterator(String line, int originalStart, int maxWalkFromBinding) {
        return ContainerUtil.concatIterators((Iterator[])new Iterator[]{new WalkingIterator(line, originalStart, maxWalkFromBinding, true), new WalkingIterator(line, originalStart, maxWalkFromBinding, false)});
    }

    private boolean testForExactMatch(SplitHunk splitHunk) {
        int offset = splitHunk.getContextBefore().size();
        List<BeforeAfter<List<String>>> steps = splitHunk.getPatchSteps();
        if (splitHunk.isInsertion()) {
            boolean emptyFile;
            boolean bl = emptyFile = this.myLines.isEmpty() || this.myLines.size() == 1 && this.myLines.get(0).trim().length() == 0;
            if (emptyFile) {
                this.myNotBound.add(splitHunk);
            }
            return emptyFile;
        }
        int idx = splitHunk.getStartLineBefore() + offset;
        int cnt = 0;
        boolean hadAlreadyApplied = false;
        for (BeforeAfter<List<String>> step : steps) {
            int length;
            if (this.myLines.size() <= idx) {
                return false;
            }
            if (((List)step.getBefore()).isEmpty()) continue;
            Pair<Integer, Boolean> distance = new FragmentMatcher(idx + cnt, step).find(false);
            if ((Integer)distance.getFirst() > 0) {
                return false;
            }
            if (((Boolean)distance.getSecond()).booleanValue()) {
                length = ((List)step.getBefore()).size();
            } else {
                length = ((List)step.getAfter()).size();
                hadAlreadyApplied = true;
            }
            cnt += length;
        }
        this.putCutIntoTransformations(new TextRange(idx, idx + cnt - 1), new MyAppliedData(splitHunk.getAfterAll(), hadAlreadyApplied, true, true, ChangeType.REPLACE));
        return true;
    }

    public String getAfter() {
        final StringBuilder sb = new StringBuilder();
        for (SplitHunk hunk : this.myNotBound) {
            this.linesToSb(sb, hunk.getAfterAll());
        }
        this.iterateTransformations(new Consumer<TextRange>(){

            public void consume(TextRange range) {
                GenericPatchApplier.this.linesToSb(sb, GenericPatchApplier.this.myLines.subList(range.getStartOffset(), range.getEndOffset() + 1));
            }
        }, new Consumer<TextRange>(){

            public void consume(TextRange range) {
                MyAppliedData appliedData = (MyAppliedData)GenericPatchApplier.this.myTransformations.get(range);
                if (appliedData.isInsertAfter()) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append((String)GenericPatchApplier.this.myLines.get(range.getStartOffset()));
                }
                GenericPatchApplier.this.linesToSb(sb, appliedData.getList());
            }
        });
        if (!this.mySuppressNewLineInEnd) {
            sb.append('\n');
        }
        return sb.toString();
    }

    private void linesToSb(StringBuilder sb, List<String> list) {
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(s);
        }
    }

    private void iterateTransformations(Consumer<TextRange> consumerExcluded, Consumer<TextRange> consumerIncluded) {
        if (this.myTransformations.isEmpty()) {
            consumerExcluded.consume((Object)new UnfairTextRange(0, this.myLines.size() - 1));
        } else {
            Set<Map.Entry<TextRange, MyAppliedData>> entries = this.myTransformations.entrySet();
            Iterator<Map.Entry<TextRange, MyAppliedData>> iterator = entries.iterator();
            assert (iterator.hasNext());
            Map.Entry<TextRange, MyAppliedData> first = iterator.next();
            TextRange range = first.getKey();
            if (range.getStartOffset() > 0) {
                consumerExcluded.consume((Object)new TextRange(0, range.getStartOffset() - 1));
            }
            consumerIncluded.consume((Object)range);
            int previousEnd = range.getEndOffset() + 1;
            while (iterator.hasNext() && previousEnd < this.myLines.size()) {
                Map.Entry<TextRange, MyAppliedData> entry = iterator.next();
                TextRange key = entry.getKey();
                consumerExcluded.consume((Object)new UnfairTextRange(previousEnd, key.getStartOffset() - 1));
                consumerIncluded.consume((Object)key);
                previousEnd = key.getEndOffset() + 1;
            }
            if (previousEnd < this.myLines.size()) {
                consumerExcluded.consume((Object)new TextRange(previousEnd, this.myLines.size() - 1));
            }
        }
    }

    public TreeMap<TextRange, MyAppliedData> getTransformations() {
        return this.myTransformations;
    }

    private static class HunksComparator
    implements Comparator<SplitHunk> {
        private static final HunksComparator ourInstance = new HunksComparator();

        private HunksComparator() {
        }

        public static HunksComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(SplitHunk o1, SplitHunk o2) {
            return Integer.valueOf(o1.getStartLineBefore()).compareTo(o2.getStartLineBefore());
        }
    }

    public static enum ChangeType {
        INSERT_AFTER,
        REPLACE;

    }

    public static class MyAppliedData {
        private List<String> myList;
        private final boolean myHaveAlreadyApplied;
        private final boolean myPlaceCoinside;
        private final boolean myChangedCoinside;
        private final ChangeType myChangeType;

        public MyAppliedData(List<String> list, boolean alreadyApplied, boolean placeCoinside, boolean changedCoinside, ChangeType changeType) {
            this.myList = list;
            this.myHaveAlreadyApplied = alreadyApplied;
            this.myPlaceCoinside = placeCoinside;
            this.myChangedCoinside = changedCoinside;
            this.myChangeType = changeType;
        }

        public List<String> getList() {
            return this.myList;
        }

        public void cutToSize(int size) {
            assert (size > 0 && size < this.myList.size());
            this.myList = new ArrayList<String>(this.myList.subList(0, size));
        }

        public boolean isHaveAlreadyApplied() {
            return this.myHaveAlreadyApplied;
        }

        public boolean isPlaceCoinside() {
            return this.myPlaceCoinside;
        }

        public boolean isChangedCoinside() {
            return this.myChangedCoinside;
        }

        public boolean isInsertAfter() {
            return ChangeType.INSERT_AFTER.equals((Object)this.myChangeType);
        }
    }

    public static class SplitHunk {
        private final List<String> myContextBefore;
        private final List<String> myContextAfter;
        private final List<BeforeAfter<List<String>>> myPatchSteps;
        private final int myStartLineBefore;

        public SplitHunk(int startLineBefore, List<BeforeAfter<List<String>>> patchSteps, List<String> contextAfter, List<String> contextBefore) {
            this.myStartLineBefore = startLineBefore;
            this.myPatchSteps = patchSteps;
            this.myContextAfter = contextAfter;
            this.myContextBefore = contextBefore;
        }

        public void cutSameTail() {
            BeforeAfter<List<String>> lastStep = this.myPatchSteps.get(this.myPatchSteps.size() - 1);
            List before = (List)lastStep.getBefore();
            List after = (List)lastStep.getAfter();
            int cntBefore = before.size() - 1;
            for (int cntAfter = after.size() - 1; cntBefore >= 0 && cntAfter > 0 && ((String)before.get(cntBefore)).equals(after.get(cntAfter)); --cntBefore, --cntAfter) {
            }
            int cutSame = before.size() - 1 - cntBefore;
            for (int i = 0; i < cutSame; ++i) {
                before.remove(before.size() - 1);
                after.remove(after.size() - 1);
            }
        }

        public static List<SplitHunk> read(PatchHunk hunk) {
            ArrayList<SplitHunk> result = new ArrayList<SplitHunk>();
            List lines = hunk.getLines();
            int i = 0;
            ArrayList<String> contextBefore = new ArrayList<String>();
            int newSize = 0;
            while (i < lines.size()) {
                int inheritedContext = contextBefore.size();
                ArrayList<String> contextAfter = new ArrayList<String>();
                ArrayList<BeforeAfter<List<String>>> steps = new ArrayList<BeforeAfter<List<String>>>();
                int endIdx = SplitHunk.readOne(lines, contextBefore, contextAfter, steps, i);
                result.add(new SplitHunk(hunk.getStartLineBefore() + i - inheritedContext - newSize, steps, contextAfter, contextBefore));
                for (BeforeAfter beforeAfter : steps) {
                    newSize += ((List)beforeAfter.getAfter()).size();
                }
                i = endIdx;
                if (i >= lines.size()) continue;
                contextBefore = new ArrayList();
                contextBefore.addAll(contextAfter);
            }
            return result;
        }

        private static int readOne(List<PatchLine> lines, List<String> contextBefore, List<String> contextAfter, List<BeforeAfter<List<String>>> steps, int startI) {
            PatchLine patchLine;
            PatchLine.Type type;
            PatchLine patchLine2;
            int i;
            for (i = startI; i < lines.size() && PatchLine.Type.CONTEXT.equals((Object)(patchLine2 = lines.get(i)).getType()); ++i) {
                contextBefore.add(patchLine2.getText());
            }
            boolean addFirst = i < lines.size() && PatchLine.Type.ADD.equals((Object)lines.get(i).getType());
            ArrayList<String> before = new ArrayList<String>();
            ArrayList<String> after = new ArrayList<String>();
            while (i < lines.size() && !PatchLine.Type.CONTEXT.equals((Object)(type = (patchLine = lines.get(i)).getType()))) {
                if (PatchLine.Type.ADD.equals((Object)type)) {
                    if (addFirst && !before.isEmpty()) {
                        steps.add((BeforeAfter<List<String>>)new BeforeAfter(before, after));
                        before = new ArrayList();
                        after = new ArrayList();
                    }
                    after.add(patchLine.getText());
                } else if (PatchLine.Type.REMOVE.equals((Object)type)) {
                    if (!addFirst && !after.isEmpty()) {
                        steps.add((BeforeAfter<List<String>>)new BeforeAfter(before, after));
                        before = new ArrayList();
                        after = new ArrayList();
                    }
                    before.add(patchLine.getText());
                }
                ++i;
            }
            if (!before.isEmpty() || !after.isEmpty()) {
                steps.add((BeforeAfter<List<String>>)new BeforeAfter(before, after));
            }
            while (i < lines.size()) {
                patchLine = lines.get(i);
                if (!PatchLine.Type.CONTEXT.equals((Object)patchLine.getType())) {
                    return i;
                }
                contextAfter.add(patchLine.getText());
                ++i;
            }
            return lines.size();
        }

        public boolean isInsertion() {
            return this.myPatchSteps.size() == 1 && ((List)this.myPatchSteps.get(0).getBefore()).isEmpty();
        }

        public int getStartLineBefore() {
            return this.myStartLineBefore;
        }

        public List<String> getContextBefore() {
            return this.myContextBefore;
        }

        public List<String> getContextAfter() {
            return this.myContextAfter;
        }

        public List<BeforeAfter<List<String>>> getPatchSteps() {
            return this.myPatchSteps;
        }

        public List<String> getAfterAll() {
            ArrayList<String> after = new ArrayList<String>();
            for (BeforeAfter<List<String>> step : this.myPatchSteps) {
                after.addAll((Collection)step.getAfter());
            }
            return after;
        }
    }

    private class FragmentMatcher {
        private int myIdx;
        private int myOffsetIdxInHunk = 0;
        private Boolean myBeforeSide;
        private boolean myIsInBefore;
        private int myIdxInHunk;
        private final BeforeAfter<List<String>> myBeforeAfter;

        private FragmentMatcher(int idx, BeforeAfter<List<String>> beforeAfter) {
            this.myIdx = idx;
            this.myBeforeAfter = beforeAfter;
            this.myIdxInHunk = 0;
        }

        public void setSideAndIdx(int startInHunk, boolean beforeSide) {
            this.myOffsetIdxInHunk = startInHunk;
            this.myBeforeSide = beforeSide;
            if (this.myBeforeSide != false ? !$assertionsDisabled && ((List)this.myBeforeAfter.getBefore()).size() <= this.myOffsetIdxInHunk && (this.myOffsetIdxInHunk != 0 || ((List)this.myBeforeAfter.getBefore()).size() != 0) : !$assertionsDisabled && ((List)this.myBeforeAfter.getAfter()).size() <= this.myOffsetIdxInHunk && (this.myOffsetIdxInHunk != 0 || ((List)this.myBeforeAfter.getAfter()).size() != 0)) {
                throw new AssertionError();
            }
        }

        public Pair<Integer, Boolean> find(boolean canMismatch) {
            if (this.myBeforeSide != null) {
                if (this.myBeforeSide.booleanValue()) {
                    return new Pair((Object)this.checkSide((List)this.myBeforeAfter.getBefore(), canMismatch), (Object)true);
                }
                return new Pair((Object)this.checkSide((List)this.myBeforeAfter.getAfter(), canMismatch), (Object)false);
            }
            int beforeCheckResult = this.checkSide((List)this.myBeforeAfter.getBefore(), canMismatch);
            int afterCheckResult = this.checkSide((List)this.myBeforeAfter.getAfter(), canMismatch);
            Pair beforePair = new Pair((Object)beforeCheckResult, (Object)true);
            Pair afterPair = new Pair((Object)afterCheckResult, (Object)false);
            if (!canMismatch) {
                if (beforeCheckResult == 0) {
                    return beforePair;
                }
                if (afterCheckResult == 0) {
                    return afterPair;
                }
                return beforePair;
            }
            int beforeCommon = ((List)this.myBeforeAfter.getBefore()).size() - beforeCheckResult;
            int afterCommon = ((List)this.myBeforeAfter.getAfter()).size() - afterCheckResult;
            if (beforeCommon > 0 && afterCommon > 0) {
                if (beforeCommon == 1 && ((List)this.myBeforeAfter.getBefore()).size() == 1 && afterCommon > 1) {
                    return afterPair;
                }
                if (afterCommon == 1 && ((List)this.myBeforeAfter.getAfter()).size() == 1 && beforeCommon > 1) {
                    return beforePair;
                }
                if (beforeCommon >= afterCommon) {
                    return beforePair;
                }
                return afterPair;
            }
            if (afterCommon > 0) {
                return afterPair;
            }
            return beforePair;
        }

        private int checkSide(List<String> side, boolean canMismatch) {
            int j;
            int distance = 0;
            if (this.myOffsetIdxInHunk > 0) {
                int i;
                int linesIdx = this.myIdx - 1;
                for (i = this.myOffsetIdxInHunk - 1; i >= 0 && linesIdx >= 0 && ((String)GenericPatchApplier.this.myLines.get(linesIdx)).equals(side.get(i)); --i, --linesIdx) {
                }
                if (++i > 0 && !canMismatch) {
                    return i;
                }
                distance = i;
            }
            int linesEndIdx = this.myIdx;
            for (j = this.myOffsetIdxInHunk; j < side.size() && linesEndIdx < GenericPatchApplier.this.myLines.size() && ((String)GenericPatchApplier.this.myLines.get(linesEndIdx)).equals(side.get(j)); ++j, ++linesEndIdx) {
            }
            return distance += side.size() - j;
        }
    }

    private class WalkingIterator
    implements Iterator<Integer> {
        private final String myLine;
        private final boolean myDirection;
        private int myLeftWalk;
        private int myCurrentIdx;

        private WalkingIterator(String line, int start, int leftWalk, boolean direction) {
            this.myLine = line;
            this.myLeftWalk = leftWalk;
            this.myDirection = direction;
            this.myCurrentIdx = start - 1;
            this.step();
        }

        @Override
        public boolean hasNext() {
            return this.myCurrentIdx != -1;
        }

        @Override
        public Integer next() {
            int currentIdx = this.myCurrentIdx;
            this.step();
            return currentIdx;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void step() {
            if (this.myDirection) {
                int i;
                int maxWalk = this.myLeftWalk + i;
                this.myCurrentIdx = -1;
                for (i = this.myCurrentIdx + 1; i < GenericPatchApplier.this.myLines.size() && i < maxWalk; ++i) {
                    String s = (String)GenericPatchApplier.this.myLines.get(i);
                    if (!this.myLine.equals(s) || this.isSeized(i)) continue;
                    this.myCurrentIdx = i;
                    this.myLeftWalk = maxWalk - 1 - i;
                    break;
                }
            } else {
                int i;
                int maxWalk = Math.max(-1, i - this.myLeftWalk);
                this.myCurrentIdx = -1;
                for (i = this.myCurrentIdx; i >= 0 && i > maxWalk && i < GenericPatchApplier.this.myLines.size(); --i) {
                    String s = (String)GenericPatchApplier.this.myLines.get(i);
                    if (!this.myLine.equals(s) || this.isSeized(i)) continue;
                    this.myCurrentIdx = i;
                    this.myLeftWalk = i - (maxWalk + 1);
                    break;
                }
            }
        }

        private boolean isSeized(int lineNumber) {
            TextRange art = new TextRange(lineNumber, lineNumber);
            TextRange floor = GenericPatchApplier.this.myTransformations.floorKey(art);
            return floor != null && floor.intersects(art);
        }
    }

    private static abstract class MismatchSolver {
        protected final ArrayList<FirstLineDescriptor> myResult = new ArrayList();
        private final boolean myAllowMismatch;

        protected MismatchSolver(boolean allowMismatch) {
            this.myAllowMismatch = allowMismatch;
        }

        public Iterator<FirstLineDescriptor> getStartLineVariationsIterator() {
            return this.myResult.iterator();
        }

        public boolean isAllowMismatch() {
            return this.myAllowMismatch;
        }
    }

    public static class LongTryMismatchSolver
    extends MismatchSolver {
        public LongTryMismatchSolver(SplitHunk hunk) {
            super(true);
            List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
            int beforeOffset = 0;
            int afterOffset = 0;
            for (int i = 0; i < steps.size() && i < 3; ++i) {
                BeforeAfter<List<String>> list = steps.get(i);
                List before = (List)list.getBefore();
                for (int j = 0; j < before.size() && j < 2; ++j) {
                    String s = (String)before.get(j);
                    this.myResult.add(new FirstLineDescriptor(s, beforeOffset + j, i, j, true));
                }
                List after = (List)list.getAfter();
                for (int j = 0; j < after.size() && j < 2; ++j) {
                    String s = (String)after.get(j);
                    this.myResult.add(new FirstLineDescriptor(s, afterOffset + j, i, j, false));
                }
                beforeOffset += before.size();
                afterOffset += after.size();
            }
        }
    }

    private static class ExactMatchSolver
    extends MismatchSolver {
        private ExactMatchSolver(SplitHunk hunk) {
            super(false);
            List<BeforeAfter<List<String>>> steps = hunk.getPatchSteps();
            BeforeAfter<List<String>> first = steps.get(0);
            if (steps.size() == 1 && ((List)first.getBefore()).isEmpty()) {
                this.myResult.add(new FirstLineDescriptor((String)((List)first.getBefore()).get(0), 0, 0, 0, true));
            }
            if (!((List)first.getBefore()).isEmpty()) {
                this.myResult.add(new FirstLineDescriptor((String)((List)first.getBefore()).get(0), 0, 0, 0, true));
            }
            if (!((List)first.getAfter()).isEmpty()) {
                this.myResult.add(new FirstLineDescriptor((String)((List)first.getAfter()).get(0), 0, 0, 0, false));
            }
            assert (!this.myResult.isEmpty());
        }
    }

    private static class FirstLineDescriptor {
        private final String myLine;
        private final int myOffset;
        private final int myStepNumber;
        private final int myOffsetInStep;
        private final boolean myIsInBefore;

        private FirstLineDescriptor(String line, int offset, int stepNumber, int offsetInStep, boolean isInBefore) {
            this.myLine = line;
            this.myOffset = offset;
            this.myStepNumber = stepNumber;
            this.myOffsetInStep = offsetInStep;
            this.myIsInBefore = isInBefore;
        }

        public String getLine() {
            return this.myLine;
        }

        public int getOffset() {
            return this.myOffset;
        }

        public int getStepNumber() {
            return this.myStepNumber;
        }

        public int getOffsetInStep() {
            return this.myOffsetInStep;
        }

        public boolean isIsInBefore() {
            return this.myIsInBefore;
        }
    }

    private class SequentialStepsChecker
    implements SequenceDescriptor {
        private int myDistance;
        private int myIdx;
        private int myStartIdx;
        private final boolean myForward;
        private boolean myUsesAlreadyApplied;

        private SequentialStepsChecker(int lineNumber, boolean forward) {
            this.myStartIdx = lineNumber;
            this.myIdx = lineNumber;
            this.myForward = forward;
        }

        @Override
        public boolean isUsesAlreadyApplied() {
            return this.myUsesAlreadyApplied;
        }

        @Override
        public int getDistance() {
            return this.myDistance;
        }

        public void go(List<BeforeAfter<List<String>>> steps) {
            Consumer<BeforeAfter<List<String>>> stepConsumer = new Consumer<BeforeAfter<List<String>>>(){

                public void consume(BeforeAfter<List<String>> listBeforeAfter) {
                    if (SequentialStepsChecker.this.myDistance == 0) {
                        if (((List)listBeforeAfter.getBefore()).isEmpty()) {
                            return;
                        }
                        FragmentMatcher fragmentMatcher = new FragmentMatcher(SequentialStepsChecker.this.myIdx, listBeforeAfter);
                        Pair<Integer, Boolean> pair = fragmentMatcher.find(true);
                        SequentialStepsChecker.this.myDistance = (Integer)pair.getFirst();
                        if (SequentialStepsChecker.this.myDistance == 0) {
                            SequentialStepsChecker.this.myIdx = SequentialStepsChecker.this.myIdx + ((Boolean)pair.getSecond() != false ? ((List)listBeforeAfter.getBefore()).size() : ((List)listBeforeAfter.getAfter()).size());
                        } else {
                            SequentialStepsChecker.this.myIdx = SequentialStepsChecker.this.myIdx + (((Boolean)pair.getSecond() != false ? ((List)listBeforeAfter.getBefore()).size() : ((List)listBeforeAfter.getAfter()).size()) - (Integer)pair.getFirst());
                        }
                        SequentialStepsChecker.this.myUsesAlreadyApplied = (Boolean)pair.getSecond() == false;
                    } else {
                        SequentialStepsChecker.this.myDistance = SequentialStepsChecker.this.myDistance + ((List)listBeforeAfter.getBefore()).size();
                    }
                }
            };
            if (this.myForward) {
                for (BeforeAfter<List<String>> step : steps) {
                    stepConsumer.consume(step);
                }
            } else {
                for (int i = steps.size() - 1; i >= 0; --i) {
                    BeforeAfter<List<String>> step = steps.get(i);
                    stepConsumer.consume(step);
                }
            }
        }

        @Override
        public int getSizeOfFragmentToBeReplaced() {
            return this.myForward ? this.myIdx - this.myStartIdx : this.myStartIdx - this.myIdx;
        }
    }

    private static class Point {
        private int myDistance;
        private int myContextDistance;
        private int myCommon;
        private final boolean myUsesAlreadyApplied;
        private TextRange myInOldDocument;

        private Point(int distance, TextRange inOldDocument, boolean usesAlreadyApplied, int contextDistance, int common) {
            this.myDistance = distance;
            this.myInOldDocument = inOldDocument;
            this.myUsesAlreadyApplied = usesAlreadyApplied;
            this.myContextDistance = contextDistance;
            this.myCommon = common;
        }

        public boolean meBetter(Point maxPoint) {
            if (this.myCommon <= 1 && maxPoint.myCommon > 1) {
                return false;
            }
            if (maxPoint.myCommon <= 1 && this.myCommon > 1) {
                return true;
            }
            return this.myDistance < maxPoint.getDistance() || this.myDistance == 0 && maxPoint.getDistance() == 0 && this.myContextDistance < maxPoint.myContextDistance;
        }

        public int getDistance() {
            return this.myDistance;
        }

        public boolean idealFound() {
            return this.myDistance == 0 && this.myContextDistance == 0;
        }

        public TextRange getInOldDocument() {
            return this.myInOldDocument;
        }
    }

    private static class BetterPoint {
        private Point myPoint;

        private BetterPoint() {
        }

        public void feed(@NotNull Point point) {
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/openapi/diff/impl/patch/apply/GenericPatchApplier$BetterPoint", "feed"));
            }
            if (this.myPoint == null || point.meBetter(this.myPoint)) {
                this.myPoint = point;
            }
        }

        public Point getPoint() {
            return this.myPoint;
        }
    }

    private static class FragmentResult {
        private int myStart;
        private int myEnd;
        private boolean myContainAlreadyApplied;
        private int myDistance;
        private boolean myStartAtEdge;
        private boolean myEndAtEdge;

        private FragmentResult(int start, int end, boolean containAlreadyApplied) {
            this.myStart = start;
            this.myEnd = end;
            this.myContainAlreadyApplied = containAlreadyApplied;
            this.myDistance = 0;
        }

        public boolean isStartAtEdge() {
            return this.myStartAtEdge;
        }

        public void setStartAtEdge(boolean startAtEdge) {
            this.myStartAtEdge = startAtEdge;
        }

        public boolean isEndAtEdge() {
            return this.myEndAtEdge;
        }

        public void setEndAtEdge(boolean endAtEdge) {
            this.myEndAtEdge = endAtEdge;
        }

        public void addDistance(int distance) {
            this.myDistance += distance;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public boolean isContainAlreadyApplied() {
            return this.myContainAlreadyApplied;
        }

        public void setStart(int start) {
            this.myStart = start;
        }

        public void setEnd(int end) {
            this.myEnd = end;
        }

        public void setContainAlreadyApplied(boolean containAlreadyApplied) {
            this.myContainAlreadyApplied = containAlreadyApplied;
        }
    }
}

