/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.Nullable;

class MoveCaretLeftOrRightWithSelectionHandler
extends EditorActionHandler {
    private final boolean myMoveRight;

    MoveCaretLeftOrRightWithSelectionHandler(boolean moveRight) {
        super(true);
        this.myMoveRight = moveRight;
    }

    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        assert (caret != null);
        VisualPosition currentPosition = caret.getVisualPosition();
        if (caret.isAtDirectionBoundary() && this.myMoveRight ^ currentPosition.leansRight) {
            int selectionStartToUse = caret.getLeadSelectionOffset();
            VisualPosition selectionStartPositionToUse = caret.getLeadSelectionPosition();
            caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
            caret.setSelection(selectionStartPositionToUse, selectionStartToUse, caret.getVisualPosition(), caret.getOffset());
        } else {
            editor.getCaretModel().moveCaretRelatively(this.myMoveRight ? 1 : -1, 0, true, editor.isColumnMode(), caret == editor.getCaretModel().getPrimaryCaret());
        }
    }
}

