/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplementaryFontsRegistry {
    private static final Object lock = new String("common lock");
    private static final List<String> ourFontNames;
    private static final Map<String, Pair<String, Integer>[]> ourStyledFontMap;
    private static final LinkedHashMap<FontKey, FontInfo> ourUsedFonts;
    private static FontKey ourSharedKeyInstance;
    private static FontInfo ourSharedDefaultFont;
    private static final TIntHashSet ourUndisplayableChars;
    private static boolean ourOldUseAntialiasing;
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";

    private ComplementaryFontsRegistry() {
    }

    private static void fillStyledFontMap() {
        Font[] allFonts;
        for (Font font : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            String name = font.getName();
            int style = name.endsWith("-Italic") ? 2 : (name.endsWith("-Bold") ? 1 : (name.endsWith("-BoldItalic") ? 3 : 0));
            if (style == 0) continue;
            String baseName = name.substring(0, name.lastIndexOf(45));
            Pair<String, Integer>[] entry = ourStyledFontMap.get(baseName);
            if (entry == null) {
                entry = new Pair[4];
                for (int i = 1; i < 4; ++i) {
                    entry[i] = Pair.create((Object)baseName, (Object)i);
                }
                ourStyledFontMap.put(baseName, entry);
            }
            entry[style] = Pair.create((Object)name, (Object)0);
        }
    }

    private static Pair<String, Integer> fontFamily(String familyName, int style) {
        Pair<String, Integer>[] replacement;
        if (SystemInfo.isMac && style > 0 && style < 4 && (replacement = ourStyledFontMap.get(familyName)) != null) {
            familyName = (String)replacement[style].first;
            style = (Integer)replacement[style].second;
        }
        return Pair.create((Object)familyName, (Object)style);
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(char c, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences) {
        FontInfo result;
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        boolean tryDefaultFont = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        int len = fontFamilies.size();
        for (int i = 0; i < len; ++i) {
            String fontFamily = (String)fontFamilies.get(i);
            result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(c, preferences.getSize(fontFamily), style, fontFamily);
            if (result != null) {
                FontInfo fontInfo = result;
                if (fontInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
                }
                return fontInfo;
            }
            tryDefaultFont &= !FontPreferences.DEFAULT_FONT_NAME.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFont && (result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(c, size, style, FontPreferences.DEFAULT_FONT_NAME)) != null) {
            FontInfo fontInfo = result;
            if (fontInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
            }
            return fontInfo;
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.doGetFontAbleToDisplay(c, size, style);
        if (fontInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(char c, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily) {
        if (defaultFontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultFontFamily", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        FontInfo result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(c, size, style, defaultFontFamily);
        if (result != null) {
            FontInfo fontInfo = result;
            if (fontInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
            }
            return fontInfo;
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.doGetFontAbleToDisplay(c, size, style);
        if (fontInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FontInfo doGetFontAbleToDisplay(char c, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily) {
        if (defaultFontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultFontFamily", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
        }
        Object object = lock;
        synchronized (object) {
            Pair<String, Integer> p = ComplementaryFontsRegistry.fontFamily(defaultFontFamily, style);
            if (ComplementaryFontsRegistry.ourSharedKeyInstance.mySize == size && ComplementaryFontsRegistry.ourSharedKeyInstance.myStyle == (Integer)p.getSecond() && ComplementaryFontsRegistry.ourSharedKeyInstance.myFamilyName != null && ComplementaryFontsRegistry.ourSharedKeyInstance.myFamilyName.equals(p.getFirst()) && ourSharedDefaultFont != null && (c < '\u0080' || ourSharedDefaultFont.canDisplay(c))) {
                return ourSharedDefaultFont;
            }
            ComplementaryFontsRegistry.ourSharedKeyInstance.myFamilyName = (String)p.getFirst();
            ComplementaryFontsRegistry.ourSharedKeyInstance.mySize = size;
            ComplementaryFontsRegistry.ourSharedKeyInstance.myStyle = (Integer)p.getSecond();
            FontInfo defaultFont = ourUsedFonts.get(ourSharedKeyInstance);
            if (defaultFont == null) {
                defaultFont = new FontInfo((String)p.getFirst(), size, (Integer)p.getSecond());
                ourUsedFonts.put(ourSharedKeyInstance, defaultFont);
                ourSharedKeyInstance = new FontKey("", 0, 0);
            }
            ourSharedDefaultFont = defaultFont;
            if (c < '\u0080' || defaultFont.canDisplay(c)) {
                return defaultFont;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static FontInfo doGetFontAbleToDisplay(char c, int size, @JdkConstants.FontStyle int style) {
        FontInfo fontInfo;
        Object object = lock;
        synchronized (object) {
            if (ourUndisplayableChars.contains((int)c)) {
                FontInfo fontInfo2 = ourSharedDefaultFont;
                // MONITOREXIT @DISABLED, blocks:[4, 10] lbl5 : MonitorExitStatement: MONITOREXIT : var3_3
                if (fontInfo2 != null) return fontInfo2;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
            }
            Collection<FontInfo> descriptors = ourUsedFonts.values();
            for (FontInfo font : descriptors) {
                if (font.getSize() != size || font.getStyle() != style || !font.canDisplay(c)) continue;
                FontInfo fontInfo3 = font;
                // MONITOREXIT @DISABLED, blocks:[4, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                if (fontInfo3 != null) return fontInfo3;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
            }
            for (int i = 0; i < ourFontNames.size(); ++i) {
                String name = ourFontNames.get(i);
                FontInfo font = new FontInfo(name, size, style);
                if (!font.canDisplay(c)) continue;
                ourUsedFonts.put(new FontKey(name, size, style), font);
                ourFontNames.remove(i);
                FontInfo fontInfo4 = font;
                // MONITOREXIT @DISABLED, blocks:[4, 6] lbl26 : MonitorExitStatement: MONITOREXIT : var3_3
                if (fontInfo4 != null) return fontInfo4;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
            }
            ourUndisplayableChars.add((int)c);
            fontInfo = ourSharedDefaultFont;
        }
        if (fontInfo != null) return fontInfo;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
    }

    static {
        ourStyledFontMap = new HashMap<String, Pair<String, Integer>[]>();
        ourSharedKeyInstance = new FontKey("", 0, 0);
        ourUndisplayableChars = new TIntHashSet();
        UISettings settings = UISettings.getInstance();
        ourOldUseAntialiasing = settings.ANTIALIASING_IN_EDITOR;
        settings.addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                if (ourOldUseAntialiasing ^ source.ANTIALIASING_IN_EDITOR) {
                    ourOldUseAntialiasing = source.ANTIALIASING_IN_EDITOR;
                    for (FontInfo fontInfo : ourUsedFonts.values()) {
                        fontInfo.reset();
                    }
                    ourUsedFonts.clear();
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
        ourFontNames = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourFontNames.add("Monospaced");
        } else {
            String[] fontNames;
            if (SystemInfo.isMac) {
                ComplementaryFontsRegistry.fillStyledFontMap();
            }
            for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX)) continue;
                ourFontNames.add(fontName);
            }
        }
        ourUsedFonts = new LinkedHashMap();
    }

    private static class FontKey {
        public String myFamilyName;
        public int mySize;
        public int myStyle;

        public FontKey(@NotNull String familyName, int size, @JdkConstants.FontStyle int style) {
            if (familyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry$FontKey", "<init>"));
            }
            this.myFamilyName = familyName;
            this.mySize = size;
            this.myStyle = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            FontKey fontKey = (FontKey)o;
            if (this.mySize != fontKey.mySize) {
                return false;
            }
            if (this.myStyle != fontKey.myStyle) {
                return false;
            }
            return this.myFamilyName.equals(fontKey.myFamilyName);
        }

        public int hashCode() {
            int result = this.myFamilyName.hashCode();
            result = 29 * result + this.mySize;
            result = 29 * result + this.myStyle;
            return result;
        }
    }
}

