/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditorBase;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class KeymapListModelEditor<T extends Keymap>
extends ListModelEditorBase<T> {
    private final ComboBox comboBox;

    public KeymapListModelEditor(@NotNull ListItemEditor<T> itemEditor) {
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/openapi/keymap/impl/ui/KeymapListModelEditor", "<init>"));
        }
        super(itemEditor);
        this.comboBox = new ComboBox((ComboBoxModel)((Object)this.model));
        this.comboBox.setEditor((ComboBoxEditor)((Object)new MyEditor()));
        this.comboBox.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
    }

    @Override
    @NotNull
    public MutableCollectionComboBoxModel<T> getModel() {
        ListModelEditorBase.MyModel myModel = this.model;
        if (myModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapListModelEditor", "getModel"));
        }
        return myModel;
    }

    @NotNull
    public ComboBox getComboBox() {
        ComboBox comboBox = this.comboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapListModelEditor", "getComboBox"));
        }
        return comboBox;
    }

    private class MyListCellRenderer
    extends ListCellRendererWrapper<T> {
        private MyListCellRenderer() {
        }

        public void customize(JList list, T item, int index, boolean selected, boolean hasFocus) {
            if (item != null) {
                this.setText(((ListItemEditor)KeymapListModelEditor.this.itemEditor).getName(item));
            }
        }
    }

    private class MyEditor
    extends FixedComboBoxEditor {
        private T item = null;
        private boolean mutated;

        public MyEditor() {
            this.getField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (MyEditor.this.item != null && MyEditor.this.item.canModify()) {
                        String newName = MyEditor.this.getField().getText();
                        if (newName.equals(MyEditor.this.item.getName())) {
                            return;
                        }
                        if (!MyEditor.this.mutated) {
                            MyEditor.this.mutated = true;
                            MyEditor.this.item = KeymapListModelEditor.this.getMutable(MyEditor.this.item);
                        }
                        ((KeymapImpl)MyEditor.this.item).setName(newName);
                    }
                }
            });
        }

        public void setItem(Object newItem) {
            if (newItem != null && newItem != this.item) {
                this.item = (Keymap)newItem;
                this.mutated = false;
                this.getField().setText(((ListItemEditor)KeymapListModelEditor.this.itemEditor).getName(this.item));
            }
        }

        public Object getItem() {
            return this.item;
        }
    }
}

