/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListModelEditor;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private static final Condition<Keymap> KEYMAP_FILTER = new Condition<Keymap>(){

        public boolean value(Keymap keymap) {
            return !SystemInfo.isMac || !"$default".equals(keymap.getName());
        }
    };
    private final KeymapListModelEditor<Keymap> myEditor = new KeymapListModelEditor<Keymap>(new ListItemEditor<Keymap>(){

        @Override
        @NotNull
        public String getName(@NotNull Keymap item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "getName"));
            }
            String name = item.getPresentableName();
            String string = name == null ? KeyMapBundle.message((String)"keymap.noName.presentable.name", (Object[])new Object[0]) : name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public Class<? extends Keymap> getItemClass() {
            if (KeymapImpl.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "getItemClass"));
            }
            return KeymapImpl.class;
        }

        @Override
        public Keymap clone(@NotNull Keymap item, boolean forInPlaceEditing) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "clone"));
            }
            return ((KeymapImpl)item).copy();
        }

        @Override
        public void applyModifiedProperties(@NotNull Keymap newItem, @NotNull Keymap oldItem) {
            if (newItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newItem", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "applyModifiedProperties"));
            }
            if (oldItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItem", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "applyModifiedProperties"));
            }
            ((KeymapImpl)newItem).copyTo((KeymapImpl)oldItem);
        }

        @Override
        public boolean isRemovable(@NotNull Keymap item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "isRemovable"));
            }
            return item.canModify();
        }

        @Override
        public boolean isEditable(@NotNull Keymap item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "isEditable"));
            }
            return item.canModify();
        }
    });
    private Keymap mySelectedKeymap;
    private JButton myCopyButton;
    private JButton myDeleteButton;
    private JButton myResetToDefault;
    private JCheckBox myNonEnglishKeyboardSupportOption;
    private JLabel myBaseKeymapLabel;
    private ActionsTree myActionsTree;
    private FilterComponent myFilterComponent;
    private JBPopup myPopup = null;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();

    public KeymapPanel() {
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add((Component)this.createKeymapListPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$3", "propertyChange"));
                }
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.processCurrentKeymapChanged(KeymapPanel.this.myQuickLists);
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
    }

    @Override
    public void quickListRenamed(QuickList oldQuickList, QuickList newQuickList) {
        for (Keymap keymap : this.myEditor.getModel().getItems()) {
            String actionId;
            Shortcut[] shortcuts = keymap.getShortcuts(actionId = oldQuickList.getActionId());
            if (shortcuts.length == 0) continue;
            String newActionId = newQuickList.getActionId();
            for (Shortcut shortcut : shortcuts) {
                keymap.removeShortcut(actionId, shortcut);
                keymap.addShortcut(newActionId, shortcut);
            }
        }
        this.myQuickListsModified = true;
    }

    private JPanel createKeymapListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel keymapLabel = new JLabel(KeyMapBundle.message((String)"keymaps.border.factory.title", (Object[])new Object[0]));
        keymapLabel.setLabelFor((Component)this.myEditor.getComboBox());
        panel.add((Component)keymapLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.myEditor.getComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.createKeymapButtonsPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myEditor.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$4", "actionPerformed"));
                }
                if (KeymapPanel.this.myEditor.getModel().getSelectedItem() != KeymapPanel.this.mySelectedKeymap) {
                    KeymapPanel.this.processCurrentKeymapChanged(KeymapPanel.this.myQuickLists);
                }
            }
        });
        panel.add((Component)this.createKeymapNamePanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                KeymapPanel.this.showOption(option);
            }
        };
    }

    @Override
    public void processCurrentKeymapChanged(@NotNull QuickList[] ids) {
        Keymap selectedKeymap;
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/openapi/keymap/impl/ui/KeymapPanel", "processCurrentKeymapChanged"));
        }
        this.myQuickLists = ids;
        this.myResetToDefault.setEnabled(false);
        this.mySelectedKeymap = selectedKeymap = (Keymap)this.myEditor.getModel().getSelected();
        boolean editable = selectedKeymap != null && selectedKeymap.canModify();
        this.myDeleteButton.setEnabled(editable);
        this.myCopyButton.setEnabled(selectedKeymap != null);
        this.myEditor.getComboBox().setEditable(editable);
        if (selectedKeymap == null) {
            this.myActionsTree.reset(new KeymapImpl(), this.myQuickLists);
            return;
        }
        Keymap parent = selectedKeymap.getParent();
        if (parent == null || !selectedKeymap.canModify()) {
            this.myBaseKeymapLabel.setText("");
        } else {
            this.myBaseKeymapLabel.setText(KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{parent.getPresentableName()}));
            if (selectedKeymap.canModify() && ((KeymapImpl)this.mySelectedKeymap).getOwnActionIds().length > 0) {
                this.myResetToDefault.setEnabled(true);
            }
        }
        this.resetActionsTree(selectedKeymap);
    }

    private void resetActionsTree(@NotNull Keymap keymap) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/ui/KeymapPanel", "resetActionsTree"));
        }
        this.myActionsTree.reset(this.myEditor.getMutable(keymap), this.myQuickLists);
    }

    private JPanel createKeymapButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        panel.setLayout(new GridBagLayout());
        this.myCopyButton = new JButton(new AbstractAction(KeyMapBundle.message((String)"copy.keymap.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.copyKeymap();
            }
        });
        Insets insets = new Insets(2, 2, 2, 2);
        this.myCopyButton.setMargin(insets);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        panel.add((Component)this.myCopyButton, gc);
        this.myResetToDefault = new JButton(CommonBundle.message((String)"button.reset", (Object[])new Object[0]));
        this.myResetToDefault.setMargin(insets);
        panel.add((Component)this.myResetToDefault, gc);
        this.myDeleteButton = new JButton(new AbstractAction(KeyMapBundle.message((String)"delete.keymap.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.deleteKeymap();
            }
        });
        this.myDeleteButton.setMargin(insets);
        gc.weightx = 1.0;
        panel.add((Component)this.myDeleteButton, gc);
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && KeyboardSettingsExternalizable.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            String displayLanguage = ideFrame.getComponent().getInputContext().getLocale().getDisplayLanguage();
            this.myNonEnglishKeyboardSupportOption = new JCheckBox(new AbstractAction(displayLanguage + " " + KeyMapBundle.message((String)"use.non.english.keyboard.layout.support", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(KeymapPanel.this.myNonEnglishKeyboardSupportOption.isSelected());
                }
            });
            this.myNonEnglishKeyboardSupportOption.setSelected(KeyboardSettingsExternalizable.getInstance().isNonEnglishKeyboardSupportEnabled());
            panel.add((Component)this.myNonEnglishKeyboardSupportOption, gc);
        }
        this.myResetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$9", "actionPerformed"));
                }
                KeymapPanel.this.resetKeymap();
            }
        });
        return panel;
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.myActionsTree = new ActionsTree();
        panel.add((Component)this.createToolbarPanel(), "North");
        panel.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                KeymapPanel.this.editSelection(e);
                return true;
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$11", "mousePressed"));
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$11", "mouseReleased"));
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e);
                    e.consume();
                }
            }
        });
        return panel;
    }

    private JPanel createToolbarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)KeymapPanel.this.myActionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(new AnAction("Edit Shortcut", "Edit Shortcut", AllIcons.ToolbarDecorator.Edit){
            {
                this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$13", "update"));
                }
                String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                e.getPresentation().setEnabled(actionId != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$13", "actionPerformed"));
                }
                KeymapPanel.this.editSelection(e.getInputEvent());
            }
        });
        panel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        group = new DefaultActionGroup();
        final JComponent searchToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                            return;
                        }
                        KeymapPanel.this.myTreeExpansionMonitor.freeze();
                        String filter = this.getFilter();
                        KeymapPanel.this.myActionsTree.filter(filter, KeymapPanel.this.myQuickLists);
                        JTree tree = KeymapPanel.this.myActionsTree.getTree();
                        TreeUtil.expandAll((JTree)tree);
                        if (filter == null || filter.length() == 0) {
                            TreeUtil.collapseAll((JTree)tree, (int)0);
                            KeymapPanel.this.myTreeExpansionMonitor.restore();
                        } else {
                            KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                        }
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$15", "actionPerformed"));
                }
                KeymapPanel.this.myFilterComponent.reset();
                if (KeymapPanel.this.myPopup == null || KeymapPanel.this.myPopup.getContent() == null) {
                    KeymapPanel.this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)KeymapPanel.this.createFilteringPanel(), null).setRequestFocus(true).setTitle(KeyMapBundle.message((String)"filter.settings.popup.title", (Object[])new Object[0])).setCancelKeyEnabled(false).setMovable(true).createPopup();
                }
                KeymapPanel.this.myPopup.showUnderneathOf((Component)searchToolbar);
            }
        });
        group.add((AnAction)new DumbAwareAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), AllIcons.Actions.GC){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$16", "actionPerformed"));
                }
                KeymapPanel.this.myTreeExpansionMonitor.freeze();
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }
        });
        panel.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createKeymapNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myBaseKeymapLabel = new JLabel(KeyMapBundle.message((String)"parent.keymap.label", (Object[])new Object[0]));
        panel.add((Component)this.myBaseKeymapLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createFilteringPanel() {
        this.resetActionsTree((Keymap)this.myEditor.getModel().getSelected());
        JLabel firstLabel = new JLabel(KeyMapBundle.message((String)"filter.first.stroke.input", (Object[])new Object[0]));
        final JCheckBox enable2Shortcut = new JCheckBox(KeyMapBundle.message((String)"filter.second.stroke.input", (Object[])new Object[0]));
        final ShortcutTextField firstShortcut = new ShortcutTextField();
        final ShortcutTextField secondShortcut = new ShortcutTextField();
        enable2Shortcut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$17", "actionPerformed"));
                }
                secondShortcut.setEnabled(enable2Shortcut.isSelected());
                if (enable2Shortcut.isSelected()) {
                    secondShortcut.requestFocusInWindow();
                }
            }
        });
        firstShortcut.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                KeymapPanel.this.filterTreeByShortcut(firstShortcut, enable2Shortcut, secondShortcut);
            }
        });
        secondShortcut.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                KeymapPanel.this.filterTreeByShortcut(firstShortcut, enable2Shortcut, secondShortcut);
            }
        });
        IJSwingUtilities.adjustComponentsOnMac(firstLabel, firstShortcut);
        JPanel filterComponent = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)firstLabel, (JComponent)firstShortcut, true).addComponent((JComponent)enable2Shortcut).setVerticalGap(0).setIndent(5).addComponent((JComponent)secondShortcut).getPanel();
        filterComponent.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        enable2Shortcut.setSelected(false);
        secondShortcut.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                firstShortcut.requestFocus();
            }
        });
        return filterComponent;
    }

    private void filterTreeByShortcut(ShortcutTextField firstShortcut, JCheckBox enable2Shortcut, ShortcutTextField secondShortcut) {
        KeyStroke keyStroke = firstShortcut.getKeyStroke();
        if (keyStroke != null) {
            this.myTreeExpansionMonitor.freeze();
            this.myActionsTree.filterTree(new KeyboardShortcut(keyStroke, enable2Shortcut.isSelected() ? secondShortcut.getKeyStroke() : null), this.myQuickLists);
            JTree tree = this.myActionsTree.getTree();
            TreeUtil.expandAll((JTree)tree);
            this.myTreeExpansionMonitor.restore();
        }
    }

    public void showOption(String option) {
        this.createFilteringPanel();
        this.myFilterComponent.setFilter(option);
        this.myActionsTree.filter(option, this.myQuickLists);
    }

    private void addKeyboardShortcut(Shortcut shortcut) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        if (!this.createKeymapCopyIfNeeded()) {
            return;
        }
        KeyboardShortcutDialog dialog = new KeyboardShortcutDialog(this, actionId, this.myQuickLists);
        KeyboardShortcut selectedKeyboardShortcut = shortcut instanceof KeyboardShortcut ? (KeyboardShortcut)shortcut : null;
        dialog.setData(this.mySelectedKeymap, selectedKeyboardShortcut);
        if (!dialog.showAndGet()) {
            return;
        }
        KeyboardShortcut keyboardShortcut = dialog.getKeyboardShortcut();
        if (keyboardShortcut == null) {
            return;
        }
        Map conflicts = this.mySelectedKeymap.getConflicts(actionId, keyboardShortcut);
        if (!conflicts.isEmpty()) {
            int result = Messages.showYesNoCancelDialog((Component)this, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (result == 0) {
                for (String id : conflicts.keySet()) {
                    for (Shortcut s : (ArrayList)conflicts.get(id)) {
                        this.mySelectedKeymap.removeShortcut(id, s);
                    }
                }
            } else if (result != 1) {
                return;
            }
        }
        Shortcut[] shortcuts = this.mySelectedKeymap.getShortcuts(actionId);
        for (Shortcut s : shortcuts) {
            if (!s.equals(keyboardShortcut)) continue;
            return;
        }
        this.mySelectedKeymap.addShortcut(actionId, (Shortcut)keyboardShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)keyboardShortcut);
        }
        this.repaintLists();
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    private void addMouseShortcut(Shortcut shortcut, ShortcutRestrictions restrictions) {
        Shortcut[] shortcuts;
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        if (!this.createKeymapCopyIfNeeded()) {
            return;
        }
        MouseShortcut mouseShortcut = shortcut instanceof MouseShortcut ? (MouseShortcut)shortcut : null;
        MouseShortcutDialog dialog = new MouseShortcutDialog(this, mouseShortcut, this.mySelectedKeymap, actionId, this.myActionsTree.getMainGroup(), restrictions);
        if (!dialog.showAndGet()) {
            return;
        }
        mouseShortcut = dialog.getMouseShortcut();
        if (mouseShortcut == null) {
            return;
        }
        String[] actionIds = this.mySelectedKeymap.getActionIds(mouseShortcut);
        if (actionIds.length > 1 || actionIds.length == 1 && !actionId.equals(actionIds[0])) {
            int result = Messages.showYesNoCancelDialog((Component)this, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (result == 0) {
                for (String string : actionIds) {
                    this.mySelectedKeymap.removeShortcut(string, (Shortcut)mouseShortcut);
                }
            } else if (result != 1) {
                return;
            }
        }
        for (Shortcut shortcut2 : shortcuts = this.mySelectedKeymap.getShortcuts(actionId)) {
            if (!shortcut2.equals(mouseShortcut)) continue;
            return;
        }
        this.mySelectedKeymap.addShortcut(actionId, (Shortcut)mouseShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)mouseShortcut);
        }
        this.repaintLists();
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    private boolean createKeymapCopyIfNeeded() {
        if (this.mySelectedKeymap.canModify()) {
            return true;
        }
        Keymap selectedKeymap = (Keymap)this.myEditor.getModel().getSelected();
        if (selectedKeymap == null) {
            return false;
        }
        KeymapImpl newKeymap = ((KeymapImpl)selectedKeymap).deriveKeymap();
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{selectedKeymap.getPresentableName()});
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{selectedKeymap.getPresentableName(), i}))) {
                ++i;
            }
        }
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        int indexOf = this.myEditor.getModel().getElementIndex((Object)selectedKeymap);
        if (indexOf >= 0) {
            this.myEditor.getModel().add(indexOf + 1, (Object)newKeymap);
        } else {
            this.myEditor.getModel().add((Object)newKeymap);
        }
        this.myEditor.getModel().setSelectedItem((Object)newKeymap);
        this.processCurrentKeymapChanged(this.myQuickLists);
        return true;
    }

    private void removeShortcut(Shortcut shortcut) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        if (!this.createKeymapCopyIfNeeded()) {
            return;
        }
        if (shortcut == null) {
            return;
        }
        this.mySelectedKeymap.removeShortcut(actionId, shortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
        }
        this.repaintLists();
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    private void copyKeymap() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        if (keymap == null) {
            return;
        }
        KeymapImpl newKeymap = ((KeymapImpl)keymap).deriveKeymap();
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{keymap.getPresentableName(), i}))) {
                ++i;
            }
        }
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        this.myEditor.getModel().add((Object)newKeymap);
        this.myEditor.getModel().setSelectedItem((Object)newKeymap);
        this.myEditor.getComboBox().getEditor().selectAll();
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    private boolean tryNewKeymapName(String name) {
        for (int i = 0; i < this.myEditor.getModel().getSize(); ++i) {
            if (!name.equals(((Keymap)this.myEditor.getModel().getElementAt(i)).getPresentableName())) continue;
            return false;
        }
        return true;
    }

    private void deleteKeymap() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        if (keymap == null || Messages.showYesNoDialog((Component)this, (String)KeyMapBundle.message((String)"delete.keymap.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"delete.keymap.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        this.myEditor.getModel().remove((Object)keymap);
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    private void resetKeymap() {
        Keymap keymap = (Keymap)this.myEditor.getModel().getSelected();
        if (keymap == null) {
            return;
        }
        ((KeymapImpl)keymap).clearOwnActionsIds();
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    @NotNull
    public String getId() {
        if ("preferences.keymap" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapPanel", "getId"));
        }
        return "preferences.keymap";
    }

    public void reset() {
        if (this.myNonEnglishKeyboardSupportOption != null) {
            KeyboardSettingsExternalizable.getInstance().setNonEnglishKeyboardSupportEnabled(false);
            this.myNonEnglishKeyboardSupportOption.setSelected(KeyboardSettingsExternalizable.getInstance().isNonEnglishKeyboardSupportEnabled());
        }
        this.mySelectedKeymap = null;
        List<Keymap> list = KeymapPanel.getManagerKeymaps();
        for (Keymap keymap : list) {
            if (this.mySelectedKeymap != null || keymap != KeymapManagerEx.getInstanceEx().getActiveKeymap()) continue;
            this.mySelectedKeymap = keymap;
        }
        this.myEditor.reset(list);
        if (this.myEditor.getModel().isEmpty()) {
            KeymapImpl keymap = new KeymapImpl();
            keymap.setName(KeyMapBundle.message((String)"keymap.no.name", (Object[])new Object[0]));
            this.myEditor.getModel().add((Object)keymap);
            this.mySelectedKeymap = keymap;
        }
        this.myEditor.getModel().setSelectedItem((Object)this.mySelectedKeymap);
        this.processCurrentKeymapChanged(this.myQuickLists);
    }

    public void apply() throws ConfigurationException {
        this.myEditor.ensureNonEmptyNames("Quick list should have non empty name");
        this.ensureUniqueKeymapNames();
        KeymapManagerImpl keymapManager = (KeymapManagerImpl)KeymapManager.getInstance();
        keymapManager.setKeymaps(this.myEditor.apply(), KEYMAP_FILTER);
        keymapManager.setActiveKeymap(this.mySelectedKeymap);
        ActionToolbarImpl.updateAllToolbarsImmediately();
    }

    private void ensureUniqueKeymapNames() throws ConfigurationException {
        THashSet keymapNames = new THashSet();
        for (Keymap keymap : this.myEditor.getModel().getItems()) {
            if (keymapNames.add(keymap.getName())) continue;
            throw new ConfigurationException(KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]));
        }
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.mySelectedKeymap, (Object)KeymapManager.getInstance().getActiveKeymap()) || this.myEditor.isModified();
    }

    @NotNull
    private static List<Keymap> getManagerKeymaps() {
        List<Keymap> list = ((KeymapManagerImpl)KeymapManagerEx.getInstanceEx()).getKeymaps(KEYMAP_FILTER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapPanel", "getManagerKeymaps"));
        }
        return list;
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public Shortcut[] getCurrentShortcuts(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/keymap/impl/ui/KeymapPanel", "getCurrentShortcuts"));
        }
        return this.mySelectedKeymap == null ? null : this.mySelectedKeymap.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e) {
        final String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        final Shortcut[] shortcuts = this.getCurrentShortcuts(actionId);
        Set abbreviations = AbbreviationManager.getInstance().getAbbreviations(actionId);
        final ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Keyboard Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$21", "actionPerformed"));
                    }
                    Shortcut firstKeyboard = null;
                    assert (shortcuts != null);
                    for (Shortcut shortcut : shortcuts) {
                        if (!(shortcut instanceof KeyboardShortcut)) continue;
                        firstKeyboard = shortcut;
                        break;
                    }
                    KeymapPanel.this.addKeyboardShortcut(firstKeyboard);
                }
            });
        }
        if (restrictions.allowMouseShortcut) {
            group.add((AnAction)new DumbAwareAction("Add Mouse Shortcut"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$22", "actionPerformed"));
                    }
                    Shortcut firstMouse = null;
                    assert (shortcuts != null);
                    for (Shortcut shortcut : shortcuts) {
                        if (!(shortcut instanceof MouseShortcut)) continue;
                        firstMouse = shortcut;
                        break;
                    }
                    KeymapPanel.this.addMouseShortcut(firstMouse, restrictions);
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group.add((AnAction)new DumbAwareAction("Add Abbreviation"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$23", "actionPerformed"));
                    }
                    String abbr = Messages.showInputDialog((String)"Enter new abbreviation:", (String)"Abbreviation", null);
                    if (abbr != null) {
                        String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
                        AbbreviationManager.getInstance().register(abbr, actionId);
                        KeymapPanel.this.repaintLists();
                    }
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$23", "update"));
                    }
                    e.getPresentation().setEnabledAndVisible(KeymapPanel.this.myActionsTree.getSelectedActionId() != null);
                }
            });
        }
        group.addSeparator();
        assert (shortcuts != null);
        for (final Shortcut shortcut : shortcuts) {
            group.add((AnAction)new DumbAwareAction("Remove " + KeymapUtil.getShortcutText((Shortcut)shortcut)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$24", "actionPerformed"));
                    }
                    KeymapPanel.this.removeShortcut(shortcut);
                }
            });
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (final String abbreviation : abbreviations) {
                group.addAction((AnAction)new DumbAwareAction("Remove Abbreviation '" + abbreviation + "'"){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$25", "actionPerformed"));
                        }
                        AbbreviationManager.getInstance().remove(abbreviation, actionId);
                        KeymapPanel.this.repaintLists();
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$25", "update"));
                        }
                        super.update(e);
                    }
                });
            }
        }
        group.add((AnAction)new Separator());
        group.add((AnAction)new DumbAwareAction("Reset Shortcuts"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$26", "actionPerformed"));
                }
                ((KeymapImpl)KeymapPanel.this.mySelectedKeymap).clearOwnActionsId(actionId);
                KeymapPanel.this.processCurrentKeymapChanged(KeymapPanel.this.myQuickLists);
                KeymapPanel.this.repaintLists();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$26", "update"));
                }
                e.getPresentation().setVisible(KeymapPanel.this.mySelectedKeymap.canModify() && ((KeymapImpl)KeymapPanel.this.mySelectedKeymap).hasOwnActionId(actionId));
                super.update(e);
            }
        });
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
            popupMenu.getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Edit Shortcuts", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        }
    }
}

