/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.options.SchemesManagerImpl;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SchemesManagerFactoryImpl
extends SchemesManagerFactory
implements SettingsSavingComponent {
    private static final Logger LOG = Logger.getInstance(SchemesManagerFactoryImpl.class);
    private final List<SchemesManagerImpl> myRegisteredManagers = ContainerUtil.createLockFreeCopyOnWriteList();

    @NotNull
    public <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        StateStorageManager storageManager = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager();
        String baseDirPath = storageManager.expandMacros(fileSpec);
        StreamProvider provider = storageManager.getStreamProvider();
        SchemesManagerImpl manager = new SchemesManagerImpl(fileSpec, processor, roamingType, provider, new File(baseDirPath));
        this.myRegisteredManagers.add(manager);
        SchemesManagerImpl schemesManagerImpl = manager;
        if (schemesManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "createSchemesManager"));
        }
        return schemesManagerImpl;
    }

    public void process(@NotNull Consumer<SchemesManagerImpl> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactoryImpl", "process"));
        }
        for (SchemesManagerImpl manager : this.myRegisteredManagers) {
            try {
                processor.consume((Object)manager);
            }
            catch (Throwable e) {
                LOG.error("Cannot reload settings for " + ((Object)((Object)manager)).getClass().getName(), e);
            }
        }
    }

    public void save() {
        List errors = null;
        for (SchemesManager schemesManager : this.myRegisteredManagers) {
            try {
                schemesManager.save();
            }
            catch (Throwable e) {
                if (errors == null) {
                    errors = new SmartList();
                }
                errors.add(e);
            }
        }
        CompoundRuntimeException.doThrow(errors);
    }
}

