/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactoryImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SchemesManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends SchemesManager<T, E>
implements SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance(SchemesManagerFactoryImpl.class);
    private final ArrayList<T> mySchemes;
    private volatile T myCurrentScheme;
    @Nullable
    private String myCurrentSchemeName;
    private final String myFileSpec;
    private final SchemeProcessor<E> myProcessor;
    private final RoamingType myRoamingType;
    private final StreamProvider provider;
    private final File myIoDir;
    private VirtualFile myDir;
    private final String mySchemeExtension;
    private final boolean myUpdateExtension;
    private final Set<String> filesToDelete;
    private final THashMap<ExternalizableScheme, ExternalInfo> schemeToInfo;

    public SchemesManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType, @Nullable StreamProvider provider, @NotNull File baseDir) {
        VirtualFileTracker virtualFileTracker;
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        this.mySchemes = new ArrayList();
        this.filesToDelete = new THashSet();
        this.schemeToInfo = new THashMap(TObjectHashingStrategy.IDENTITY);
        this.myFileSpec = fileSpec;
        this.myProcessor = processor;
        this.myRoamingType = roamingType;
        this.provider = provider;
        this.myIoDir = baseDir;
        if (processor instanceof SchemeExtensionProvider) {
            this.mySchemeExtension = ((SchemeExtensionProvider)processor).getSchemeExtension();
            this.myUpdateExtension = ((SchemeExtensionProvider)processor).isUpgradeNeeded();
        } else {
            this.mySchemeExtension = ".xml";
            this.myUpdateExtension = false;
        }
        Application application = ApplicationManager.getApplication();
        VirtualFileTracker virtualFileTracker2 = virtualFileTracker = application == null ? null : (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class);
        if (virtualFileTracker != null) {
            String baseDirPath = this.myIoDir.getAbsolutePath().replace(File.separatorChar, '/');
            virtualFileTracker.addTracker("file://" + baseDirPath, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    ExternalizableScheme readScheme;
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "contentsChanged"));
                    }
                    if (event.getRequestor() != null || !SchemesManagerImpl.this.isMy(event)) {
                        return;
                    }
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findExternalizableSchemeByFileName(event.getFile().getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        SchemesManagerImpl.this.removeScheme(scheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    if ((readScheme = SchemesManagerImpl.this.readSchemeFromFile(event.getFile(), null)) != null) {
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                        Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        if (oldCurrentScheme != null && newCurrentScheme == null) {
                            SchemesManagerImpl.this.setCurrentSchemeName(readScheme.getName());
                            newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        }
                        if (oldCurrentScheme != newCurrentScheme) {
                            SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                        }
                    }
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "fileCreated"));
                    }
                    if (event.getRequestor() == null) {
                        if (event.getFile().isDirectory()) {
                            VirtualFile dir = SchemesManagerImpl.this.getDirectory();
                            if (event.getFile().equals(dir)) {
                                for (VirtualFile file : dir.getChildren()) {
                                    if (!SchemesManagerImpl.this.isMy(file)) continue;
                                    this.schemeCreatedExternally(file);
                                }
                            }
                        } else if (SchemesManagerImpl.this.isMy(event)) {
                            this.schemeCreatedExternally(event.getFile());
                        }
                    }
                }

                private void schemeCreatedExternally(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl$1", "schemeCreatedExternally"));
                    }
                    ExternalizableScheme readScheme = SchemesManagerImpl.this.readSchemeFromFile(file, null);
                    if (readScheme != null) {
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                    }
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "fileDeleted"));
                    }
                    if (event.getRequestor() == null) {
                        if (event.getFile().isDirectory()) {
                            VirtualFile dir = SchemesManagerImpl.this.myDir;
                            if (event.getFile().equals(dir)) {
                                SchemesManagerImpl.this.myDir = null;
                                for (VirtualFile file : dir.getChildren()) {
                                    if (!SchemesManagerImpl.this.isMy(file)) continue;
                                    this.schemeDeletedExternally(file);
                                }
                            }
                        } else if (SchemesManagerImpl.this.isMy(event)) {
                            this.schemeDeletedExternally(event.getFile());
                        }
                    }
                }

                private void schemeDeletedExternally(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl$1", "schemeDeletedExternally"));
                    }
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findExternalizableSchemeByFileName(file.getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        SchemesManagerImpl.this.removeScheme(scheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    if (oldCurrentScheme != null && newCurrentScheme == null && !SchemesManagerImpl.this.mySchemes.isEmpty()) {
                        SchemesManagerImpl.this.setCurrentSchemeName(((Scheme)SchemesManagerImpl.this.mySchemes.get(0)).getName());
                        newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    }
                    if (oldCurrentScheme != newCurrentScheme) {
                        SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                    }
                }
            }, false, (Disposable)application);
        }
    }

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/intellij/openapi/options/SchemesManagerImpl", "loadBundledScheme"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/options/SchemesManagerImpl", "loadBundledScheme"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/options/SchemesManagerImpl", "loadBundledScheme"));
        }
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                LOG.error("Cannot read scheme from " + resourceName);
                return;
            }
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Scheme scheme = (Scheme)convertor.convert((Object)element);
            if (scheme instanceof ExternalizableScheme) {
                String fileName = PathUtilRt.getFileName((String)url.getPath());
                String extension = this.getFileExtension(fileName, true);
                ExternalInfo info = new ExternalInfo(fileName.substring(0, fileName.length() - extension.length()), extension);
                info.hash = JDOMUtil.getTreeHash((Element)element, (boolean)true);
                info.schemeName = scheme.getName();
                ExternalInfo oldInfo = (ExternalInfo)this.schemeToInfo.put((Object)((ExternalizableScheme)scheme), (Object)info);
                LOG.assertTrue(oldInfo == null);
            }
            this.addNewScheme(scheme, false);
        }
        catch (Throwable e) {
            LOG.error("Cannot read scheme from " + resourceName, e);
        }
    }

    @NotNull
    private String getFileExtension(@NotNull CharSequence fileName, boolean allowAny) {
        String extension;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "getFileExtension"));
        }
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.mySchemeExtension)) {
            extension = this.mySchemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            extension = ".xml";
        } else if (allowAny) {
            extension = PathUtil.getFileExtension((String)fileName.toString());
            LOG.assertTrue(extension != null);
        } else {
            throw new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
        }
        String string = extension;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "getFileExtension"));
        }
        return string;
    }

    private boolean isMy(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl", "isMy"));
        }
        return this.isMy(event.getFile());
    }

    private boolean isMy(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "isMy"));
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.mySchemeExtension);
    }

    @NotNull
    public Collection<E> loadSchemes() {
        final LinkedHashMap result = new LinkedHashMap();
        if (this.provider != null && this.provider.isEnabled()) {
            this.provider.processChildren(this.myFileSpec, this.myRoamingType, new Condition<String>(){

                public boolean value(@NotNull String name) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/SchemesManagerImpl$2", "value"));
                    }
                    return SchemesManagerImpl.this.canRead(name);
                }
            }, new StreamProvider.ChildrenProcessor(){

                @Override
                public boolean process(@NotNull String name, @NotNull InputStream input) {
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/SchemesManagerImpl$3", "process"));
                    }
                    if (input == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/options/SchemesManagerImpl$3", "process"));
                    }
                    SchemesManagerImpl.this.loadScheme(name, input, result);
                    return true;
                }
            });
        } else {
            VirtualFile[] files;
            VirtualFile dir = this.getDirectory();
            VirtualFile[] virtualFileArray = files = dir == null ? null : dir.getChildren();
            if (files != null) {
                for (VirtualFile file : files) {
                    this.readSchemeFromFile(file, result);
                }
            }
        }
        Collection list = result.values();
        for (ExternalizableScheme scheme : list) {
            this.myProcessor.initScheme(scheme);
        }
        Collection collection = list;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSchemes"));
        }
        return collection;
    }

    public void reload() {
        for (int i = this.mySchemes.size() - 1; i >= 0; --i) {
            Scheme scheme = (Scheme)this.mySchemes.get(i);
            if (!(scheme instanceof ExternalizableScheme) || this.getState((ExternalizableScheme)scheme) == BaseSchemeProcessor.State.NON_PERSISTENT) continue;
            this.mySchemes.remove(i);
            if (scheme != this.myCurrentScheme) continue;
            this.myCurrentScheme = null;
        }
        this.retainExternalInfo(this.mySchemes);
        this.loadSchemes();
    }

    @Nullable
    private E findExternalizableSchemeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "findExternalizableSchemeByFileName"));
        }
        for (Scheme scheme : this.mySchemes) {
            if (!(scheme instanceof ExternalizableScheme) || !fileName.equals(this.getFileName((ExternalizableScheme)scheme) + this.mySchemeExtension)) continue;
            return (E)((ExternalizableScheme)scheme);
        }
        return null;
    }

    private boolean isOverwriteOnLoad(@NotNull T existingScheme) {
        ExternalInfo info;
        if (existingScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingScheme", "com/intellij/openapi/options/SchemesManagerImpl", "isOverwriteOnLoad"));
        }
        return existingScheme instanceof ExternalizableScheme && (info = (ExternalInfo)this.schemeToInfo.get(existingScheme)) != null && !this.mySchemeExtension.equals(info.fileExtension);
    }

    @Nullable
    private E loadScheme(@NotNull CharSequence fileName, @NotNull InputStream input, @Nullable Map<String, E> result) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "loadScheme"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/options/SchemesManagerImpl", "loadScheme"));
        }
        boolean duringLoad = result != null;
        try {
            ExternalInfo info;
            Element element = JDOMUtil.load((InputStream)input);
            ExternalizableScheme scheme = this.myProcessor instanceof BaseSchemeProcessor ? ((BaseSchemeProcessor)this.myProcessor).readScheme(element, duringLoad) : this.myProcessor.readScheme(new Document((Element)element.detach()));
            if (scheme == null) {
                return null;
            }
            String extension = this.getFileExtension(fileName, false);
            String fileNameWithoutExtension = fileName.subSequence(0, fileName.length() - extension.length()).toString();
            if (duringLoad) {
                if (this.filesToDelete.contains(fileName.toString())) {
                    LOG.warn("Scheme file " + fileName + " is not loaded because marked to delete");
                    return null;
                }
                T existingScheme = this.findSchemeByName(scheme.getName());
                if (existingScheme != null) {
                    if (this.isOverwriteOnLoad(existingScheme)) {
                        this.removeScheme(existingScheme);
                    } else {
                        LOG.warn("Scheme file " + fileName + " is not loaded because defines duplicated name " + scheme.getName());
                        return null;
                    }
                }
            }
            if ((info = (ExternalInfo)this.schemeToInfo.get((Object)scheme)) == null) {
                info = new ExternalInfo(fileNameWithoutExtension, extension);
                this.schemeToInfo.put((Object)scheme, (Object)info);
            } else {
                info.setFileNameWithoutExtension(fileNameWithoutExtension, extension);
            }
            info.hash = JDOMUtil.getTreeHash((Element)element, (boolean)true);
            info.schemeName = scheme.getName();
            ExternalizableScheme s = scheme;
            if (duringLoad) {
                this.mySchemes.add(s);
            } else {
                this.addScheme((Scheme)s);
            }
            if (result != null) {
                result.put(scheme.getName(), scheme);
            }
            return (E)scheme;
        }
        catch (Exception e) {
            LOG.error("Cannot read scheme " + fileName, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private String getFileName(@NotNull ExternalizableScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "getFileName"));
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get((Object)scheme);
        return info == null ? null : info.fileNameWithoutExtension;
    }

    private boolean canRead(@NotNull CharSequence name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/SchemesManagerImpl", "canRead"));
        }
        return this.myUpdateExtension && StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".xml") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)this.mySchemeExtension);
    }

    @Nullable
    private E readSchemeFromFile(@NotNull VirtualFile file, @Nullable Map<String, E> result) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "readSchemeFromFile"));
        }
        CharSequence fileName = file.getNameSequence();
        if (file.isDirectory() || !this.canRead(fileName)) {
            return null;
        }
        try {
            return this.loadScheme(fileName, file.getInputStream(), result);
        }
        catch (IOException e) {
            LOG.error("Cannot read scheme " + fileName, (Throwable)e);
            return null;
        }
    }

    public void save() {
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Object scheme : this.mySchemes) {
            String fileName;
            ExternalizableScheme eScheme;
            BaseSchemeProcessor.State state;
            if (!(scheme instanceof ExternalizableScheme) || (state = this.getState(eScheme = (ExternalizableScheme)scheme)) == BaseSchemeProcessor.State.NON_PERSISTENT) continue;
            hasSchemes = true;
            if (state != BaseSchemeProcessor.State.UNCHANGED) {
                schemesToSave.add(eScheme);
            }
            if ((fileName = this.getFileName(eScheme)) == null || this.isRenamed(eScheme)) continue;
            nameGenerator.addExistingName(fileName);
        }
        Object errors = null;
        for (ExternalizableScheme scheme : schemesToSave) {
            try {
                this.saveScheme(scheme, nameGenerator);
            }
            catch (Throwable e) {
                if (errors == null) {
                    errors = new SmartList();
                }
                errors.add((Throwable)e);
            }
        }
        VirtualFile dir = this.getDirectory();
        errors = this.deleteFiles(dir, (List<Throwable>)errors);
        if (!hasSchemes && dir != null) {
            errors = this.removeDirectoryIfEmpty(dir, (List<Throwable>)errors);
        }
        CompoundRuntimeException.doThrow(errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Throwable> removeDirectoryIfEmpty(@NotNull VirtualFile dir, @Nullable List<Throwable> errors) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/options/SchemesManagerImpl", "removeDirectoryIfEmpty"));
        }
        for (VirtualFile file : dir.getChildren()) {
            if (file.is(VFileProperty.HIDDEN)) continue;
            LOG.info("Directory " + dir.getNameSequence() + " is not deleted: at least one file " + file.getNameSequence() + " exists");
            return errors;
        }
        LOG.info("Remove schemes directory " + dir.getNameSequence());
        this.myDir = null;
        AccessToken token = WriteAction.start();
        try {
            dir.delete((Object)this);
        }
        catch (Throwable e) {
            if (errors == null) {
                errors = new SmartList();
            }
            errors.add((Throwable)e);
        }
        finally {
            token.finish();
        }
        return errors;
    }

    @NotNull
    private BaseSchemeProcessor.State getState(@NotNull E scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "getState"));
        }
        if (this.myProcessor instanceof BaseSchemeProcessor) {
            BaseSchemeProcessor.State state = ((BaseSchemeProcessor)this.myProcessor).getState(scheme);
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "getState"));
            }
            return state;
        }
        BaseSchemeProcessor.State state = this.myProcessor.shouldBeSaved(scheme) ? BaseSchemeProcessor.State.POSSIBLY_CHANGED : BaseSchemeProcessor.State.NON_PERSISTENT;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "getState"));
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScheme(@NotNull E scheme, @NotNull UniqueNameGenerator nameGenerator) throws WriteExternalException, IOException {
        int newHash;
        String fileNameWithoutExtension;
        ExternalInfo externalInfo;
        block26: {
            boolean renamed;
            String providerPath;
            Element element;
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "saveScheme"));
            }
            if (nameGenerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameGenerator", "com/intellij/openapi/options/SchemesManagerImpl", "saveScheme"));
            }
            externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme);
            String currentFileNameWithoutExtension = externalInfo == null ? null : externalInfo.fileNameWithoutExtension;
            Parent parent = this.myProcessor.writeScheme(scheme);
            Element element2 = element = parent == null || parent instanceof Element ? (Element)parent : ((Document)parent).detachRootElement();
            if (JDOMUtil.isEmpty((Element)element)) {
                if (externalInfo != null) {
                    this.scheduleDelete(externalInfo);
                }
                return;
            }
            fileNameWithoutExtension = currentFileNameWithoutExtension;
            if (fileNameWithoutExtension == null || this.isRenamed((ExternalizableScheme)scheme)) {
                fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeName((String)scheme.getName()));
            }
            newHash = JDOMUtil.getTreeHash((Element)element, (boolean)true);
            if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.hash) {
                return;
            }
            String fileName = fileNameWithoutExtension + this.mySchemeExtension;
            this.filesToDelete.remove(fileName);
            BufferExposingByteArrayOutputStream byteOut = StorageUtil.writeToBytes((Parent)element, "\n");
            if (this.provider != null && this.provider.isEnabled()) {
                providerPath = this.myFileSpec + '/' + fileName;
                if (!this.provider.isApplicable(providerPath, this.myRoamingType)) {
                    providerPath = null;
                }
            } else {
                providerPath = null;
            }
            boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension);
            if (providerPath == null) {
                AccessToken token;
                VirtualFile file = null;
                VirtualFile dir = this.getDirectory();
                if (dir == null || !dir.isValid()) {
                    this.myDir = dir = DirectoryBasedStorage.createDir(this.myIoDir, (Object)this);
                }
                if (renamed && (file = dir.findChild(externalInfo.fileNameWithoutExtension + externalInfo.fileExtension)) != null) {
                    token = WriteAction.start();
                    try {
                        file.rename((Object)this, fileName);
                    }
                    finally {
                        token.finish();
                    }
                }
                if (file == null) {
                    file = DirectoryBasedStorage.getFile(fileName, dir, (Object)this);
                }
                token = WriteAction.start();
                try {
                    OutputStream out = file.getOutputStream((Object)this);
                    try {
                        byteOut.writeTo(out);
                        break block26;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    token.finish();
                }
            }
            if (renamed) {
                this.scheduleDelete(externalInfo);
            }
            this.provider.saveContent(providerPath, byteOut.getInternalBuffer(), byteOut.size(), this.myRoamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.mySchemeExtension);
            this.schemeToInfo.put(scheme, (Object)externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.mySchemeExtension);
        }
        externalInfo.hash = newHash;
        externalInfo.schemeName = scheme.getName();
    }

    private void scheduleDelete(@NotNull ExternalInfo externalInfo) {
        if (externalInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalInfo", "com/intellij/openapi/options/SchemesManagerImpl", "scheduleDelete"));
        }
        this.filesToDelete.add(externalInfo.fileNameWithoutExtension + externalInfo.fileExtension);
    }

    private boolean isRenamed(@NotNull ExternalizableScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "isRenamed"));
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get((Object)scheme);
        return info != null && !scheme.getName().equals(info.schemeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Throwable> deleteFiles(@Nullable VirtualFile dir, List<Throwable> errors) {
        if (this.filesToDelete.isEmpty()) {
            return errors;
        }
        if (this.provider != null && this.provider.isEnabled()) {
            for (String name : this.filesToDelete) {
                try {
                    StorageUtil.delete(this.provider, this.myFileSpec + '/' + name, this.myRoamingType);
                }
                catch (Throwable e) {
                    if (errors == null) {
                        errors = new SmartList();
                    }
                    errors.add((Throwable)e);
                }
            }
        } else if (dir != null) {
            AccessToken token = null;
            try {
                for (VirtualFile file : dir.getChildren()) {
                    if (!this.filesToDelete.contains(file.getName())) continue;
                    if (token == null) {
                        token = WriteAction.start();
                    }
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException e) {
                        if (errors == null) {
                            errors = new SmartList();
                        }
                        errors.add(e);
                    }
                }
            }
            finally {
                if (token != null) {
                    token.finish();
                }
            }
        }
        this.filesToDelete.clear();
        return errors;
    }

    @Nullable
    private VirtualFile getDirectory() {
        VirtualFile result = this.myDir;
        if (result == null) {
            this.myDir = result = LocalFileSystem.getInstance().findFileByIoFile(this.myIoDir);
        }
        return result;
    }

    public File getRootDirectory() {
        return this.myIoDir;
    }

    private void schemeAdded(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "schemeAdded"));
        }
        if (!(scheme instanceof ExternalizableScheme)) {
            return;
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(scheme);
        if (info != null) {
            this.filesToDelete.remove(info.fileNameWithoutExtension + info.fileExtension);
        }
    }

    public void setSchemes(@NotNull List<T> newSchemes, @Nullable Condition<T> removeCondition) {
        if (newSchemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSchemes", "com/intellij/openapi/options/SchemesManagerImpl", "setSchemes"));
        }
        if (removeCondition == null) {
            this.mySchemes.clear();
        } else {
            for (int i = this.mySchemes.size() - 1; i >= 0; --i) {
                Scheme scheme = (Scheme)this.mySchemes.get(i);
                if (!removeCondition.value((Object)scheme)) continue;
                this.mySchemes.remove(i);
            }
        }
        this.retainExternalInfo(newSchemes);
        this.mySchemes.ensureCapacity(newSchemes.size());
        for (Scheme scheme : newSchemes) {
            this.mySchemes.add(scheme);
            this.schemeAdded(scheme);
        }
        if (this.myCurrentSchemeName != null) {
            this.myCurrentScheme = this.findSchemeByName(this.myCurrentSchemeName);
            if (this.myCurrentScheme != null) {
                return;
            }
        }
        this.myCurrentScheme = this.mySchemes.isEmpty() ? null : (Scheme)this.mySchemes.get(0);
        this.myCurrentSchemeName = this.myCurrentScheme == null ? null : this.myCurrentScheme.getName();
    }

    private void retainExternalInfo(final @NotNull List<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/options/SchemesManagerImpl", "retainExternalInfo"));
        }
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        this.schemeToInfo.retainEntries((TObjectObjectProcedure)new TObjectObjectProcedure<ExternalizableScheme, ExternalInfo>(){

            public boolean execute(ExternalizableScheme scheme, ExternalInfo info) {
                for (Scheme t : schemes) {
                    if (t != scheme) continue;
                    return true;
                }
                SchemesManagerImpl.this.scheduleDelete(info);
                return false;
            }
        });
    }

    public void addNewScheme(@NotNull T scheme, boolean replaceExisting) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "addNewScheme"));
        }
        int toReplace = -1;
        for (int i = 0; i < this.mySchemes.size(); ++i) {
            ExternalInfo newInfo;
            ExternalInfo oldInfo;
            Scheme existing = (Scheme)this.mySchemes.get(i);
            if (!existing.getName().equals(scheme.getName())) continue;
            if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                LOG.warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
            }
            toReplace = i;
            if (!replaceExisting || !(existing instanceof ExternalizableScheme) || (oldInfo = (ExternalInfo)this.schemeToInfo.remove((Object)((ExternalizableScheme)existing))) == null || !(scheme instanceof ExternalizableScheme) || (newInfo = (ExternalInfo)this.schemeToInfo.get((Object)((ExternalizableScheme)scheme))) != null) break;
            this.schemeToInfo.put((Object)((ExternalizableScheme)scheme), (Object)oldInfo);
            break;
        }
        if (toReplace == -1) {
            this.mySchemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.mySchemes.set(toReplace, scheme);
        } else {
            SchemesManagerImpl.renameScheme((ExternalizableScheme)scheme, UniqueNameGenerator.generateUniqueName((String)scheme.getName(), this.collectExistingNames(this.mySchemes)));
            this.mySchemes.add(scheme);
        }
        this.schemeAdded(scheme);
    }

    @NotNull
    private Collection<String> collectExistingNames(@NotNull Collection<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/openapi/options/SchemesManagerImpl", "collectExistingNames"));
        }
        THashSet result = new THashSet(schemes.size());
        for (Scheme scheme : schemes) {
            result.add(scheme.getName());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "collectExistingNames"));
        }
        return tHashSet;
    }

    public void clearAllSchemes() {
        this.schemeToInfo.forEachValue((TObjectProcedure)new TObjectProcedure<ExternalInfo>(){

            public boolean execute(ExternalInfo info) {
                SchemesManagerImpl.this.scheduleDelete(info);
                return true;
            }
        });
        this.myCurrentScheme = null;
        this.mySchemes.clear();
        this.schemeToInfo.clear();
    }

    @NotNull
    public List<T> getAllSchemes() {
        List<T> list = Collections.unmodifiableList(this.mySchemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "getAllSchemes"));
        }
        return list;
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/options/SchemesManagerImpl", "findSchemeByName"));
        }
        for (Scheme scheme : this.mySchemes) {
            if (!scheme.getName().equals(schemeName)) continue;
            return (T)scheme;
        }
        return null;
    }

    public void setCurrentSchemeName(@Nullable String schemeName) {
        this.myCurrentSchemeName = schemeName;
        this.myCurrentScheme = null;
    }

    @Nullable
    public T getCurrentScheme() {
        T scheme = this.myCurrentScheme;
        if (scheme == null && this.myCurrentSchemeName != null && (scheme = this.findSchemeByName(this.myCurrentSchemeName)) != null) {
            this.myCurrentScheme = scheme;
        }
        return scheme;
    }

    public void removeScheme(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "removeScheme"));
        }
        int n = this.mySchemes.size();
        for (int i = 0; i < n; ++i) {
            ExternalInfo info;
            Scheme s = (Scheme)this.mySchemes.get(i);
            if (!scheme.getName().equals(s.getName())) continue;
            if (this.myCurrentScheme == s) {
                this.myCurrentScheme = null;
            }
            if (s instanceof ExternalizableScheme && (info = (ExternalInfo)this.schemeToInfo.remove((Object)((ExternalizableScheme)s))) != null) {
                this.scheduleDelete(info);
            }
            this.mySchemes.remove(i);
            break;
        }
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        if (this.mySchemes.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "getAllSchemeNames"));
            }
            return list;
        }
        ArrayList<String> names = new ArrayList<String>(this.mySchemes.size());
        for (Scheme scheme : this.mySchemes) {
            names.add(scheme.getName());
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "getAllSchemeNames"));
        }
        return arrayList;
    }

    private static void renameScheme(@NotNull ExternalizableScheme scheme, @NotNull String newName) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "renameScheme"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/options/SchemesManagerImpl", "renameScheme"));
        }
        if (!newName.equals(scheme.getName())) {
            scheme.setName(newName);
            LOG.assertTrue(newName.equals(scheme.getName()));
        }
    }

    public String toString() {
        return this.myFileSpec;
    }

    private static final class ExternalInfo {
        private String schemeName;
        @NotNull
        private String fileNameWithoutExtension;
        private int hash;
        private String fileExtension;

        public ExternalInfo(@NotNull String fileNameWithoutExtension, @NotNull String fileExtension) {
            if (fileNameWithoutExtension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithoutExtension", "com/intellij/openapi/options/SchemesManagerImpl$ExternalInfo", "<init>"));
            }
            if (fileExtension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtension", "com/intellij/openapi/options/SchemesManagerImpl$ExternalInfo", "<init>"));
            }
            this.fileNameWithoutExtension = fileNameWithoutExtension;
            this.fileExtension = fileExtension;
        }

        public void setFileNameWithoutExtension(@NotNull String nameWithoutExtension, @NotNull String extension) {
            if (nameWithoutExtension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameWithoutExtension", "com/intellij/openapi/options/SchemesManagerImpl$ExternalInfo", "setFileNameWithoutExtension"));
            }
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/options/SchemesManagerImpl$ExternalInfo", "setFileNameWithoutExtension"));
            }
            this.fileNameWithoutExtension = nameWithoutExtension;
            this.fileExtension = extension;
        }

        public String toString() {
            return this.fileNameWithoutExtension;
        }
    }
}

