/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimpleProjectRoot
implements ProjectRoot,
JDOMExternalizable {
    private String myUrl;
    private VirtualFile myFile;
    private final VirtualFile[] myFileArray;
    private boolean myInitialized;
    @NonNls
    private static final String ATTRIBUTE_URL = "url";

    public SimpleProjectRoot(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot", "<init>"));
        }
        this.myFileArray = new VirtualFile[1];
        this.myInitialized = false;
        this.myFile = file;
        this.myUrl = this.myFile.getUrl();
    }

    public SimpleProjectRoot(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_URL, "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot", "<init>"));
        }
        this.myFileArray = new VirtualFile[1];
        this.myInitialized = false;
        this.myUrl = url;
    }

    SimpleProjectRoot() {
        this.myFileArray = new VirtualFile[1];
        this.myInitialized = false;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        String path = VirtualFileManager.extractPath((String)this.myUrl);
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        String string = path.replace('/', File.separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot", "getPresentableString"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile[] getVirtualFiles() {
        if (!this.myInitialized) {
            this.initialize();
        }
        if (this.myFile == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot", "getVirtualFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        this.myFileArray[0] = this.myFile;
        if (this.myFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot", "getVirtualFiles"));
        }
        return this.myFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        String[] stringArray = new String[]{this.myUrl};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/SimpleProjectRoot", "getUrls"));
        }
        return stringArray;
    }

    @Override
    public boolean isValid() {
        if (!this.myInitialized) {
            this.initialize();
        }
        return this.myFile != null && this.myFile.isValid();
    }

    @Override
    public void update() {
        this.initialize();
    }

    private void initialize() {
        this.myInitialized = true;
        if (this.myFile == null || !this.myFile.isValid()) {
            this.myFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
            if (this.myFile != null && !this.canHaveChildren()) {
                this.myFile = null;
            }
        }
    }

    private boolean canHaveChildren() {
        return this.myFile.getFileSystem().getProtocol().equals("http") || this.myFile.isDirectory();
    }

    public String getUrl() {
        return this.myUrl;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String url = element.getAttributeValue(ATTRIBUTE_URL);
        this.myUrl = SimpleProjectRoot.migrateJdkAnnotationsToCommunityForDevIdea(url);
    }

    private static String migrateJdkAnnotationsToCommunityForDevIdea(String url) {
        boolean isOldJdkAnnotations;
        File root = new File(VfsUtilCore.urlToPath((String)url) + "/..");
        boolean bl = isOldJdkAnnotations = new File(root, "community/java/jdkAnnotations").exists() && new File(root, "idea.iml").exists() && new File(root, "testData").exists();
        if (isOldJdkAnnotations) {
            return VfsUtilCore.pathToUrl((String)PathUtil.getCanonicalPath((String)VfsUtilCore.urlToPath((String)(url + "/../community/java/jdkAnnotations"))));
        }
        return url;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.myInitialized) {
            this.initialize();
        }
        element.setAttribute(ATTRIBUTE_URL, this.myUrl);
    }
}

