/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.AutoMatchStrategy;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;

public class DefaultPatchStrategy
extends AutoMatchStrategy {
    public DefaultPatchStrategy(VirtualFile baseDir) {
        super(baseDir);
    }

    @Override
    public void acceptPatch(TextFilePatch patch, Collection<VirtualFile> foundByName) {
        AbstractFilePatchInProgress longest = null;
        for (VirtualFile file : foundByName) {
            TextFilePatchInProgress current = this.processMatch(patch, file);
            if (current == null || longest != null && longest.getCurrentStrip() <= current.getCurrentStrip()) continue;
            longest = current;
        }
        if (longest != null) {
            this.registerFolderDecision(((TextFilePatch)longest.getPatch()).getBeforeName(), longest.getBase());
            this.myResult.add(longest);
        } else {
            this.myResult.add(new TextFilePatchInProgress(patch, null, this.myBaseDir));
        }
    }

    @Override
    public void processCreation(TextFilePatch creation) {
        this.processCreationBasedOnFolderDecisions(creation);
    }

    @Override
    public void beforeCreations() {
    }

    @Override
    public boolean succeeded() {
        return true;
    }
}

