/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcessor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.GatheringContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.FilesProgress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager");
    private final MessageBus myBus;
    private final List<ShelvedChangeList> myShelvedChangeLists = new ArrayList<ShelvedChangeList>();
    private final List<ShelvedChangeList> myRecycledShelvedChangeLists = new ArrayList<ShelvedChangeList>();
    @NonNls
    private static final String ATTRIBUTE_SHOW_RECYCLED = "show_recycled";
    private final CompoundShelfFileProcessor myFileProcessor;
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);
    private boolean myShowRecycled;

    public static ShelveChangesManager getInstance(Project project) {
        return (ShelveChangesManager)((Object)PeriodicalTasksCloser.getInstance().safeGetComponent(project, ShelveChangesManager.class));
    }

    public ShelveChangesManager(Project project, MessageBus bus) {
        super(project);
        this.myBus = bus;
        if (project.isDefault()) {
            this.myFileProcessor = new CompoundShelfFileProcessor(null, PathManager.getConfigPath() + File.separator + "shelf");
        } else if (project instanceof ProjectEx && ((ProjectEx)project).getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            VirtualFile dir = project.getBaseDir();
            String shelfBaseDirPath = dir == null ? "" : dir.getPath() + File.separator + ".idea";
            this.myFileProcessor = new CompoundShelfFileProcessor(shelfBaseDirPath);
        } else {
            this.myFileProcessor = new CompoundShelfFileProcessor();
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelveChangesManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "getComponentName"));
        }
        return "ShelveChangesManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        String showRecycled = element.getAttributeValue(ATTRIBUTE_SHOW_RECYCLED);
        this.myShowRecycled = showRecycled != null ? Boolean.parseBoolean(showRecycled) : true;
        ShelveChangesManager.readExternal(element, this.myShelvedChangeLists, this.myRecycledShelvedChangeLists);
    }

    public static void readExternal(Element element, List<ShelvedChangeList> changes, List<ShelvedChangeList> recycled) throws InvalidDataException {
        changes.addAll(ShelvedChangeList.readChanges(element, false, true));
        recycled.addAll(ShelvedChangeList.readChanges(element, true, true));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATTRIBUTE_SHOW_RECYCLED, Boolean.toString(this.myShowRecycled));
        ShelvedChangeList.writeChanges(this.myShelvedChangeLists, this.myRecycledShelvedChangeLists, element);
    }

    public List<ShelvedChangeList> getShelvedChangeLists() {
        return Collections.unmodifiableList(this.myShelvedChangeLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage, boolean rollback) throws IOException, VcsException {
        ShelvedChangeList changeList;
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(change));
                continue;
            }
            textChanges.add(change);
        }
        try {
            File patchPath = this.getPatchPath(commitMessage);
            ProgressManager.checkCanceled();
            final List patches = IdeaTextPatchBuilder.buildPatch((Project)this.myProject, textChanges, (String)this.myProject.getBaseDir().getPresentableUrl(), (boolean)false);
            ProgressManager.checkCanceled();
            CommitContext commitContext = new CommitContext();
            this.baseRevisionsOfDvcsIntoContext(textChanges, commitContext);
            this.myFileProcessor.savePathFile(new CompoundShelfFileProcessor.ContentProvider(){

                @Override
                public void writeContentTo(Writer writer, CommitContext commitContext) throws IOException {
                    UnifiedDiffWriter.write((Project)ShelveChangesManager.this.myProject, (Collection)patches, (Writer)writer, (String)"\n", (CommitContext)commitContext);
                }
            }, patchPath, commitContext);
            changeList = new ShelvedChangeList(patchPath.toString(), commitMessage.replace('\n', ' '), binaryFiles);
            this.myShelvedChangeLists.add(changeList);
            ProgressManager.checkCanceled();
            if (rollback) {
                String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes));
                boolean modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
                new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]));
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return changeList;
    }

    private void baseRevisionsOfDvcsIntoContext(List<Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (vcsManager.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            Set<Change> big = SelectFilesToAddTextsToPatchPanel.getBig(textChanges);
            ArrayList<FilePath> toKeep = new ArrayList<FilePath>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || big.contains(change) || (vcs = vcsManager.getVcsFor(filePath = ChangesUtil.getFilePath((Change)change))) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.add(filePath);
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)true);
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisionPaths, toKeep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList importFilePatches(String fileName, final List<FilePatch> patches, final PatchEP[] patchTransitExtensions) throws IOException {
        try {
            File patchPath = this.getPatchPath(fileName);
            this.myFileProcessor.savePathFile(new CompoundShelfFileProcessor.ContentProvider(){

                @Override
                public void writeContentTo(Writer writer, CommitContext commitContext) throws IOException {
                    UnifiedDiffWriter.write((Project)ShelveChangesManager.this.myProject, (Collection)patches, (Writer)writer, (String)"\n", (PatchEP[])patchTransitExtensions, (CommitContext)commitContext);
                }
            }, patchPath, new CommitContext());
            ShelvedChangeList changeList = new ShelvedChangeList(patchPath.toString(), fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList());
            this.myShelvedChangeLists.add(changeList);
            ShelvedChangeList shelvedChangeList = changeList;
            return shelvedChangeList;
        }
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<VirtualFile> files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        LinkedList<VirtualFile> filesQueue = new LinkedList<VirtualFile>(files);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file = filesQueue.removeFirst();
            if (file.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file.getChildren()));
                continue;
            }
            if (!"PATCH".equals(file.getFileType().getName())) continue;
            result.add(file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShelvedChangeList> importChangeLists(Collection<VirtualFile> files, Consumer<VcsException> exceptionConsumer) {
        ArrayList<ShelvedChangeList> result = new ArrayList<ShelvedChangeList>(files.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files.size(), "Processing ");
            for (VirtualFile file : files) {
                filesProgress.updateIndicator(file);
                String description = file.getNameWithoutExtension().replace('_', ' ');
                File patchPath = this.getPatchPath(description);
                ShelvedChangeList list = new ShelvedChangeList(patchPath.getPath(), description, (List<ShelvedBinaryFile>)new SmartList(), file.getTimeStamp());
                try {
                    List<TextFilePatch> patchesList = ShelveChangesManager.loadPatches(this.myProject, file.getPath(), new CommitContext());
                    if (patchesList.isEmpty()) continue;
                    FileUtil.copy((File)new File(file.getPath()), (File)patchPath);
                    this.myShelvedChangeLists.add(list);
                    result.add(list);
                }
                catch (IOException e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
                catch (PatchSyntaxException e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result;
    }

    private ShelvedBinaryFile shelveBinaryFile(Change change) throws IOException {
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedName = FileUtil.getNameWithoutExtension((String)afterFile.getName());
            String shelvedExt = FileUtilRt.getExtension((String)afterFile.getName());
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)this.myFileProcessor.getBaseIODir(), (String)shelvedName, (String)shelvedExt);
            this.myFileProcessor.saveFile(afterRevision.getFile().getIOFile(), shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent((Object)this));
        }
    }

    private File getPatchPath(@NonNls String commitMessage) {
        File file = this.myFileProcessor.getBaseIODir();
        if (!file.exists()) {
            file.mkdirs();
        }
        return ShelveChangesManager.suggestPatchName(this.myProject, commitMessage.length() > 100 ? commitMessage.substring(0, 100) : commitMessage, file, "patch");
    }

    public static File suggestPatchName(Project project, String commitMessage, File file, String extension) {
        File nonexistentFile;
        String defaultPath = PathUtil.suggestFileName((String)commitMessage);
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance((Project)project).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        return nonexistentFile;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, LocalChangeList targetChangeList) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, true);
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        Continuation continuation = Continuation.createForCurrentProgress(this.myProject, true, "Unshelve changes");
        GatheringContinuationContext initContext = new GatheringContinuationContext();
        this.scheduleUnshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, (ContinuationContext)initContext, false, false, null, null);
        continuation.run(initContext.getList());
    }

    public void scheduleUnshelveChangeList(final ShelvedChangeList changeList, final @Nullable List<ShelvedChange> changes, final @Nullable List<ShelvedBinaryFile> binaryFiles, final @Nullable LocalChangeList targetChangeList, final boolean showSuccessNotification, ContinuationContext context, final boolean systemOperation, final boolean reverse, final String leftConflictTitle, final String rightConflictTitle) {
        context.next(new TaskDescriptor[]{new TaskDescriptor("", Where.AWT){

            public void run(ContinuationContext contextInner) {
                List textFilePatches;
                final ArrayList remainingPatches = new ArrayList();
                final CommitContext commitContext = new CommitContext();
                try {
                    textFilePatches = ShelveChangesManager.loadTextPatches(ShelveChangesManager.this.myProject, changeList, changes, remainingPatches, commitContext);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    PatchApplier.showError(ShelveChangesManager.this.myProject, "Cannot load patch(es): " + e.getMessage(), true);
                    return;
                }
                catch (PatchSyntaxException e) {
                    PatchApplier.showError(ShelveChangesManager.this.myProject, "Cannot load patch(es): " + e.getMessage(), true);
                    LOG.info((Throwable)e);
                    return;
                }
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>(textFilePatches);
                final ArrayList remainingBinaries = new ArrayList();
                List binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
                for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
                    patches.add(new ShelvedBinaryFilePatch(shelvedBinaryFile));
                }
                BinaryPatchApplier binaryPatchApplier = new BinaryPatchApplier();
                final PatchApplier<ShelvedBinaryFilePatch> patchApplier = new PatchApplier<ShelvedBinaryFilePatch>(ShelveChangesManager.this.myProject, ShelveChangesManager.this.myProject.getBaseDir(), patches, targetChangeList, binaryPatchApplier, commitContext, reverse, leftConflictTitle, rightConflictTitle);
                patchApplier.setIsSystemOperation(systemOperation);
                contextInner.next(new TaskDescriptor[]{new TaskDescriptor("", Where.AWT){

                    public void run(ContinuationContext context) {
                        remainingPatches.addAll(patchApplier.getRemainingPatches());
                        if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
                            ShelveChangesManager.this.recycleChangeList(changeList);
                        } else {
                            ShelveChangesManager.this.saveRemainingPatches(changeList, remainingPatches, remainingBinaries, commitContext);
                        }
                    }
                }});
                patchApplier.scheduleSelf(showSuccessNotification, contextInner, systemOperation);
            }
        }});
    }

    private static List<TextFilePatch> loadTextPatches(Project project, ShelvedChangeList changeList, List<ShelvedChange> changes, List<FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(project, changeList.PATH, commitContext);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<ShelvedBinaryFile> binaryFiles, List<ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file)) {
                result.add(file);
                continue;
            }
            remainingBinaries.add(file);
        }
        return result;
    }

    private void unshelveBinaryFile(ShelvedBinaryFile file, final @NotNull VirtualFile patchTarget) throws IOException {
        if (patchTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchTarget", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "unshelveBinaryFile"));
        }
        final Ref ex = new Ref();
        final Ref patchedFileRef = new Ref();
        final File shelvedFile = file.SHELVED_PATH == null ? null : new File(file.SHELVED_PATH);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    if (shelvedFile == null) {
                        patchTarget.delete((Object)this);
                    } else {
                        patchTarget.setBinaryContent(FileUtil.loadFileBytes((File)shelvedFile));
                        patchedFileRef.set((Object)patchTarget);
                    }
                }
                catch (IOException e) {
                    ex.set((Object)e);
                }
            }
        });
        if (!ex.isNull()) {
            throw (IOException)ex.get();
        }
    }

    private static boolean needUnshelve(FilePatch patch, List<ShelvedChange> changes) {
        for (ShelvedChange change : changes) {
            if (!Comparing.equal((String)patch.getBeforeName(), (String)change.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePatchesToFile(Project project, String path, List<FilePatch> remainingPatches, CommitContext commitContext) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), CharsetToolkit.UTF8_CHARSET);
            try {
                UnifiedDiffWriter.write((Project)project, remainingPatches, (Writer)writer, (String)"\n", (CommitContext)commitContext);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    void saveRemainingPatches(ShelvedChangeList changeList, List<FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        File newPath = this.getPatchPath(changeList.DESCRIPTION);
        try {
            FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        }
        catch (IOException e) {
            return;
        }
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles()));
        listCopy.DATE = changeList.DATE == null ? null : new Date(changeList.DATE.getTime());
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.PATH, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.clearLoadedChanges();
        this.recycleChangeList(listCopy, changeList);
        this.notifyStateChanged();
    }

    public void restoreList(ShelvedChangeList changeList) {
        this.myShelvedChangeLists.add(changeList);
        this.myRecycledShelvedChangeLists.remove(changeList);
        changeList.setRecycled(false);
        this.notifyStateChanged();
    }

    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.myRecycledShelvedChangeLists;
    }

    public void clearRecycled() {
        for (ShelvedChangeList list : this.myRecycledShelvedChangeLists) {
            this.deleteListImpl(list);
        }
        this.myRecycledShelvedChangeLists.clear();
        this.notifyStateChanged();
    }

    private void recycleChangeList(ShelvedChangeList listCopy, ShelvedChangeList newList) {
        if (newList != null) {
            Iterator<ShelvedBinaryFile> shelvedChangeListIterator = listCopy.getBinaryFiles().iterator();
            while (shelvedChangeListIterator.hasNext()) {
                ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
                for (ShelvedBinaryFile newBinary : newList.getBinaryFiles()) {
                    if (!Comparing.equal((String)newBinary.BEFORE_PATH, (String)binaryFile.BEFORE_PATH) || !Comparing.equal((String)newBinary.AFTER_PATH, (String)binaryFile.AFTER_PATH)) continue;
                    shelvedChangeListIterator.remove();
                }
            }
            Iterator<ShelvedChange> iterator = listCopy.getChanges(this.myProject).iterator();
            while (iterator.hasNext()) {
                ShelvedChange change = iterator.next();
                for (ShelvedChange newChange : newList.getChanges(this.myProject)) {
                    if (!Comparing.equal((String)change.getBeforePath(), (String)newChange.getBeforePath()) || !Comparing.equal((String)change.getAfterPath(), (String)newChange.getAfterPath())) continue;
                    iterator.remove();
                }
            }
            try {
                CommitContext commitContext = new CommitContext();
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
                for (ShelvedChange change : listCopy.getChanges(this.myProject)) {
                    patches.add((FilePatch)change.loadFilePatch(this.myProject, commitContext));
                }
                ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.PATH, patches, commitContext);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            catch (PatchSyntaxException e) {
                LOG.info((Throwable)e);
            }
        }
        if (!listCopy.getBinaryFiles().isEmpty() || !listCopy.getChanges(this.myProject).isEmpty()) {
            listCopy.setRecycled(true);
            this.myRecycledShelvedChangeLists.add(listCopy);
            this.notifyStateChanged();
        }
    }

    private void recycleChangeList(ShelvedChangeList changeList) {
        this.recycleChangeList(changeList, null);
        this.myShelvedChangeLists.remove(changeList);
        this.notifyStateChanged();
    }

    public void deleteChangeList(ShelvedChangeList changeList) {
        this.deleteListImpl(changeList);
        if (!changeList.isRecycled()) {
            this.myShelvedChangeLists.remove(changeList);
        } else {
            this.myRecycledShelvedChangeLists.remove(changeList);
        }
        this.notifyStateChanged();
    }

    private void deleteListImpl(ShelvedChangeList changeList) {
        File file = new File(changeList.PATH);
        this.myFileProcessor.delete(file.getName());
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path = binaryFile.SHELVED_PATH;
            if (path == null) continue;
            File binFile = new File(path);
            this.myFileProcessor.delete(binFile.getName());
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project, String patchPath, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list = ShelveChangesManager.loadPatches(project, patchPath, commitContext, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "loadPatches"));
        }
        return list;
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(Project project, String patchPath, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list = ShelveChangesManager.loadPatches(project, patchPath, commitContext, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "loadPatchesWithoutContent"));
        }
        return list;
    }

    private static List<TextFilePatch> loadPatches(Project project, String patchPath, CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text = FileUtil.loadFileText((File)new File(patchPath), (String)"UTF-8");
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text), loadContent);
        List textFilePatches = reader.readAllPatches();
        TransparentlyFailedValueI additionalInfo = reader.getAdditionalInfo(null);
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project, (TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException>)additionalInfo, commitContext);
        return textFilePatches;
    }

    public boolean isShowRecycled() {
        return this.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myShowRecycled = showRecycled;
        this.notifyStateChanged();
    }

    public static class ShelvedBinaryFilePatch
    extends FilePatch {
        private final ShelvedBinaryFile myShelvedBinaryFile;

        public ShelvedBinaryFilePatch(ShelvedBinaryFile shelvedBinaryFile) {
            this.myShelvedBinaryFile = shelvedBinaryFile;
            this.setBeforeName(this.myShelvedBinaryFile.BEFORE_PATH);
            this.setAfterName(this.myShelvedBinaryFile.AFTER_PATH);
        }

        public static ShelvedBinaryFilePatch patchCopy(@NotNull ShelvedBinaryFilePatch patch) {
            if (patch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$ShelvedBinaryFilePatch", "patchCopy"));
            }
            return new ShelvedBinaryFilePatch(patch.getShelvedBinaryFile());
        }

        public String getBeforeFileName() {
            return ShelvedBinaryFilePatch.getFileName(this.myShelvedBinaryFile.BEFORE_PATH);
        }

        public String getAfterFileName() {
            return ShelvedBinaryFilePatch.getFileName(this.myShelvedBinaryFile.AFTER_PATH);
        }

        @Nullable
        private static String getFileName(String filePath) {
            return filePath != null ? PathUtil.getFileName((String)filePath) : null;
        }

        public boolean isNewFile() {
            return this.myShelvedBinaryFile.BEFORE_PATH == null;
        }

        public boolean isDeletedFile() {
            return this.myShelvedBinaryFile.AFTER_PATH == null;
        }

        public ShelvedBinaryFile getShelvedBinaryFile() {
            return this.myShelvedBinaryFile;
        }
    }

    private class BinaryPatchApplier
    implements CustomBinaryPatchApplier<ShelvedBinaryFilePatch> {
        private final List<FilePatch> myAppliedPatches = new ArrayList<FilePatch>();

        private BinaryPatchApplier() {
        }

        @Override
        @NotNull
        public ApplyPatchStatus apply(List<Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>>> patches) throws IOException {
            for (Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>> patch : patches) {
                ShelvedBinaryFilePatch shelvedPatch = (ShelvedBinaryFilePatch)((Object)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                ShelveChangesManager.this.unshelveBinaryFile(shelvedPatch.getShelvedBinaryFile(), (VirtualFile)patch.getFirst());
                this.myAppliedPatches.add(shelvedPatch);
            }
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier", "apply"));
            }
            return applyPatchStatus;
        }

        @Override
        @NotNull
        public List<FilePatch> getAppliedPatches() {
            List<FilePatch> list = this.myAppliedPatches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier", "getAppliedPatches"));
            }
            return list;
        }
    }
}

