/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeBackgroundUtil {
    @NotNull
    public static Graphics2D withEditorBackground(@NotNull Graphics g, @NotNull JComponent component) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g, "editor", component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withFrameBackground(@NotNull Graphics g, @NotNull JComponent component) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g, "ide", component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D getOriginalGraphics(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getOriginalGraphics"));
        }
        Graphics2D graphics2D = g instanceof MyGraphics ? ((MyGraphics)((Object)g)).getDelegate() : (Graphics2D)g;
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getOriginalGraphics"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withNamedPainters(@NotNull Graphics g, @NotNull String paintersName, @NotNull JComponent component) {
        PaintersHelper helper;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        if (paintersName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintersName", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        JRootPane rootPane = component.getRootPane();
        Component glassPane = rootPane == null ? null : rootPane.getGlassPane();
        PaintersHelper paintersHelper = helper = glassPane instanceof IdeGlassPaneImpl ? ((IdeGlassPaneImpl)glassPane).getNamedPainters(paintersName) : null;
        if (helper == null || !helper.hasPainters()) {
            Graphics2D graphics2D = (Graphics2D)g;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
            }
            return graphics2D;
        }
        MyGraphics myGraphics = new MyGraphics(g, helper, component);
        if (myGraphics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        return myGraphics;
    }

    public static void initEditorPainters(@NotNull PaintersHelper painters) {
        if (painters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painters", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "initEditorPainters"));
        }
        painters.addPainter((Painter)PaintersHelper.newWallpaperPainter("idea.wallpaper.editor"), null);
    }

    public static void initFramePainters(@NotNull PaintersHelper painters) {
        Image centerImage;
        if (painters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painters", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "initFramePainters"));
        }
        painters.addPainter((Painter)PaintersHelper.newWallpaperPainter("idea.wallpaper.ide"), null);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String path = UIUtil.isUnderDarcula() ? appInfo.getEditorBackgroundImageUrl() : null;
        URL url = path == null ? null : ((Object)((Object)appInfo)).getClass().getResource(path);
        Image image = centerImage = url == null ? null : ImageLoader.loadFromUrl((URL)url);
        if (centerImage != null) {
            painters.addPainter((Painter)PaintersHelper.newImagePainter(centerImage, PaintersHelper.FillType.TOP_CENTER, 1.0f, (Insets)JBUI.insets((int)5, (int)0, (int)0, (int)0)), null);
        }
    }

    @Nullable
    public static Color getIdeBackgroundColor() {
        Color result = UIUtil.getSlightlyDarkerColor((Color)UIUtil.getPanelBackground());
        return UIUtil.isUnderDarcula() ? new Color(40, 40, 41) : UIUtil.getSlightlyDarkerColor((Color)UIUtil.getSlightlyDarkerColor((Color)result));
    }

    private static class MyGraphics
    extends Graphics2DDelegate {
        private final PaintersHelper myHelper;
        private final JComponent myComponent;

        public MyGraphics(Graphics g, PaintersHelper helper, JComponent component) {
            super((Graphics2D)g);
            this.myHelper = helper;
            this.myComponent = component;
        }

        @NotNull
        public Graphics create() {
            MyGraphics myGraphics = new MyGraphics(super.create(), this.myHelper, this.myComponent);
            if (myGraphics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyGraphics", "create"));
            }
            return myGraphics;
        }

        public void clearRect(int x, int y, int width, int height) {
            super.clearRect(x, y, width, height);
            this.processPainters(x, y, width, height);
        }

        public void fillRect(int x, int y, int width, int height) {
            super.fillRect(x, y, width, height);
            this.processPainters(x, y, width, height);
        }

        void processPainters(int x, int y, int width, int height) {
            Shape s = this.getClip();
            Rectangle newClip = s == null ? new Rectangle(x, y, width, height) : SwingUtilities.computeIntersection(x, y, width, height, s.getBounds());
            this.setClip(newClip);
            this.myHelper.paint(this.getDelegate(), this.myComponent);
            this.setClip(s);
        }
    }
}

