/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler;
import com.intellij.refactoring.convertToInstanceMethod.ImplementingClassUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.JavaDocUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.MethodCallUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.ParameterUsageInfo;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToInstanceMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodProcessor");
    private PsiMethod myMethod;
    private PsiParameter myTargetParameter;
    private PsiClass myTargetClass;
    private Map<PsiTypeParameter, PsiTypeParameter> myTypeParameterReplacements;
    private static final Key<PsiTypeParameter> BIND_TO_TYPE_PARAMETER = Key.create((String)"REPLACEMENT");
    private final String myOldVisibility;
    private final String myNewVisibility;

    public ConvertToInstanceMethodProcessor(Project project, PsiMethod method, PsiParameter targetParameter, String newVisibility) {
        super(project);
        this.myMethod = method;
        this.myTargetParameter = targetParameter;
        LOG.assertTrue(method.hasModifierProperty("static"));
        LOG.assertTrue(this.myTargetParameter.getDeclarationScope() == this.myMethod);
        LOG.assertTrue(this.myTargetParameter.getType() instanceof PsiClassType);
        PsiType type = this.myTargetParameter.getType();
        LOG.assertTrue(type instanceof PsiClassType);
        this.myTargetClass = ((PsiClassType)type).resolve();
        this.myOldVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        this.myNewVisibility = newVisibility;
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "createUsageViewDescriptor"));
        }
        MoveInstanceMethodViewDescriptor moveInstanceMethodViewDescriptor = new MoveInstanceMethodViewDescriptor(this.myMethod, (PsiVariable)this.myTargetParameter, this.myTargetClass);
        if (moveInstanceMethodViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "createUsageViewDescriptor"));
        }
        return moveInstanceMethodViewDescriptor;
    }

    @Override
    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "refreshElements"));
        }
        LOG.assertTrue(elements.length == 3);
        this.myMethod = (PsiMethod)elements[0];
        this.myTargetParameter = (PsiParameter)elements[1];
        this.myTargetClass = (PsiClass)elements[2];
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        LOG.assertTrue(this.myTargetParameter.getDeclarationScope() == this.myMethod);
        Project project = this.myMethod.getProject();
        PsiReference[] methodReferences = (PsiReference[])ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])new PsiReference[0]);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiReference ref : methodReferences) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression) {
                if (!(element.getParent() instanceof PsiMethodCallExpression)) continue;
                result.add(new MethodCallUsageInfo((PsiMethodCallExpression)element.getParent()));
                continue;
            }
            if (!(element instanceof PsiDocTagValue)) continue;
            result.add(new JavaDocUsageInfo(ref));
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myTargetParameter, (SearchScope)new LocalSearchScope((PsiElement)this.myMethod), (boolean)false)) {
            PsiElement element = ref.getElement();
            if (!(element instanceof PsiReferenceExpression) && !(element instanceof PsiDocParamRef)) continue;
            result.add(new ParameterUsageInfo(ref));
        }
        if (this.myTargetClass.isInterface()) {
            PsiClass[] implementingClasses;
            for (PsiClass implementingClass : implementingClasses = RefactoringHierarchyUtil.findImplementingClasses(this.myTargetClass)) {
                result.add(new ImplementingClassUsageInfo(implementingClass));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.makeInstance";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(new PsiElement[]{this.myMethod, this.myTargetClass});
        return data;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "getAfterData"));
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myTargetClass);
        return data;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "preprocessUsages"));
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        Set<PsiMethod> methods = Collections.singleton(this.myMethod);
        if (!this.myTargetClass.isInterface()) {
            RefactoringConflictsUtil.analyzeAccessibilityConflicts(methods, this.myTargetClass, (MultiMap<PsiElement, String>)conflicts, this.myNewVisibility);
        } else {
            for (UsageInfo usage : usagesIn) {
                if (!(usage instanceof ImplementingClassUsageInfo)) continue;
                RefactoringConflictsUtil.analyzeAccessibilityConflicts(methods, ((ImplementingClassUsageInfo)usage).getPsiClass(), (MultiMap<PsiElement, String>)conflicts, "public");
            }
        }
        for (UsageInfo usageInfo : usagesIn) {
            if (!(usageInfo instanceof MethodCallUsageInfo)) continue;
            PsiMethodCallExpression methodCall = ((MethodCallUsageInfo)usageInfo).getMethodCall();
            PsiExpression[] expressions = methodCall.getArgumentList().getExpressions();
            int index = this.myMethod.getParameterList().getParameterIndex(this.myTargetParameter);
            if (index >= expressions.length) continue;
            PsiExpression instanceValue = expressions[index];
            if (!((instanceValue = RefactoringUtil.unparenthesizeExpression(instanceValue)) instanceof PsiLiteralExpression) || ((PsiLiteralExpression)instanceValue).getValue() != null) continue;
            String message = RefactoringBundle.message((String)"0.contains.call.with.null.argument.for.parameter.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(ConflictsUtil.getContainer((PsiElement)methodCall), true), CommonRefactoringUtil.htmlEmphasize((String)this.myTargetParameter.getName())});
            conflicts.putValue((Object)methodCall, (Object)message);
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usagesIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor", "performRefactoring"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)this.myTargetClass)) {
            return;
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            a.finish();
        }
    }

    private void doRefactoring(UsageInfo[] usages) throws IncorrectOperationException {
        this.myTypeParameterReplacements = this.buildTypeParameterReplacements();
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
        for (UsageInfo usage : usages) {
            if (usage instanceof MethodCallUsageInfo) {
                this.processMethodCall((MethodCallUsageInfo)usage);
                continue;
            }
            if (usage instanceof ParameterUsageInfo) {
                this.processParameterUsage((ParameterUsageInfo)usage);
                continue;
            }
            if (!(usage instanceof ImplementingClassUsageInfo)) continue;
            inheritors.add(((ImplementingClassUsageInfo)usage).getPsiClass());
        }
        this.prepareTypeParameterReplacement();
        this.myTargetParameter.delete();
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, true);
        if (!this.myTargetClass.isInterface()) {
            PsiMethod method = this.addMethodToClass(this.myTargetClass);
            this.fixVisibility(method, usages);
            EditorHelper.openInEditor((PsiElement)method);
        } else {
            PsiMethod interfaceMethod = this.addMethodToClass(this.myTargetClass);
            PsiModifierList modifierList = interfaceMethod.getModifierList();
            modifierList.setModifierProperty("private", false);
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty("protected", false);
            RefactoringUtil.makeMethodAbstract(this.myTargetClass, interfaceMethod);
            EditorHelper.openInEditor((PsiElement)interfaceMethod);
            for (PsiClass psiClass : inheritors) {
                PsiMethod newMethod = this.addMethodToClass(psiClass);
                PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)(this.myNewVisibility != null && !this.myNewVisibility.equals("EscalateVisible") ? this.myNewVisibility : "public"), (boolean)true);
            }
        }
        this.myMethod.delete();
    }

    private void fixVisibility(PsiMethod method, UsageInfo[] usages) throws IncorrectOperationException {
        PsiModifierList modifierList = method.getModifierList();
        if ("EscalateVisible".equals(this.myNewVisibility)) {
            for (UsageInfo usage : usages) {
                PsiElement place;
                if (!(usage instanceof MethodCallUsageInfo) || (place = usage.getElement()) == null) continue;
                VisibilityUtil.escalateVisibility((PsiMember)method, (PsiElement)place);
            }
        } else if (this.myNewVisibility != null && !this.myNewVisibility.equals(this.myOldVisibility)) {
            modifierList.setModifierProperty(this.myNewVisibility, true);
        }
    }

    private void prepareTypeParameterReplacement() throws IncorrectOperationException {
        if (this.myTypeParameterReplacements == null) {
            return;
        }
        Set<PsiTypeParameter> typeParameters = this.myTypeParameterReplacements.keySet();
        for (PsiTypeParameter parameter : typeParameters) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)this.myMethod), (boolean)false)) {
                if (!(reference.getElement() instanceof PsiJavaCodeReferenceElement)) continue;
                reference.getElement().putCopyableUserData(BIND_TO_TYPE_PARAMETER, (Object)this.myTypeParameterReplacements.get(parameter));
            }
        }
        Set<PsiTypeParameter> methodTypeParameters = this.myTypeParameterReplacements.keySet();
        for (PsiTypeParameter methodTypeParameter : methodTypeParameters) {
            methodTypeParameter.delete();
        }
    }

    private PsiMethod addMethodToClass(PsiClass targetClass) throws IncorrectOperationException {
        HashMap additionalReplacements;
        PsiMethod newMethod = (PsiMethod)targetClass.add((PsiElement)this.myMethod);
        PsiModifierList modifierList = newMethod.getModifierList();
        modifierList.setModifierProperty("static", false);
        ChangeContextUtil.decodeContextInfo((PsiElement)newMethod, null, null);
        if (this.myTypeParameterReplacements == null) {
            return newMethod;
        }
        if (targetClass != this.myTargetClass) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myTargetClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            Map<PsiTypeParameter, PsiTypeParameter> map = ConvertToInstanceMethodProcessor.calculateReplacementMap(superClassSubstitutor, this.myTargetClass, (PsiElement)targetClass);
            if (map == null) {
                return newMethod;
            }
            additionalReplacements = new HashMap();
            for (Map.Entry<PsiTypeParameter, PsiTypeParameter> entry : map.entrySet()) {
                additionalReplacements.put(entry.getValue(), entry.getKey());
            }
        } else {
            additionalReplacements = null;
        }
        newMethod.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Map)additionalReplacements){
            final /* synthetic */ Map val$additionalReplacements;
            {
                this.val$additionalReplacements = map;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiTypeParameter typeParameterToBind = (PsiTypeParameter)reference.getCopyableUserData(BIND_TO_TYPE_PARAMETER);
                if (typeParameterToBind != null) {
                    reference.putCopyableUserData(BIND_TO_TYPE_PARAMETER, null);
                    try {
                        if (this.val$additionalReplacements != null) {
                            typeParameterToBind = (PsiTypeParameter)this.val$additionalReplacements.get(typeParameterToBind);
                        }
                        reference.bindToElement((PsiElement)typeParameterToBind);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                } else {
                    this.visitElement((PsiElement)reference);
                }
            }
        });
        return newMethod;
    }

    private void processParameterUsage(ParameterUsageInfo usage) throws IncorrectOperationException {
        PsiReference reference = usage.getReferenceExpression();
        if (reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
            if (referenceExpression.getParent() instanceof PsiReferenceExpression) {
                referenceExpression.delete();
            } else {
                PsiExpression expression = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createExpressionFromText("this", null);
                referenceExpression.replace((PsiElement)expression);
            }
        } else {
            PsiElement element = reference.getElement();
            if (element instanceof PsiDocParamRef) {
                element.getParent().delete();
            }
        }
    }

    private void processMethodCall(MethodCallUsageInfo usageInfo) throws IncorrectOperationException {
        PsiExpression qualifier;
        PsiMethodCallExpression methodCall = usageInfo.getMethodCall();
        PsiParameterList parameterList = this.myMethod.getParameterList();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
        int parameterIndex = parameterList.getParameterIndex(this.myTargetParameter);
        PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
        if (arguments.length <= parameterIndex) {
            return;
        }
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        if (methodExpression.getQualifierExpression() != null) {
            qualifier = methodExpression.getQualifierExpression();
        } else {
            PsiReferenceExpression newRefExpr = (PsiReferenceExpression)factory.createExpressionFromText("x." + this.myMethod.getName(), null);
            qualifier = ((PsiReferenceExpression)methodExpression.replace((PsiElement)newRefExpr)).getQualifierExpression();
        }
        qualifier.replace((PsiElement)arguments[parameterIndex]);
        arguments[parameterIndex].delete();
    }

    @Override
    protected String getCommandName() {
        return ConvertToInstanceMethodHandler.REFACTORING_NAME;
    }

    @Nullable
    public Map<PsiTypeParameter, PsiTypeParameter> buildTypeParameterReplacements() {
        PsiClassType type = (PsiClassType)this.myTargetParameter.getType();
        PsiSubstitutor substitutor = type.resolveGenerics().getSubstitutor();
        return ConvertToInstanceMethodProcessor.calculateReplacementMap(substitutor, this.myTargetClass, (PsiElement)this.myMethod);
    }

    @Nullable
    private static Map<PsiTypeParameter, PsiTypeParameter> calculateReplacementMap(PsiSubstitutor substitutor, PsiClass targetClass, PsiElement containingElement) {
        HashMap result = new HashMap();
        for (PsiTypeParameter classTypeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass)) {
            PsiType substitution = substitutor.substitute(classTypeParameter);
            if (!(substitution instanceof PsiClassType)) {
                return null;
            }
            PsiClass aClass = ((PsiClassType)substitution).resolve();
            if (!(aClass instanceof PsiTypeParameter)) {
                return null;
            }
            PsiTypeParameter methodTypeParameter = (PsiTypeParameter)aClass;
            if (methodTypeParameter.getOwner() != containingElement) {
                return null;
            }
            if (result.keySet().contains(methodTypeParameter)) {
                return null;
            }
            result.put((Object)methodTypeParameter, (Object)classTypeParameter);
        }
        return result;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiParameter getTargetParameter() {
        return this.myTargetParameter;
    }
}

