/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiVariable;

public abstract class VisibilityListener {
    private final Editor myEditor;
    private static final Logger LOG = Logger.getInstance((String)("#" + VisibilityListener.class.getName()));

    protected VisibilityListener(Editor editor) {
        this.myEditor = editor;
    }

    public void perform(PsiVariable variable) {
        String visibility;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final Document document = this.myEditor.getDocument();
        LOG.assertTrue(variable != null);
        PsiModifierList modifierList = variable.getModifierList();
        LOG.assertTrue(modifierList != null);
        int textOffset = modifierList.getTextOffset();
        String modifierListText = modifierList.getText();
        int length = "public".length();
        int idx = modifierListText.indexOf("public");
        if (idx == -1) {
            idx = modifierListText.indexOf("protected");
            length = "protected".length();
        }
        if (idx == -1) {
            idx = modifierListText.indexOf("private");
            length = "private".length();
        }
        if ((visibility = this.getVisibility()) == "packageLocal") {
            visibility = "";
        }
        boolean wasPackageLocal = idx == -1;
        boolean isPackageLocal = visibility.isEmpty();
        final int startOffset = textOffset + (wasPackageLocal ? 0 : idx);
        final int endOffset = wasPackageLocal ? startOffset : textOffset + length + (isPackageLocal ? 1 : 0);
        final String finalVisibility = visibility + (wasPackageLocal ? " " : "");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                document.replaceString(startOffset, endOffset, (CharSequence)finalVisibility);
            }
        };
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor);
        if (lookup != null) {
            lookup.performGuardedChange(runnable);
        } else {
            runnable.run();
        }
    }

    protected abstract String getVisibility();
}

