/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentImpl
implements Deployment {
    private final ServerConnectionImpl<?> myConnection;
    private final String myName;
    private final DeploymentTask<?> myDeploymentTask;
    private volatile DeploymentState myState;

    public DeploymentImpl(@NotNull ServerConnectionImpl<?> connection, @NotNull String name, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @Nullable DeploymentTask<?> deploymentTask) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        this.myConnection = connection;
        this.myName = name;
        this.myDeploymentTask = deploymentTask;
        this.myState = new DeploymentState(status, statusText, runtime);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus = this.myState.getStatus();
        if (deploymentStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getStatus"));
        }
        return deploymentStatus;
    }

    @NotNull
    public String getStatusText() {
        String statusText = this.myState.getStatusText();
        String string = statusText != null ? statusText : this.getStatus().getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getStatusText"));
        }
        return string;
    }

    public DeploymentRuntime getRuntime() {
        return this.myState.getRuntime();
    }

    @Nullable
    public DeploymentTask<?> getDeploymentTask() {
        return this.myDeploymentTask;
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getOrCreateLogManager"));
        }
        DeploymentLogManager deploymentLogManager = this.myConnection.getOrCreateLogManager(project, this);
        if (deploymentLogManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getOrCreateLogManager"));
        }
        return deploymentLogManager;
    }

    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        if (oldStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStatus", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "changeState"));
        }
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "changeState"));
        }
        if (this.myState.getStatus() == oldStatus) {
            this.myState = new DeploymentState(newStatus, statusText, runtime);
            return true;
        }
        return false;
    }

    private static class DeploymentState {
        private final DeploymentStatus myStatus;
        private final String myStatusText;
        private final DeploymentRuntime myRuntime;

        private DeploymentState(@NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState", "<init>"));
            }
            this.myStatus = status;
            this.myStatusText = statusText;
            this.myRuntime = runtime;
        }

        @NotNull
        public DeploymentStatus getStatus() {
            DeploymentStatus deploymentStatus = this.myStatus;
            if (deploymentStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState", "getStatus"));
            }
            return deploymentStatus;
        }

        @Nullable
        public String getStatusText() {
            return this.myStatusText;
        }

        @Nullable
        public DeploymentRuntime getRuntime() {
            return this.myRuntime;
        }
    }
}

