/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class DeploymentLogManagerImpl
implements DeploymentLogManager {
    private final LoggingHandlerImpl myMainLoggingHandler;
    private final Project myProject;
    private final List<LoggingHandlerBase> myAdditionalLoggingHandlers;
    private final Runnable myChangeListener;
    private final AtomicBoolean myLogsDisposed;
    private final Disposable myLogsDisposable;
    private boolean myMainHandlerVisible;

    public DeploymentLogManagerImpl(@NotNull Project project, @NotNull Runnable changeListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "<init>"));
        }
        if (changeListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListener", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "<init>"));
        }
        this.myAdditionalLoggingHandlers = new ArrayList<LoggingHandlerBase>();
        this.myLogsDisposed = new AtomicBoolean(false);
        this.myMainHandlerVisible = false;
        this.myProject = project;
        this.myChangeListener = changeListener;
        this.myMainLoggingHandler = new LoggingHandlerImpl(null, project);
        this.myLogsDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)this.myMainLoggingHandler);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DeploymentLogManagerImpl.this.disposeLogs();
            }
        });
    }

    public DeploymentLogManagerImpl withMainHandlerVisible(boolean mainHandlerVisible) {
        this.myMainHandlerVisible = mainHandlerVisible;
        return this;
    }

    public boolean isMainHandlerVisible() {
        return this.myMainHandlerVisible;
    }

    @NotNull
    public LoggingHandlerImpl getMainLoggingHandler() {
        LoggingHandlerImpl loggingHandlerImpl = this.myMainLoggingHandler;
        if (loggingHandlerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "getMainLoggingHandler"));
        }
        return loggingHandlerImpl;
    }

    @NotNull
    public LoggingHandler addAdditionalLog(@NotNull String presentableName) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "addAdditionalLog"));
        }
        LoggingHandlerImpl handler = new LoggingHandlerImpl(presentableName, this.myProject);
        this.addAdditionalLoggingHandler(handler);
        LoggingHandlerImpl loggingHandlerImpl = handler;
        if (loggingHandlerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "addAdditionalLog"));
        }
        return loggingHandlerImpl;
    }

    public TerminalHandler addTerminal(@NotNull String presentableName, InputStream terminalOutput, OutputStream terminalInput) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "addTerminal"));
        }
        TerminalHandlerBase handler = CloudTerminalProvider.getInstance().createTerminal(presentableName, this.myProject, terminalOutput, terminalInput);
        this.addAdditionalLoggingHandler(handler);
        return handler;
    }

    public boolean isTtySupported() {
        return CloudTerminalProvider.getInstance().isTtySupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdditionalLoggingHandler(LoggingHandlerBase loggingHandler) {
        Disposer.register((Disposable)this.myLogsDisposable, (Disposable)loggingHandler);
        List<LoggingHandlerBase> list = this.myAdditionalLoggingHandlers;
        synchronized (list) {
            this.myAdditionalLoggingHandlers.add(loggingHandler);
        }
        this.myChangeListener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LoggingHandlerBase> getAdditionalLoggingHandlers() {
        ArrayList<LoggingHandlerBase> result;
        List<LoggingHandlerBase> list = this.myAdditionalLoggingHandlers;
        synchronized (list) {
            result = new ArrayList<LoggingHandlerBase>(this.myAdditionalLoggingHandlers);
        }
        ArrayList<LoggingHandlerBase> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/DeploymentLogManagerImpl", "getAdditionalLoggingHandlers"));
        }
        return arrayList;
    }

    public void disposeLogs() {
        if (!this.myLogsDisposed.getAndSet(true)) {
            Disposer.dispose((Disposable)this.myLogsDisposable);
        }
    }
}

