/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class GCUtil {
    private static final boolean ourHasBeanInfoCache = SystemInfo.isJavaVersionAtLeast((String)"1.7");

    public static void tryForceGC() {
        GCUtil.tryGcSoftlyReachableObjects();
        WeakReference<Object> weakReference = new WeakReference<Object>(new Object());
        do {
            System.gc();
        } while (weakReference.get() != null);
    }

    public static void tryGcSoftlyReachableObjects() {
        ReferenceQueue q = new ReferenceQueue();
        SoftReference<Object> ref = new SoftReference<Object>(new Object(), q);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)(100 + GCUtil.useReference(ref)));
        System.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < 100 && q.poll() == null; ++i) {
            int bytes = Math.min((int)((double)freeMemory * 0.45), 0x3FFFFFFF);
            list.add(new SoftReference<byte[]>(new byte[bytes]));
        }
        list.ensureCapacity(list.size() + GCUtil.useReference(ref));
        for (SoftReference createdReference : list) {
            createdReference.clear();
        }
    }

    private static int useReference(SoftReference<Object> ref) {
        Object o = ref.get();
        return o == null ? 0 : Math.abs(o.hashCode()) % 10;
    }

    public static void tryClearBeanInfoCache() {
        if (ourHasBeanInfoCache) {
            try {
                Class<?> aClass = Class.forName("java.beans.ThreadGroupContext");
                Method getContextMethod = aClass.getDeclaredMethod("getContext", new Class[0]);
                getContextMethod.setAccessible(true);
                Object contextForThreadGroup = getContextMethod.invoke(null, new Object[0]);
                Method clearBeanInfoCacheMethod = contextForThreadGroup.getClass().getDeclaredMethod("clearBeanInfoCache", new Class[0]);
                clearBeanInfoCacheMethod.setAccessible(true);
                clearBeanInfoCacheMethod.invoke(contextForThreadGroup, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

